/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.impl;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.URLClassLoader;
import org.eclipse.birt.data.oda.pojo.api.IPojoDataSet;
import org.eclipse.birt.data.oda.pojo.api.PojoDataSetFromArray;
import org.eclipse.birt.data.oda.pojo.api.PojoDataSetFromCollection;
import org.eclipse.birt.data.oda.pojo.api.PojoDataSetFromIterator;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.impl.ClassLoaderProvider;
import org.eclipse.birt.data.oda.pojo.impl.Connection;
import org.eclipse.birt.data.oda.pojo.impl.ResultSet;
import org.eclipse.birt.data.oda.pojo.impl.ResultSetMetaData;
import org.eclipse.birt.data.oda.pojo.impl.internal.PojoDataSetFromCustomClass;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.util.PojoQueryParser;
import org.eclipse.birt.data.oda.pojo.util.URLParser;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class Query
implements IQuery {
    private static Logger logger = Logger.getLogger(Query.class.getName());
    private int maxRows;
    private boolean isClosed;
    private String pojoDataSetClassPath;
    private PojoQuery pojoQuery;
    private Connection connection;
    private Map<String, Object> passedInParams = new HashMap<String, Object>();
    Map appContext;

    public Query(String pojoDataSetClassPath) {
        this.pojoDataSetClassPath = pojoDataSetClassPath;
        this.connection = null;
    }

    public void prepare(String queryText) throws OdaException {
        this.testClosed();
        if (queryText == null) {
            throw new OdaException(Messages.getString("Query.NoQueryText"));
        }
        this.pojoQuery = PojoQueryParser.parse(queryText);
        this.pojoQuery.setConnection(this.connection);
    }

    public void setAppContext(Object context) throws OdaException {
        this.testClosed();
        if (context != null && !(context instanceof Map)) {
            logger.log(Level.WARNING, "Invalid appContext: " + String.valueOf(context));
        } else {
            this.appContext = (Map)context;
        }
    }

    public void close() throws OdaException {
        this.isClosed = true;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.testClosed();
        return new ResultSetMetaData(this.pojoQuery.getReferenceGraph());
    }

    public IResultSet executeQuery() throws OdaException {
        this.testClosed();
        URLClassLoader pojoClassLoader = this.getPojoDataSetClassLoader();
        IPojoDataSet pojoDataSet = this.getPojoDataSet(pojoClassLoader);
        this.pojoQuery.prepareParameterValues(this.passedInParams, pojoClassLoader);
        pojoDataSet.open(this.appContext, this.passedInParams);
        ResultSet resultSet = new ResultSet(this.pojoQuery, pojoDataSet, pojoClassLoader);
        resultSet.setMaxRows(this.getMaxRows());
        return resultSet;
    }

    private IPojoDataSet getPojoDataSet(ClassLoader cl) throws OdaException {
        IPojoDataSet pojoDataSet = this.getPojoDataSetFromAppContext();
        if (pojoDataSet == null) {
            Class pojoDataSetClass = this.loadPojoDataSetClass(cl);
            try {
                pojoDataSet = IPojoDataSet.class.isAssignableFrom(pojoDataSetClass) ? (IPojoDataSet)pojoDataSetClass.newInstance() : new PojoDataSetFromCustomClass(pojoDataSetClass);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new OdaException((Throwable)e);
            }
        }
        return pojoDataSet;
    }

    private Class loadPojoDataSetClass(ClassLoader cl) throws OdaException {
        String dataSetClass = this.pojoQuery.getDataSetClass();
        if (dataSetClass == null || dataSetClass.length() == 0) {
            throw new OdaException(Messages.getString("ResultSet.MissDataSetClassName"));
        }
        try {
            return cl.loadClass(dataSetClass);
        }
        catch (Throwable e) {
            throw new OdaException(e);
        }
    }

    private URLClassLoader getPojoDataSetClassLoader() throws OdaException {
        URLParser up = new URLParser(this.appContext);
        Object[] urls = up.parse(this.pojoDataSetClassPath);
        logger.log(Level.INFO, "URLs from data set class path: [" + Arrays.toString(urls) + "]");
        URLClassLoader loader = ClassLoaderProvider.getInstance().getClassLoader((URL[])urls);
        return loader;
    }

    private IPojoDataSet getPojoDataSetFromAppContext() throws OdaException {
        Object pojoInstances;
        if (this.appContext != null && this.pojoQuery.getAppContextKey() != null && this.pojoQuery.getAppContextKey().length() > 0 && (pojoInstances = this.appContext.get(this.pojoQuery.getAppContextKey())) != null) {
            if (pojoInstances instanceof Iterator) {
                return new PojoDataSetFromIterator(){

                    @Override
                    protected Iterator fetchPojos() throws OdaException {
                        return (Iterator)pojoInstances;
                    }
                };
            }
            if (pojoInstances instanceof Collection) {
                return new PojoDataSetFromCollection(){

                    @Override
                    protected Collection fetchPojos() throws OdaException {
                        return (Collection)pojoInstances;
                    }
                };
            }
            if (pojoInstances instanceof Object[]) {
                return new PojoDataSetFromArray(){

                    @Override
                    protected Object[] fetchPojos() throws OdaException {
                        return (Object[])pojoInstances;
                    }
                };
            }
            throw new OdaException(Messages.getString("ResultSet.InvalidAppContextValue", this.pojoQuery.getAppContextKey(), pojoInstances.getClass().getName()));
        }
        return null;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void setMaxRows(int max) throws OdaException {
        this.testClosed();
        this.maxRows = max > 0 ? max : 0;
    }

    public int getMaxRows() throws OdaException {
        this.testClosed();
        return this.maxRows;
    }

    public void clearInParameters() throws OdaException {
        this.passedInParams.clear();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setString(String parameterName, String value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        this.passedInParams.put(parameterName, value);
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        this.setParamValueByIndex(parameterId, value);
    }

    public void setNull(String parameterName) throws OdaException {
        this.passedInParams.put(parameterName, null);
    }

    public void setNull(int parameterId) throws OdaException {
        this.setParamValueByIndex(parameterId, null);
    }

    private void setParamValueByIndex(int index, Object value) throws OdaException {
        String name = this.pojoQuery.getQueryParameters().getParamName(index);
        if (name != null) {
            this.setObject(name, value);
        }
    }

    public int findInParameter(String parameterName) throws OdaException {
        return this.pojoQuery.getQueryParameters().findInParameter(parameterName);
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return this.pojoQuery.getQueryParameters().getParameterMetaData();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        throw new UnsupportedOperationException();
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    private void testClosed() throws OdaException {
        if (this.isClosed) {
            throw new OdaException(Messages.getString("Query.Closed"));
        }
    }
}

