/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.ICascadingParameterGroup;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.ExportedColumn;
import org.eclipse.birt.report.service.api.ExportedResultSet;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.service.api.ToC;
import org.eclipse.birt.report.soapengine.api.Column;
import org.eclipse.birt.report.soapengine.api.ResultSet;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtViewerReportService
implements IViewerReportService {
    public BirtViewerReportService(ServletContext context) {
        try {
            ReportEngineService.initEngineInstance(context);
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String runReport(IViewerReportDesignHandle design, String outputDocName, InputOptions runOptions, Map parameters) throws ReportServiceException {
        return this.runReport(design, outputDocName, runOptions, parameters, null);
    }

    @Override
    public String runReport(IViewerReportDesignHandle design, String outputDocName, InputOptions runOptions, Map parameters, Map displayTexts) throws ReportServiceException {
        return this.runReport(design, outputDocName, runOptions, parameters, displayTexts, null);
    }

    @Override
    public String runReport(IViewerReportDesignHandle design, String outputDocName, InputOptions runOptions, Map parameters, Map displayTexts, List<Exception> errorList) throws ReportServiceException {
        if (design == null || design.getDesignObject() == null) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.generalException.NO_REPORT_DESIGN"));
        }
        HttpServletRequest request = (HttpServletRequest)runOptions.getOption("request");
        Locale locale = (Locale)runOptions.getOption("locale");
        TimeZone timeZone = (TimeZone)runOptions.getOption("timeZone");
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        HashMap parsedParams = attrBean.getParameters();
        if (parameters != null) {
            parsedParams.putAll(parameters);
        }
        Map displayTextMap = attrBean.getDisplayTexts();
        if (displayTexts != null) {
            displayTextMap.putAll(displayTexts);
        }
        IReportRunnable runnable = (IReportRunnable)design.getDesignObject();
        try {
            List<Exception> errors;
            Integer maxRows = null;
            if (ParameterAccessor.isReportParameterExist(request, "__maxrows")) {
                maxRows = ParameterAccessor.getMaxRows(request);
            }
            if ((errors = ReportEngineService.getInstance().runReport(request, runnable, outputDocName, locale, timeZone, parsedParams, displayTextMap, maxRows)) != null && !errors.isEmpty()) {
                errorList.addAll(errors);
            }
        }
        catch (RemoteException e) {
            if (e.getCause() instanceof ReportServiceException) {
                throw (ReportServiceException)e.getCause();
            }
            throw new ReportServiceException(e.getLocalizedMessage(), e.getCause());
        }
        return outputDocName;
    }

    @Override
    public ByteArrayOutputStream getPage(String docName, String pageID, InputOptions renderOptions, List activeIds) throws ReportServiceException {
        ByteArrayOutputStream os = null;
        try (IReportDocument doc = null;){
            try {
                doc = this.openReportDocument(docName, renderOptions);
                long pageNum = Long.parseLong(pageID);
                os = new ByteArrayOutputStream();
                ReportEngineService.getInstance().renderReport(os, doc, pageNum, null, renderOptions, activeIds);
            }
            catch (RemoteException e) {
                this.throwReportServiceException(e);
                if (doc != null) {
                    doc.close();
                }
            }
        }
        return os;
    }

    @Override
    @Deprecated
    public boolean isDocumentRtl(String docName, InputOptions renderOptions) throws ReportServiceException {
        try (IReportDocument doc = null;){
            doc = this.openReportDocument(docName, renderOptions);
            String bidiOrientation = doc.getReportDesign().getBidiOrientation();
            boolean bl = "rtl".equalsIgnoreCase(bidiOrientation);
            return bl;
        }
    }

    private IReportDocument openReportDocument(String docName, InputOptions renderOptions) throws ReportServiceException {
        IReportDocument doc = null;
        try {
            doc = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(renderOptions), docName, this.getModuleOptions(renderOptions));
        }
        catch (RemoteException e) {
            this.throwReportServiceException(e);
        }
        return doc;
    }

    @Override
    public ByteArrayOutputStream getPageByBookmark(String docName, String bookmark, InputOptions renderOptions, List activeIds) throws ReportServiceException {
        long pageNum = this.getPageNumberByBookmark(docName, bookmark, renderOptions);
        return this.getPage(docName, "" + pageNum, renderOptions, activeIds);
    }

    @Override
    public ByteArrayOutputStream getPageByObjectId(String docName, String objectId, InputOptions renderOptions, List activeIds) throws ReportServiceException {
        return null;
    }

    @Override
    public ByteArrayOutputStream getReportlet(String docName, String objectId, InputOptions renderOptions, List activeIds) throws ReportServiceException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.renderReportlet(docName, objectId, renderOptions, activeIds, out);
        return out;
    }

    @Override
    public void renderReportlet(String docName, String objectId, InputOptions renderOptions, List activeIds, OutputStream out) throws ReportServiceException {
        try (IReportDocument doc = null;){
            try {
                doc = this.openReportDocument(docName, renderOptions);
                ReportEngineService.getInstance().renderReportlet(out, doc, renderOptions, objectId, null);
            }
            catch (RemoteException e) {
                this.throwReportServiceException(e);
                if (doc != null) {
                    doc.close();
                }
            }
        }
    }

    @Override
    public void renderReport(String docName, int pageNum, String pageRange, InputOptions renderOptions, OutputStream out) throws ReportServiceException {
        try (IReportDocument doc = null;){
            try {
                doc = this.openReportDocument(docName, renderOptions);
                ReportEngineService.getInstance().renderReport(out, doc, pageNum, pageRange, renderOptions, null);
            }
            catch (RemoteException e) {
                this.throwReportServiceException(e);
                if (doc != null) {
                    doc.close();
                }
            }
        }
    }

    @Override
    @Deprecated
    public void renderReport(String docName, int pageNum, InputOptions renderOptions, OutputStream out) throws ReportServiceException {
        this.renderReport(docName, pageNum, null, renderOptions, out);
    }

    @Override
    public void extractData(String docName, InputOptions options, OutputStream out) throws ReportServiceException {
        try (IReportDocument doc = null;){
            try {
                InstanceID iidObj;
                doc = this.openReportDocument(docName, options);
                Locale locale = (Locale)options.getOption("locale");
                TimeZone timeZone = (TimeZone)options.getOption("timeZone");
                HttpServletRequest request = (HttpServletRequest)options.getOption("request");
                String extractFormat = ParameterAccessor.getExtractFormat(request);
                String extractExtension = ParameterAccessor.getExtractExtension(request);
                String resultSetName = ParameterAccessor.getResultSetName(request);
                String instanceId = null;
                String bookmark = ParameterAccessor.getBookmark(request);
                if (bookmark != null && doc != null && (iidObj = doc.getBookmarkInstance(bookmark)) != null) {
                    instanceId = iidObj.toString();
                }
                if (instanceId == null) {
                    instanceId = ParameterAccessor.getInstanceId(request);
                }
                Collection columns = ParameterAccessor.getSelectedColumns(request);
                Map<String, String> paramMap = ParameterAccessor.getParameterAsMap(request);
                ReportEngineService.getInstance().extractDataEx(doc, extractFormat, extractExtension, resultSetName, instanceId, columns, locale, timeZone, paramMap, out);
            }
            catch (RemoteException e) {
                this.throwReportServiceException(e);
                if (doc != null) {
                    doc.close();
                }
            }
        }
    }

    private void throwReportServiceException(RemoteException e) throws ReportServiceException {
        Throwable wrappedException = e;
        if (e instanceof ReportEngineService.DummyRemoteException) {
            wrappedException = e.getCause();
        }
        if (wrappedException instanceof ReportServiceException) {
            throw (ReportServiceException)wrappedException;
        }
        if (wrappedException != null) {
            throw new ReportServiceException(wrappedException.getLocalizedMessage(), wrappedException);
        }
        throw new ReportServiceException(e.getLocalizedMessage(), e);
    }

    @Override
    public void extractResultSet(String docName, String resultSetId, Collection columns, Set filters, InputOptions options, OutputStream out) throws ReportServiceException {
        try (IReportDocument doc = null;){
            try {
                doc = this.openReportDocument(docName, options);
                Locale locale = (Locale)options.getOption("locale");
                TimeZone timeZone = (TimeZone)options.getOption("timeZone");
                HttpServletRequest request = (HttpServletRequest)options.getOption("request");
                Map<String, String> paramMap = ParameterAccessor.getParameterAsMap(request);
                ReportEngineService.getInstance().extractDataEx(doc, "csv", "org.eclipse.birt.report.engine.dataextraction.csv", resultSetId, null, columns, locale, timeZone, paramMap, out);
            }
            catch (RemoteException e) {
                this.throwReportServiceException(e);
                if (doc != null) {
                    doc.close();
                }
            }
        }
    }

    @Override
    public List getResultSetsMetadata(String docName, InputOptions options) throws ReportServiceException {
        ResultSet[] resultSetArray;
        block9: {
            IReportDocument doc = null;
            resultSetArray = null;
            try {
                try {
                    doc = this.openReportDocument(docName, options);
                    resultSetArray = ReportEngineService.getInstance().getResultSets(doc);
                }
                catch (RemoteException e) {
                    this.throwReportServiceException(e);
                    if (doc != null) {
                        doc.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (doc != null) {
                    doc.close();
                }
                throw throwable;
            }
            if (doc != null) {
                doc.close();
            }
        }
        if (resultSetArray == null || resultSetArray.length < 0) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.EXTRACT_DATA_NO_RESULT_SET"));
        }
        return this.transformResultSetArray(resultSetArray);
    }

    @Override
    public List getResultSetsMetadata(String docName, String instanceId, InputOptions options) throws ReportServiceException {
        return null;
    }

    @Override
    public void getImage(String docName, String imageId, OutputStream out, InputOptions options) throws ReportServiceException {
        try {
            HttpServletRequest request = (HttpServletRequest)options.getOption("request");
            ReportEngineService.getInstance().renderImage(imageId, request, out);
        }
        catch (RemoteException e) {
            this.throwReportServiceException(e);
        }
    }

    @Override
    public ToC getTOC(String docName, String tocId, InputOptions options) throws ReportServiceException {
        ToC tableOfContents = null;
        try (IReportDocument doc = null;){
            doc = this.openReportDocument(docName, options);
            TOCNode node = null;
            if (doc != null) {
                Locale locale = null;
                TimeZone timeZone = null;
                if (options != null) {
                    locale = (Locale)options.getOption("locale");
                    timeZone = (TimeZone)options.getOption("timeZone");
                }
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                ITOCTree tocTree = null;
                tocTree = timeZone != null ? doc.getTOCTree("viewer", ULocale.forLocale((Locale)locale), BirtUtility.toICUTimeZone(timeZone)) : doc.getTOCTree("viewer", ULocale.forLocale((Locale)locale));
                node = tocId != null ? tocTree.findTOC(tocId) : tocTree.findTOC(null);
            }
            if (node == null) {
                throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.INVALID_TOC"));
            }
            tableOfContents = BirtViewerReportService.transformTOCNode(node);
        }
        return tableOfContents;
    }

    @Override
    public String findTocByName(String docName, String name, InputOptions options) {
        try (IReportDocument doc = null;){
            doc = this.openReportDocument(docName, options);
            String string = BirtUtility.findTocByName(doc, name, options);
            return string;
        }
    }

    @Override
    public long getPageCount(String docName, InputOptions options, OutputOptions outputOptions) throws ReportServiceException {
        long count = 1L;
        try (IReportDocument doc = null;){
            doc = this.openReportDocument(docName, options);
            if (doc != null) {
                count = doc.getPageCount();
            }
        }
        return count;
    }

    @Override
    public Collection getParameterDefinitions(IViewerReportDesignHandle design, InputOptions runOptions, boolean includeGroups) throws ReportServiceException {
        try (IGetParameterDefinitionTask task = null;){
            task = this.getParameterDefinitionTask(design, runOptions);
            if (task != null) {
                Collection params = task.getParameterDefns(true);
                Collection collection = BirtViewerReportService.convertEngineParameters(params, includeGroups);
                return collection;
            }
        }
        return null;
    }

    @Override
    public Collection getSelectionListForCascadingGroup(IViewerReportDesignHandle design, String groupName, Object[] groupKeys, InputOptions options) throws ReportServiceException {
        IGetParameterDefinitionTask task = null;
        HttpServletRequest request = (HttpServletRequest)options.getOption("request");
        try {
            task = this.getParameterDefinitionTask(design, options);
            if (task != null) {
                ViewerAttributeBean bean = this.getViewerAttrBean(options);
                if (bean != null) {
                    com.ibm.icu.util.TimeZone tz = BirtUtility.toICUTimeZone(bean.getTimeZone());
                    if (tz != null) {
                        task.setTimeZone(tz);
                    }
                    task.setLocale(bean.getLocale());
                    task.setParameterValues((Map)bean.getParameters());
                }
                BirtUtility.addTask(request, (IEngineTask)task);
                task.evaluateQuery(groupName);
                Collection selectionList = task.getSelectionListForCascadingGroup(groupName, groupKeys);
                Collection collection = BirtViewerReportService.convertEngineParameterSelectionChoice(selectionList);
                return collection;
            }
        }
        finally {
            BirtUtility.removeTask(request);
            if (task != null) {
                task.close();
            }
        }
        return null;
    }

    @Override
    public Collection getParameterSelectionList(IViewerReportDesignHandle design, InputOptions runOptions, String paramName) throws ReportServiceException {
        try (IGetParameterDefinitionTask task = null;){
            task = this.getParameterDefinitionTask(design, runOptions);
            if (task != null) {
                ViewerAttributeBean bean = this.getViewerAttrBean(runOptions);
                if (bean != null) {
                    com.ibm.icu.util.TimeZone tz = BirtUtility.toICUTimeZone(bean.getTimeZone());
                    if (tz != null) {
                        task.setTimeZone(tz);
                    }
                    task.setLocale(bean.getLocale());
                    task.setParameterValues((Map)bean.getParameters());
                }
                Collection selectionList = task.getSelectionList(paramName);
                Collection collection = BirtViewerReportService.convertEngineParameterSelectionChoice(selectionList);
                return collection;
            }
        }
        return null;
    }

    private IGetParameterDefinitionTask getParameterDefinitionTask(IViewerReportDesignHandle design, InputOptions options) throws ReportServiceException {
        IGetParameterDefinitionTask task;
        if (design.getContentType() == "rptRunnableObject") {
            IReportRunnable runnable = (IReportRunnable)design.getDesignObject();
            task = ReportEngineService.getInstance().createGetParameterDefinitionTask(runnable, options);
        } else {
            try {
                task = this.getParameterDefinitionTask(design.getFileName(), options);
            }
            catch (EngineException e) {
                throw new ReportServiceException(e.getLocalizedMessage(), e.getCause());
            }
        }
        if (task != null) {
            HttpServletRequest request = (HttpServletRequest)options.getOption("request");
            HashMap<String, HttpServletRequest> context = new HashMap<String, HttpServletRequest>();
            context.put("BIRT_VIEWER_HTTPSERVET_REQUEST", request);
            ParameterAccessor.pushAppContext(context, request);
            task.setAppContext(context);
        }
        return task;
    }

    @Override
    public long getPageNumberByBookmark(String docName, String bookmark, InputOptions options) throws ReportServiceException {
        long pageNumber = -1L;
        try (IReportDocument doc = null;){
            doc = this.openReportDocument(docName, options);
            if (doc != null) {
                pageNumber = doc.getPageNumber(bookmark);
            }
        }
        return pageNumber;
    }

    @Override
    public long getPageNumberByObjectId(String docName, String objectId, InputOptions options) throws ReportServiceException {
        long pageNumber = -1L;
        try (IReportDocument doc = null;){
            doc = this.openReportDocument(docName, options);
            pageNumber = doc.getPageNumber(objectId);
        }
        return pageNumber;
    }

    @Override
    public void runAndRenderReport(IViewerReportDesignHandle design, String outputDocName, InputOptions options, Map parameters, OutputStream out, List activeIds) throws ReportServiceException {
        this.runAndRenderReport(design, outputDocName, options, parameters, out, activeIds, null);
    }

    @Override
    public void runAndRenderReport(IViewerReportDesignHandle design, String outputDocName, InputOptions options, Map parameters, OutputStream out, List activeIds, Map displayTexts) throws ReportServiceException {
        if (design == null || design.getDesignObject() == null) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.generalException.NO_REPORT_DESIGN"));
        }
        HttpServletRequest request = (HttpServletRequest)options.getOption("request");
        try {
            ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
            String reportTitle = ParameterAccessor.htmlDecode(attrBean.getReportTitle());
            IReportRunnable runnable = (IReportRunnable)design.getDesignObject();
            Integer maxRows = null;
            if (ParameterAccessor.isReportParameterExist(request, "__maxrows")) {
                maxRows = ParameterAccessor.getMaxRows(request);
            }
            ReportEngineService.getInstance().runAndRenderReport(runnable, out, options, parameters, null, null, null, displayTexts, reportTitle, maxRows);
        }
        catch (RemoteException e) {
            this.throwReportServiceException(e);
        }
    }

    @Override
    public Object getParameterDefaultValue(IViewerReportDesignHandle design, String parameterName, InputOptions options) throws ReportServiceException {
        Object defaultValue = null;
        try (IGetParameterDefinitionTask task = null;){
            task = this.getParameterDefinitionTask(design, options);
            if (task != null) {
                defaultValue = task.getDefaultValue(parameterName);
            }
        }
        return defaultValue;
    }

    @Override
    public void setContext(Object context, InputOptions options) throws BirtException {
        ReportEngineService.getInstance().setEngineContext((ServletContext)context);
    }

    public IReportRunnable getReportRunnable(IViewerReportDesignHandle design, Map moduleOptions) throws ReportServiceException {
        IReportRunnable runnable;
        if (design.getContentType() == "rptRunnableObject") {
            runnable = (IReportRunnable)design.getDesignObject();
        } else {
            try {
                runnable = ReportEngineService.getInstance().openReportDesign(design.getFileName(), moduleOptions);
            }
            catch (EngineException e) {
                throw new ReportServiceException(e.getLocalizedMessage(), e.getCause());
            }
        }
        return runnable;
    }

    private static ToC transformTOCNode(TOCNode node) {
        ToC toc = new ToC(node.getNodeID(), node.getDisplayString(), node.getBookmark(), BirtUtility.getTOCStyle(node));
        toc.setChildren(BirtViewerReportService.getToCChildren(node));
        return toc;
    }

    private static List getToCChildren(TOCNode node) {
        if (node.getChildren() == null) {
            return null;
        }
        List children = node.getChildren();
        ArrayList<ToC> ret = new ArrayList<ToC>();
        for (TOCNode childNode : children) {
            ToC child = new ToC(childNode.getNodeID(), childNode.getDisplayString(), childNode.getBookmark(), BirtUtility.getTOCStyle(childNode));
            child.setChildren(BirtViewerReportService.getToCChildren(childNode));
            ret.add(child);
        }
        return ret;
    }

    private IGetParameterDefinitionTask getParameterDefinitionTask(String reportDesignName, InputOptions options) throws EngineException {
        IReportRunnable runnable = ReportEngineService.getInstance().openReportDesign(reportDesignName, this.getModuleOptions(options));
        IGetParameterDefinitionTask paramTask = ReportEngineService.getInstance().createGetParameterDefinitionTask(runnable, options);
        return paramTask;
    }

    private List transformResultSetArray(ResultSet[] resultSetArray) {
        ArrayList<ExportedResultSet> ret = new ArrayList<ExportedResultSet>();
        int i = 0;
        while (i < resultSetArray.length) {
            ResultSet rs = resultSetArray[i];
            String queryName = rs.getQueryName();
            Column[] columnArray = rs.getColumn();
            ArrayList<ExportedColumn> columns = new ArrayList<ExportedColumn>();
            int j = 0;
            while (j < columnArray.length) {
                Column column = columnArray[j];
                ExportedColumn exportedColumn = new ExportedColumn(column.getName(), column.getLabel(), column.getVisibility());
                columns.add(exportedColumn);
                ++j;
            }
            ExportedResultSet exportedResultSet = new ExportedResultSet(queryName, columns);
            ret.add(exportedResultSet);
            ++i;
        }
        return ret;
    }

    private String getReportDesignName(InputOptions options) {
        HttpServletRequest request;
        String reportDesignName = null;
        if (options != null && (request = (HttpServletRequest)options.getOption("request")) != null) {
            ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
            assert (attrBean != null);
            reportDesignName = attrBean.getReportDesignName();
            if (reportDesignName != null && (reportDesignName.endsWith("\\") || reportDesignName.endsWith("/"))) {
                reportDesignName = null;
            }
        }
        return reportDesignName;
    }

    private static Collection convertEngineParameters(Collection params, boolean includeGroups) {
        if (params == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : params) {
            IScalarParameterDefn engineParam;
            if (o instanceof IScalarParameterDefn) {
                engineParam = (IScalarParameterDefn)o;
                ParameterGroupDefinition group = null;
                ParameterDefinition param = BirtViewerReportService.convertScalarParameter(engineParam, group);
                ret.add(param);
                continue;
            }
            if (!(o instanceof IParameterGroupDefn)) continue;
            engineParam = (IParameterGroupDefn)o;
            ParameterGroupDefinition paramGroup = BirtViewerReportService.convertParameterGroup((IParameterGroupDefn)engineParam);
            ret.add(paramGroup);
        }
        if (includeGroups) {
            return ret;
        }
        return BirtViewerReportService.flattenGroups(ret);
    }

    private static List flattenGroups(List params) {
        if (params == null || params.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList ret = new ArrayList();
        for (Object o : params) {
            if (o instanceof ParameterGroupDefinition) {
                ParameterGroupDefinition group = (ParameterGroupDefinition)o;
                ret.addAll(group.getParameters());
                continue;
            }
            ret.add(o);
        }
        return ret;
    }

    private static List convertParametersInGroup(Collection scalarParameters, ParameterGroupDefinition group) {
        if (scalarParameters == null) {
            return null;
        }
        ArrayList<ParameterDefinition> ret = new ArrayList<ParameterDefinition>();
        for (IScalarParameterDefn engineParam : scalarParameters) {
            ParameterDefinition param = BirtViewerReportService.convertScalarParameter(engineParam, group);
            ret.add(param);
        }
        return ret;
    }

    private static ParameterGroupDefinition convertParameterGroup(IParameterGroupDefn engineParam) {
        boolean cascade = engineParam instanceof ICascadingParameterGroup;
        String name = engineParam.getName();
        String displayName = engineParam.getDisplayName();
        String helpText = engineParam.getHelpText();
        String promptText = engineParam.getPromptText();
        ParameterGroupDefinition paramGroup = new ParameterGroupDefinition(name, displayName, promptText, null, cascade, helpText);
        List contents = BirtViewerReportService.convertParametersInGroup(engineParam.getContents(), paramGroup);
        paramGroup.setParameters(contents);
        return paramGroup;
    }

    private static ParameterDefinition convertScalarParameter(IScalarParameterDefn engineParam, ParameterGroupDefinition group) {
        String category;
        String pattern;
        ReportElementHandle handle = engineParam.getHandle();
        ScalarParameterHandle scalarParamHandle = null;
        if (handle instanceof ScalarParameterHandle) {
            scalarParamHandle = (ScalarParameterHandle)handle;
        }
        String name = engineParam.getName();
        long id = scalarParamHandle != null ? scalarParamHandle.getID() : 0L;
        String string = pattern = scalarParamHandle == null ? "" : scalarParamHandle.getPattern();
        if (pattern == null) {
            pattern = "";
        }
        String string2 = category = scalarParamHandle == null ? "" : scalarParamHandle.getCategory();
        if (category == null) {
            category = "";
        }
        String displayFormat = engineParam.getDisplayFormat();
        String displayName = engineParam.getDisplayName();
        String helpText = engineParam.getHelpText();
        String promptText = engineParam.getPromptText();
        int dataType = engineParam.getDataType();
        String valueExpr = scalarParamHandle == null ? null : scalarParamHandle.getValueExpr();
        int controlType = engineParam.getControlType();
        boolean hidden = engineParam.isHidden();
        boolean allowNull = !engineParam.isRequired();
        boolean allowBlank = engineParam.getDataType() == 1 || engineParam.getDataType() == 0;
        boolean isRequired = engineParam.isRequired();
        boolean mustMatch = scalarParamHandle == null ? false : scalarParamHandle.isMustMatch();
        boolean concealValue = engineParam.isValueConcealed();
        boolean distinct = scalarParamHandle == null ? false : scalarParamHandle.distinct();
        boolean isMultiValue = false;
        if (scalarParamHandle != null) {
            isMultiValue = "multi-value".equalsIgnoreCase(scalarParamHandle.getParamType());
        }
        ParameterDefinition param = new ParameterDefinition(id, name, category, pattern, displayFormat, displayName, helpText, promptText, dataType, valueExpr, controlType, hidden, allowNull, allowBlank, isRequired, mustMatch, concealValue, distinct, isMultiValue, group, null);
        return param;
    }

    private static Collection convertEngineParameterSelectionChoice(Collection params) {
        if (params == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ParameterSelectionChoice> ret = new ArrayList<ParameterSelectionChoice>();
        for (IParameterSelectionChoice engineChoice : params) {
            ParameterSelectionChoice paramChoice = new ParameterSelectionChoice(engineChoice.getLabel(), engineChoice.getValue());
            ret.add(paramChoice);
        }
        return ret;
    }

    private Map getModuleOptions(InputOptions options) {
        ViewerAttributeBean bean = this.getViewerAttrBean(options);
        if (bean != null) {
            return bean.getModuleOptions();
        }
        return null;
    }

    private ViewerAttributeBean getViewerAttrBean(InputOptions options) {
        HttpServletRequest request;
        if (options != null && (request = (HttpServletRequest)options.getOption("request")) != null) {
            return (ViewerAttributeBean)request.getAttribute("attributeBean");
        }
        return null;
    }
}

