/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class InputStreamFile<F extends BaseStorageFactory>
implements StorageFile {
    final String path;
    final int nameStart;
    final F storageFactory;

    InputStreamFile(F storageFactory, String path) {
        this.storageFactory = storageFactory;
        if (path == null || path.length() == 0) {
            this.path = ((BaseStorageFactory)storageFactory).dataDirectory;
            this.nameStart = -1;
        } else {
            StringBuilder sb = new StringBuilder(((BaseStorageFactory)storageFactory).separatedDataDirectory);
            if (File.separatorChar != '/') {
                sb.append(path.replace(File.separatorChar, '/'));
            } else {
                sb.append(path);
            }
            this.path = sb.toString();
            this.nameStart = this.path.lastIndexOf(47) + 1;
        }
    }

    InputStreamFile(F storageFactory, String parent, String name) {
        this.storageFactory = storageFactory;
        StringBuilder sb = new StringBuilder(((BaseStorageFactory)storageFactory).separatedDataDirectory);
        if (File.separatorChar != '/') {
            sb.append(parent.replace(File.separatorChar, '/'));
            sb.append('/');
            sb.append(name.replace(File.separatorChar, '/'));
        } else {
            sb.append(parent);
            sb.append('/');
            sb.append(name);
        }
        this.path = sb.toString();
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    InputStreamFile(InputStreamFile<F> dir, String name) {
        this.storageFactory = dir.storageFactory;
        StringBuilder sb = new StringBuilder(dir.path);
        sb.append('/');
        if (File.separatorChar != '/') {
            sb.append(name.replace(File.separatorChar, '/'));
        } else {
            sb.append(name);
        }
        this.path = sb.toString();
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    InputStreamFile(F storageFactory, String child, int pathLen) {
        this.storageFactory = storageFactory;
        this.path = child.substring(0, pathLen);
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    public boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        InputStreamFile otherFile = (InputStreamFile)other;
        return this.path.equals(otherFile.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public abstract boolean exists();

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public boolean deleteAll() {
        return false;
    }

    @Override
    public String getPath() {
        if (File.separatorChar != '/') {
            return this.path.replace('/', File.separatorChar);
        }
        return this.path;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return ((BaseStorageFactory)this.storageFactory).getCanonicalName() + "/" + this.path;
    }

    @Override
    public String getName() {
        return this.nameStart < 0 ? "" : this.path.substring(this.nameStart);
    }

    @Override
    public boolean createNewFile() throws IOException {
        throw new IOException("createNewFile called in a read-only file system.");
    }

    @Override
    public boolean renameTo(StorageFile newName) {
        return false;
    }

    @Override
    public boolean mkdir() {
        return false;
    }

    @Override
    public boolean mkdirs() {
        return false;
    }

    @Override
    public StorageFile getParentDir() {
        if (this.path.length() <= ((BaseStorageFactory)this.storageFactory).separatedDataDirectory.length()) {
            return null;
        }
        return this.getParentDir(this.path.lastIndexOf(47));
    }

    abstract StorageFile getParentDir(int var1);

    @Override
    public boolean setReadOnly() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        throw new FileNotFoundException("Attempt to write into a read only file system.");
    }

    @Override
    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        throw new FileNotFoundException("Attempt to write into a read only file system.");
    }

    @Override
    public abstract InputStream getInputStream() throws FileNotFoundException;

    @Override
    public int getExclusiveFileLock() throws StandardException {
        return 0;
    }

    @Override
    public void releaseExclusiveFileLock() {
    }

    @Override
    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        SanityManager.NOTREACHED();
        return null;
    }

    public String toString() {
        return this.path;
    }

    @Override
    public void limitAccessToOwner() {
    }
}

