/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.pkg;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.report.engine.odf.pkg.PackageEntry;
import org.eclipse.birt.report.engine.odf.writer.ManifestWriter;

public class Package {
    private static Logger logger = Logger.getLogger(Package.class.getName());
    private static final String MANIFEST_URI = "META-INF/manifest.xml";
    private static final String MIME_URI = "mimetype";
    private Map<String, PackageEntry> entries;
    private String tempFileName;
    private ArchiveWriter archiveWriter;
    private ArchiveFile archive;
    private ZipOutputStream zipStream;
    private boolean hasEntryWriter;
    private boolean closed = false;
    private String rootMime;

    public static Package createInstance(OutputStream out, String tempFileDir, String rootMime) {
        try {
            File tempFile = File.createTempFile("BIRT_ODF_Temp_", "", new File(tempFileDir));
            return new Package(tempFile.getAbsolutePath(), out, rootMime);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    private Package(String tempFileName, OutputStream out, String rootMime) throws IOException {
        this.tempFileName = tempFileName;
        this.archive = new ArchiveFile(tempFileName, "rw");
        this.archive.setCacheSize(4096L);
        this.archiveWriter = new ArchiveWriter(this.archive);
        this.rootMime = rootMime;
        this.closed = false;
        this.entries = new HashMap<String, PackageEntry>();
        this.zipStream = new ZipOutputStream(out);
    }

    OutputStream getCachedOutputStream(String uri) throws IOException {
        this.assertOpen();
        return this.archiveWriter.getOutputStream(uri);
    }

    OutputStream getEntryOutputStream(String uri) throws IOException {
        this.assertOpen();
        return new EntryOutputStream(uri);
    }

    public PackageEntry addEntry(String uri, String contentType) {
        PackageEntry entry = new PackageEntry(this, uri, contentType, false);
        this.entries.put(uri, entry);
        return entry;
    }

    void addEntry(PackageEntry entry) {
        this.entries.put(entry.getUri(), entry);
    }

    public PackageEntry addCachedEntry(String uri, String contentType) {
        PackageEntry entry = new PackageEntry(this, uri, contentType, true);
        this.entries.put(uri, entry);
        return entry;
    }

    public void close() throws IOException {
        try {
            this.save();
            this.writeMimeFile();
            this.writeManifest();
        }
        finally {
            this.zipStream.flush();
            this.zipStream.close();
        }
        this.archiveWriter.flush();
        this.archive.close();
        File file = new File(this.tempFileName);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
        this.closed = true;
    }

    private void save() throws IOException {
        for (PackageEntry entry : this.entries.values()) {
            if (!entry.isCached()) continue;
            String uri = entry.getUri();
            try (InputStream input = null;){
                if (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                input = this.archiveWriter.getInputStream(entry.getUri());
                this.zipStream.putNextEntry(new ZipEntry(uri));
                int length = -1;
                byte[] buf = new byte[4096];
                while ((length = input.read(buf)) != -1) {
                    this.zipStream.write(buf, 0, length);
                }
                this.zipStream.closeEntry();
            }
        }
    }

    private void writeMimeFile() throws IOException {
        this.zipStream.putNextEntry(new ZipEntry(MIME_URI));
        this.zipStream.write(this.rootMime.getBytes());
        this.zipStream.closeEntry();
    }

    private void writeManifest() throws IOException {
        this.zipStream.putNextEntry(new ZipEntry(MANIFEST_URI));
        this.zipStream.write(this.GetByteArrayFromManifestWriter());
        this.zipStream.closeEntry();
    }

    private byte[] GetByteArrayFromManifestWriter() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ManifestWriter writer = new ManifestWriter(out);
        writer.start(this.rootMime);
        for (PackageEntry entry : this.entries.values()) {
            writer.writeEntry(entry);
        }
        writer.end();
        return out.toByteArray();
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Package is already closed");
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        public EntryOutputStream(String entry) throws IOException {
            super(Package.this.zipStream);
            if (Package.this.hasEntryWriter) {
                throw new RuntimeException("Can't open more than one entry writers concurrently.");
            }
            Package.this.hasEntryWriter = true;
            Package.this.zipStream.putNextEntry(new ZipEntry(entry));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Package.this.zipStream.write(b, off, len);
        }

        @Override
        public void close() {
            Package.this.hasEntryWriter = false;
            try {
                Package.this.zipStream.flush();
                Package.this.zipStream.closeEntry();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
    }
}

