/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.internal.texteditor.LineNumberColumn;
import org.eclipse.ui.internal.texteditor.stickyscroll.IStickyLine;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingControlSettings;
import org.eclipse.ui.internal.texteditor.stickyscroll.StickyScrollingHandler;

public class StickyScrollingControl {
    private static final int MIN_VISIBLE_EDITOR_LINES_THRESHOLD = 3;
    private static final String DISABLE_CSS = "org.eclipse.e4.ui.css.disabled";
    private List<IStickyLine> stickyLines;
    private ISourceViewer sourceViewer;
    private IVerticalRuler verticalRuler;
    private StickyScrollingControlSettings settings;
    private Canvas stickyLinesCanvas;
    private StyledText stickyLineNumber;
    private StyledText stickyLineText;
    private ITextPresentationListener textPresentationListener;
    private ControlListener controlListener;
    private StickyScollingCaretListener caretListener;
    private Composite bottomSeparator;
    private StickyScrollingHandler stickyScrollingHandler;
    private int maximumVisibleStickyLines = Integer.MAX_VALUE;

    public StickyScrollingControl(ISourceViewer sourceViewer, StickyScrollingControlSettings settings) {
        this(sourceViewer, null, settings, null);
    }

    public StickyScrollingControl(ISourceViewer sourceViewer, IVerticalRuler verticalRuler, StickyScrollingControlSettings settings, StickyScrollingHandler stickyScrollingHandler) {
        this.stickyScrollingHandler = stickyScrollingHandler;
        this.stickyLines = new ArrayList<IStickyLine>();
        this.sourceViewer = sourceViewer;
        this.verticalRuler = verticalRuler;
        this.settings = settings;
        this.createControls();
        this.addSourceViewerListeners();
    }

    public void setStickyLines(List<IStickyLine> stickyLines) {
        if (!stickyLines.equals(this.stickyLines)) {
            this.stickyLines = stickyLines;
            this.updateStickyScrollingControls();
        }
    }

    public void applySettings(StickyScrollingControlSettings newSettings) {
        this.settings = newSettings;
        this.stickyLineNumber.setBackground(newSettings.stickyLineBackgroundColor());
        this.stickyLineText.setBackground(newSettings.stickyLineBackgroundColor());
        this.bottomSeparator.setBackground(this.settings.stickyLinesSeparatorColor());
        this.updateStickyScrollingControls();
        this.styleStickyLines();
        this.layoutStickyLines();
    }

    public void dispose() {
        ISourceViewer iSourceViewer = this.sourceViewer;
        if (iSourceViewer instanceof ITextViewerExtension4) {
            ITextViewerExtension4 extension = (ITextViewerExtension4)iSourceViewer;
            extension.removeTextPresentationListener(this.textPresentationListener);
        }
        if (this.sourceViewer.getTextWidget() != null) {
            this.sourceViewer.getTextWidget().removeControlListener(this.controlListener);
            this.sourceViewer.getTextWidget().removeKeyListener((KeyListener)this.caretListener);
            this.sourceViewer.getTextWidget().removeCaretListener((CaretListener)this.caretListener);
        }
        this.stickyLinesCanvas.dispose();
    }

    private void createControls() {
        Composite sourceViewerComposite = null;
        ISourceViewer iSourceViewer = this.sourceViewer;
        if (iSourceViewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)iSourceViewer;
            sourceViewerComposite = (Composite)extension.getControl();
        } else {
            sourceViewerComposite = this.sourceViewer.getTextWidget().getParent();
        }
        this.stickyLinesCanvas = new Canvas(sourceViewerComposite, 0);
        this.addMouseListeners(this.stickyLinesCanvas);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo((Composite)this.stickyLinesCanvas);
        this.stickyLineNumber = new StyledText((Composite)this.stickyLinesCanvas, 16448);
        GridDataFactory.fillDefaults().grab(false, true).exclude(this.verticalRuler == null).applyTo((Control)this.stickyLineNumber);
        this.stickyLineNumber.setVisible(this.verticalRuler != null);
        this.stickyLineNumber.setEnabled(false);
        this.stickyLineNumber.setBackground(this.settings.stickyLineBackgroundColor());
        this.stickyLineText = new StyledText((Composite)this.stickyLinesCanvas, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.stickyLineText);
        this.stickyLineText.setEnabled(false);
        this.stickyLineText.setBackground(this.settings.stickyLineBackgroundColor());
        this.bottomSeparator = new Composite((Composite)this.stickyLinesCanvas, 0);
        GridDataFactory.fillDefaults().hint(0, 3).grab(true, false).span(2, 1).applyTo((Control)this.bottomSeparator);
        this.bottomSeparator.setEnabled(false);
        this.bottomSeparator.setData(DISABLE_CSS, (Object)Boolean.TRUE);
        this.bottomSeparator.setBackground(this.settings.stickyLinesSeparatorColor());
        this.layoutLineNumbers();
        this.limitVisibleStickyLinesToTextWidgetHeight(this.sourceViewer.getTextWidget());
        this.stickyLinesCanvas.pack();
        this.stickyLinesCanvas.moveAbove(null);
    }

    private void updateStickyScrollingControls() {
        StringJoiner stickyLineTextJoiner = new StringJoiner(System.lineSeparator());
        StringJoiner stickyLineNumberJoiner = new StringJoiner(System.lineSeparator());
        int i = 0;
        while (i < this.getNumberStickyLines()) {
            IStickyLine stickyLine = this.stickyLines.get(i);
            stickyLineTextJoiner.add(stickyLine.getText());
            int lineNumber = this.getSourceViewerLineNumber(stickyLine.getLineNumber());
            stickyLineNumberJoiner.add(this.fillLineNumberWithLeadingSpaces(lineNumber + 1));
            ++i;
        }
        String newStickyLineText = stickyLineTextJoiner.toString();
        String newStickyLineNumber = stickyLineNumberJoiner.toString();
        if (!newStickyLineText.equals(this.stickyLineText.getText()) || !newStickyLineNumber.equals(this.stickyLineNumber.getText())) {
            this.stickyLineText.setText(stickyLineTextJoiner.toString());
            this.stickyLineNumber.setText(stickyLineNumberJoiner.toString());
            this.styleStickyLines();
            this.layoutStickyLines();
        }
    }

    private int getSourceViewerLineNumber(int i) {
        ISourceViewer iSourceViewer = this.sourceViewer;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)iSourceViewer;
            return extension.widgetLine2ModelLine(i);
        }
        return i;
    }

    private String fillLineNumberWithLeadingSpaces(int lineNumber) {
        int lineCount = this.sourceViewer.getDocument().getNumberOfLines();
        int lineNumberLength = String.valueOf(lineCount).length();
        String formatString = "%" + lineNumberLength + "d";
        return String.format(formatString, lineNumber);
    }

    private void styleStickyLines() {
        StyledText textWidget = this.sourceViewer.getTextWidget();
        if (textWidget == null || textWidget.isDisposed()) {
            return;
        }
        ArrayList<StyleRange> stickyLinesStyleRanges = new ArrayList<StyleRange>();
        int stickyLineTextOffset = 0;
        int i = 0;
        while (i < this.getNumberStickyLines()) {
            IStickyLine stickyLine = this.stickyLines.get(i);
            StyleRange[] ranges = stickyLine.getStyleRanges();
            if (ranges != null) {
                StyleRange[] styleRangeArray = ranges;
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    StyleRange styleRange = styleRangeArray[n2];
                    styleRange.start += stickyLineTextOffset;
                    stickyLinesStyleRanges.add(styleRange);
                    ++n2;
                }
            }
            stickyLineTextOffset += stickyLine.getText().length() + System.lineSeparator().length();
            ++i;
        }
        this.stickyLineText.setStyleRanges((StyleRange[])stickyLinesStyleRanges.toArray(StyleRange[]::new));
        this.stickyLineNumber.setFont(textWidget.getFont());
        this.stickyLineNumber.setStyleRange(new StyleRange(0, this.stickyLineNumber.getText().length(), this.settings.lineNumberColor(), null));
        this.stickyLineNumber.setLineSpacing(textWidget.getLineSpacing());
        this.stickyLineText.setFont(textWidget.getFont());
        this.stickyLineText.setForeground(textWidget.getForeground());
        this.stickyLineText.setLineSpacing(textWidget.getLineSpacing());
        this.stickyLineText.setLeftMargin(textWidget.getLeftMargin());
    }

    private void layoutStickyLines() {
        if (this.getNumberStickyLines() == 0) {
            this.stickyLinesCanvas.setVisible(false);
            return;
        }
        this.layoutLineNumbers();
        this.stickyLinesCanvas.setVisible(true);
        this.calculateAndSetStickyLinesCanvasBounds();
    }

    private void layoutLineNumbers() {
        if (this.verticalRuler == null) {
            return;
        }
        LineNumberColumn lineNumberColumn = this.getLineNumberColumn(this.verticalRuler);
        if (!this.settings.showLineNumbers()) {
            this.stickyLineNumber.setRightMargin(this.verticalRuler.getWidth());
            ((GridData)this.stickyLineNumber.getLayoutData()).widthHint = 0;
            this.stickyLineNumber.setLeftMargin(0);
        } else if (lineNumberColumn == null) {
            ((GridData)this.stickyLineNumber.getLayoutData()).widthHint = this.verticalRuler.getWidth();
            GC gc = new GC((Drawable)this.stickyLinesCanvas);
            gc.setFont(this.sourceViewer.getTextWidget().getFont());
            String lastLineNumber = String.valueOf(this.sourceViewer.getTextWidget().getLineCount());
            Point p = gc.textExtent(lastLineNumber);
            int textWidth = p.x;
            gc.dispose();
            int width = this.verticalRuler.getWidth();
            int left = (width - textWidth) / 2;
            this.stickyLineNumber.setLeftMargin(left);
            ((GridData)this.stickyLineNumber.getLayoutData()).widthHint = textWidth;
            this.stickyLineNumber.setRightMargin(width - left - textWidth);
        } else {
            Rectangle lineNumberBounds = lineNumberColumn.getControl().getBounds();
            this.stickyLineNumber.setLeftMargin(lineNumberBounds.x);
            ((GridData)this.stickyLineNumber.getLayoutData()).widthHint = lineNumberBounds.width;
            this.stickyLineNumber.setRightMargin(this.verticalRuler.getWidth() - lineNumberBounds.x - lineNumberBounds.width);
        }
        this.stickyLinesCanvas.layout();
    }

    private LineNumberColumn getLineNumberColumn(IVerticalRuler ruler) {
        if (ruler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)ruler;
            Iterator decoratorIterator = compositeRuler.getDecoratorIterator();
            while (decoratorIterator.hasNext()) {
                IVerticalRulerColumn colum = (IVerticalRulerColumn)decoratorIterator.next();
                if (!(colum instanceof LineNumberColumn)) continue;
                LineNumberColumn lineNumberColumn = (LineNumberColumn)colum;
                return lineNumberColumn;
            }
        }
        return null;
    }

    private void calculateAndSetStickyLinesCanvasBounds() {
        StyledText textWidget = this.sourceViewer.getTextWidget();
        int numberStickyLines = this.getNumberStickyLines();
        int lineHeight = this.stickyLineText.getLineHeight() * numberStickyLines;
        int spacingHeight = this.stickyLineText.getLineSpacing() * (numberStickyLines - 1);
        int separatorHeight = this.bottomSeparator.getBounds().height;
        int rulerWidth = this.verticalRuler != null ? this.verticalRuler.getWidth() : 0;
        int textWidth = textWidget.getClientArea().width + 1;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        bounds.height = lineHeight + spacingHeight + separatorHeight;
        bounds.width = rulerWidth + textWidth;
        this.stickyLinesCanvas.setBounds(bounds);
    }

    private void navigateToClickedLine(MouseEvent event) {
        int clickedStickyLineIndex = this.stickyLineText.getLineIndex(event.y);
        IStickyLine clickedStickyLine = this.stickyLines.get(clickedStickyLineIndex);
        try {
            int offset = this.sourceViewer.getDocument().getLineOffset(clickedStickyLine.getLineNumber());
            this.sourceViewer.setSelectedRange(offset, 0);
            this.ensureSourceViewerLineVisible(clickedStickyLine.getLineNumber());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void ensureSourceViewerLineVisible(int line) {
        ISourceViewer iSourceViewer = this.sourceViewer;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)iSourceViewer;
            line = extension.modelLine2WidgetLine(line);
        }
        StyledText textWidget = this.sourceViewer.getTextWidget();
        int bottomIndex = JFaceTextUtil.getBottomIndex((StyledText)textWidget);
        if (line < textWidget.getTopIndex() + this.settings.maxCountStickyLines() || line > bottomIndex) {
            int jumpTo = Math.max(0, line - this.settings.maxCountStickyLines());
            ISourceViewer iSourceViewer2 = this.sourceViewer;
            if (iSourceViewer2 instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)iSourceViewer2;
                jumpTo = extension.widgetLine2ModelLine(jumpTo);
            }
            this.sourceViewer.setTopIndex(jumpTo);
        }
    }

    private int getNumberStickyLines() {
        int numberStickyLines = Math.min(this.settings.maxCountStickyLines(), this.stickyLines.size());
        numberStickyLines = Math.min(this.maximumVisibleStickyLines, numberStickyLines);
        return numberStickyLines;
    }

    private void addSourceViewerListeners() {
        ISourceViewer iSourceViewer = this.sourceViewer;
        if (iSourceViewer instanceof ITextViewerExtension4) {
            ITextViewerExtension4 extension = (ITextViewerExtension4)iSourceViewer;
            this.textPresentationListener = e -> Job.create((String)"Update sticky lines styling", monitor -> Display.getDefault().asyncExec(() -> this.styleStickyLines())).schedule();
            extension.addTextPresentationListener(this.textPresentationListener);
        }
        this.caretListener = new StickyScollingCaretListener();
        this.sourceViewer.getTextWidget().addCaretListener((CaretListener)this.caretListener);
        this.sourceViewer.getTextWidget().addKeyListener((KeyListener)this.caretListener);
        this.controlListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                StyledText textWidget = StickyScrollingControl.this.sourceViewer.getTextWidget();
                StickyScrollingControl.this.limitVisibleStickyLinesToTextWidgetHeight(textWidget);
                StickyScrollingControl.this.layoutStickyLines();
                if (StickyScrollingControl.this.stickyScrollingHandler != null) {
                    StickyScrollingControl.this.stickyScrollingHandler.viewportChanged(textWidget.getTopPixel());
                }
            }

            public void controlMoved(ControlEvent e) {
                StickyScrollingControl.this.layoutStickyLines();
            }
        };
        this.sourceViewer.getTextWidget().addControlListener(this.controlListener);
    }

    private void limitVisibleStickyLinesToTextWidgetHeight(StyledText textWidget) {
        int lineHeight = textWidget.getLineHeight() + textWidget.getLineSpacing();
        int textWidgetHeight = textWidget.getBounds().height;
        int visibleLinesInTextWidget = textWidgetHeight / lineHeight;
        this.maximumVisibleStickyLines = Math.max(0, visibleLinesInTextWidget - 3);
        this.updateStickyScrollingControls();
    }

    private void addMouseListeners(Canvas canvas) {
        canvas.setCursor(Display.getDefault().getSystemCursor(21));
        canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StickyScrollingControl.this.navigateToClickedLine(e);
            }
        });
        canvas.addMouseMoveListener(e -> {
            int affectedStickyLineIndex = this.stickyLineText.getLineIndex(e.y);
            this.stickyLineText.setLineBackground(0, this.getNumberStickyLines(), null);
            this.stickyLineText.setLineBackground(affectedStickyLineIndex, 1, this.settings.stickyLineHoverColor());
        });
        canvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                StickyScrollingControl.this.stickyLineText.setLineBackground(0, StickyScrollingControl.this.getNumberStickyLines(), null);
            }
        });
        ScrollingDispatchingListener scrollingDispatchingListener = new ScrollingDispatchingListener();
        canvas.addListener(38, (Listener)scrollingDispatchingListener);
        canvas.addListener(37, (Listener)scrollingDispatchingListener);
    }

    class ScrollingDispatchingListener
    implements Listener {
        ScrollingDispatchingListener() {
        }

        public void handleEvent(Event event) {
            ScrollBar bar;
            StyledText textWidget = StickyScrollingControl.this.sourceViewer.getTextWidget();
            ScrollBar scrollBar = bar = event.type == 38 ? textWidget.getHorizontalBar() : textWidget.getVerticalBar();
            if (bar == null) {
                return;
            }
            int deltaY = event.count;
            if (-1 < deltaY && deltaY < 0) {
                deltaY = -1;
            }
            if (deltaY > 0 && deltaY < 1) {
                deltaY = 1;
            }
            int pixel = Math.max(0, (int)(0.5f + (float)bar.getSelection() - (float)(bar.getIncrement() * deltaY)));
            if (event.type == 38) {
                StickyScrollingControl.this.sourceViewer.getTextWidget().setHorizontalPixel(pixel);
            } else {
                StickyScrollingControl.this.sourceViewer.getTextWidget().setTopPixel(pixel);
                if (StickyScrollingControl.this.stickyScrollingHandler != null) {
                    StickyScrollingControl.this.stickyScrollingHandler.viewportChanged(pixel);
                }
            }
        }
    }

    class StickyScollingCaretListener
    implements CaretListener,
    KeyListener {
        private boolean enableCaretListener;

        StickyScollingCaretListener() {
        }

        public void keyPressed(KeyEvent e) {
            this.enableCaretListener = true;
        }

        public void keyReleased(KeyEvent e) {
            this.enableCaretListener = false;
        }

        public void caretMoved(CaretEvent event) {
            int offsetEndPosition = StickyScrollingControl.this.sourceViewer.getTextWidget().getCharCount();
            if (event.caretOffset == 0 || event.caretOffset == offsetEndPosition) {
                return;
            }
            Display.getDefault().asyncExec(() -> {
                StyledText textWidget = StickyScrollingControl.this.sourceViewer.getTextWidget();
                if (!this.enableCaretListener || caretEvent.caretOffset > textWidget.getCharCount()) {
                    return;
                }
                int line = textWidget.getLineAtOffset(caretEvent.caretOffset);
                ISourceViewer iSourceViewer = StickyScrollingControl.this.sourceViewer;
                if (iSourceViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)iSourceViewer;
                    line = extension.widgetLine2ModelLine(line);
                }
                StickyScrollingControl.this.ensureSourceViewerLineVisible(line);
            });
        }
    }
}

