/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationPreferenceListener;
import org.eclipse.pde.ds.internal.annotations.DSLibPluginModelListener;
import org.eclipse.pde.ds.internal.annotations.ProjectClasspathPreferenceChangeListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.pde.ds.annotations";
    public static final String PREF_ENABLED = "enabled";
    public static final String PREF_PATH = "path";
    public static final String PREF_SPEC_VERSION = "dsVersion";
    public static final String PREF_VALIDATION_ERROR_LEVEL = "validationErrorLevel";
    public static final String PREF_MISSING_UNBIND_METHOD_ERROR_LEVEL = "validationErrorLevel.missingImplicitUnbindMethod";
    public static final String PREF_GENERATE_BAPL = "generateBundleActivationPolicyLazy";
    public static final String DEFAULT_PATH = "OSGI-INF";
    public static final String CP_ATTRIBUTE = "org.eclipse.pde.ds.annotations.cp";
    private static Activator plugin;
    private DSAnnotationPreferenceListener dsPrefListener;
    private final HashMap<IJavaProject, ProjectClasspathPreferenceChangeListener> projectPrefListeners = new HashMap();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.dsPrefListener = new DSAnnotationPreferenceListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        DSLibPluginModelListener.dispose();
        this.dsPrefListener.dispose();
        HashMap<IJavaProject, ProjectClasspathPreferenceChangeListener> hashMap = this.projectPrefListeners;
        synchronized (hashMap) {
            for (ProjectClasspathPreferenceChangeListener listener : this.projectPrefListeners.values()) {
                listener.dispose();
            }
            this.projectPrefListeners.clear();
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        Activator.log(Status.error((String)e.getMessage(), (Throwable)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listenForClasspathPreferenceChanges(IJavaProject project) {
        HashMap<IJavaProject, ProjectClasspathPreferenceChangeListener> hashMap = this.projectPrefListeners;
        synchronized (hashMap) {
            if (!this.projectPrefListeners.containsKey(project)) {
                this.projectPrefListeners.put(project, new ProjectClasspathPreferenceChangeListener(project));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeProjectClasspathPreferenceChangeListener(IJavaProject project) {
        HashMap<IJavaProject, ProjectClasspathPreferenceChangeListener> hashMap = this.projectPrefListeners;
        synchronized (hashMap) {
            ProjectClasspathPreferenceChangeListener listener = this.projectPrefListeners.remove(project);
            if (listener != null) {
                listener.dispose();
            }
        }
    }
}

