/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ui.core;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.internal.dbitem.SQLObjectItem;

public class IngresSQLObjectItem
extends SQLObjectItem {
    private static final Pattern RESULT_ROW_PATTERN = Pattern.compile("(\\s*)(create)(.*)(result)(\\s*)(row)(.*)(begin)(.*)", 42);

    public IngresSQLObjectItem(ProcIdentifier proc, SQLObject routine, IControlConnection controlConn) {
        super(proc, routine, controlConn);
    }

    public ParameterDescriptor[] getParameterDescriptor() throws SQLException {
        ParameterDescriptor[] pds = super.getParameterDescriptor();
        if (pds != null) {
            int i = 0;
            while (i < pds.length) {
                if (this.isRowProducing()) {
                    pds[i].setParmType(1);
                } else {
                    pds[i].setParmType(2);
                }
                ++i;
            }
        }
        return pds;
    }

    private boolean isRowProducing() {
        Routine ingresProcedure;
        boolean result = true;
        if (this._routine instanceof Routine && (ingresProcedure = (Routine)this._routine).getSource() != null && ingresProcedure.getSource().getBody() != null) {
            Matcher matcher = RESULT_ROW_PATTERN.matcher(ingresProcedure.getSource().getBody());
            result = matcher.matches();
        }
        return result;
    }
}

