/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import com.ibm.icu.util.ULocale;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CompatibleBoundColumnsTest
extends BaseTestCase {
    public void testExpressionCompatible() throws Exception {
        this.openDesign("CompatibleBirt2_1M5Expr.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleBirt2_1M5Expr_golden.xml"));
    }

    public void testDataValueExpr() throws Exception {
        this.openDesign("Birt2_1_0Expr.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("Birt2_1_0Expr_golden.xml"));
    }

    public void testTextContent() throws Exception {
        this.openDesign("Birt2_1_M5TextContent.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("Birt2_1_M5TextContent_golden.xml"));
    }

    public void testNestedTable() throws Exception {
        this.openDesign("CompatibleBoundColumnNestedTable.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleBoundColumnNestedTable_golden.xml"));
    }

    public void testDataValueExprWithGroup() throws Exception {
        this.openDesign("CompatibleDataValueExprWithGroup.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleDataValueExprWithGroup_golden.xml"));
    }

    public void testGroupBoundCOlumns() throws Exception {
        this.openDesign("CompatibleBoundDataColumnGroupTest.xml");
        ListingHandle tableHandle = (ListingHandle)this.designHandle.findElement("MyTable1");
        GroupHandle group = (GroupHandle)tableHandle.getGroups().get(0);
        CompatibleBoundColumnsTest.assertEquals((String)"NewTableGroup1", (String)group.getName());
        Iterator iter = tableHandle.columnBindingsIterator();
        ComputedColumnHandle structure = (ComputedColumnHandle)iter.next();
        CompatibleBoundColumnsTest.assertEquals((String)"column1", (String)structure.getName());
        structure = (ComputedColumnHandle)iter.next();
        CompatibleBoundColumnsTest.assertEquals((String)"column2", (String)structure.getName());
        CompatibleBoundColumnsTest.assertEquals((String)group.getName(), (String)structure.getAggregateOn());
        tableHandle = (ListingHandle)this.designHandle.findElement("MyTable2");
        group = (GroupHandle)tableHandle.getGroups().get(1);
        CompatibleBoundColumnsTest.assertEquals((String)"NewTableGroup1", (String)group.getName());
        group = (GroupHandle)tableHandle.getGroups().get(0);
        CompatibleBoundColumnsTest.assertEquals((String)"NewTableGroup2", (String)group.getName());
        iter = tableHandle.columnBindingsIterator();
        structure = (ComputedColumnHandle)iter.next();
        structure = (ComputedColumnHandle)iter.next();
        CompatibleBoundColumnsTest.assertEquals((String)"column3", (String)structure.getName());
        CompatibleBoundColumnsTest.assertEquals((String)group.getName(), (String)structure.getAggregateOn());
        structure = (ComputedColumnHandle)iter.next();
        CompatibleBoundColumnsTest.assertFalse((boolean)iter.hasNext());
    }

    public void testGroupExprssion() throws Exception {
        this.openDesign("CompatibleGroupExpression.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleGroupExpression_golden.xml"));
        this.openDesign("CompatibleGroupExpression_1.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleGroupExpression_golden_1.xml"));
    }

    public void testRows() throws Exception {
        this.openDesign("CompatibleRowsExpr_1.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleRowsExpr_golden_1.xml"));
        this.openDesign("CompatibleRowsExpr_2.xml", ULocale.ENGLISH);
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleRowsExpr_golden_2.xml"));
        this.openDesign("CompatibleRowsExpr_3.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleRowsExpr_golden_3.xml"));
        this.openDesign("CompatibleRowsExpr_NoChange.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleRowsExpr_NoChange_golden.xml"));
        this.openDesign("CompatibleRowsExpr_4.xml");
        this.save();
        CompatibleBoundColumnsTest.assertTrue((boolean)this.compareFile("CompatibleRowsExpr_golden_4.xml"));
    }
}

