/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.elements.structures.DimensionCondition;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class DimensionJoinConditionHandleTest
extends BaseTestCase {
    public void testDropAndClear() throws Exception {
        this.openDesign("DimensionJoinConditionHandleTest_2.xml");
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("Customer Cube");
        PropertyHandle propHandle = cube.getPropertyHandle("dimensionConditions");
        ArrayList propList = propHandle.getListValue();
        DimensionJoinConditionHandleTest.assertEquals((int)3, (int)propList.size());
        propHandle.drop(0);
        DimensionJoinConditionHandleTest.assertEquals((int)2, (int)propHandle.getListValue().size());
        DimensionHandle dimensionHandle = cube.getDimension("Group");
        dimensionHandle.dropAndClear();
        this.save();
        DimensionJoinConditionHandleTest.assertTrue((boolean)this.compareFile("DimensionJoinConditionHandleTest_golden.xml"));
    }

    public void testEquals() throws Exception {
        this.openDesign("DimensionJoinConditionHandleTest.xml");
        TabularCubeHandle cube = (TabularCubeHandle)this.designHandle.findCube("testCube");
        DimensionCondition condition = new DimensionCondition();
        DimensionConditionHandle structHandle = cube.addDimensionCondition(condition);
        DimensionJoinConditionHandle joinConditionHandle = structHandle.addJoinCondition(new DimensionJoinCondition());
        joinConditionHandle.setCubeKey("addCubeKey");
        joinConditionHandle.setHierarchyKey("addHierarchyKey");
        DimensionJoinConditionHandle joinConditionHandle2 = structHandle.addJoinCondition(new DimensionJoinCondition());
        joinConditionHandle2.setCubeKey("addCubeKey");
        joinConditionHandle2.setHierarchyKey("addHierarchyKey");
        DimensionJoinConditionHandleTest.assertFalse((boolean)joinConditionHandle.equals((Object)joinConditionHandle2));
        DimensionJoinConditionHandleTest.assertTrue((boolean)joinConditionHandle.equals(structHandle.getJoinConditions().get(0)));
    }
}

