/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.writer.ExtendedXMLWriter;
import org.eclipse.birt.report.engine.odf.writer.StyleEntryWriter;

public class ContentWriter {
    protected ExtendedXMLWriter writer;
    private int reportDpi;

    public ContentWriter(OutputStream out, int reportDpi) {
        this.reportDpi = reportDpi;
        this.writer = new ExtendedXMLWriter();
        this.writer.open(out);
    }

    public void write(Collection<StyleEntry> styles, InputStream bodyStream) throws IOException {
        this.writer.startWriter();
        this.writeDocumentHeader();
        this.writeAutomaticStyles(styles);
        this.writeBody(bodyStream);
        this.writeDocumentFooter();
        this.writer.endWriter();
        this.writer.close();
    }

    private void writeDocumentHeader() {
        this.writer.literal("\n");
        this.writer.openTag("office:document-content");
        this.writer.attribute("xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        this.writer.attribute("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        this.writer.attribute("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        this.writer.attribute("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        this.writer.attribute("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        this.writer.attribute("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        this.writer.attribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.writer.attribute("xmlns:dc", "http://purl.org/dc/elements/1.1/");
        this.writer.attribute("xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        this.writer.attribute("xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        this.writer.attribute("xmlns:svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        this.writer.attribute("xmlns:chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        this.writer.attribute("xmlns:dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        this.writer.attribute("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        this.writer.attribute("xmlns:form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        this.writer.attribute("xmlns:script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        this.writer.attribute("xmlns:ooo", "http://openoffice.org/2004/office");
        this.writer.attribute("xmlns:ooow", "http://openoffice.org/2004/writer");
        this.writer.attribute("xmlns:oooc", "http://openoffice.org/2004/calc");
        this.writer.attribute("xmlns:dom", "http://www.w3.org/2001/xml-events");
        this.writer.attribute("xmlns:xforms", "http://www.w3.org/2002/xforms");
        this.writer.attribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        this.writer.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.writer.attribute("xmlns:rpt", "http://openoffice.org/2005/report");
        this.writer.attribute("xmlns:of", "urn:oasis:names:tc:opendocument:xmlns:of:1.2");
        this.writer.attribute("xmlns:xhtml", "http://www.w3.org/1999/xhtml");
        this.writer.attribute("xmlns:grddl", "http://www.w3.org/2003/g/data-view#");
        this.writer.attribute("xmlns:tableooo", "http://openoffice.org/2009/table");
        this.writer.attribute("xmlns:field", "urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0");
        this.writer.attribute("xmlns:formx", "urn:openoffice:names:experimental:ooxml-odf-interop:xmlns:form:1.0");
        this.writer.attribute("office:version", "1.2");
        this.writer.attribute("grddl:transformation", "http://docs.oasis-open.org/office/1.2/xslt/odf2rdf.xsl");
    }

    private void writeDocumentFooter() {
        this.writer.closeTag("office:document-content");
    }

    private void writeAutomaticStyles(Collection<StyleEntry> styles) {
        this.writer.openTag("office:automatic-styles");
        StyleEntryWriter styleWriter = new StyleEntryWriter(this.writer, this.reportDpi);
        styleWriter.writeStyles(styles);
        this.writer.closeTag("office:automatic-styles");
    }

    private void writeBody(InputStream bodyStream) throws IOException {
        this.writer.write(bodyStream);
    }
}

