/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.BigLevelsAndFactTableDataset;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivider;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.LevelsAndFactTableDataset;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.junit.Assert;
import org.junit.Test;

public class FactTableHelperTest {
    @Test
    public void testFactTableDocumentObjectNameUtil() throws IOException, BirtException {
        int[] i1 = new int[]{12, 13, 14, 15};
        Assert.assertEquals((Object)FactTableAccessor.FTSUDocumentObjectNamingUtil.getDocumentObjectName((String)"", (int[])i1), (Object)"12X13X14X15");
        int[] i2 = new int[]{12};
        Assert.assertEquals((Object)FactTableAccessor.FTSUDocumentObjectNamingUtil.getDocumentObjectName((String)"", (int[])i2), (Object)"12");
        int[] i3 = new int[]{1};
        Assert.assertEquals((Object)FactTableAccessor.FTSUDocumentObjectNamingUtil.getDocumentObjectName((String)"", (int[])i3), (Object)"1");
        int[] i4 = new int[]{1, 12, 313, 55514, 4415};
        Assert.assertEquals((Object)FactTableAccessor.FTSUDocumentObjectNamingUtil.getDocumentObjectName((String)"", (int[])i4), (Object)"1X12X313X55514X4415");
    }

    @Test
    public void testCombinedPositionCalculator() throws IOException, BirtException {
        DimensionDivision[] subDimensions = new DimensionDivision[]{new DimensionDivision(300, 3), new DimensionDivision(3000, 3), new DimensionDivision(30000, 3)};
        DimensionDivider.CombinedPositionContructor combinedPositionCalculator = new DimensionDivider.CombinedPositionContructor(subDimensions);
        int[] subdimensionNumber = new int[3];
        int[] dimensionPosition = new int[3];
        subdimensionNumber[0] = 0;
        subdimensionNumber[1] = 0;
        subdimensionNumber[2] = 1;
        dimensionPosition[0] = 64;
        dimensionPosition[1] = 512;
        dimensionPosition[2] = 10024;
        BigInteger bigInteger = combinedPositionCalculator.calculateCombinedPosition(subdimensionNumber, dimensionPosition);
        Assert.assertEquals((long)bigInteger.longValue(), (long)1082130456L);
        this.equal(combinedPositionCalculator.calculateDimensionPosition(subdimensionNumber, bigInteger.toByteArray()), dimensionPosition);
    }

    @Test
    public void testCombinedPositionCalculator1() throws IOException, BirtException {
        DimensionDivision[] subDimensions = new DimensionDivision[]{new DimensionDivision(768, 3), new DimensionDivision(768, 3), new DimensionDivision(768, 3)};
        DimensionDivider.CombinedPositionContructor combinedPositionCalculator = new DimensionDivider.CombinedPositionContructor(subDimensions);
        int[] subdimensionNumber = new int[3];
        int[] dimensionPosition = new int[3];
        subdimensionNumber[0] = 0;
        subdimensionNumber[1] = 1;
        subdimensionNumber[2] = 2;
        dimensionPosition[0] = 255;
        dimensionPosition[1] = 510;
        dimensionPosition[2] = 640;
        BigInteger bigInteger = combinedPositionCalculator.calculateCombinedPosition(subdimensionNumber, dimensionPosition);
        this.equal(combinedPositionCalculator.calculateDimensionPosition(subdimensionNumber, bigInteger.toByteArray()), dimensionPosition);
    }

    @Test
    public void testCombinedPositionCalculator2() throws IOException, BirtException {
        DimensionDivision[] subDimensions = new DimensionDivision[]{new DimensionDivision(300, 3), new DimensionDivision(3000, 3), new DimensionDivision(30000, 3), new DimensionDivision(3000000, 3), new DimensionDivision(3000000, 3)};
        DimensionDivider.CombinedPositionContructor combinedPositionCalculator = new DimensionDivider.CombinedPositionContructor(subDimensions);
        int[] subdimensionNumber = new int[5];
        int[] dimensionPosition = new int[5];
        subdimensionNumber[0] = 0;
        subdimensionNumber[1] = 0;
        subdimensionNumber[2] = 1;
        subdimensionNumber[3] = 1;
        subdimensionNumber[4] = 2;
        dimensionPosition[0] = 64;
        dimensionPosition[1] = 512;
        dimensionPosition[2] = 10024;
        dimensionPosition[3] = 1000024;
        dimensionPosition[4] = 2000024;
        BigInteger bigInteger = combinedPositionCalculator.calculateCombinedPosition(subdimensionNumber, dimensionPosition);
        long l = 1134696025030680L;
        BigInteger bigInteger1 = BigInteger.valueOf(l);
        bigInteger1 = bigInteger1.shiftLeft(20);
        bigInteger1 = bigInteger1.or(BigInteger.valueOf(24L));
        Assert.assertEquals((Object)bigInteger, (Object)bigInteger1);
        this.equal(combinedPositionCalculator.calculateDimensionPosition(subdimensionNumber, bigInteger.toByteArray()), dimensionPosition);
        dimensionPosition[0] = 64;
        dimensionPosition[1] = 512;
        dimensionPosition[2] = 24576;
        dimensionPosition[3] = 1000324;
        dimensionPosition[4] = 2030024;
        bigInteger = combinedPositionCalculator.calculateCombinedPosition(subdimensionNumber, dimensionPosition);
        this.equal(combinedPositionCalculator.calculateDimensionPosition(subdimensionNumber, bigInteger.toByteArray()), dimensionPosition);
    }

    private void equal(int[] i1, int[] i2) {
        Assert.assertEquals((long)i1.length, (long)i2.length);
        int i = 0;
        while (i < i1.length) {
            Assert.assertEquals((long)i1[i], (long)i2[i]);
            ++i;
        }
    }

    @Test
    public void testFactTableSaveAndLoad1() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad1(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad1(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        ILevelDefn[] levelDefs = new ILevelDefn[1];
        String[] levelNames = new String[]{"dimension1"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest.distinct(LevelsAndFactTableDataset.dimension1Col));
        levelDefs[0] = new LevelDefinition("dimension1", new String[]{"dimension1"}, null);
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        levelNames = new String[]{"dimension2"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest.distinct(LevelsAndFactTableDataset.dimension2Col));
        levelDefs[0] = new LevelDefinition("dimension2", new String[]{"dimension2"}, null);
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        levelNames = new String[]{"dimension3"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest.distinct(LevelsAndFactTableDataset.dimension3Col));
        levelDefs[0] = new LevelDefinition("dimension3", new String[]{"dimension3"}, null);
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        LevelsAndFactTableDataset factTableIterator = new LevelsAndFactTableDataset();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"threeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTableIterator, dimensions, measureColumnName, new StopSign());
        Assert.assertEquals((long)factTable.getSegmentCount(), (long)1L);
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"threeDimensions"), new StopSign());
        Assert.assertEquals((long)factTable.getSegmentCount(), (long)1L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[0].getDimensionName(), (Object)"dimension1");
        Assert.assertEquals((long)factTable.getDimensionInfo()[0].getDimensionLength(), (long)3L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[1].getDimensionName(), (Object)"dimension2");
        Assert.assertEquals((long)factTable.getDimensionInfo()[1].getDimensionLength(), (long)7L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[2].getDimensionName(), (Object)"dimension3");
        Assert.assertEquals((long)factTable.getDimensionInfo()[2].getDimensionLength(), (long)14L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[0].getMeasureName(), (Object)"measure1");
        Assert.assertEquals((long)factTable.getMeasureInfo()[0].getDataType(), (long)2L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[1].getMeasureName(), (Object)"measure2");
        Assert.assertEquals((long)factTable.getMeasureInfo()[1].getDataType(), (long)3L);
        String[] dimensionNames = new String[]{"dimension2"};
        IDiskArray[] dimensionPosition = new IDiskArray[]{new BufferedPrimitiveDiskArray()};
        dimensionPosition[0].add((Object)new Integer(1));
        dimensionPosition[0].add((Object)new Integer(2));
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNames, dimensionPosition, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)0L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)3L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(121), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(121.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)0L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)4L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(122), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(122.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)5L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(211), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(211.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)6L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(212), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(212.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertFalse((boolean)facttableRowIterator.next());
    }

    @Test
    public void testFactTableSaveAndLoad2() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad2(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad2(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        ILevelDefn[] levelDefs = new ILevelDefn[1];
        String[] levelNames = new String[]{"dimension1"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest.distinct(LevelsAndFactTableDataset.dimension1Col));
        levelDefs[0] = new LevelDefinition("dimension1", new String[]{"dimension1"}, null);
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        levelNames = new String[]{"dimension2"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest.distinct(LevelsAndFactTableDataset.dimension2Col));
        levelDefs[0] = new LevelDefinition("dimension2", new String[]{"dimension2"}, null);
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        levelNames = new String[]{"dimension3"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableHelperTest.distinct(LevelsAndFactTableDataset.dimension3Col));
        levelDefs[0] = new LevelDefinition("dimension3", new String[]{"dimension3"}, null);
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        LevelsAndFactTableDataset factTableIterator = new LevelsAndFactTableDataset();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"threeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTableIterator, dimensions, measureColumnName, new StopSign());
        Assert.assertEquals((long)factTable.getSegmentCount(), (long)1L);
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"threeDimensions"), new StopSign());
        Assert.assertEquals((long)factTable.getSegmentCount(), (long)1L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[0].getDimensionName(), (Object)"dimension1");
        Assert.assertEquals((long)factTable.getDimensionInfo()[0].getDimensionLength(), (long)3L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[1].getDimensionName(), (Object)"dimension2");
        Assert.assertEquals((long)factTable.getDimensionInfo()[1].getDimensionLength(), (long)7L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[2].getDimensionName(), (Object)"dimension3");
        Assert.assertEquals((long)factTable.getDimensionInfo()[2].getDimensionLength(), (long)14L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[0].getMeasureName(), (Object)"measure1");
        Assert.assertEquals((long)factTable.getMeasureInfo()[0].getDataType(), (long)2L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[1].getMeasureName(), (Object)"measure2");
        Assert.assertEquals((long)factTable.getMeasureInfo()[1].getDataType(), (long)3L);
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        IDiskArray[] dimensionPosition = new IDiskArray[3];
        dimensionPosition[0] = new BufferedPrimitiveDiskArray();
        dimensionPosition[0].add((Object)new Integer(1));
        dimensionPosition[0].add((Object)new Integer(2));
        dimensionPosition[1] = new BufferedPrimitiveDiskArray();
        dimensionPosition[1].add((Object)new Integer(1));
        dimensionPosition[1].add((Object)new Integer(2));
        dimensionPosition[2] = new BufferedPrimitiveDiskArray();
        dimensionPosition[2].add((Object)new Integer(1));
        dimensionPosition[2].add((Object)new Integer(2));
        dimensionPosition[2].add((Object)new Integer(3));
        dimensionPosition[2].add((Object)new Integer(4));
        dimensionPosition[2].add((Object)new Integer(5));
        dimensionPosition[2].add((Object)new Integer(6));
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNames, dimensionPosition, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)5L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(211), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(211.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)6L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(212), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(212.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertFalse((boolean)facttableRowIterator.next());
    }

    @Test
    public void testFactTableSaveAndLoad3() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad3(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad3(IDocumentManager documentManager) throws IOException, BirtException {
        long startTime = System.currentTimeMillis();
        Dimension[] dimensions = new Dimension[3];
        String[] levelNames = new String[]{"dimension1"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        int[] data = new int[BigLevelsAndFactTableDataset.dimensionPositionLength[0]];
        int i = 0;
        while (i < data.length) {
            data[i] = i;
            ++i;
        }
        iterator.setLevelMember(0, data);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("dimension1", new String[]{"dimension1"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        Assert.assertEquals((long)dimensions[0].length(), (long)BigLevelsAndFactTableDataset.dimensionPositionLength[0]);
        levelNames = new String[]{"dimension2"};
        iterator = new DimensionForTest(levelNames);
        data = new int[BigLevelsAndFactTableDataset.dimensionPositionLength[1]];
        int i2 = 0;
        while (i2 < data.length) {
            data[i2] = i2;
            ++i2;
        }
        iterator.setLevelMember(0, data);
        levelDefs[0] = new LevelDefinition("dimension2", new String[]{"dimension2"}, null);
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        Assert.assertEquals((long)dimensions[1].length(), (long)BigLevelsAndFactTableDataset.dimensionPositionLength[1]);
        levelNames = new String[]{"dimension3"};
        iterator = new DimensionForTest(levelNames);
        data = new int[BigLevelsAndFactTableDataset.dimensionPositionLength[2]];
        i2 = 0;
        while (i2 < data.length) {
            data[i2] = i2;
            ++i2;
        }
        iterator.setLevelMember(0, data);
        levelDefs[0] = new LevelDefinition("dimension3", new String[]{"dimension3"}, null);
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        Assert.assertEquals((long)dimensions[2].length(), (long)BigLevelsAndFactTableDataset.dimensionPositionLength[2]);
        BigLevelsAndFactTableDataset facttableIterator = new BigLevelsAndFactTableDataset();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        System.out.println("Finish creating dimension... time: " + (System.currentTimeMillis() - startTime) / 1000L);
        startTime = System.currentTimeMillis();
        System.out.println("start save fact table...");
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"bigThreeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)facttableIterator, dimensions, measureColumnName, new StopSign());
        System.out.println("Save fact table, finished... time: " + (System.currentTimeMillis() - startTime) / 1000L);
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"bigThreeDimensions"), new StopSign());
        System.out.println("start iterator...");
        startTime = System.currentTimeMillis();
        Assert.assertEquals((Object)factTable.getDimensionInfo()[0].getDimensionName(), (Object)"dimension1");
        Assert.assertEquals((long)factTable.getDimensionInfo()[0].getDimensionLength(), (long)BigLevelsAndFactTableDataset.dimensionPositionLength[0]);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[1].getDimensionName(), (Object)"dimension2");
        Assert.assertEquals((long)factTable.getDimensionInfo()[1].getDimensionLength(), (long)BigLevelsAndFactTableDataset.dimensionPositionLength[1]);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[2].getDimensionName(), (Object)"dimension3");
        Assert.assertEquals((long)factTable.getDimensionInfo()[2].getDimensionLength(), (long)BigLevelsAndFactTableDataset.dimensionPositionLength[2]);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[0].getMeasureName(), (Object)"measure1");
        Assert.assertEquals((long)factTable.getMeasureInfo()[0].getDataType(), (long)2L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[1].getMeasureName(), (Object)"measure2");
        Assert.assertEquals((long)factTable.getMeasureInfo()[1].getDataType(), (long)3L);
        String[] dimensionNames = new String[]{"dimension1", "dimension2", "dimension3"};
        IDiskArray[] dimensionPosition = new IDiskArray[3];
        dimensionPosition[0] = new BufferedPrimitiveDiskArray();
        dimensionPosition[0].add((Object)new Integer(10));
        dimensionPosition[0].add((Object)new Integer(99));
        dimensionPosition[1] = new BufferedPrimitiveDiskArray();
        dimensionPosition[1].add((Object)new Integer(10));
        dimensionPosition[1].add((Object)new Integer(99));
        dimensionPosition[2] = new BufferedPrimitiveDiskArray();
        dimensionPosition[2].add((Object)new Integer(1));
        dimensionPosition[2].add((Object)new Integer(9));
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNames, dimensionPosition, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        while (facttableRowIterator.next()) {
            System.out.print(facttableRowIterator.getDimensionPosition(0) + "," + facttableRowIterator.getDimensionPosition(1) + "," + facttableRowIterator.getDimensionPosition(2) + "  ");
            System.out.println(String.valueOf(facttableRowIterator.getMeasure(0)) + "," + String.valueOf(facttableRowIterator.getMeasure(1)));
        }
        System.out.println("Finish iterator... time: " + (System.currentTimeMillis() - startTime) / 1000L);
    }

    private static String[] distinct(String[] sValues) {
        Arrays.sort(sValues);
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(sValues[0]);
        int i = 1;
        while (i < sValues.length) {
            if (!sValues[i].equals(sValues[i - 1])) {
                tempList.add(sValues[i]);
            }
            ++i;
        }
        String[] result = new String[tempList.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)tempList.get(i2);
            ++i2;
        }
        return result;
    }
}

