/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import com.ibm.icu.util.Calendar;
import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.junit.Assert;
import org.junit.Test;
import testutil.ConfigText;

public class AggregationTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Impl.TestData2.TableName"), ConfigText.getString("Impl.TestData2.TableSQL"), ConfigText.getString("Impl.TestData2.TestDataFileName"));
    }

    @Test
    public void test1() throws Exception {
        QueryDefinition query = this.newReportQuery();
        Calendar c = Calendar.getInstance();
        c.clear();
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row.e1");
        query.addGroup((IGroupDefinition)g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row.e2");
        query.addGroup((IGroupDefinition)g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row.e3");
        g3.setInterval(2);
        g3.setIntervalRange(1.0);
        c.set(2004, 9, 1);
        g3.setIntervalStart((Object)c.getTime());
        query.addGroup((IGroupDefinition)g3);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row.e3");
        sort.setSortDirection(0);
        query.addSort(sort);
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("dataSetRow.STORE");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("dataSetRow.SALE_DATE");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("dataSetRow.SKU");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e10 = new ScriptExpression("dataSetRow.PRICE");
        query.addResultSetExpression("e10", (IBaseExpression)e10);
        ScriptExpression e11 = new ScriptExpression("dataSetRow.QUANTITY");
        query.addResultSetExpression("e11", (IBaseExpression)e11);
        ScriptExpression e5 = new ScriptExpression("Total.Count( )");
        e5.setGroupName("G1");
        query.addResultSetExpression("e5", (IBaseExpression)e5);
        ScriptExpression e6 = new ScriptExpression("Total.Count( null, 1 )");
        e6.setGroupName("G2");
        query.addResultSetExpression("e6", (IBaseExpression)e6);
        ScriptExpression e7 = new ScriptExpression("Total.Sum( dataSetRow.PRICE * dataSetRow.QUANTITY )");
        e7.setGroupName("G3");
        query.addResultSetExpression("e7", (IBaseExpression)e7);
        ScriptExpression e8 = new ScriptExpression("dataSetRow.PRICE * dataSetRow.QUANTITY / Total.Sum( dataSetRow.PRICE * dataSetRow.QUANTITY )");
        query.addResultSetExpression("e8", (IBaseExpression)e8);
        ScriptExpression e9 = new ScriptExpression("Total.movingAve( dataSetRow.PRICE, 3, dataSetRow.QUANTITY > 1)");
        query.addResultSetExpression("e9", (IBaseExpression)e9);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "e5", "e6", "e7", "e8", "e9"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    @Test
    public void test3() throws Exception {
        QueryDefinition query = this.newReportQuery();
        query.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("false")));
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row.e1");
        query.addGroup((IGroupDefinition)g1);
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("Total.Count( )");
        e2.setGroupName("G1");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)query);
        Assert.assertFalse((boolean)resultIt.next());
        Assert.assertEquals((Object)new Integer(0), (Object)resultIt.getValue("e2"));
    }

    @Test
    public void test4() throws Exception {
        QueryDefinition query = this.newReportQuery();
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("dataSetRow.CITY");
        query.addGroup((IGroupDefinition)g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("dataSetRow.STORE");
        query.addGroup((IGroupDefinition)g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("dataSetRow.SALE_DATE");
        g3.setInterval(2);
        g3.setIntervalRange(1.0);
        query.addGroup((IGroupDefinition)g3);
        ScriptExpression e1 = new ScriptExpression("Total.Ave( dataSetRow.PRICE )");
        e1.setGroupName("G1");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("Total.Ave( dataSetRow.PRICE, null, \"G1\" )");
        e2.setGroupName("G2");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("Total.Ave( dataSetRow.PRICE, null, -2 )");
        e3.setGroupName("G3");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("Total.Ave( dataSetRow.PRICE )");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e5 = new ScriptExpression("Total.Ave( dataSetRow.PRICE, dataSetRow.VOIDED == 0 )");
        e5.setGroupName("G1");
        query.addResultSetExpression("e5", (IBaseExpression)e5);
        this.dataEngine.prepare((IQueryDefinition)query);
        AggregateExpression ae1 = (AggregateExpression)e1.getHandle();
        AggregateExpression ae2 = (AggregateExpression)e2.getHandle();
        AggregateExpression ae3 = (AggregateExpression)e3.getHandle();
        AggregateExpression ae4 = (AggregateExpression)e4.getHandle();
        AggregateExpression ae5 = (AggregateExpression)e5.getHandle();
        Assert.assertTrue((ae1.getRegId() == ae2.getRegId() ? 1 : 0) != 0);
        Assert.assertTrue((ae1.getRegId() == ae3.getRegId() ? 1 : 0) != 0);
        Assert.assertTrue((ae1.getRegId() != ae4.getRegId() ? 1 : 0) != 0);
        Assert.assertTrue((ae1.getRegId() != ae5.getRegId() ? 1 : 0) != 0);
    }

    @Test
    public void test5() throws Exception {
        QueryDefinition query = this.newReportQuery();
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("dataSetRow.STORE");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("dataSetRow.SALE_DATE");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("dataSetRow.SKU");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e10 = new ScriptExpression("dataSetRow.PRICE");
        query.addResultSetExpression("e10", (IBaseExpression)e10);
        ScriptExpression e11 = new ScriptExpression("dataSetRow.QUANTITY");
        query.addResultSetExpression("e11", (IBaseExpression)e11);
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("dataSetRow.CITY");
        query.addGroup((IGroupDefinition)g1);
        Binding aggr1 = new Binding("Rank", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        aggr1.setAggrFunction("RANK");
        aggr1.addAggregateOn("G1");
        query.addBinding((IBinding)aggr1);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"Rank\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "Rank"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    @Test
    public void test6() throws Exception {
        QueryDefinition query = this.newReportQuery();
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("dataSetRow.STORE");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("dataSetRow.SALE_DATE");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("dataSetRow.SKU");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e10 = new ScriptExpression("dataSetRow.PRICE");
        query.addResultSetExpression("e10", (IBaseExpression)e10);
        ScriptExpression e11 = new ScriptExpression("dataSetRow.QUANTITY");
        query.addResultSetExpression("e11", (IBaseExpression)e11);
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("dataSetRow.CITY");
        query.addGroup((IGroupDefinition)g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("dataSetRow.STORE");
        query.addGroup((IGroupDefinition)g2);
        Binding aggr1 = new Binding("Rank", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        aggr1.setAggrFunction("RANK");
        aggr1.addAggregateOn("G1");
        query.addBinding((IBinding)aggr1);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"Rank\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        Binding aggr2 = new Binding("Runningsum", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        aggr2.setAggrFunction("RUNNINGSUM");
        aggr2.addAggregateOn("G2");
        query.addBinding((IBinding)aggr2);
        sort = new SortDefinition();
        sort.setExpression("row[\"Runningsum\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "Rank", "Runningsum"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    @Test
    public void test7() throws Exception {
        QueryDefinition query = this.newReportQuery();
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("dataSetRow.STORE");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("dataSetRow.SALE_DATE");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("dataSetRow.SKU");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e10 = new ScriptExpression("dataSetRow.PRICE");
        query.addResultSetExpression("e10", (IBaseExpression)e10);
        ScriptExpression e11 = new ScriptExpression("dataSetRow.QUANTITY");
        query.addResultSetExpression("e11", (IBaseExpression)e11);
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("dataSetRow.CITY");
        query.addGroup((IGroupDefinition)g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("dataSetRow.STORE");
        query.addGroup((IGroupDefinition)g2);
        Binding aggr2 = new Binding("Runningsum", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        aggr2.setAggrFunction("RUNNINGSUM");
        aggr2.addAggregateOn("G2");
        query.addBinding((IBinding)aggr2);
        Binding binding1 = new Binding("sqrtSum", (IBaseExpression)new ScriptExpression("Math.sqrt(row[\"Runningsum\"])"));
        query.addBinding((IBinding)binding1);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"sqrtSum\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "sqrtSum"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    @Test
    public void test8() throws Exception {
        QueryDefinition query = this.newReportQuery();
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("dataSetRow.STORE");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("dataSetRow.SALE_DATE");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("dataSetRow.SKU");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e10 = new ScriptExpression("dataSetRow.PRICE");
        query.addResultSetExpression("e10", (IBaseExpression)e10);
        ScriptExpression e11 = new ScriptExpression("dataSetRow.QUANTITY");
        query.addResultSetExpression("e11", (IBaseExpression)e11);
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("dataSetRow.CITY");
        query.addGroup((IGroupDefinition)g1);
        Binding aggr1 = new Binding("Rank", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        aggr1.setAggrFunction("RANK");
        aggr1.addAggregateOn("G1");
        query.addBinding((IBinding)aggr1);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"Rank\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("dataSetRow.STORE");
        query.addGroup((IGroupDefinition)g2);
        Binding aggr2 = new Binding("Runningsum", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        aggr2.setAggrFunction("RUNNINGSUM");
        aggr2.addAggregateOn("G2");
        query.addBinding((IBinding)aggr2);
        Binding binding1 = new Binding("sqrtSum", (IBaseExpression)new ScriptExpression("Math.sqrt(row[\"Runningsum\"])"));
        query.addBinding((IBinding)binding1);
        sort = new SortDefinition();
        sort.setExpression("row[\"Runningsum\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "Rank", "sqrtSum"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    @Test
    public void test9() throws Exception {
        QueryDefinition query = this.newReportQuery();
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("dataSetRow.STORE");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("dataSetRow.SALE_DATE");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("dataSetRow.SKU");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e10 = new ScriptExpression("dataSetRow.PRICE");
        query.addResultSetExpression("e10", (IBaseExpression)e10);
        ScriptExpression e11 = new ScriptExpression("dataSetRow.QUANTITY");
        query.addResultSetExpression("e11", (IBaseExpression)e11);
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("dataSetRow.CITY");
        query.addGroup((IGroupDefinition)g1);
        Binding aggr1 = new Binding("Rank", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        aggr1.setAggrFunction("RANK");
        aggr1.addAggregateOn("G1");
        query.addBinding((IBinding)aggr1);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"Rank\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        ConditionalExpression filter = new ConditionalExpression("dataSetRow.CITY", 1, "\"LONDON\"");
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)filter);
        query.addFilter((IFilterDefinition)filterDefn);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "Rank"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    @Test
    public void test10() throws Exception {
        QueryDefinition query = this.newReportQuery();
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("dataSetRow.STORE");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("dataSetRow.SALE_DATE");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("dataSetRow.SKU");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e10 = new ScriptExpression("dataSetRow.PRICE");
        query.addResultSetExpression("e10", (IBaseExpression)e10);
        ScriptExpression e11 = new ScriptExpression("dataSetRow.QUANTITY");
        query.addResultSetExpression("e11", (IBaseExpression)e11);
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("dataSetRow.CITY");
        query.addGroup((IGroupDefinition)g1);
        Binding aggr2 = new Binding("Runningsum", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        aggr2.setAggrFunction("RUNNINGSUM");
        aggr2.addAggregateOn("G1");
        query.addBinding((IBinding)aggr2);
        Binding bind1 = new Binding("bind1", (IBaseExpression)new ScriptExpression("row[\"Runningsum\"]"));
        query.addBinding((IBinding)bind1);
        Binding binding2 = new Binding("sqrtBind1", (IBaseExpression)new ScriptExpression("Math.sqrt(row[\"bind1\"])"));
        query.addBinding((IBinding)binding2);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"sqrtBind1\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        String[] exprs = new String[]{"e1", "e2", "e3", "e4", "e10", "e11", "sqrtBind1"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), exprs);
        this.checkOutputFile();
    }

    @Test
    public void testSCR74988() throws Exception {
        QueryDefinition query = this.newReportQuery();
        ScriptExpression e1 = new ScriptExpression("dataSetRow.CITY");
        query.addResultSetExpression("e1", (IBaseExpression)e1);
        ScriptExpression e2 = new ScriptExpression("dataSetRow.STORE");
        query.addResultSetExpression("e2", (IBaseExpression)e2);
        ScriptExpression e3 = new ScriptExpression("dataSetRow.SALE_DATE");
        query.addResultSetExpression("e3", (IBaseExpression)e3);
        ScriptExpression e4 = new ScriptExpression("dataSetRow.SKU");
        query.addResultSetExpression("e4", (IBaseExpression)e4);
        ScriptExpression e5 = new ScriptExpression("dataSetRow.PRICE");
        query.addResultSetExpression("e5", (IBaseExpression)e5);
        ScriptExpression e6 = new ScriptExpression("dataSetRow.QUANTITY");
        query.addResultSetExpression("e6", (IBaseExpression)e6);
        GroupDefinition g1 = new GroupDefinition("G1");
        g1.setKeyExpression("row.e1");
        query.addGroup((IGroupDefinition)g1);
        GroupDefinition g2 = new GroupDefinition("G2");
        g2.setKeyExpression("row.e2");
        query.addGroup((IGroupDefinition)g2);
        GroupDefinition g3 = new GroupDefinition("G3");
        g3.setKeyExpression("row.e3");
        g3.setInterval(2);
        g3.setIntervalRange(1.0);
        query.addGroup((IGroupDefinition)g3);
        ScriptExpression expr0 = new ScriptExpression("Total.Sum( row.e5 * row.e6 )");
        ScriptExpression expr1 = new ScriptExpression("Total.Sum( row.e5 * row.e6 , null, 0)");
        expr1.setGroupName("G1");
        ScriptExpression expr2 = new ScriptExpression("Total.Sum( row.e5 * row.e6 , null, Total.OVERALL)");
        expr2.setGroupName("G2");
        ScriptExpression expr3 = new ScriptExpression("Total.Sum( row.e5 * row.e6 , null, \"overall\")");
        expr3.setGroupName("G3");
        query.addResultSetExpression("expr0", (IBaseExpression)expr0);
        query.addResultSetExpression("expr1", (IBaseExpression)expr1);
        query.addResultSetExpression("expr2", (IBaseExpression)expr2);
        query.addResultSetExpression("expr3", (IBaseExpression)expr3);
        IResultIterator resultIterator = this.executeQuery((IQueryDefinition)query);
        while (resultIterator.next()) {
            String resultValue0 = this.evalAsString("expr0", resultIterator);
            String resultValue1 = this.evalAsString("expr1", resultIterator);
            String resultValue2 = this.evalAsString("expr2", resultIterator);
            String resultValue3 = this.evalAsString("expr3", resultIterator);
            Assert.assertEquals((Object)resultValue0, (Object)resultValue1);
            Assert.assertEquals((Object)resultValue0, (Object)resultValue2);
            Assert.assertEquals((Object)resultValue0, (Object)resultValue3);
            Assert.assertEquals((Object)resultValue0, (Object)resultValue3);
        }
    }

    @Test
    public void testTed49051() throws Exception {
        QueryDefinition query = this.newReportQuery();
        Binding b = new Binding("b1", (IBaseExpression)new ScriptExpression("dataSetRow[\"CITY\"]"));
        query.addBinding((IBinding)b);
        b = new Binding("b2", (IBaseExpression)new ScriptExpression("dataSetRow[\"STORE\"]"));
        query.addBinding((IBinding)b);
        b = new Binding("b3", (IBaseExpression)new ScriptExpression("dataSetRow[\"SALE_DATE\"]"));
        query.addBinding((IBinding)b);
        b = new Binding("b4", (IBaseExpression)new ScriptExpression("dataSetRow[\"SKU\"]"));
        query.addBinding((IBinding)b);
        b = new Binding("b5", (IBaseExpression)new ScriptExpression("dataSetRow[\"PRICE\"]"));
        query.addBinding((IBinding)b);
        b = new Binding("b6", (IBaseExpression)new ScriptExpression("dataSetRow[\"QUANTITY\"]"));
        query.addBinding((IBinding)b);
        b = new Binding("aggr1", null);
        b.setAggrFunction("RANK");
        b.addArgument((IBaseExpression)new ScriptExpression("row[\"b5\"]"));
        query.addBinding((IBinding)b);
        SortDefinition sort = new SortDefinition();
        sort.setExpression("row[\"aggr1\"]");
        sort.setSortDirection(0);
        query.addSort(sort);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ConditionalExpression("row[\"b5\"]", 14, "3"));
        query.addFilter((IFilterDefinition)filter);
        String[] cols = new String[]{"b1", "b2", "b3", "b4", "b5", "b6", "aggr1"};
        this.outputQueryResult(this.executeQuery((IQueryDefinition)query), cols);
        this.checkOutputFile();
    }
}

