/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.junit.Assert;
import org.junit.Test;
import testutil.BaseTestCase;

public class DteLevelDataSetCacheTest
extends BaseTestCase {
    @Test
    public void testDataSetWithDteLevelCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(DteLevelDataSetCacheTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(DteLevelDataSetCacheTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 10 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        qd.setDataSetName("test");
        QueryDefinition qd1 = new QueryDefinition();
        qd1.addBinding((IBinding)new Binding("column2", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        qd1.setDataSetName("test");
        IDataQueryDefinition[] QueryDefinition2 = new IDataQueryDefinition[]{qd, qd1};
        dataEngine.registerQueries(QueryDefinition2);
        HashMap<String, String> appContextMap = new HashMap<String, String>();
        appContextMap.put(DataEngine.MEMORY_DATA_SET_CACHE, "100");
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        IResultIterator ri2 = dataEngine.prepare((IQueryDefinition)qd1, appContextMap).execute(null).getResultIterator();
        Assert.assertTrue((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            Assert.assertTrue((boolean)ri2.next());
            Assert.assertEquals((Object)ri1.getValue("column1"), (Object)ri2.getValue("column2"));
        }
        dataEngine.shutdown();
    }

    @Test
    public void testDataSetWithoutCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(DteLevelDataSetCacheTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(DteLevelDataSetCacheTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 11 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        IResultIterator ri2 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            Assert.assertTrue((boolean)ri2.next());
            Assert.assertEquals((long)((Integer)ri1.getValue("column1") + 1), (long)((Integer)ri2.getValue("column1")).intValue());
        }
        dataEngine.shutdown();
    }

    @Test
    public void testDataSetWithJVMCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(DteLevelDataSetCacheTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(DteLevelDataSetCacheTest.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; if ( i % 10 == 0 ) return false; row.column1 = i;return true;");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        qd.setDataSetName("test");
        HashMap<String, String> appContextMap = new HashMap<String, String>();
        appContextMap.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, "100");
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        IResultIterator ri2 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertTrue((boolean)((DataEngineImpl)dataEngine).getSession().getDataSetCacheManager().doesLoadFromCache());
        while (ri1.next()) {
            Assert.assertTrue((boolean)ri2.next());
            Assert.assertEquals((Object)ri1.getValue("column1"), (Object)ri2.getValue("column1"));
        }
        dataEngine.shutdown();
    }
}

