/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.core.btree.BTreeTestCase;
import org.eclipse.birt.core.btree.FileBTreeFile;
import org.eclipse.birt.core.btree.RAMBTreeFile;
import org.junit.Ignore;
import org.junit.Test;

public class BTreeTest
extends BTreeTestCase {
    @Test
    public void testBTree() throws Exception {
        RAMBTreeFile file = new RAMBTreeFile();
        BTreeOption option = new BTreeOption();
        option.setHasValue(false);
        option.setKeySize(4);
        option.setKeySerializer((BTreeSerializer)new BTreeTestCase.IntegerSerializer());
        option.setFile((BTreeFile)file);
        BTree btree = new BTree(option);
        int i = 0;
        while (i < 10000) {
            if (!btree.exist((Object)i)) {
                btree.insert((Object)i, null);
            }
            ++i;
        }
        BTreeTest.assertEquals((int)10000, (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)0, (int)btree.getTotalValues());
        i = 0;
        while (i < 10000) {
            BTreeTest.assertTrue((boolean)btree.exist((Object)i));
            ++i;
        }
        BTreeTest.assertTrue((!btree.exist((Object)10001) ? 1 : 0) != 0);
        BTreeTest.assertTrue((!btree.exist((Object)-1) ? 1 : 0) != 0);
        btree.close();
        btree = new BTree(option);
        BTreeTest.assertEquals((int)10000, (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)0, (int)btree.getTotalValues());
        i = 0;
        while (i < 10000) {
            BTreeTest.assertTrue((boolean)btree.exist((Object)i));
            ++i;
        }
        BTreeTest.assertTrue((!btree.exist((Object)10001) ? 1 : 0) != 0);
        BTreeTest.assertTrue((!btree.exist((Object)-1) ? 1 : 0) != 0);
        btree.close();
    }

    @Test
    public void testFixKey() throws Exception {
        RAMBTreeFile file = new RAMBTreeFile();
        BTreeOption option = new BTreeOption();
        option.setHasValue(false);
        option.setKeySize(4);
        option.setKeySerializer((BTreeSerializer)new BTreeTestCase.IntegerSerializer());
        option.setFile((BTreeFile)file);
        BTree btree = new BTree(option);
        Collection<String> input = this.createSampleInput();
        HashSet<String> keys = new HashSet<String>();
        for (String key : input) {
            keys.add(key);
            btree.insert((Object)Integer.valueOf(key), null);
        }
        BTreeTest.assertEquals((int)keys.size(), (int)btree.getTotalKeys());
        for (String key : keys) {
            BTreeTest.assertTrue((boolean)btree.exist((Object)Integer.valueOf(key)));
        }
        btree.close();
        btree = new BTree(option);
        BTreeTest.assertEquals((int)keys.size(), (int)btree.getTotalKeys());
        for (String key : keys) {
            BTreeTest.assertTrue((boolean)btree.exist((Object)Integer.valueOf(key)));
        }
        btree.close();
    }

    @Test
    public void testFixValue() throws Exception {
        Integer value;
        RAMBTreeFile file = new RAMBTreeFile();
        BTreeOption option = new BTreeOption();
        option.setHasValue(true);
        option.setValueSize(4);
        option.setValueSerializer((BTreeSerializer)new BTreeTestCase.IntegerSerializer());
        option.setFile((BTreeFile)file);
        BTree btree = new BTree(option);
        Collection<String> input = this.createSampleInput();
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        for (String string : input) {
            value = Integer.valueOf(string);
            values.put(string, value);
            btree.insert((Object)string, (Object)value);
        }
        BTreeTest.assertEquals((int)values.size(), (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)values.size(), (int)btree.getTotalValues());
        for (Map.Entry entry : values.entrySet()) {
            value = (Integer)btree.getValue((Object)((String)entry.getKey()));
            BTreeTest.assertEquals(entry.getValue(), (Object)value);
        }
        btree.close();
        btree = new BTree(option);
        BTreeTest.assertEquals((int)values.size(), (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)values.size(), (int)btree.getTotalValues());
        for (Map.Entry entry : values.entrySet()) {
            value = (Integer)btree.getValue((Object)((String)entry.getKey()));
            BTreeTest.assertEquals(entry.getValue(), (Object)value);
        }
        btree.close();
    }

    @Test
    public void testDuplicate() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                Collection values2;
                Collection values1;
                BTreeOption option = new BTreeOption();
                option.setHasValue(true);
                option.setAllowDuplicate(true);
                option.setFile((BTreeFile)file, true);
                BTree btree = new BTree(option);
                Collection<String> input = this.createSampleInput();
                HashMap<String, ArrayList<Integer>> map = new HashMap<String, ArrayList<Integer>>();
                int totalValues = 0;
                for (String string : input) {
                    Integer value = totalValues;
                    ArrayList<Integer> values = (ArrayList<Integer>)map.get(string);
                    if (values == null) {
                        values = new ArrayList<Integer>();
                        map.put(string, values);
                    }
                    values.add(value);
                    btree.insert((Object)string, (Object)value);
                    ++totalValues;
                }
                BTreeTest.assertEquals((int)map.size(), (int)btree.getTotalKeys());
                BTreeTest.assertEquals((int)totalValues, (int)btree.getTotalValues());
                for (Map.Entry entry : map.entrySet()) {
                    values1 = btree.getValues((Object)((String)entry.getKey()));
                    values2 = (Collection)entry.getValue();
                    BTreeTest.assertEquals((int)values2.size(), (int)values1.size());
                    BTreeTest.assertTrue((boolean)values1.containsAll(values2));
                }
                btree.close();
                btree = new BTree(option);
                BTreeTest.assertEquals((int)map.size(), (int)btree.getTotalKeys());
                BTreeTest.assertEquals((int)totalValues, (int)btree.getTotalValues());
                for (Map.Entry entry : map.entrySet()) {
                    values1 = btree.getValues((Object)((String)entry.getKey()));
                    values2 = (Collection)entry.getValue();
                    BTreeTest.assertEquals((int)values2.size(), (int)values1.size());
                    BTreeTest.assertTrue((boolean)values1.containsAll(values2));
                }
                btree.close();
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testHugeKey() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                String key;
                char[] chars;
                BTreeOption option = new BTreeOption();
                option.setHasValue(false);
                option.setFile((BTreeFile)file, true);
                BTree btree = new BTree(option);
                Random random = new Random();
                ArrayList<Integer> input = new ArrayList<Integer>();
                int i = 0;
                while (i < 10000) {
                    int value = random.nextInt(40) + 1;
                    chars = new char[value * 1024];
                    Arrays.fill(chars, 'a');
                    key = new String(chars);
                    if (!btree.exist((Object)key)) {
                        btree.insert((Object)key, null);
                        input.add(value);
                    }
                    ++i;
                }
                BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalKeys());
                for (Integer value : input) {
                    chars = new char[value * 1024];
                    Arrays.fill(chars, 'a');
                    key = new String(chars);
                    BTreeTest.assertTrue((boolean)btree.exist((Object)key));
                }
                btree.close();
                btree = new BTree(option);
                BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalKeys());
                for (Integer value : input) {
                    chars = new char[value * 1024];
                    Arrays.fill(chars, 'a');
                    key = new String(chars);
                    BTreeTest.assertTrue((boolean)btree.exist((Object)key));
                }
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testHugeValue() throws Exception {
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                char[] value;
                BTreeOption option = new BTreeOption();
                option.setHasValue(true);
                option.setAllowDuplicate(false);
                option.setFile((BTreeFile)file, true);
                BTree btree = new BTree(option);
                Random random = new Random();
                ArrayList<Integer> input = new ArrayList<Integer>();
                int i = 0;
                while (i < 10000) {
                    int v = random.nextInt(40) + 1;
                    Integer key = v;
                    if (!btree.exist((Object)key)) {
                        char[] value2 = new char[v * 1023];
                        Arrays.fill(value2, 'a');
                        btree.insert((Object)key, (Object)value2);
                        input.add(v);
                    }
                    ++i;
                }
                BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalKeys());
                BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalValues());
                for (Integer key : input) {
                    value = (char[])btree.getValue((Object)key);
                    BTreeTest.assertEquals((Object)key, (Object)(value.length / 1023));
                }
                btree.close();
                btree = new BTree(option);
                BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalKeys());
                BTreeTest.assertEquals((int)input.size(), (int)btree.getTotalValues());
                for (Integer key : input) {
                    value = (char[])btree.getValue((Object)key);
                    BTreeTest.assertEquals((Object)key, (Object)(value.length / 1023));
                }
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String createTestKey(int value, int entryCount) {
        int a = value % 3;
        int b = value / 3;
        switch (a) {
            case 0: {
                return String.valueOf(b);
            }
            case 1: {
                return String.valueOf(entryCount / 3 + b);
            }
        }
        return String.valueOf(entryCount / 3 * 2 + b);
    }

    @Ignore(value="long run test")
    @Test
    public void testHugeNumberOfEntries() throws Exception {
        int ENTRY_COUNT = 999999;
        new File("./utest/btree.dat").delete();
        FileBTreeFile file = new FileBTreeFile("./utest/btree.dat");
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            try {
                BTreeOption option = new BTreeOption();
                option.setHasValue(true);
                option.setFile((BTreeFile)file, true);
                option.setCacheSize(1024);
                BTree btree = new BTree(option);
                long start = System.currentTimeMillis();
                System.out.println("INSERT 1M entries....");
                int i = 0;
                while (i < ENTRY_COUNT) {
                    String key = this.createTestKey(i, ENTRY_COUNT);
                    btree.insert((Object)key, (Object)key);
                    if (i % 10000 == 0) {
                        System.out.print('.');
                    }
                    ++i;
                }
                btree.close();
                long end = System.currentTimeMillis();
                System.out.println("FINISHED at " + (end - start) + "ms");
                start = System.currentTimeMillis();
                System.out.println("QURRY 1M entries....");
                btree = new BTree(option);
                BTreeTest.assertEquals((int)ENTRY_COUNT, (int)btree.getTotalKeys());
                BTreeTest.assertEquals((int)ENTRY_COUNT, (int)btree.getTotalValues());
                int i2 = 0;
                while (i2 < ENTRY_COUNT) {
                    String key = String.valueOf(i2);
                    String value = (String)btree.getValue((Object)key);
                    BTreeTest.assertEquals((String)key, (String)value);
                    if (i2 % 10000 == 0) {
                        System.out.print('.');
                    }
                    ++i2;
                }
                end = System.currentTimeMillis();
                System.out.println("FINISHED at " + (end - start) + "ms");
                btree.close();
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testNullKeyValue() throws IOException {
        RAMBTreeFile file = new RAMBTreeFile();
        BTreeOption option = new BTreeOption();
        option.setHasValue(true);
        option.setKeySerializer((BTreeSerializer)new BTreeTestCase.IntegerSerializer());
        option.setFile((BTreeFile)file);
        option.setAllowNullKey(true);
        BTree btree = new BTree(option);
        int i = 0;
        while (i < 10000) {
            if (!btree.exist((Object)i)) {
                btree.insert((Object)i, null);
            }
            ++i;
        }
        btree.insert(null, (Object)"abc");
        BTreeTest.assertEquals((int)10001, (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)10001, (int)btree.getTotalValues());
        btree.close();
    }

    @Test
    public void testBatchInsert() throws IOException {
        RAMBTreeFile file = new RAMBTreeFile();
        BTreeOption option = new BTreeOption();
        option.setHasValue(true);
        option.setKeySize(4);
        option.setAllowDuplicate(true);
        option.setAllowNullKey(true);
        option.setKeySerializer((BTreeSerializer)new BTreeTestCase.IntegerSerializer());
        option.setFile((BTreeFile)file);
        BTree btree = new BTree(option);
        Object[] values = new String[4];
        values[0] = null;
        int i = 1;
        while (i < 4) {
            values[i] = "NULL" + i;
            ++i;
        }
        btree.insert(null, values);
        i = 0;
        while (i < 10000) {
            values[0] = null;
            int j = 1;
            while (j < 4) {
                values[j] = i + "." + j;
                ++j;
            }
            btree.insert((Object)i, values);
            ++i;
        }
        BTreeTest.assertEquals((int)10001, (int)btree.getTotalKeys());
        BTreeTest.assertEquals((int)40004, (int)btree.getTotalValues());
        btree.close();
    }
}

