/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import com.ibm.icu.util.ULocale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class TemplateElementHandleTest
extends BaseTestCase {
    private ElementFactory factory = null;
    private OdaDataSourceHandle datasource = null;
    private OdaDataSetHandle dataset = null;
    private OdaDataSetHandle dataset2 = null;
    private LabelHandle label = null;

    public TemplateElementHandleTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(TemplateElementHandleTest.class);
    }

    @Override
    public void setUp() throws Exception {
        this.sessionHandle = DesignEngine.newSession((ULocale)ULocale.ENGLISH);
        this.designHandle = this.sessionHandle.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        this.factory = this.designHandle.getElementFactory();
    }

    public void testTemplate() throws Exception {
        this.datasource = this.factory.newOdaDataSource("dsource", "org.eclipse.birt.report.data.oda.jdbc");
        this.designHandle.getDataSources().add((DesignElementHandle)this.datasource);
        try {
            this.datasource.createTemplateElement("T.dsource");
            TemplateElementHandleTest.fail();
        }
        catch (SemanticException e) {
            TemplateElementHandleTest.assertNotNull((Object)((Object)e));
        }
        this.dataset = this.factory.newOdaDataSet("dset", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        this.designHandle.getDataSets().add((DesignElementHandle)this.dataset);
        this.dataset2 = this.factory.newOdaDataSet("dset2", "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        this.designHandle.getDataSets().add((DesignElementHandle)this.dataset2);
        TemplateElementHandle tdataset = this.dataset2.createTemplateElement("dset");
        TemplateElementHandleTest.assertEquals((String)"dset1", (String)tdataset.getName());
        this.label = this.factory.newLabel("label");
        try {
            this.label.revertToTemplate("T.lable");
        }
        catch (SemanticException e) {
            TemplateElementHandleTest.assertNotNull((Object)((Object)e));
        }
    }
}

