/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.RowDesign;

public class RowTypeTest
extends EngineCase {
    public void testAddCell() {
        RowDesign row = new RowDesign();
        row.addCell(this.createCell(1));
        row.addCell(this.createCell(3, 3));
        row.addCell(this.createCell(4));
        row.addCell(this.createCell(6, 6));
        this.assertCell(row.getCell(0), 1);
        this.assertCell(row.getCell(1), 3);
        this.assertCell(row.getCell(2), 4);
        this.assertCell(row.getCell(3), 6);
    }

    private CellDesign createCell(int colId, int cellId) {
        CellDesign cell = new CellDesign();
        cell.setColumn(colId);
        cell.setColSpan(cellId);
        return cell;
    }

    private CellDesign createCell(int cellId) {
        return this.createCell(0, cellId);
    }

    private void assertCell(CellDesign cell, int cellId) {
        RowTypeTest.assertTrue((cell.getColSpan() == cellId ? 1 : 0) != 0);
    }

    public void testGetSet() {
        RowDesign row = new RowDesign();
        DimensionType height = new DimensionType(1.0, "cm");
        Expression.Constant bookmark = Expression.newConstant((String)"");
        row.setHeight(height);
        row.setBookmark((Expression)bookmark);
        RowTypeTest.assertEquals((Object)row.getHeight(), (Object)height);
        RowTypeTest.assertEquals((Object)row.getBookmark(), (Object)bookmark);
    }
}

