/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.NothingLocator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.CornerTracker;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;

public class CornerHandle
extends AbstractHandle {
    protected DragTracker createDragTracker() {
        return new CornerTracker((TableEditPart)this.getOwner());
    }

    public CornerHandle(TableEditPart owner) {
        this(owner, new NothingLocator(owner.getFigure()));
    }

    public CornerHandle(TableEditPart owner, Locator loc) {
        super((GraphicalEditPart)owner, loc);
        this.initialize();
    }

    public boolean containsPoint(int x, int y) {
        return this.getBounds().getCopy().shrink(2, 2).contains(x, y);
    }

    protected void initialize() {
        this.setOpaque(true);
        LineBorder bd = new LineBorder(1);
        bd.setColor(ReportColorConstants.HandleBorderColor);
        this.setBorder((Border)bd);
        this.setCursor(Cursors.ARROW);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setBackgroundColor(ReportColorConstants.TableGuideFillColor);
        graphics.setLineStyle(1);
        graphics.fillRectangle(this.getBounds().getCopy().resize(-1, -1));
    }
}

