/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.TemplateException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.TemplateDataSet;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateFactory;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.TemplateReportItem;
import org.eclipse.birt.report.model.elements.strategy.CopyForTemplatePolicy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ContentExceptionFactory;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;

public class TemplateCommand
extends AbstractElementCommand {
    protected final ContainerContext focus;

    public TemplateCommand(Module module, DesignElement obj) {
        super(module, obj);
        this.focus = null;
    }

    public TemplateCommand(Module module, ContainerContext containerInfor) {
        super(module, containerInfor.getElement());
        this.focus = containerInfor;
    }

    public void checkProperty(ElementPropertyDefn prop, Object value) throws PropertyValueException {
        TemplateParameterDefinition templateParam;
        if (value == null) {
            return;
        }
        if ((this.element instanceof ReportItem || this.element instanceof TemplateReportItem) && "refTemplateParameter".equals(prop.getName())) {
            assert (value instanceof ElementRefValue);
            if (((ElementRefValue)value).getElement() == null && !((templateParam = this.resolveTemplateParameterDefinition(this.module, ((ElementRefValue)value).getName())).getDefaultElement() instanceof ReportItem)) {
                throw new PropertyValueException(this.element, prop.getName(), value, "Error.PropertyValueException.INVALID_VALUE");
            }
        }
        if ((this.element instanceof SimpleDataSet || this.element instanceof TemplateDataSet) && "refTemplateParameter".equals(prop.getName())) {
            assert (value instanceof ElementRefValue);
            if (((ElementRefValue)value).getElement() == null && !((templateParam = this.resolveTemplateParameterDefinition(this.module, ((ElementRefValue)value).getName())).getDefaultElement() instanceof SimpleDataSet)) {
                throw new PropertyValueException(this.element, prop.getName(), value, "Error.PropertyValueException.INVALID_VALUE");
            }
        }
    }

    private TemplateParameterDefinition resolveTemplateParameterDefinition(Module module, String name) {
        ElementPropertyDefn prop = this.element.getPropertyDefn("refTemplateParameter");
        if (prop == null) {
            return null;
        }
        DesignElement resolvedElement = module.resolveElement(this.element, name, (PropertyDefn)prop, null);
        return (TemplateParameterDefinition)resolvedElement;
    }

    public void checkAdd(Object content) throws ContentException {
        Object obj = null;
        if (content instanceof DesignElement) {
            DesignElement element = (DesignElement)content;
            obj = element.getProperty(this.module, "refTemplateParameter");
            if (obj == null) {
                LevelContentIterator iter = new LevelContentIterator(this.module, element, 1);
                while (iter.hasNext()) {
                    DesignElement eleObj = iter.next();
                    this.checkAdd(eleObj);
                }
            } else {
                this.addTemplateParameterDefinition(obj, (DesignElement)content);
            }
        }
    }

    private void addTemplateParameterDefinition(Object obj, DesignElement content) throws ContentException {
        block14: {
            assert (obj instanceof ElementRefValue);
            ElementRefValue templateParam = (ElementRefValue)obj;
            if (templateParam.getElement() == null) {
                block12: {
                    if (content instanceof TemplateElement) {
                        throw ContentExceptionFactory.createContentException(this.focus, content, "Error.ContentException.INVALID_TEMPLATE_ELEMENT");
                    }
                    try {
                        PropertyCommand cmd = new PropertyCommand(this.module, content);
                        cmd.clearProperty("refTemplateParameter");
                    }
                    catch (SemanticException e) {
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError();
                    }
                }
                return;
            }
            if (!(content instanceof TemplateElement)) {
                block13: {
                    try {
                        if (this.needClearParameterDefinition(content, templateParam.getName())) {
                            PropertyCommand cmd = new PropertyCommand(this.module, content);
                            cmd.clearProperty("refTemplateParameter");
                        }
                    }
                    catch (SemanticException e) {
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError();
                    }
                }
                return;
            }
            TemplateParameterDefinition definition = (TemplateParameterDefinition)templateParam.getElement();
            if (this.module.findTemplateParameterDefinition(templateParam.getName()) != definition) {
                try {
                    DesignElement copyTemplateParam = ModelUtil.getCopy(definition);
                    this.module.makeUniqueName(copyTemplateParam);
                    ContentCommand cmd = new ContentCommand(this.module, new ContainerContext((DesignElement)this.module, 8));
                    cmd.add(copyTemplateParam);
                    PropertyCommand propertyCmd = new PropertyCommand(this.module, content);
                    propertyCmd.setProperty("refTemplateParameter", (Object)copyTemplateParam);
                }
                catch (SemanticException e) {
                    if ($assertionsDisabled) break block14;
                    throw new AssertionError();
                }
            }
        }
    }

    private boolean needClearParameterDefinition(DesignElement content, String parameterDefinitionName) {
        assert (content != null && parameterDefinitionName != null);
        TemplateParameterDefinition templateParam = this.module.findTemplateParameterDefinition(parameterDefinitionName);
        if (templateParam != null) {
            String type = templateParam.getAllowedType(this.module);
            IElementDefn allowedDefn = null;
            allowedDefn = "ExtendedItem".equals(type) ? MetaDataDictionary.getInstance().getElement("ReportItem") : MetaDataDictionary.getInstance().getElement(type);
            if (content.getDefn().isKindOf(allowedDefn)) {
                return false;
            }
        }
        return true;
    }

    public TemplateElement createTemplateElement(DesignElement base, String name) throws SemanticException {
        assert (base != null);
        TemplateElement template = TemplateFactory.createTemplate(this.module, base, name);
        if (template == null) {
            throw new TemplateException(base, "Error.TemplateException.INVALID_TEMPLATE_ELEMENT_TYPE");
        }
        if (!(this.module instanceof ReportDesign)) {
            throw new TemplateException(this.module, "Error.TemplateException.TEMPLATE_ELEMENT_NOT_SUPPORTED");
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.CreateTemplateElement"));
        try {
            this.createTemplateFromDesignElement(template, base);
            ContentCommand cmd = new ContentCommand(this.module, this.focus);
            cmd.transformTemplate(base, template, true);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
        return template;
    }

    private void createTemplateFromDesignElement(TemplateElement template, DesignElement base) {
        block12: {
            assert (base instanceof ReportItem || base instanceof SimpleDataSet);
            assert (template != null);
            assert (this.module instanceof ReportDesign);
            try {
                TemplateParameterDefinition templateParam = new TemplateParameterDefinition();
                this.module.makeUniqueName(templateParam);
                PropertyCommand propertyCmd = new PropertyCommand(this.module, templateParam);
                if (base instanceof SimpleDataSet) {
                    propertyCmd.setProperty("allowedType", (Object)"DataSet");
                } else {
                    propertyCmd.setProperty("allowedType", (Object)base.getElementName());
                }
                ContainerSlot defaultSlot = templateParam.getSlot(0);
                assert (defaultSlot != null);
                DesignElement defaultElement = (DesignElement)base.doClone(CopyForTemplatePolicy.getInstance());
                assert (defaultElement != null);
                TemplateParameterDefinition temp = defaultElement.getTemplateParameterElement(this.module);
                if (temp != null) {
                    propertyCmd = new PropertyCommand(this.module, defaultElement);
                    propertyCmd.setProperty("refTemplateParameter", null);
                    propertyCmd = new PropertyCommand(this.module, base);
                    propertyCmd.setProperty("refTemplateParameter", null);
                }
                ContentCommand contentCmd = new ContentCommand(this.module, new ContainerContext((DesignElement)templateParam, 0));
                contentCmd.add(defaultElement);
                contentCmd = new ContentCommand(this.module, new ContainerContext((DesignElement)this.module, 8));
                contentCmd.add(templateParam);
                propertyCmd = new PropertyCommand(this.module, template);
                propertyCmd.setProperty("refTemplateParameter", (Object)templateParam.getFullName());
            }
            catch (SemanticException e) {
                assert (false);
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError();
            }
        }
    }

    public void transformToReportItem(TemplateReportItem templateItem, ReportItem reportItem) throws SemanticException {
        TemplateParameterDefinition templateparam = templateItem.getTemplateParameterElement(this.module);
        if (templateparam == null) {
            throw new TemplateException(templateItem, "Error.TemplateException.TRANSFORM_TO_REPORT_ITEM_FORBIDDEN");
        }
        this.module.rename(reportItem);
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.TransformToReportItem"));
        try {
            PropertyCommand pcmd = new PropertyCommand(this.module, reportItem);
            pcmd.setProperty("refTemplateParameter", (Object)templateparam.getFullName());
            ContentCommand cmd = new ContentCommand(this.module, this.focus);
            cmd.transformTemplate(templateItem, reportItem, false);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void transformToDataSet(TemplateDataSet templateDataSet, SimpleDataSet dataSet) throws SemanticException {
        TemplateParameterDefinition templateparam = templateDataSet.getTemplateParameterElement(this.module);
        if (templateparam == null) {
            throw new TemplateException(templateDataSet, "Error.TemplateException.TRANSFORM_TO_DATA_SET_FORBIDDEN");
        }
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.TransformToDataSet"));
        try {
            PropertyCommand pcmd = new PropertyCommand(this.module, dataSet);
            pcmd.setProperty("refTemplateParameter", (Object)templateparam.getFullName());
            ContentCommand cmd = new ContentCommand(this.module, this.focus);
            cmd.transformTemplate(templateDataSet, dataSet, false);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public TemplateElement revertToTemplate(DesignElement base, String name) throws SemanticException {
        TemplateElement template;
        block6: {
            assert (base != null);
            template = TemplateFactory.createTemplate(this.module, base, name);
            if (template == null) {
                throw new TemplateException(base, "Error.TemplateException.INVALID_TEMPLATE_ELEMENT_TYPE");
            }
            if (!(this.module instanceof ReportDesign)) {
                throw new TemplateException(this.module, "Error.TemplateException.TEMPLATE_ELEMENT_NOT_SUPPORTED");
            }
            TemplateParameterDefinition templateParam = base.getTemplateParameterElement(this.module);
            if (templateParam == null) {
                throw new TemplateException(base, "Error.TemplateException.REVERT_TO_TEMPLATE_FORBIDDEN");
            }
            try {
                PropertyCommand propertyCmd = new PropertyCommand(this.module, template);
                propertyCmd.setProperty("refTemplateParameter", (Object)templateParam.getFullName());
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        ContentCommand cmd = new ContentCommand(this.module, this.focus);
        cmd.transformTemplate(base, template, false);
        return template;
    }
}

