/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.tidy.DOMNodeImpl;
import org.w3c.tidy.Node;
import org.w3c.tidy.TidyUtils;

public class DOMCharacterDataImpl
extends DOMNodeImpl
implements CharacterData {
    protected DOMCharacterDataImpl(Node adaptee) {
        super(adaptee);
    }

    @Override
    public String getData() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public int getLength() {
        int len = 0;
        if (this.adaptee.textarray != null && this.adaptee.start < this.adaptee.end) {
            len = this.adaptee.end - this.adaptee.start;
        }
        return len;
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        String value = null;
        if (count < 0) {
            throw new DOMException(1, "Invalid length");
        }
        if (this.adaptee.textarray != null && this.adaptee.start < this.adaptee.end) {
            if (this.adaptee.start + offset >= this.adaptee.end) {
                throw new DOMException(1, "Invalid offset");
            }
            int len = count;
            if (this.adaptee.start + offset + len - 1 >= this.adaptee.end) {
                len = this.adaptee.end - this.adaptee.start - offset;
            }
            value = TidyUtils.getString(this.adaptee.textarray, this.adaptee.start + offset, len);
        }
        return value;
    }

    @Override
    public void setData(String data) throws DOMException {
        this.setNodeValue(data);
    }

    @Override
    public void appendData(String arg) throws DOMException {
        this.setNodeValue(this.getNodeValue() + arg);
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        if (offset < this.adaptee.start || this.adaptee.start + offset >= this.adaptee.end) {
            throw new DOMException(1, "Invalid offset");
        }
        StringBuilder sb = new StringBuilder(this.getNodeValue());
        sb.insert(offset, arg);
        this.setData(sb.toString());
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        if (count < 0) {
            throw new DOMException(1, "Invalid length");
        }
        if (offset < this.adaptee.start || this.adaptee.start + offset >= this.adaptee.end) {
            throw new DOMException(1, "Invalid offset");
        }
        StringBuilder sb = new StringBuilder(this.getNodeValue());
        int end = offset + count;
        if (end > this.adaptee.end) {
            end = this.adaptee.end;
        }
        this.setData(sb.delete(offset, end).toString());
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        this.deleteData(offset, count);
        this.insertData(offset, arg);
    }
}

