/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.ROMResultColumnHelper;
import org.eclipse.birt.report.model.adapter.oda.impl.ROMResultSetsHelper;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetCriteriaAdapter;
import org.eclipse.birt.report.model.adapter.oda.util.IdentifierUtility;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.AxisAttributes;
import org.eclipse.datatools.connectivity.oda.design.AxisType;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementIdentifier;
import org.eclipse.datatools.connectivity.oda.design.DataElementIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.HorizontalAlignment;
import org.eclipse.datatools.connectivity.oda.design.OutputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSets;
import org.eclipse.datatools.connectivity.oda.design.ResultSubset;
import org.eclipse.datatools.connectivity.oda.design.TextWrapType;
import org.eclipse.datatools.connectivity.oda.design.ValueFormatHints;
import org.eclipse.emf.common.util.EList;

class ResultSetsAdapter {
    private final OdaDataSetHandle setHandle;
    private final DataSetDesign setDesign;
    private List setDefinedResults = null;
    private List setDefinedColumnHints = null;
    private List<IStructure> columnHintsForComputedColumns = null;
    private final IODADesignFactory designFactory;
    private final ResultSetCriteriaAdapter filterAdapter;

    ResultSetsAdapter(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        this.setHandle = setHandle;
        this.setDesign = setDesign;
        this.filterAdapter = new ResultSetCriteriaAdapter(setHandle, setDesign);
        Iterator tmpIterator = setHandle.resultSetIterator();
        this.setDefinedResults = new ArrayList();
        while (tmpIterator.hasNext()) {
            this.setDefinedResults.add(tmpIterator.next());
        }
        tmpIterator = setHandle.columnHintsIterator();
        this.setDefinedColumnHints = new ArrayList();
        while (tmpIterator.hasNext()) {
            this.setDefinedColumnHints.add(tmpIterator.next());
        }
        this.designFactory = ODADesignFactory.getFactory();
    }

    static ColumnHint newROMColumnHintFromColumnDefinition(ColumnDefinition columnDefn, ColumnDefinition cachedColumnDefn, ColumnHint oldHint, OdaResultSetColumn resultSetColumn) {
        if (columnDefn == null) {
            return null;
        }
        String columnName = resultSetColumn == null ? null : resultSetColumn.getColumnName();
        DataElementAttributes dataAttrs = columnDefn.getAttributes();
        ColumnHint newHint = null;
        if (oldHint != null) {
            newHint = (ColumnHint)oldHint.copy();
        } else if (dataAttrs != null) {
            newHint = StructureFactory.createColumnHint();
            OutputElementAttributes outputAttrs = columnDefn.getUsageHints();
            ResultSetsAdapter.updateColumnHintFromDataAttrs(columnDefn.getAttributes(), null, newHint, resultSetColumn);
            ResultSetsAdapter.updateColumnHintFromUsageHints(outputAttrs, null, newHint, resultSetColumn);
            ResultSetsAdapter.updateColumnHintFromAxisAttrs(columnDefn.getMultiDimensionAttributes(), null, newHint);
        }
        if (newHint != null) {
            newHint.setProperty("columnName", (Object)columnName);
        }
        return newHint;
    }

    private static void updateColumnHintFromDataAttrs(DataElementAttributes dataAttrs, DataElementAttributes cachedDataAttrs, ColumnHint newHint, OdaResultSetColumn column) {
        DataElementUIHints dataUIHints;
        if (dataAttrs == null) {
            return;
        }
        String oldValue = cachedDataAttrs == null ? null : cachedDataAttrs.getName();
        String newValue = dataAttrs.getName();
        if (!CompareUtil.isEquals(newHint.getProperty(null, "columnName"), column.getColumnName()) && !CompareUtil.isEquals(oldValue, newValue)) {
            newHint.setProperty("columnName", (Object)newValue);
        }
        if ((dataUIHints = dataAttrs.getUiHints()) == null) {
            return;
        }
        DataElementUIHints cachedDataUIHints = cachedDataAttrs == null ? null : cachedDataAttrs.getUiHints();
        oldValue = cachedDataUIHints == null ? null : cachedDataUIHints.getDisplayName();
        if (!CompareUtil.isEquals(oldValue, newValue = dataUIHints.getDisplayName())) {
            newHint.setProperty("displayName", (Object)newValue);
        }
        if (!CompareUtil.isEquals(oldValue = cachedDataUIHints == null ? null : cachedDataUIHints.getDisplayNameKey(), newValue = dataUIHints.getDisplayNameKey())) {
            newHint.setProperty("displayNameID", (Object)newValue);
        }
    }

    private static void updateColumnHintFromUsageHints(OutputElementAttributes outputAttrs, OutputElementAttributes cachedOutputAttrs, ColumnHint newHint, OdaResultSetColumn column) {
        ValueFormatHints formatHints;
        String newValue;
        if (outputAttrs == null) {
            return;
        }
        String oldValue = cachedOutputAttrs == null ? null : cachedOutputAttrs.getHelpText();
        if (!CompareUtil.isEquals(oldValue, newValue = outputAttrs.getHelpText())) {
            newHint.setProperty("helpText", (Object)newValue);
        }
        if (!CompareUtil.isEquals(oldValue = cachedOutputAttrs == null ? null : cachedOutputAttrs.getHelpTextKey(), newValue = outputAttrs.getHelpTextKey())) {
            newHint.setProperty("helpTextID", (Object)newValue);
        }
        if (!CompareUtil.isEquals(oldValue = cachedOutputAttrs == null ? null : cachedOutputAttrs.getLabel(), newValue = outputAttrs.getLabel())) {
            newHint.setProperty("heading", (Object)newValue);
        }
        if (!CompareUtil.isEquals(oldValue = cachedOutputAttrs == null ? null : cachedOutputAttrs.getLabelKey(), newValue = outputAttrs.getLabelKey())) {
            newHint.setProperty("headingID", (Object)newValue);
        }
        if ((formatHints = outputAttrs.getFormattingHints()) == null) {
            return;
        }
        ValueFormatHints cachedFormatHints = cachedOutputAttrs == null ? null : cachedOutputAttrs.getFormattingHints();
        oldValue = cachedFormatHints == null ? null : cachedFormatHints.getDisplayFormat();
        if (!CompareUtil.isEquals(oldValue, newValue = formatHints.getDisplayFormat())) {
            FormatValue format = (FormatValue)newHint.getProperty(null, "valueFormat");
            if (format == null && newValue != null) {
                format = StructureFactory.newFormatValue();
                newHint.setProperty("valueFormat", (Object)format);
            }
            if (newValue != null && column != null && "date-time".equals(column.getDataType())) {
                String formatValue = newValue;
                newValue = formatValue.replaceFirst("mm/", "MM/");
            }
            if (format != null) {
                format.setPattern(newValue);
            }
        }
        newValue = formatHints.getHorizontalAlignment();
        Object object = oldValue = cachedFormatHints == null ? null : cachedFormatHints.getHorizontalAlignment();
        if (formatHints.isSetHorizontalAlignment() && !CompareUtil.isEquals(oldValue, newValue)) {
            newHint.setProperty("horizontalAlign", (Object)ResultSetsAdapter.convertToROMHorizontalAlignment((HorizontalAlignment)newValue));
        }
    }

    static String convertToROMHorizontalAlignment(HorizontalAlignment tmpAlign) {
        if (tmpAlign == null) {
            return null;
        }
        switch (tmpAlign.getValue()) {
            case 0: {
                return null;
            }
            case 2: {
                return "center";
            }
            case 1: {
                return "left";
            }
            case 3: {
                return "right";
            }
            case 4: {
                return "justify";
            }
        }
        return null;
    }

    private static HorizontalAlignment convertToOdaHorizontalAlignment(String tmpAlign) {
        if (tmpAlign == null) {
            return HorizontalAlignment.get((int)0);
        }
        if ("justify".equalsIgnoreCase(tmpAlign)) {
            return HorizontalAlignment.get((int)4);
        }
        if ("center".equalsIgnoreCase(tmpAlign)) {
            return HorizontalAlignment.get((int)2);
        }
        if ("left".equalsIgnoreCase(tmpAlign)) {
            return HorizontalAlignment.get((int)1);
        }
        if ("right".equalsIgnoreCase(tmpAlign)) {
            return HorizontalAlignment.get((int)3);
        }
        return null;
    }

    static Boolean convertToROMWordWrap(TextWrapType newValue) {
        if (newValue == null) {
            return null;
        }
        switch (newValue.getValue()) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static void updateColumnHintFromAxisAttrs(AxisAttributes axisAttributes, AxisAttributes cachedAxisAttributes, ColumnHint newHint) {
        AxisType oldValue;
        if (axisAttributes == null) {
            return;
        }
        Object newValue = axisAttributes.getAxisType();
        AxisType axisType = oldValue = cachedAxisAttributes == null ? null : cachedAxisAttributes.getAxisType();
        if (!CompareUtil.isEquals(oldValue, newValue)) {
            newHint.setProperty("analysis", (Object)ResultSetsAdapter.convertAxisTypeToAnalysisType(newValue));
        }
        newValue = axisAttributes.isOnColumnLayout();
        Boolean bl = oldValue = cachedAxisAttributes == null ? null : Boolean.valueOf(cachedAxisAttributes.isOnColumnLayout());
        if (!CompareUtil.isEquals(oldValue, newValue)) {
            newHint.setProperty("onColumnLayout", newValue);
        }
        newValue = axisAttributes.getRelatedColumns();
        ResultSubset resultSubset = oldValue = cachedAxisAttributes == null ? null : cachedAxisAttributes.getRelatedColumns();
        if (!CompareUtil.isEquals(oldValue, newValue)) {
            String analysisColumnName = null;
            DataElementIdentifiers columns = ((ResultSubset)newValue).getColumnIdentifiers();
            if (columns != null && !columns.getIdentifiers().isEmpty()) {
                analysisColumnName = ((DataElementIdentifier)columns.getIdentifiers().get(0)).getName();
            }
            newHint.setProperty("analysisColumn", analysisColumnName);
        }
    }

    static String convertAxisTypeToAnalysisType(AxisType axisType) {
        switch (axisType) {
            case MEASURE_LITERAL: {
                return "measure";
            }
            case DIMENSION_ATTRIBUTE_LITERAL: {
                return "attribute";
            }
            case DIMENSION_MEMBER_LITERAL: {
                return "dimension";
            }
        }
        return null;
    }

    private void updateResultSetColumnFromDataAttrs(DataElementAttributes dataAttrs, DataElementAttributes cachedDataAttrs, OdaResultSetColumn newColumn, String dataSourceId, String dataSetId) {
        Object newValue;
        if (dataAttrs == null) {
            return;
        }
        String oldValue = cachedDataAttrs == null ? null : cachedDataAttrs.getName();
        if (!CompareUtil.isEquals(oldValue, newValue = dataAttrs.getName())) {
            Object tmpNativeName = newValue;
            if (tmpNativeName != null && ((String)tmpNativeName).length() == 0) {
                tmpNativeName = null;
            }
            newColumn.setNativeName((String)tmpNativeName);
        }
        if (!CompareUtil.isEquals(oldValue = cachedDataAttrs == null ? null : Integer.valueOf(cachedDataAttrs.getPosition()), newValue = Integer.valueOf(dataAttrs.getPosition()))) {
            newColumn.setPosition((Integer)newValue);
        }
        if (!CompareUtil.isEquals(oldValue = cachedDataAttrs == null ? null : Integer.valueOf(cachedDataAttrs.getNativeDataTypeCode()), newValue = Integer.valueOf(dataAttrs.getNativeDataTypeCode())) || newColumn.getNativeDataType() == null) {
            newColumn.setNativeDataType((Integer)newValue);
        }
        newColumn.setDataType(this.getROMDataType(dataSourceId, dataSetId, newColumn));
    }

    private String getROMDataType(String dataSourceId, String dataSetId, OdaResultSetColumn column) {
        String name = column.getNativeName();
        Integer position = column.getPosition();
        Integer nativeDataType = column.getNativeDataType();
        OdaResultSetColumnHandle tmpParam = ResultSetsAdapter.findOdaResultSetColumn(this.setDefinedResults.iterator(), name, position, nativeDataType);
        if (tmpParam == null) {
            return AdapterUtil.convertNativeTypeToROMDataType(dataSourceId, dataSetId, column.getNativeDataType(), null);
        }
        Integer tmpPosition = tmpParam.getPosition();
        if (tmpPosition == null || !tmpPosition.equals(column.getPosition())) {
            return AdapterUtil.convertNativeTypeToROMDataType(dataSourceId, dataSetId, column.getNativeDataType(), null);
        }
        Integer tmpNativeCodeType = tmpParam.getNativeDataType();
        if (tmpNativeCodeType == null || tmpNativeCodeType.equals(column.getNativeDataType())) {
            return tmpParam.getDataType();
        }
        String oldDataType = tmpParam.getDataType();
        return AdapterUtil.convertNativeTypeToROMDataType(dataSourceId, dataSetId, column.getNativeDataType(), oldDataType);
    }

    /*
     * Unable to fully structure code
     */
    static OdaResultSetColumnHandle findOdaResultSetColumn(Iterator columns, String paramName, Integer position, Integer nativeDataType, Boolean duplicate) {
        if (position != null && nativeDataType != null) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            column = (OdaResultSetColumnHandle)columns.next();
            tmpNativeDataType = column.getNativeDataType();
            nativeName = column.getNativeName();
            if (duplicate == Boolean.FALSE && !StringUtil.isBlank(nativeName) && nativeName.equalsIgnoreCase(paramName) && (tmpNativeDataType == null || nativeDataType.equals(tmpNativeDataType))) {
                return column;
            }
            if (!StringUtil.isBlank(nativeName) && !nativeName.equalsIgnoreCase(paramName) || !position.equals(column.getPosition()) || tmpNativeDataType != null && !nativeDataType.equals(tmpNativeDataType)) continue;
            return column;
lbl10:
            // 2 sources

            ** while (columns.hasNext())
        }
lbl11:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    static OdaResultSetColumnHandle findOdaResultSetColumn(Iterator columns, String paramName, Integer position, Integer nativeDataType) {
        if (position != null && nativeDataType != null) ** GOTO lbl8
        return null;
lbl-1000:
        // 1 sources

        {
            column = (OdaResultSetColumnHandle)columns.next();
            tmpNativeDataType = column.getNativeDataType();
            nativeName = column.getNativeName();
            if (!StringUtil.isBlank(nativeName) && !nativeName.equalsIgnoreCase(paramName) || !position.equals(column.getPosition()) || tmpNativeDataType != null && !nativeDataType.equals(tmpNativeDataType)) continue;
            return column;
lbl8:
            // 2 sources

            ** while (columns.hasNext())
        }
lbl9:
        // 1 sources

        return null;
    }

    private static ColumnDefinition findColumnDefinition(ResultSetColumns columns, String columnName, Integer position) {
        if (columns == null || columnName == null) {
            return null;
        }
        EList odaColumns = columns.getResultColumnDefinitions();
        if (odaColumns == null || odaColumns.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < odaColumns.size()) {
            ColumnDefinition columnDefn = (ColumnDefinition)odaColumns.get(i);
            DataElementAttributes dataAttrs = columnDefn.getAttributes();
            if (dataAttrs != null && columnName.equals(dataAttrs.getName()) && (position == null || position.intValue() == dataAttrs.getPosition())) {
                return columnDefn;
            }
            ++i;
        }
        return null;
    }

    List<ResultSetColumnInfo> newROMResultSets(ResultSetDefinition cachedSetDefn) throws SemanticException {
        int i;
        ResultSets resultSets;
        ResultSetColumns cachedSetColumns = cachedSetDefn == null ? null : cachedSetDefn.getResultSetColumns();
        ResultSetDefinition resultDefn = this.setDesign.getPrimaryResultSet();
        if (resultDefn == null && (resultSets = this.setDesign.getResultSets()) != null && !resultSets.getResultSetDefinitions().isEmpty()) {
            resultDefn = (ResultSetDefinition)resultSets.getResultSetDefinitions().get(0);
        }
        if (resultDefn == null) {
            return null;
        }
        ResultSetColumns setColumns = resultDefn.getResultSetColumns();
        if (setColumns == null) {
            return null;
        }
        EList odaSetColumns = setColumns.getResultColumnDefinitions();
        if (odaSetColumns.isEmpty()) {
            return null;
        }
        ArrayList<ColumnDefinition> oldColumnDefns = new ArrayList<ColumnDefinition>();
        if (cachedSetColumns != null) {
            EList tmpDefns = cachedSetColumns.getResultColumnDefinitions();
            i = 0;
            while (i < tmpDefns.size()) {
                oldColumnDefns.add((ColumnDefinition)tmpDefns.get(i));
                ++i;
            }
        }
        ArrayList<OdaResultSetColumnHandle> oldColumns = new ArrayList<OdaResultSetColumnHandle>();
        i = 0;
        while (i < this.setDefinedResults.size()) {
            oldColumns.add((OdaResultSetColumnHandle)this.setDefinedResults.get(i));
            ++i;
        }
        ArrayList<ColumnHintHandle> oldColumnHints = new ArrayList<ColumnHintHandle>();
        int i2 = 0;
        while (i2 < this.setDefinedColumnHints.size()) {
            oldColumnHints.add((ColumnHintHandle)this.setDefinedColumnHints.get(i2));
            ++i2;
        }
        ArrayList<ColumnDefinition> newColumnDefns = new ArrayList<ColumnDefinition>();
        int i3 = 0;
        while (i3 < odaSetColumns.size()) {
            newColumnDefns.add((ColumnDefinition)odaSetColumns.get(i3));
            ++i3;
        }
        ROMResultSetsHelper resultSetHelper = new ROMResultSetsHelper(oldColumnDefns, oldColumns, oldColumnHints, newColumnDefns, this.setDesign.getOdaExtensionDataSourceId(), this.setDesign.getOdaExtensionDataSetId());
        ArrayList<ResultSetColumnInfo> retList = new ArrayList<ResultSetColumnInfo>();
        ResultSetColumnInfo setInfo = null;
        int i4 = 0;
        while (i4 < newColumnDefns.size()) {
            ROMResultColumnHelper columnHelper = resultSetHelper.getColumnHelper(i4);
            OdaResultSetColumn newColumn = resultSetHelper.getNewColumn(i4);
            ColumnDefinition newColumnDefn = columnHelper.getNewColumnDefn();
            ColumnHintHandle oldColumnHintHandle = columnHelper.getOldColumnHint();
            ColumnHint oldColumnHint = oldColumnHintHandle == null ? null : (ColumnHint)oldColumnHintHandle.getStructure();
            ColumnHint newColumnHint = ResultSetsAdapter.newROMColumnHintFromColumnDefinition(newColumnDefn, null, oldColumnHint, newColumn);
            setInfo = new ResultSetColumnInfo(newColumn, newColumnHint);
            retList.add(setInfo);
            ++i4;
        }
        this.updateHintsForComputedColumn();
        return retList;
    }

    /*
     * Unable to fully structure code
     */
    static ResultSetColumnHandle findColumn(String name, Iterator columns) {
        if (name != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            column = (ResultSetColumnHandle)columns.next();
            if (!name.equals(column.getColumnName())) continue;
            return column;
lbl6:
            // 2 sources

            ** while (columns.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }

    void updateOdaResultSetDefinition() {
        this.setDesign.setPrimaryResultSet(this.newOdaResultSetDefinition());
        this.filterAdapter.updateODAResultSetCriteria();
    }

    private ResultSetDefinition newOdaResultSetDefinition() {
        Iterator romSets = this.setDefinedResults.iterator();
        String name = this.setHandle.getResultSetName();
        if (!romSets.hasNext()) {
            return null;
        }
        ResultSetDefinition odaSetDefn = null;
        ResultSetColumns odaSetColumns = null;
        if (!StringUtil.isBlank(name)) {
            odaSetDefn = this.designFactory.createResultSetDefinition();
            odaSetDefn.setName(name);
        }
        while (romSets.hasNext()) {
            Integer nativeDataType;
            if (odaSetDefn == null) {
                odaSetDefn = this.designFactory.createResultSetDefinition();
            }
            if (odaSetColumns == null) {
                odaSetColumns = this.designFactory.createResultSetColumns();
            }
            OdaResultSetColumnHandle setColumn = (OdaResultSetColumnHandle)romSets.next();
            ColumnHintHandle hint = AdapterUtil.findColumnHint((OdaResultSetColumn)setColumn.getStructure(), this.setDefinedColumnHints.iterator());
            ColumnDefinition columnDefn = this.designFactory.createColumnDefinition();
            DataElementAttributes dataAttrs = this.designFactory.createDataElementAttributes();
            String newName = setColumn.getNativeName();
            dataAttrs.setName(newName);
            Integer position = setColumn.getPosition();
            if (position != null) {
                dataAttrs.setPosition(setColumn.getPosition().intValue());
            }
            if ((nativeDataType = setColumn.getNativeDataType()) != null) {
                dataAttrs.setNativeDataTypeCode(nativeDataType.intValue());
            }
            columnDefn.setAttributes(dataAttrs);
            odaSetColumns.getResultColumnDefinitions().add((Object)columnDefn);
            if (hint == null) continue;
            this.updateOdaColumnHint(columnDefn, hint);
        }
        if (odaSetDefn != null) {
            odaSetDefn.setResultSetColumns(odaSetColumns);
        }
        return odaSetDefn;
    }

    void updateOdaFilterExpression() {
        this.filterAdapter.updateODAResultSetCriteria();
    }

    void updateROMFilterCondition() throws SemanticException {
        this.filterAdapter.updateROMSortAndFilter();
    }

    static void createUniqueResultSetColumnNames(List<ResultSetColumnInfo> columnInfo) {
        if (columnInfo == null || columnInfo.isEmpty()) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < columnInfo.size()) {
            ResultSetColumnInfo tmpInfo = columnInfo.get(i);
            OdaResultSetColumn column = tmpInfo.column;
            String nativeName = column.getNativeName();
            if (nativeName != null) {
                names.add(nativeName);
            }
            ++i;
        }
        HashSet<String> newNames = new HashSet<String>();
        int i2 = 0;
        while (i2 < columnInfo.size()) {
            ResultSetColumnInfo tmpInfo = columnInfo.get(i2);
            OdaResultSetColumn column = tmpInfo.column;
            String nativeName = column.getNativeName();
            String name = column.getColumnName();
            if (!StringUtil.isBlank(name)) {
                newNames.add(name);
            } else {
                nativeName = StringUtil.trimString(nativeName);
                String newName = IdentifierUtility.getUniqueColumnName(names, newNames, nativeName, i2);
                newNames.add(newName);
                column.setColumnName(newName);
                if (tmpInfo.hint != null) {
                    tmpInfo.hint.setProperty("columnName", (Object)newName);
                }
            }
            ++i2;
        }
        names.clear();
        newNames.clear();
    }

    private void updateHintsForComputedColumn() {
        Iterator columns = this.setHandle.computedColumnsIterator();
        ArrayList<String> columnNames = new ArrayList<String>();
        while (columns.hasNext()) {
            ComputedColumnHandle tmpColumn = (ComputedColumnHandle)columns.next();
            columnNames.add(tmpColumn.getName());
        }
        int i = 0;
        while (i < columnNames.size()) {
            String columnName = (String)columnNames.get(i);
            ColumnHintHandle hintHandle = AdapterUtil.findColumnHint(columnName, this.setDefinedColumnHints.iterator());
            if (hintHandle != null) {
                if (this.columnHintsForComputedColumns == null) {
                    this.columnHintsForComputedColumns = new ArrayList<IStructure>();
                }
                this.columnHintsForComputedColumns.add(hintHandle.getStructure().copy());
            }
            ++i;
        }
    }

    List<IStructure> getHintsForComputedColumn() {
        if (this.columnHintsForComputedColumns == null) {
            return Collections.EMPTY_LIST;
        }
        return this.columnHintsForComputedColumns;
    }

    void updateOdaColumnHints() {
        ResultSetDefinition columnDefns = this.setDesign.getPrimaryResultSet();
        if (columnDefns == null) {
            return;
        }
        int i = 0;
        while (i < this.setDefinedColumnHints.size()) {
            ColumnDefinition odaColumn;
            ColumnHintHandle hint = (ColumnHintHandle)this.setDefinedColumnHints.get(i);
            OdaResultSetColumnHandle column = (OdaResultSetColumnHandle)ResultSetsAdapter.findColumn(hint.getColumnName(), this.setDefinedResults.iterator());
            if (column != null && (odaColumn = ResultSetsAdapter.findColumnDefinition(columnDefns.getResultSetColumns(), column.getNativeName(), column.getPosition())) != null) {
                this.updateOdaColumnHint(odaColumn, hint);
            }
            ++i;
        }
    }

    private void updateOdaColumnHint(ColumnDefinition columnDefn, ColumnHintHandle hint) {
        DataElementAttributes dataAttrs = columnDefn.getAttributes();
        DataElementUIHints uiHints = null;
        String displayName = hint.getDisplayName();
        String displayNameKey = hint.getDisplayNameKey();
        if (displayName != null || displayNameKey != null) {
            uiHints = this.designFactory.createDataElementUIHints();
            uiHints.setDisplayName(displayName);
            uiHints.setDisplayNameKey(displayNameKey);
        }
        dataAttrs.setUiHints(uiHints);
        OutputElementAttributes outputAttrs = null;
        String helpText = hint.getHelpText();
        String helpTextKey = hint.getHelpTextKey();
        if (helpText != null || helpTextKey != null) {
            outputAttrs = this.designFactory.createOutputElementAttributes();
            if (helpText != null || helpTextKey != null) {
                outputAttrs.setHelpText(helpText);
                outputAttrs.setHelpTextKey(helpTextKey);
            }
        }
        String heading = hint.getHeading();
        String headingKey = hint.getHeadingKey();
        if (heading != null || headingKey != null) {
            if (outputAttrs == null) {
                outputAttrs = this.designFactory.createOutputElementAttributes();
            }
            if (heading != null || headingKey != null) {
                outputAttrs.setLabel(heading);
                outputAttrs.setLabelKey(headingKey);
            }
        }
        FormatValue format = hint.getValueFormat();
        String horizontalAlign = hint.getHorizontalAlign();
        if (format != null && format.getPattern() != null || horizontalAlign != null) {
            if (outputAttrs == null) {
                outputAttrs = this.designFactory.createOutputElementAttributes();
            }
            ValueFormatHints formatHint = this.designFactory.createValueFormatHints();
            if (format != null) {
                formatHint.setDisplayFormat(format.getPattern());
            }
            formatHint.setHorizontalAlignment(ResultSetsAdapter.convertToOdaHorizontalAlignment(horizontalAlign));
            outputAttrs.setFormattingHints(formatHint);
        }
        columnDefn.setUsageHints(outputAttrs);
        AxisAttributes axisAttrs = null;
        String analysisType = hint.getAnalysis();
        AxisType axisType = this.convertAnalysisTypeToAxisType(analysisType);
        if (axisType != null) {
            axisAttrs = this.designFactory.createAxisAttributes();
            axisAttrs.setAxisType(axisType);
            axisAttrs.setOnColumnLayout(hint.isOnColumnLayout());
            String analysisColumnName = hint.getAnalysisColumn();
            if (!StringUtil.isBlank(analysisColumnName)) {
                ResultSubset relatedColumns = this.designFactory.createResultSubset();
                relatedColumns.addColumnIdentifier(analysisColumnName);
                axisAttrs.setRelatedColumns(relatedColumns);
            }
        }
        columnDefn.setMultiDimensionAttributes(axisAttrs);
    }

    private AxisType convertAnalysisTypeToAxisType(String analysisType) {
        AxisType axisType = null;
        if ("measure".equals(analysisType)) {
            axisType = AxisType.MEASURE_LITERAL;
        } else if ("attribute".equals(analysisType)) {
            axisType = AxisType.DIMENSION_ATTRIBUTE_LITERAL;
        } else if ("dimension".equals(analysisType)) {
            axisType = AxisType.DIMENSION_MEMBER_LITERAL;
        }
        return axisType;
    }

    static class ResultSetColumnInfo {
        private OdaResultSetColumn column;
        private ColumnHint hint;

        ResultSetColumnInfo(OdaResultSetColumn column, ColumnHint hint) {
            this.column = column;
            this.hint = hint;
        }

        static void updateResultSetColumnList(List<ResultSetColumnInfo> infos, List<OdaResultSetColumn> columns, List<ColumnHint> hints) {
            if (infos == null || infos.isEmpty()) {
                return;
            }
            int i = 0;
            while (i < infos.size()) {
                ResultSetColumnInfo info = infos.get(i);
                if (columns != null) {
                    columns.add(info.column);
                }
                if (info.hint != null && hints != null) {
                    hints.add(info.hint);
                }
                ++i;
            }
        }
    }
}

