/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class ColumnNameHelperImpl {
    protected ColumnNameHelperImpl() {
    }

    public String extractColumnName(Object column) {
        if (column instanceof String) {
            return this.extractColumnName((String)column);
        }
        if (column instanceof Expression) {
            return this.extractColumnName((Expression)column);
        }
        return null;
    }

    public String extractColumnName(Expression columnExpr) {
        if (columnExpr != null) {
            String type = columnExpr.getType();
            String value = columnExpr.getStringExpression();
            if ("javascript".equalsIgnoreCase(type)) {
                return this.extractColumnName(value);
            }
            return value;
        }
        return null;
    }

    public String extractColumnName(String columnExpr) {
        if (!StringUtil.isBlank(columnExpr)) {
            String columnName = this.checkColumnName(columnExpr);
            if (StringUtil.isBlank(columnName)) {
                return columnExpr;
            }
            return columnName;
        }
        return null;
    }

    protected String checkColumnName(String columnExpr) {
        String columnName = null;
        if (!StringUtil.isBlank(columnExpr)) {
            try {
                columnName = ExpressionUtil.getColumnName(columnExpr);
            }
            catch (BirtException birtException) {
                // empty catch block
            }
            if (columnName == null) {
                try {
                    columnName = ExpressionUtil.getColumnBindingName(columnExpr);
                }
                catch (BirtException birtException) {
                    // empty catch block
                }
            }
        }
        return columnName;
    }

    public Expression createColumnExpression(String column, String type) {
        if (StringUtil.isBlank(column)) {
            return null;
        }
        if (StringUtil.isBlank(type)) {
            type = "javascript";
        }
        if (!"javascript".equals(type)) {
            return null;
        }
        String columnName = this.checkColumnName(column);
        if (StringUtil.isBlank(columnName)) {
            columnName = column;
        }
        return new Expression(ExpressionUtil.createDataSetRowExpression(columnName), type);
    }
}

