/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.DesignRunnable;
import org.eclipse.birt.report.engine.api.script.element.IReportDesign;
import org.eclipse.birt.report.engine.script.internal.element.ReportDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportRunnable
extends DesignRunnable
implements IReportRunnable {
    protected String reportName;
    protected boolean prepared = false;
    protected Hashtable<String, Map<String, ICompiledScript>> cachedScripts = new Hashtable();

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public Map<String, Map<String, ICompiledScript>> getScriptCache() {
        return this.cachedScripts;
    }

    public ICompiledScript getScript(String scriptName, String source) {
        Map<String, ICompiledScript> scriptCache = this.cachedScripts.get(scriptName);
        if (scriptCache == null) {
            return null;
        }
        return scriptCache.get(source);
    }

    public void putScript(String scriptName, String source, ICompiledScript script) {
        Map<String, ICompiledScript> cachedScript = this.cachedScripts.get(scriptName);
        if (cachedScript == null) {
            cachedScript = new Hashtable<String, ICompiledScript>();
            this.cachedScripts.put(scriptName, cachedScript);
        }
        cachedScript.put(source, script);
    }

    public ReportRunnable(IReportEngine engine, ModuleHandle designHandle) {
        super(engine, designHandle);
    }

    public void setReportName(String name) {
        this.reportName = name;
    }

    @Override
    public String getReportName() {
        return this.reportName;
    }

    public ReportDesignHandle getReport() {
        return (ReportDesignHandle)this.designHandle;
    }

    @Override
    public void setDesignHandle(DesignElementHandle handle) {
        if (!(handle instanceof ReportDesignHandle)) {
            throw new IllegalArgumentException("the argument must be a instanceof ReportDesignHandle");
        }
        this.designHandle = handle;
    }

    @Override
    public IReportDesign getDesignInstance() {
        ReportDesign design = new ReportDesign((ReportDesignHandle)this.designHandle);
        return design;
    }

    public ReportRunnable cloneRunnable() {
        ReportDesignHandle newDesign = (ReportDesignHandle)this.designHandle.copy().getHandle(null);
        newDesign.setFileName(this.getReportName());
        ReportRunnable newRunnable = new ReportRunnable(this.engine, newDesign);
        newRunnable.setReportName(this.reportName);
        newRunnable.setPrepared(this.prepared);
        return newRunnable;
    }
}

