/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabHeaderRowExecutor
extends BaseCrosstabExecutor {
    private static Logger logger = Logger.getLogger(CrosstabHeaderRowExecutor.class.getName());
    private LevelViewHandle levelView;
    private long currentEdgePosition;
    private int currentDimensionIndex;
    private int currentLevelIndex;
    private int subTotalDimensionIndex;
    private int subTotalLevelIndex;
    private int currentChangeType;
    private int currentColIndex;
    private int rowSpan;
    private int colSpan;
    private boolean edgeStarted;
    private boolean subTotalStarted;
    private boolean grandTotalStarted;
    private boolean blankStarted;
    private boolean hasLast;
    private boolean isLayoutDownThenOver;
    private int currentGroupIndex;
    private int nextGroupIndex;
    private boolean isFirst;
    private IReportItemExecutor nextExecutor;

    public CrosstabHeaderRowExecutor(BaseCrosstabExecutor parent, LevelViewHandle levelView) {
        super(parent);
        this.levelView = levelView;
    }

    @Override
    public void close() {
        super.close();
        this.nextExecutor = null;
    }

    @Override
    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent(content, null);
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.isFirst = true;
        this.subTotalStarted = false;
        this.grandTotalStarted = false;
        this.edgeStarted = false;
        this.blankStarted = false;
        this.hasLast = false;
        if (this.crosstabItem != null) {
            this.isLayoutDownThenOver = "down then over".equals(this.crosstabItem.getPageLayout());
        }
        this.currentLevelIndex = this.levelView.getIndex();
        this.currentDimensionIndex = ((DimensionViewHandle)this.levelView.getContainer()).getIndex();
        this.processRowHeight(this.findHeaderRowCell(this.currentDimensionIndex, this.currentLevelIndex));
        this.subTotalDimensionIndex = -1;
        this.subTotalLevelIndex = -1;
        if (this.isLayoutDownThenOver) {
            this.subTotalDimensionIndex = this.currentDimensionIndex;
            this.subTotalLevelIndex = this.currentLevelIndex;
        } else {
            DimensionViewHandle dv;
            LevelViewHandle lv;
            EdgeGroup gp = GroupUtil.getPreviousGroup(this.columnGroups, this.currentDimensionIndex, this.currentLevelIndex);
            if (gp != null && (lv = (dv = this.crosstabItem.getDimension(1, gp.dimensionIndex)).getLevel(gp.levelIndex)).getAggregationHeader() != null) {
                this.subTotalDimensionIndex = gp.dimensionIndex;
                this.subTotalLevelIndex = gp.levelIndex;
            }
        }
        this.currentGroupIndex = GroupUtil.getGroupIndex(this.columnGroups, this.currentDimensionIndex, this.currentLevelIndex);
        this.nextGroupIndex = GroupUtil.getNextGroupIndex(this.columnGroups, this.currentDimensionIndex, this.currentLevelIndex);
        this.rowSpan = 1;
        this.colSpan = 0;
        this.currentColIndex = -1;
        this.currentChangeType = -1;
        this.currentEdgePosition = -1L;
        this.walker.reload();
    }

    private boolean isForceEmpty() {
        try {
            EdgeCursor columnEdgeCursor = this.getColumnEdgeCursor();
            if (columnEdgeCursor != null) {
                columnEdgeCursor.setPosition(this.currentEdgePosition);
                DimensionCursor dc = (DimensionCursor)columnEdgeCursor.getDimensionCursor().get(this.currentGroupIndex);
                return GroupUtil.isDummyGroup(dc);
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabHeaderRowExecutor.error.check.force.empty"), e);
        }
        return false;
    }

    private boolean isMeetEdgeEnd(ColumnEvent ev) {
        if (ev.type == 4 || this.isStartUnderSubTotal(ev)) {
            return true;
        }
        if (this.nextGroupIndex != -1) {
            try {
                EdgeCursor columnEdgeCursor = this.getColumnEdgeCursor();
                if (columnEdgeCursor != null) {
                    columnEdgeCursor.setPosition(ev.dataPosition);
                    DimensionCursor dc = (DimensionCursor)columnEdgeCursor.getDimensionCursor().get(this.currentGroupIndex);
                    if (!GroupUtil.isDummyGroup(dc)) {
                        return this.currentEdgePosition < dc.getEdgeStart();
                    }
                }
            }
            catch (OLAPException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabHeaderRowExecutor.error.check.edge.end"), e);
            }
        }
        return ev.measureIndex <= 0;
    }

    private boolean isEdgeNeedStart(ColumnEvent ev) {
        return !this.edgeStarted && !this.subTotalStarted && (ev.type == 2 || this.isStartOverSubTotal(ev));
    }

    private boolean isStartOverSubTotal(ColumnEvent ev) {
        if (this.isLayoutDownThenOver) {
            return !this.subTotalStarted && ev.type == 3 && (ev.dimensionIndex > this.currentDimensionIndex || ev.dimensionIndex == this.currentDimensionIndex && ev.levelIndex > this.currentLevelIndex);
        }
        return !this.subTotalStarted && ev.type == 3 && (ev.dimensionIndex > this.currentDimensionIndex || ev.dimensionIndex == this.currentDimensionIndex && ev.levelIndex >= this.currentLevelIndex);
    }

    private boolean isStartUnderSubTotal(ColumnEvent ev) {
        if (this.isLayoutDownThenOver) {
            return !this.subTotalStarted && ev.type == 3 && (ev.dimensionIndex < this.currentDimensionIndex || ev.dimensionIndex == this.currentDimensionIndex && ev.levelIndex <= this.currentLevelIndex);
        }
        return !this.subTotalStarted && ev.type == 3 && (ev.dimensionIndex < this.currentDimensionIndex || ev.dimensionIndex == this.currentDimensionIndex && ev.levelIndex < this.currentLevelIndex);
    }

    private boolean isSubTotalNeedStart(ColumnEvent ev) {
        return !this.subTotalStarted && ev.type == 3 && ev.dimensionIndex == this.subTotalDimensionIndex && ev.levelIndex == this.subTotalLevelIndex;
    }

    private boolean isGrandTotalNeedStart(ColumnEvent ev) {
        return !this.grandTotalStarted && ev.type == 4 && this.crosstabItem.getGrandTotal(1) != null && GroupUtil.isFirstGroup(this.columnGroups, this.currentDimensionIndex, this.currentLevelIndex);
    }

    private boolean isBlankNeedStart(ColumnEvent ev) {
        int headerCount;
        return !(this.blankStarted || ev.type != 1 && ev.type != 5 || (headerCount = this.crosstabItem.getHeaderCount()) <= 1 && !GroupUtil.isFirstGroup(this.columnGroups, this.currentDimensionIndex, this.currentLevelIndex));
    }

    private int computeCornerHeaderCellRowSpan() {
        if (this.crosstabItem.getHeaderCount() > 1) {
            return 1;
        }
        int span = GroupUtil.computeGroupSpan(this.columnGroups, this.currentDimensionIndex, this.currentLevelIndex) + 1;
        if (GroupUtil.hasMeasureHeader(this.crosstabItem, 1)) {
            ++span;
        }
        return span;
    }

    private CrosstabCellHandle getCornerHeaderCell(int colIndex) {
        int rgCount;
        int headerCount = this.crosstabItem.getHeaderCount();
        if (headerCount <= 1) {
            return this.crosstabItem.getHeader();
        }
        int n = rgCount = this.rowGroups == null ? 0 : this.rowGroups.size();
        if (GroupUtil.hasMeasureHeader(this.crosstabItem, 0)) {
            ++rgCount;
        } else if (rgCount == 0) {
            ++rgCount;
        }
        int offset = this.currentGroupIndex * rgCount;
        if (colIndex + offset < headerCount) {
            return this.crosstabItem.getHeader(colIndex + offset);
        }
        return null;
    }

    private void advance() {
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: 
                    case 5: {
                        int headerCount;
                        if (!this.blankStarted || (headerCount = this.crosstabItem.getHeaderCount()) <= 1 && (ev.type == 1 || ev.type == 5)) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getCornerHeaderCell(this.currentColIndex - this.colSpan + 1), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.blankStarted = false;
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (this.edgeStarted && this.isMeetEdgeEnd(ev)) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.levelView.getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            ((CrosstabCellExecutor)this.nextExecutor).setForceEmpty(this.isForceEmpty());
                            this.edgeStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (!this.subTotalStarted || ev.type == this.currentChangeType && ev.dimensionIndex == this.subTotalDimensionIndex && ev.levelIndex == this.subTotalLevelIndex) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(1, this.subTotalDimensionIndex).getLevel(this.subTotalLevelIndex).getAggregationHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.subTotalStarted = false;
                        this.hasLast = false;
                        break;
                    }
                    case 4: {
                        if (!this.grandTotalStarted || ev.type == this.currentChangeType) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getGrandTotal(1), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.grandTotalStarted = false;
                        this.hasLast = false;
                    }
                }
                if (this.isSubTotalNeedStart(ev)) {
                    this.subTotalStarted = true;
                    this.rowSpan = GroupUtil.computeGroupSpan(this.columnGroups, this.subTotalDimensionIndex, this.subTotalLevelIndex);
                    if (this.isLayoutDownThenOver) {
                        ++this.rowSpan;
                    }
                    this.colSpan = 0;
                    this.hasLast = true;
                } else if (this.isGrandTotalNeedStart(ev)) {
                    this.grandTotalStarted = true;
                    this.rowSpan = GroupUtil.computeGroupSpan(this.columnGroups, this.currentDimensionIndex, this.currentLevelIndex) + 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                } else if (this.isEdgeNeedStart(ev)) {
                    this.edgeStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                } else if (this.isBlankNeedStart(ev)) {
                    this.blankStarted = true;
                    this.rowSpan = this.computeCornerHeaderCellRowSpan();
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentEdgePosition = ev.dataPosition;
                this.currentChangeType = ev.type;
                ++this.colSpan;
                ++this.currentColIndex;
                if (this.nextExecutor == null) continue;
                return;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabHeaderRowExecutor.error.retrieve.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            if (this.blankStarted) {
                this.nextExecutor = new CrosstabCellExecutor(this, this.getCornerHeaderCell(this.currentColIndex - this.colSpan + 1), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
            } else if (this.edgeStarted) {
                this.nextExecutor = new CrosstabCellExecutor(this, this.levelView.getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                ((CrosstabCellExecutor)this.nextExecutor).setForceEmpty(this.isForceEmpty());
                this.edgeStarted = false;
            } else if (this.subTotalStarted) {
                this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(1, this.subTotalDimensionIndex).getLevel(this.subTotalLevelIndex).getAggregationHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.subTotalStarted = false;
            } else if (this.grandTotalStarted) {
                this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getGrandTotal(1), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.grandTotalStarted = false;
            }
        }
    }

    @Override
    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.nextExecutor;
        this.nextExecutor = null;
        this.advance();
        return childExecutor;
    }

    @Override
    public boolean hasNextChild() {
        if (this.isFirst) {
            this.isFirst = false;
            this.advance();
        }
        return this.nextExecutor != null;
    }
}

