/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx.writer;

import java.io.IOException;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXCanvas;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Component;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.emitter.pptx.writer.SlideLayout;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public class Slide
extends Component {
    private static final String TAG_SLIDE = "p:sld";
    private int index;
    private Presentation presentation;
    private boolean isClosed = false;

    public Slide(Presentation presentation, int slideIndex, SlideLayout slideLayout) throws IOException {
        this.index = slideIndex;
        this.presentation = presentation;
        String uri = this.getSlideUri(this.index);
        String relationShipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide";
        String type = "application/vnd.openxmlformats-officedocument.presentationml.slide+xml";
        this.initialize(presentation.getPart(), uri, type, relationShipType);
        this.referTo(slideLayout);
        this.writer.startWriter();
        this.writer.openTag(TAG_SLIDE);
        this.writer.nameSpace("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        this.writer.nameSpace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        this.writer.nameSpace("p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        this.writer.openTag("p:cSld");
        this.writer.openTag("p:spTree");
        this.writer.openTag("p:nvGrpSpPr");
        this.writer.openTag("p:cNvPr");
        this.writer.attribute("id", presentation.getNextShapeId());
        this.writer.attribute("name", "");
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvGrpSpPr");
        this.writer.closeTag("p:cNvGrpSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvGrpSpPr");
        this.writer.openTag("p:grpSpPr");
        this.writer.closeTag("p:grpSpPr");
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    private String getSlideUri(int slideIndex) {
        return "slides/slide" + slideIndex + ".xml";
    }

    public int getSlideId() {
        return 255 + this.index;
    }

    public void dispose() {
        if (!this.isClosed) {
            this.writer.closeTag("p:spTree");
            this.writer.closeTag("p:cSld");
            this.writer.openTag("p:clrMapOvr");
            this.writer.openTag("a:masterClrMapping");
            this.writer.closeTag("a:masterClrMapping");
            this.writer.closeTag("p:clrMapOvr");
            this.writer.closeTag(TAG_SLIDE);
            this.writer.endWriter();
            this.writer.close();
            this.writer = null;
            this.isClosed = true;
        }
    }

    public OOXmlWriter getWriter() {
        return this.writer;
    }

    public PPTXCanvas getCanvas() {
        return new PPTXCanvas(this.presentation, this.part, this.writer);
    }
}

