/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IBookmarkInfo;
import org.eclipse.birt.report.engine.api.IReportDocumentHelper;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.impl.BookmarkInfo;
import org.eclipse.birt.report.engine.api.impl.IReportletDocument;
import org.eclipse.birt.report.engine.api.impl.LinkedObjectManager;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.RunStatusReader;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.executor.ApplicationClassLoader;
import org.eclipse.birt.report.engine.extension.engine.IReportDocumentExtension;
import org.eclipse.birt.report.engine.extension.engine.IReportEngineExtension;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.PageHintReader;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.document.v4.InstanceIDComparator;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.index.DocumentIndexReader;
import org.eclipse.birt.report.engine.internal.index.IDocumentIndexReader;
import org.eclipse.birt.report.engine.ir.EngineIRReader;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.toc.ITOCReader;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCReader;
import org.eclipse.birt.report.engine.toc.TOCView;
import org.eclipse.birt.report.engine.toc.TreeNode;
import org.eclipse.birt.report.engine.toc.document.TOCReaderV0;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class ReportDocumentReader
implements IReportletDocument,
ReportDocumentConstants,
IReportDocumentHelper {
    private static Logger logger = Logger.getLogger(ReportDocumentReader.class.getName());
    private ReportEngine engine;
    private IDocArchiveReader archive;
    private Map moduleOptions;
    private String coreVersion;
    private Map properties = new HashMap();
    private HashMap parameters;
    private HashMap globalVariables;
    private IPageHintReader pageHintReader;
    private ITOCReader tocReader;
    private IDocumentIndexReader indexReader;
    private String systemId;
    private int checkpoint = 0;
    private long pageCount;
    private boolean sharedArchive;
    private ApplicationClassLoader applicationClassLoader;
    private ReportRunnable preparedRunnable = null;
    private ReportRunnable reportRunnable = null;
    private boolean coreStreamLoaded = false;
    private LinkedObjectManager.LinkedEntry<ReportDocumentReader> engineCacheEntry;
    private byte[] bodyData;
    private TreeNode cachedTreeV0;
    private Boolean isReportlet;
    private String reportletBookmark;
    private String reportletInstanceID;
    HashMap<String, IReportDocumentExtension> extensions = new HashMap();

    public ReportDocumentReader(ReportEngine engine, IDocArchiveReader archive, boolean sharedArchive) throws EngineException {
        this(null, engine, archive, sharedArchive);
    }

    public ReportDocumentReader(ReportEngine engine, IDocArchiveReader archive) throws EngineException {
        this(null, engine, archive, false);
    }

    public ReportDocumentReader(String systemId, ReportEngine engine, IDocArchiveReader archive, Map options) throws EngineException {
        this(systemId, engine, archive, false, options);
    }

    public ReportDocumentReader(String systemId, ReportEngine engine, IDocArchiveReader archive, boolean sharedArchive) throws EngineException {
        this(systemId, engine, archive, sharedArchive, null);
    }

    public ReportDocumentReader(String systemId, ReportEngine engine, IDocArchiveReader archive, boolean sharedArchive, Map options) throws EngineException {
        this.engine = engine;
        this.archive = archive;
        this.systemId = systemId;
        this.sharedArchive = sharedArchive;
        this.moduleOptions = new HashMap();
        this.moduleOptions.put("semanticCheck", Boolean.FALSE);
        if (options != null) {
            this.moduleOptions.putAll(options);
        }
        this.loadCoreStreamHeader();
    }

    @Override
    public IDocArchiveReader getArchive() {
        return this.archive;
    }

    @Override
    public String getVersion() {
        return (String)this.properties.get("BIRT ENGINE VERSION");
    }

    @Override
    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCoreStreamHeader() throws EngineException {
        try {
            Object lock = this.archive.lock("/core");
            try {
                Object object = lock;
                synchronized (object) {
                    RAInputStream in = this.archive.getStream("/core");
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try {
                        try {
                            DataInputStream di = new DataInputStream(in);
                            this.checkVersion(di);
                            this.loadCoreStreamHeader(di);
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                this.archive.unlock(lock);
            }
        }
        catch (IOException ee) {
            this.close();
            throw new EngineException("Error.ReportDocmentOpenError", ee);
        }
    }

    private void loadCoreStreamHeader(DataInputStream di) throws IOException {
        ReportDocumentCoreInfo documentInfo = new ReportDocumentCoreInfo();
        this.loadCoreStreamHeader(di, documentInfo);
        if (this.checkpoint != documentInfo.checkpoint) {
            this.checkpoint = documentInfo.checkpoint;
            this.pageCount = documentInfo.pageCount;
            if (this.systemId == null) {
                this.systemId = documentInfo.systemId;
            }
        }
    }

    private void loadCoreStreamHeader(DataInputStream di, ReportDocumentCoreInfo documentInfo) throws IOException {
        if ("CORE_VERSION_UNKNOWN".equals(this.coreVersion)) {
            this.loadCoreStreamHeaderUnknown(di, documentInfo);
        } else if ("CORE_VERSION_0".equals(this.coreVersion) || "CORE_VERSION_1".equals(this.coreVersion) || "CORE_VERSION_2".equals(this.coreVersion)) {
            this.loadCoreStreamHeaderV0(di, documentInfo);
        } else {
            throw new IOException("Error.UnsupportedCoreStreamVersion" + this.coreVersion);
        }
    }

    private void loadCoreStreamHeaderUnknown(DataInputStream coreStream, ReportDocumentCoreInfo documentInfo) throws IOException {
        documentInfo.checkpoint = 0;
        documentInfo.pageCount = 0L;
        if (!this.archive.exists("/checkpoint")) {
            documentInfo.checkpoint = -1;
            this.initializePageHintReader();
            if (this.pageHintReader != null) {
                documentInfo.pageCount = this.pageHintReader.getTotalPage();
            }
        } else {
            RAInputStream in = this.archive.getStream("/checkpoint");
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                try {
                    DataInputStream di = new DataInputStream(in);
                    documentInfo.checkpoint = IOUtil.readInt(di);
                    documentInfo.pageCount = IOUtil.readLong(di);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        documentInfo.systemId = IOUtil.readString(coreStream);
    }

    private void loadCoreStreamHeaderV0(DataInputStream di, ReportDocumentCoreInfo documentInfo) throws IOException {
        documentInfo.checkpoint = 0;
        documentInfo.pageCount = 0L;
        documentInfo.checkpoint = IOUtil.readInt(di);
        documentInfo.pageCount = IOUtil.readLong(di);
        documentInfo.systemId = IOUtil.readString(di);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCoreStreamLazily() {
        if (!this.coreStreamLoaded) {
            ReportDocumentReader reportDocumentReader = this;
            synchronized (reportDocumentReader) {
                if (!this.coreStreamLoaded) {
                    try {
                        this.loadCoreStream();
                    }
                    catch (IOException ee) {
                        logger.log(Level.SEVERE, "Failed to load core stream", ee);
                    }
                }
            }
        }
    }

    @Override
    public synchronized void refresh() {
        try {
            this.loadCoreStream();
        }
        catch (IOException ee) {
            logger.log(Level.SEVERE, "Failed to refresh", ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCoreStream() throws IOException {
        Object lock = this.archive.lock("/core");
        try {
            Object object = lock;
            synchronized (object) {
                RAInputStream in = this.archive.getStream("/core");
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    try {
                        DataInputStream di = new DataInputStream(in);
                        this.checkVersion(di);
                        this.loadCoreStream(di);
                        this.coreStreamLoaded = true;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        finally {
            this.archive.unlock(lock);
        }
    }

    private void loadCoreStream(DataInputStream di) throws IOException {
        ReportDocumentCoreInfo documentInfo = new ReportDocumentCoreInfo();
        this.loadCoreStreamHeader(di, documentInfo);
        this.loadCoreStreamBody(di, documentInfo);
        this.checkpoint = documentInfo.checkpoint;
        this.pageCount = documentInfo.pageCount;
        this.globalVariables = documentInfo.globalVariables;
        this.parameters = documentInfo.parameters;
        if (this.checkpoint == -1) {
            if (this.indexReader == null) {
                this.indexReader = documentInfo.indexReader;
            } else if (documentInfo.indexReader != null) {
                documentInfo.indexReader.close();
            }
            if (this.tocReader == null) {
                this.tocReader = documentInfo.tocReader;
                if (this.tocReader != null) {
                    this.cachedTreeV0 = (TreeNode)this.tocReader.readTree();
                }
            } else if (documentInfo.tocReader != null) {
                documentInfo.tocReader.close();
            }
        }
    }

    private void loadCoreStreamBody(DataInputStream di, ReportDocumentCoreInfo documentInfo) throws IOException {
        if ("CORE_VERSION_UNKNOWN".equals(this.coreVersion)) {
            this.loadCoreStreamBodyUnknown(di, documentInfo);
        } else if ("CORE_VERSION_0".equals(this.coreVersion) || "CORE_VERSION_1".equals(this.coreVersion)) {
            this.loadCoreStreamBodyV0(di, documentInfo);
        } else if ("CORE_VERSION_2".equals(this.coreVersion)) {
            this.loadCoreStreamBodyV2(di, documentInfo);
        } else {
            throw new IOException("unsupported core stream version: " + this.coreVersion);
        }
    }

    protected void loadCoreStreamBodyUnknown(DataInputStream coreStream, ReportDocumentCoreInfo documentInfo) throws IOException {
        this.loadCoreStreamBodyToBuffer(coreStream);
        if (documentInfo.checkpoint == -1) {
            documentInfo.indexReader = new DocumentIndexReader(0, this.archive);
        }
    }

    protected void loadCoreStreamBodyV0(DataInputStream coreStream, ReportDocumentCoreInfo documentInfo) throws IOException {
        Map originalParameters = IOUtil.readMap(coreStream);
        documentInfo.parameters = this.convertToCompatibleParameter(originalParameters);
        documentInfo.globalVariables = (HashMap)IOUtil.readMap(coreStream);
        if (documentInfo.checkpoint == -1) {
            HashMap<String, Long> bookmarks = this.readMap(coreStream);
            documentInfo.tocReader = new TOCReader(coreStream, null);
            HashMap<String, Long> reportletsIndexById = this.readMap(coreStream);
            HashMap<String, Long> reportletsIndexByBookmark = this.readMap(coreStream);
            documentInfo.indexReader = new DocumentIndexReader(1, reportletsIndexByBookmark, reportletsIndexById, bookmarks);
        }
    }

    protected void loadCoreStreamBodyV2(DataInputStream coreStream, ReportDocumentCoreInfo documentInfo) throws IOException {
        this.loadCoreStreamBodyToBuffer(coreStream);
        if (documentInfo.checkpoint == -1) {
            documentInfo.indexReader = new DocumentIndexReader(2, this.archive);
        }
    }

    private void loadCoreStreamBodyToBuffer(DataInputStream stream) throws IOException {
        byte[] datas = new byte[1024];
        int length = -1;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        while ((length = stream.read(datas)) > 0) {
            byteOut.write(datas, 0, length);
        }
        this.bodyData = byteOut.toByteArray();
    }

    private HashMap<String, Long> readMap(DataInputStream di) throws IOException {
        HashMap<String, Long> map = new HashMap<String, Long>();
        long count = IOUtil.readLong(di);
        long i = 0L;
        while (i < count) {
            String bookmark = IOUtil.readString(di);
            long pageNumber = IOUtil.readLong(di);
            map.put(bookmark, pageNumber);
            ++i;
        }
        return map;
    }

    private HashMap convertToCompatibleParameter(Map parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : parameters.entrySet()) {
            Object[] values;
            Object key = entry.getKey();
            Object valueObj = entry.getValue();
            ParameterAttribute paramAttr = null;
            if (valueObj instanceof ParameterAttribute) {
                paramAttr = (ParameterAttribute)valueObj;
            } else if (valueObj instanceof Object[] && (values = (Object[])valueObj).length == 2) {
                Object value = values[0];
                if (values[1] == null || values[1] instanceof String) {
                    paramAttr = new ParameterAttribute(value, (String)values[1]);
                } else if (values[1] instanceof String[]) {
                    paramAttr = new ParameterAttribute((Object[])value, (String[])values[1]);
                }
            }
            if (paramAttr == null) {
                paramAttr = new ParameterAttribute(valueObj, null);
            }
            result.put(key, paramAttr);
        }
        return result;
    }

    protected void checkVersion(DataInputStream di) throws IOException {
        String tag = IOUtil.readString(di);
        if (!"reportdocument".equals(tag)) {
            throw new IOException("unknown report document tag" + tag);
        }
        String docVersion = IOUtil.readString(di);
        if (docVersion == null) {
            throw new IOException("invalid core stream format");
        }
        if (!docVersion.startsWith("CORE_VERSION_")) {
            this.coreVersion = "CORE_VERSION_UNKNOWN";
        } else if ("CORE_VERSION_0".equals(docVersion) || "CORE_VERSION_1".equals(docVersion) || "CORE_VERSION_2".equals(docVersion)) {
            this.coreVersion = docVersion;
            docVersion = IOUtil.readString(di);
            if ("CORE_VERSION_1".equals(this.coreVersion) || "CORE_VERSION_2".equals(this.coreVersion)) {
                this.properties = IOUtil.readMap(di);
            }
        } else {
            throw new IOException("unknown core stream version" + tag);
        }
        String[] supportedVersions = new String[]{"1.0.0", "2.1.0", "2.1.3-2.2RC0"};
        boolean supportedVersion = false;
        int i = 0;
        while (i < supportedVersions.length) {
            if (supportedVersions[i].equals(docVersion)) {
                supportedVersion = true;
                break;
            }
            ++i;
        }
        if (!supportedVersion) {
            throw new IOException("unsupport report document version " + docVersion);
        }
        String extensions = (String)this.properties.get("BIRT_ENGINE_EXTENSIONS");
        if (extensions != null && extensions.length() > 0) {
            String[] extIds;
            String[] stringArray = extIds = extensions.split(";");
            int n = extIds.length;
            int n2 = 0;
            while (n2 < n) {
                String extId = stringArray[n2];
                IReportEngineExtension ext = this.engine.getEngineExtension(extId);
                if (ext == null) {
                    throw new IOException("unsupported report extension:" + extId);
                }
                ++n2;
            }
        }
        if (this.properties.get("BIRT ENGINE VERSION") == null) {
            if ("1.0.0".equals(docVersion)) {
                this.properties.put("BIRT ENGINE VERSION", "2.0.0");
            } else if ("2.1.0".equals(docVersion)) {
                this.properties.put("BIRT ENGINE VERSION", "2.1.0");
            } else if ("2.1.3-2.2RC0".equals(docVersion)) {
                this.properties.put("BIRT ENGINE VERSION", "2.1.3");
            }
        }
        String version = this.getVersion();
        if (this.properties.get("extraction") == null) {
            if ("2.0.0".equals(docVersion) || "2.1.0".equals(version)) {
                this.properties.put("extraction", "0");
            } else {
                this.properties.put("extraction", "1");
            }
        }
        if (this.properties.get("page hint version") == null) {
            this.properties.put("page hint version", "2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.tocReader != null) {
            try {
                this.tocReader.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to close the tocReader", ex);
            }
            this.tocReader = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to close the index reader", ex);
            }
            this.indexReader = null;
        }
        if (this.pageHintReader != null) {
            this.pageHintReader.close();
            this.pageHintReader = null;
        }
        if (this.archive != null) {
            if (!this.sharedArchive) {
                try {
                    this.archive.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to close the archive", ex);
                }
            }
            this.archive = null;
        }
        if (this.extensions != null) {
            for (Map.Entry<String, IReportDocumentExtension> entry : this.extensions.entrySet()) {
                String name = entry.getKey();
                IReportDocumentExtension extension = entry.getValue();
                if (extension == null) continue;
                try {
                    extension.close();
                }
                catch (EngineException ex) {
                    logger.log(Level.SEVERE, "Failed to close the extension " + name, ex);
                }
            }
            this.extensions.clear();
            this.extensions = null;
        }
        if (this.applicationClassLoader != null) {
            this.applicationClassLoader.close();
        }
        if (this.engineCacheEntry != null) {
            LinkedObjectManager<ReportDocumentReader> manager = this.engineCacheEntry.getManager();
            LinkedObjectManager<ReportDocumentReader> linkedObjectManager = manager;
            synchronized (linkedObjectManager) {
                manager.remove(this.engineCacheEntry);
            }
        }
        this.bodyData = null;
        this.engine = null;
        this.cachedTreeV0 = null;
        if (this.globalVariables != null) {
            this.globalVariables.clear();
            this.globalVariables = null;
        }
        if (this.moduleOptions != null) {
            this.moduleOptions.clear();
            this.moduleOptions = null;
        }
        this.preparedRunnable = null;
        this.reportRunnable = null;
        if (this.parameters != null) {
            this.parameters.clear();
            this.parameters = null;
        }
    }

    @Override
    public InputStream getDesignStream() {
        try {
            if (this.archive.exists("/original_design")) {
                return this.archive.getStream("/original_design");
            }
            return this.archive.getStream("/design");
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to open the design!", ex);
            return null;
        }
    }

    private ReportRunnable loadReportRunnable(String systemId, String streamName) {
        try {
            if (this.archive.exists(streamName)) {
                RAInputStream stream = this.archive.getStream(streamName);
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    try {
                        ReportRunnable reportRunnable;
                        String name = systemId;
                        if (name == null) {
                            name = this.archive.getName();
                        }
                        return reportRunnable = (ReportRunnable)this.engine.openReportDesign(name, (InputStream)stream, this.moduleOptions);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to open the design!", ex);
        }
        return null;
    }

    @Override
    public synchronized IReportRunnable getReportRunnable() {
        if (this.reportRunnable == null) {
            this.reportRunnable = this.loadReportRunnable(this.systemId, "/original_design");
            if (this.reportRunnable != null) {
                this.reportRunnable.setPrepared(false);
            } else {
                this.reportRunnable = this.getOnPreparedRunnable();
            }
        }
        if (this.reportRunnable != null) {
            return this.reportRunnable.cloneRunnable();
        }
        return null;
    }

    @Override
    public synchronized IReportRunnable getPreparedRunnable() {
        ReportRunnable runnable = this.getOnPreparedRunnable();
        if (runnable != null) {
            return runnable.cloneRunnable();
        }
        return null;
    }

    @Override
    public synchronized IReportRunnable getDocumentRunnable() {
        return this.getOnPreparedRunnable();
    }

    @Override
    public ReportRunnable getOnPreparedRunnable() {
        if (this.preparedRunnable == null) {
            this.preparedRunnable = this.loadReportRunnable(this.systemId, "/design");
            if (this.preparedRunnable != null) {
                this.preparedRunnable.setPrepared(true);
            }
        }
        return this.preparedRunnable;
    }

    @Override
    @Deprecated
    public Map getParameterValues() {
        this.loadCoreStreamLazily();
        this.loadVariableLazily();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.parameters != null) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                String name = (String)entry.getKey();
                ParameterAttribute value = (ParameterAttribute)entry.getValue();
                result.put(name, value.getValue());
            }
        }
        return result;
    }

    public Map getParameterValues(ClassLoader loader) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Map<String, ParameterAttribute> parameters = this.loadParameters(loader);
            if (parameters != null) {
                for (Map.Entry<String, ParameterAttribute> entry : parameters.entrySet()) {
                    String name = entry.getKey();
                    ParameterAttribute value = entry.getValue();
                    result.put(name, value.getValue());
                }
            }
        }
        catch (EngineException ex) {
            logger.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        return result;
    }

    protected void loadVariableLazily() {
        if (this.globalVariables == null) {
            assert (this.bodyData != null);
            ClassLoader loader = this.getClassLoader();
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(this.bodyData));
            try {
                this.parameters = (HashMap)IOUtil.readMap(dataStream, loader);
                this.parameters = this.convertToCompatibleParameter(this.parameters);
                this.globalVariables = (HashMap)IOUtil.readMap(dataStream, loader);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to load parameters and variables in the core stream", ex);
            }
        }
    }

    @Override
    public Map<String, ParameterAttribute> loadParameters(ClassLoader loader) throws EngineException {
        this.loadCoreStreamLazily();
        if (this.bodyData == null) {
            return this.parameters;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(this.bodyData));
            Map parameters = IOUtil.readMap(dataStream, loader);
            return this.convertToCompatibleParameter(parameters);
        }
        catch (IOException ee) {
            throw new EngineException("Failed to load parameters in the core stream", ee);
        }
    }

    public Map loadVariables(ClassLoader loader) throws EngineException {
        this.loadCoreStreamLazily();
        if (this.bodyData == null) {
            return this.globalVariables;
        }
        try {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(this.bodyData));
            IOUtil.readMap(dataStream, loader);
            return IOUtil.readMap(dataStream, loader);
        }
        catch (IOException ee) {
            throw new EngineException("Failed to load variables in the core stream", ee);
        }
    }

    @Override
    public Map getParameterDisplayTexts() {
        this.loadCoreStreamLazily();
        this.loadVariableLazily();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.parameters != null) {
            for (Map.Entry entry : this.parameters.entrySet()) {
                String name = (String)entry.getKey();
                ParameterAttribute value = (ParameterAttribute)entry.getValue();
                result.put(name, value.getDisplayText());
            }
        }
        return result;
    }

    @Override
    public long getPageCount() {
        return this.pageCount;
    }

    public IPageHint getPageHint(long pageNumber) {
        this.initializePageHintReader();
        if (this.pageHintReader != null) {
            try {
                return this.pageHintReader.getPageHint(pageNumber);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Failed to load page hint " + pageNumber, ex);
            }
        }
        return null;
    }

    @Override
    public long getPageNumber(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getPageOfBookmark(bookmark);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to load the page number of bookmark:" + bookmark, ex);
            }
        }
        return -1L;
    }

    @Override
    public List<String> getBookmarks() {
        if (!this.isComplete()) {
            return null;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getBookmarks();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to load the bookmark list", ex);
            }
        }
        return null;
    }

    public List<BookmarkContent> getBookmarkContents() {
        if (!this.isComplete()) {
            return null;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getBookmarkContents();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to load the bookmark info list", ex);
            }
        }
        return null;
    }

    @Override
    public List<IBookmarkInfo> getBookmarkInfos(Locale locale) throws EngineException {
        if (!this.isComplete()) {
            return null;
        }
        ArrayList<IBookmarkInfo> results = new ArrayList<IBookmarkInfo>();
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            List<BookmarkContent> bookmarks;
            block8: {
                bookmarks = this.indexReader.getBookmarkContents();
                if (bookmarks != null) break block8;
                return null;
            }
            try {
                ReportDesignHandle report = this.getReportDesign();
                for (BookmarkContent bookmark : bookmarks) {
                    long designId;
                    DesignElementHandle handle;
                    String bookmarkString = bookmark.getBookmark();
                    if (bookmarkString.startsWith("__bookmark_") || bookmarkString.indexOf("__TOC_") != -1 || (handle = report.getElementByID(designId = bookmark.getElementId())) == null) continue;
                    String elementType = handle.getDefn().getName();
                    String displayName = null;
                    if (handle instanceof ReportItemHandle) {
                        displayName = ((ReportItemHandle)handle).getBookmarkDisplayName();
                    }
                    if (locale != null && handle instanceof ReportElementHandle) {
                        ReportElementHandle elementHandle = (ReportElementHandle)handle;
                        displayName = ModuleUtil.getExternalizedValue(elementHandle, bookmarkString, displayName, ULocale.forLocale((Locale)locale));
                    }
                    results.add(new BookmarkInfo(bookmarkString, displayName, elementType));
                }
            }
            catch (IOException ex) {
                throw new EngineException("Error.ExceptionOnFetchingBookmarks", ex);
            }
        }
        return results;
    }

    public long getBookmark(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getOffsetOfBookmark(bookmark);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to load the offset of bookmark:" + bookmark, ex);
            }
        }
        return -1L;
    }

    @Override
    @Deprecated
    public ITOCTree getTOCTree(String format, ULocale locale) {
        return this.getTOCTree(format, locale, TimeZone.getDefault());
    }

    @Override
    @Deprecated
    public ITOCTree getTOCTree(String format, ULocale locale, TimeZone timeZone) {
        try {
            ITreeNode root = this.getTOCTree();
            if (root != null) {
                ReportDesignHandle report = this.getOnPreparedRunnable().getReport();
                return new TOCView(root, report, locale, timeZone, format);
            }
        }
        catch (EngineException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    @Override
    @Deprecated
    public TOCNode findTOC(String tocNodeId) {
        ITOCTree tree = this.getTOCTree("viewer", ULocale.getDefault());
        if (tree != null) {
            return tree.findTOC(tocNodeId);
        }
        return null;
    }

    @Override
    @Deprecated
    public List findTOCByName(String tocName) {
        ITOCTree tree = this.getTOCTree("viewer", ULocale.getDefault());
        if (tree != null) {
            return tree.findTOCByValue(tocName);
        }
        return null;
    }

    @Override
    @Deprecated
    public List getChildren(String tocNodeId) {
        TOCNode node = this.findTOC(tocNodeId);
        if (node != null) {
            return node.getChildren();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePageHintReader() {
        if (this.pageHintReader != null) {
            return;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.pageHintReader != null) {
                return;
            }
            try {
                this.pageHintReader = new PageHintReader(this);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "can not open the page hint stream", ex);
            }
        }
    }

    @Override
    public String getName() {
        return this.archive.getName();
    }

    @Override
    @Deprecated
    public Map getGlobalVariables(String option) {
        this.loadCoreStreamLazily();
        this.loadVariableLazily();
        return this.globalVariables;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getPageNumber(InstanceID iid) {
        if (!this.isComplete()) {
            return -1L;
        }
        this.initializePageHintReader();
        if (this.pageHintReader == null) {
            return -1L;
        }
        int version = this.pageHintReader.getVersion();
        try {
            if (version == 0) {
                long offset = this.getInstanceOffset(iid);
                if (offset == -1L) {
                    return -1L;
                }
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    PageSection section = hint.getSection(0);
                    if (offset >= section.startOffset) {
                        return pageNumber;
                    }
                    ++pageNumber;
                }
            } else if (version == 1) {
                long offset = this.getInstanceOffset(iid);
                if (offset == -1L) {
                    return -1L;
                }
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    int sectionCount = hint.getSectionCount();
                    int i = 0;
                    while (i < sectionCount) {
                        PageSection section = hint.getSection(i);
                        if (section.startOffset <= offset && offset <= section.endOffset) {
                            return pageNumber;
                        }
                        ++i;
                    }
                    ++pageNumber;
                }
            } else if (version == 2 || version == 3 || version == 4 || version == 5 || version == 6) {
                long totalPage = this.pageHintReader.getTotalPage();
                long pageNumber = 1L;
                while (pageNumber <= totalPage) {
                    IPageHint hint = this.pageHintReader.getPageHint(pageNumber);
                    int sectionCount = hint.getSectionCount();
                    Fragment fragment = new Fragment(new InstanceIDComparator());
                    int i = 0;
                    while (i < sectionCount) {
                        PageSection section = hint.getSection(i);
                        fragment.addSection(section.starts, section.ends);
                        ++i;
                    }
                    fragment.build();
                    if (fragment.inFragment(iid)) {
                        return pageNumber;
                    }
                    ++pageNumber;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public long getInstanceOffset(InstanceID iid) {
        if (!this.isComplete() || iid == null) {
            return -1L;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                long offset = this.indexReader.getOffsetOfInstance(iid.toUniqueString());
                if (offset == -1L) {
                    offset = this.indexReader.getOffsetOfInstance(iid.toString());
                }
                return offset;
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to get the offset of instance:" + iid.toUniqueString(), ex);
            }
        }
        return -1L;
    }

    @Override
    public long getBookmarkOffset(String bookmark) {
        if (!this.isComplete()) {
            return -1L;
        }
        if (bookmark == null) {
            return -1L;
        }
        this.loadCoreStreamLazily();
        if (this.indexReader != null) {
            try {
                return this.indexReader.getOffsetOfBookmark(bookmark);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "failed to get the offset of bookmark:" + bookmark, ex);
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ClassLoader getClassLoader() {
        if (this.applicationClassLoader != null) {
            return this.applicationClassLoader;
        }
        ReportDocumentReader reportDocumentReader = this;
        synchronized (reportDocumentReader) {
            if (this.applicationClassLoader == null) {
                this.applicationClassLoader = new ApplicationClassLoader(this.engine, this.getOnPreparedRunnable(), this.engine.getConfig().getAppContext());
            }
        }
        return this.applicationClassLoader;
    }

    @Override
    public boolean isComplete() {
        return this.checkpoint == -1;
    }

    @Override
    public ReportDesignHandle getReportDesign() {
        IReportRunnable reportRunnable = this.getReportRunnable();
        if (reportRunnable != null) {
            return (ReportDesignHandle)reportRunnable.getDesignHandle();
        }
        return null;
    }

    @Override
    public Report getReportIR(ReportDesignHandle designHandle) {
        RAInputStream stream = null;
        try {
            stream = this.archive.getStream("/design.ir");
            EngineIRReader reader = new EngineIRReader();
            Report reportIR = reader.read(stream);
            reportIR.setVersion(this.getVersion());
            reader.link(reportIR, designHandle);
            Report report = reportIR;
            return report;
        }
        catch (IOException ioex) {
            logger.log(Level.FINE, "Failed to load the engine IR", ioex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                stream = null;
            }
        }
        return null;
    }

    private InstanceID loadInstanceID(ReportContentReaderV3 reader, long offset) throws IOException {
        IContent content = reader.readContent(offset);
        if (content != null) {
            InstanceID pid;
            InstanceID iid = content.getInstanceID();
            DocumentExtension ext = (DocumentExtension)content.getExtension(0);
            long parentOffset = ext.getParent();
            if (parentOffset != -1L && (pid = this.loadInstanceID(reader, parentOffset)) != null) {
                return new InstanceID(pid, iid);
            }
            return iid;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public InstanceID getBookmarkInstance(String bookmark) {
        if (bookmark == null || bookmark.length() == 0) {
            return null;
        }
        long offset = this.getBookmarkOffset(bookmark);
        if (offset < 0L) {
            return null;
        }
        try {
            RAInputStream is = this.archive.getStream("/content/content.dat");
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                try {
                    ReportContentReaderV3 reader = new ReportContentReaderV3(new ReportContent(), is, this.applicationClassLoader);
                    try {
                        InstanceID instanceID = this.loadInstanceID(reader, offset);
                        reader.close();
                        return instanceID;
                    }
                    catch (Throwable throwable2) {
                        reader.close();
                        throw throwable2;
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Failed to get the instance ID of the bookmark: " + bookmark, ioe);
            return null;
        }
    }

    @Override
    public boolean isReporltetDocument() throws IOException {
        return this.loadReportletStream();
    }

    @Override
    public String getReportletBookmark() throws IOException {
        if (this.loadReportletStream()) {
            return this.reportletBookmark;
        }
        return null;
    }

    @Override
    public InstanceID getReportletInstanceID() throws IOException {
        if (this.loadReportletStream()) {
            return InstanceID.parse(this.reportletInstanceID);
        }
        return null;
    }

    private boolean loadReportletStream() throws IOException {
        block12: {
            if (this.isReportlet == null) {
                if (this.archive.exists("/reportletDocument")) {
                    RAInputStream in = this.archive.getInputStream("/reportletDocument");
                    Throwable throwable = null;
                    Object var3_4 = null;
                    try {
                        try {
                            int version = in.readInt();
                            if (version != 0) {
                                throw new IOException("unsupported reportlet document " + version);
                            }
                            int size = in.readInt();
                            byte[] bytes = new byte[size];
                            in.readFully(bytes, 0, size);
                            DataInputStream s = new DataInputStream(new ByteArrayInputStream(bytes));
                            this.reportletBookmark = IOUtil.readString(s);
                            this.reportletInstanceID = IOUtil.readString(s);
                            this.isReportlet = Boolean.TRUE;
                            break block12;
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.isReportlet = Boolean.FALSE;
            }
        }
        return this.isReportlet;
    }

    @Override
    public synchronized IReportDocumentExtension getDocumentExtension(String name) throws EngineException {
        IReportEngineExtension engineExtension;
        IReportDocumentExtension extension = this.extensions.get(name);
        if (extension == null && (engineExtension = this.engine.getEngineExtension(name)) != null) {
            extension = engineExtension.createDocumentExtension(this);
            this.extensions.put(name, extension);
        }
        return extension;
    }

    @Deprecated
    public synchronized ITreeNode getTOCTree() throws EngineException {
        if (!this.isComplete()) {
            return null;
        }
        this.loadCoreStreamLazily();
        try {
            if (this.tocReader == null) {
                this.tocReader = new TOCReader(this.archive, this.getClassLoader());
            }
            return this.tocReader.readTree();
        }
        catch (IOException ex) {
            throw new EngineException("Error.FailedToLoadTOCTree", ex);
        }
    }

    @Override
    public ITOCReader getTOCReader(ClassLoader loader) throws EngineException {
        this.loadCoreStreamLazily();
        if (this.cachedTreeV0 != null) {
            return new TOCReaderV0(this.cachedTreeV0);
        }
        try {
            return new TOCReader(this.archive, loader);
        }
        catch (IOException ex) {
            throw new EngineException("Error.FailedToLoadTOCTree", ex);
        }
    }

    public void setEngineCacheEntry(LinkedObjectManager.LinkedEntry<ReportDocumentReader> entry) {
        this.engineCacheEntry = entry;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public List<String> getDocumentErrors() {
        try (RunStatusReader statusReader = new RunStatusReader(this);){
            List<String> list = statusReader.getGenerationErrors();
            return list;
        }
    }

    public static class ReportDocumentCoreInfo {
        public int checkpoint;
        public long pageCount;
        public String systemId;
        public HashMap globalVariables;
        public HashMap parameters;
        public ITOCReader tocReader;
        public IDocumentIndexReader indexReader;
    }
}

