/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.ICascadingParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.engine.api.impl.CascadingParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.DynamicFilterParameterDefn;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ParameterDefnBase;
import org.eclipse.birt.report.engine.api.impl.ParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.ParameterHelper;
import org.eclipse.birt.report.engine.api.impl.ParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;
import org.eclipse.birt.report.engine.api.impl.SelectionChoiceComparator;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.util.ExpressionUtil;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.filterExtension.OdaFilterExprHelper;
import org.eclipse.birt.report.model.api.filterExtension.interfaces.IFilterExprDefinition;

public class GetParameterDefinitionTask
extends EngineTask
implements IGetParameterDefinitionTask {
    protected Collection parameterDefns = null;
    protected static Logger log = Logger.getLogger(GetParameterDefinitionTask.class.getName());
    protected boolean jsLoaded = false;

    public GetParameterDefinitionTask(ReportEngine engine, ReportRunnable runnable) {
        super(engine, runnable, 0);
    }

    @Override
    public Collection getParameterDefns(boolean includeParameterGroups) {
        ModuleHandle designHandle = this.executionContext.getDesign();
        ArrayList original = this.getParameters(designHandle, includeParameterGroups);
        Iterator iter = original.iterator();
        this.parameterDefns = new ArrayList();
        while (iter.hasNext()) {
            ParameterDefnBase pBase = (ParameterDefnBase)iter.next();
            try {
                this.parameterDefns.add(pBase.clone());
            }
            catch (CloneNotSupportedException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.parameterDefns != null) {
            Locale locale = this.ulocale.toLocale();
            for (IParameterDefnBase pBase : this.parameterDefns) {
                if (pBase instanceof ScalarParameterDefn) {
                    ((ScalarParameterDefn)pBase).setDesign(designHandle);
                    ((ScalarParameterDefn)pBase).setLocale(locale);
                    ((ScalarParameterDefn)pBase).evaluateSelectionList();
                    continue;
                }
                if (pBase instanceof DynamicFilterParameterDefn) {
                    ((DynamicFilterParameterDefn)pBase).setDesign(designHandle);
                    ((DynamicFilterParameterDefn)pBase).setLocale(locale);
                    continue;
                }
                if (!(pBase instanceof ParameterGroupDefn)) continue;
                ((ParameterGroupDefn)pBase).setDesign(designHandle);
                for (IParameterDefnBase p : ((ParameterGroupDefn)pBase).getContents()) {
                    if (p instanceof ScalarParameterDefn) {
                        ((ScalarParameterDefn)p).setDesign(designHandle);
                        ((ScalarParameterDefn)p).setLocale(locale);
                        ((ScalarParameterDefn)p).evaluateSelectionList();
                        continue;
                    }
                    if (!(p instanceof DynamicFilterParameterDefn)) continue;
                    ((DynamicFilterParameterDefn)p).setDesign(designHandle);
                    ((DynamicFilterParameterDefn)p).setLocale(locale);
                }
            }
        }
        return this.parameterDefns;
    }

    @Override
    public void evaluateDefaults() throws EngineException {
    }

    @Override
    public IParameterDefnBase getParameterDefn(String name) {
        IParameterDefnBase ret = null;
        if (name == null) {
            return ret;
        }
        ModuleHandle designHandle = this.executionContext.getDesign();
        ArrayList original = this.getParameters(designHandle, true);
        Iterator iter = original.iterator();
        while (iter.hasNext()) {
            ret = this.getParamDefnBaseByName((ParameterDefnBase)iter.next(), name);
            if (ret != null) break;
        }
        if (ret != null) {
            Locale locale = this.ulocale.toLocale();
            if (ret instanceof ScalarParameterDefn) {
                ((ScalarParameterDefn)ret).setDesign(designHandle);
                ((ScalarParameterDefn)ret).setLocale(locale);
                ((ScalarParameterDefn)ret).evaluateSelectionList();
            } else if (ret instanceof DynamicFilterParameterDefn) {
                ((DynamicFilterParameterDefn)ret).setDesign(designHandle);
                ((DynamicFilterParameterDefn)ret).setLocale(locale);
            } else if (ret instanceof ParameterGroupDefn) {
                ((ParameterGroupDefn)ret).setDesign(designHandle);
                ((ParameterGroupDefn)ret).setLocale(locale);
                for (IParameterDefnBase p : ((ParameterGroupDefn)ret).getContents()) {
                    if (p instanceof ScalarParameterDefn) {
                        ((ScalarParameterDefn)p).setDesign(designHandle);
                        ((ScalarParameterDefn)p).setLocale(locale);
                        ((ScalarParameterDefn)p).evaluateSelectionList();
                        continue;
                    }
                    if (!(p instanceof DynamicFilterParameterDefn)) continue;
                    ((DynamicFilterParameterDefn)p).setDesign(designHandle);
                    ((DynamicFilterParameterDefn)p).setLocale(locale);
                }
            }
        }
        return ret;
    }

    @Override
    public SlotHandle getParameters() {
        ModuleHandle design = this.executionContext.getDesign();
        return design.getParameters();
    }

    @Override
    public ParameterHandle getParameter(String name) {
        ModuleHandle design = this.executionContext.getDesign();
        return design.findParameter(name);
    }

    @Override
    public HashMap getDefaultValues() {
        this.loadDesign();
        this.usingParameterValues();
        final HashMap values = new HashMap();
        new EngineTask.ParameterVisitor(){

            @Override
            boolean visitScalarParameter(ScalarParameterHandle param, Object userData) {
                String name = param.getName();
                Object value = GetParameterDefinitionTask.this.getDefaultValue(name);
                values.put(name, value);
                return true;
            }

            @Override
            boolean visitDynamicFilterParameter(DynamicFilterParameterHandle param, Object userData) {
                return true;
            }

            @Override
            boolean visitParameterGroup(ParameterGroupHandle group, Object userData) {
                return this.visitParametersInGroup(group, userData);
            }
        }.visit(this.executionContext.getDesign(), this.executionContext);
        return values;
    }

    @Override
    public Object getDefaultValue(IParameterDefnBase param) {
        return param == null ? null : this.getDefaultValue(param.getName());
    }

    @Override
    protected void loadDesign() {
        if (!this.jsLoaded) {
            ReportDesignHandle reportDesign;
            this.jsLoaded = true;
            ReportRunnable runnable = this.executionContext.getRunnable();
            if (runnable != null && (reportDesign = this.executionContext.getReportDesign()) != null) {
                Iterator iter = reportDesign.includeLibraryScriptsIterator();
                this.loadScript(iter);
                iter = reportDesign.includeScriptsIterator();
                this.loadScript(iter);
            }
        }
    }

    @Override
    public Object getDefaultValue(String name) {
        ModuleHandle report = this.executionContext.getDesign();
        AbstractScalarParameterHandle parameter = (AbstractScalarParameterHandle)report.findParameter(name);
        if (parameter == null) {
            return null;
        }
        this.loadDesign();
        this.usingParameterValues();
        return this.evaluateDefaultValue(parameter);
    }

    @Override
    protected Object refineParameterValue(String name, Object value) {
        ModuleHandle report = this.executionContext.getDesign();
        AbstractScalarParameterHandle param = (AbstractScalarParameterHandle)report.findParameter(name);
        if (!(param instanceof DynamicFilterParameterHandle)) {
            return value;
        }
        return this.convertToType(value, param.getDataType());
    }

    Collection evaluateSelectionValue(ScalarParameterHandle parameter) {
        String dataType = parameter.getDataType();
        boolean fixedOrder = parameter.isFixedOrder();
        boolean sortByLabel = "label".equalsIgnoreCase(parameter.getSortBy());
        String sortDirection = parameter.getSortDirection();
        String selectionMethod = parameter.getSelectionValueListMethod();
        if (selectionMethod != null) {
            Object result;
            block12: {
                result = this.executionContext.evaluate(selectionMethod);
                if (result != null) break block12;
                return null;
            }
            try {
                ArrayList<SelectionChoice> choices = new ArrayList<SelectionChoice>();
                String pattern = parameter.getPattern();
                ReportParameterConverter converter = null;
                if (pattern != null) {
                    converter = new ReportParameterConverter(pattern, this.ulocale, this.timeZone);
                }
                if (result instanceof Collection) {
                    Iterator iter = ((Collection)result).iterator();
                    while (iter.hasNext()) {
                        Object value = this.convertToType(iter.next(), dataType);
                        String label = converter != null ? converter.format(value) : null;
                        choices.add(new SelectionChoice(label, value));
                    }
                } else if (result.getClass().isArray()) {
                    int count = Array.getLength(result);
                    int index = 0;
                    while (index < count) {
                        Object origValue = Array.get(result, index);
                        Object value = this.convertToType(origValue, dataType);
                        String label = converter != null ? converter.format(value) : null;
                        choices.add(new SelectionChoice(label, value));
                        ++index;
                    }
                } else {
                    Object value = this.convertToType(result, dataType);
                    String label = converter != null ? converter.format(value) : null;
                    choices.add(new SelectionChoice(label, value));
                    return choices;
                }
                if (!fixedOrder && sortDirection != null) {
                    boolean sortDirectionValue = "asc".equals(sortDirection);
                    Collections.sort(choices, new SelectionChoiceComparator(sortByLabel, pattern, sortDirectionValue, this.ulocale));
                }
                return choices;
            }
            catch (BirtException e) {
                log.log(Level.FINE, e.getLocalizedMessage(), e);
                this.executionContext.addException(e);
            }
        }
        return null;
    }

    @Override
    public Collection getSelectionList(String name) {
        try {
            this.switchToOsgiClassLoader();
            this.loadDesign();
            Collection collection = this.doGetSelectionList(name);
            return collection;
        }
        finally {
            this.switchClassLoaderBack();
        }
    }

    private Collection doGetSelectionList(String name) {
        this.usingParameterValues();
        ModuleHandle design = this.executionContext.getDesign();
        AbstractScalarParameterHandle parameter = (AbstractScalarParameterHandle)design.findParameter(name);
        if (parameter == null) {
            this.executionContext.addException(new EngineException("Error.ParameterIsNotFoundByName", name));
            return Collections.EMPTY_LIST;
        }
        String selectionType = parameter.getValueType();
        String dataType = parameter.getDataType();
        if ("dynamic".equals(selectionType)) {
            CascadingParameterGroupHandle group = null;
            if (this.isCascadingParameter(parameter)) {
                group = this.getCascadingGroup(parameter);
            }
            if (!(parameter instanceof DynamicFilterParameterHandle) && group != null) {
                if ("single".equals(group.getDataSetMode())) {
                    return this.getCascadingParameterList(parameter);
                }
                if (parameter.getDataSetName() != null) {
                    return this.getChoicesFromParameterQuery(parameter);
                }
            } else {
                ScalarParameterHandle sparam;
                if (parameter instanceof ScalarParameterHandle && (sparam = (ScalarParameterHandle)parameter).getSelectionValueListMethod() != null) {
                    return this.evaluateSelectionValue(sparam);
                }
                if (parameter.getDataSet() != null) {
                    return this.getChoicesFromParameterQuery(parameter);
                }
            }
        } else if ("static".equals(selectionType)) {
            ScalarParameterHandle sparam;
            if (parameter instanceof ScalarParameterHandle && (sparam = (ScalarParameterHandle)parameter).getSelectionValueListMethod() != null) {
                return this.evaluateSelectionValue(sparam);
            }
            Iterator<?> iter = parameter.choiceIterator();
            ArrayList<SelectionChoice> choices = new ArrayList<SelectionChoice>();
            String pattern = null;
            boolean isFixedOrder = false;
            if (parameter instanceof ScalarParameterHandle) {
                ScalarParameterHandle tmpParam = (ScalarParameterHandle)parameter;
                pattern = tmpParam.getPattern();
                isFixedOrder = tmpParam.isFixedOrder();
            }
            ReportParameterConverter converter = new ReportParameterConverter(pattern, this.ulocale, this.timeZone);
            while (iter.hasNext()) {
                SelectionChoiceHandle choice = (SelectionChoiceHandle)iter.next();
                String label = choice.getExternalizedValue("labelID", "label", this.ulocale);
                if (label == null) {
                    label = choice.getLabel();
                }
                Object value = this.convertToType(choice.getValue(), dataType);
                if (label == null && pattern != null) {
                    label = converter.format(value);
                }
                choices.add(new SelectionChoice(label, value));
            }
            String sortBy = parameter.getSortBy();
            boolean sortByLabel = "label".equalsIgnoreCase(parameter.getSortBy());
            String sortDirection = parameter.getSortDirection();
            if (!isFixedOrder && sortBy != null && sortDirection != null) {
                boolean sortDirectionValue = "asc".equalsIgnoreCase(sortDirection);
                Collections.sort(choices, new SelectionChoiceComparator(sortByLabel, pattern, sortDirectionValue, this.ulocale));
            }
            return choices;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection getCascadingParameterList(AbstractScalarParameterHandle parameter) {
        Object[] parameterValuesAhead = this.getParameterValuesAhead(parameter);
        return this.getChoicesFromParameterGroup(parameter, parameterValuesAhead);
    }

    private Collection populateToList(IResultIterator iterator, AbstractScalarParameterHandle parameter, SelectionFilter filter) {
        ParameterHelper parameterHelper = new ParameterHelper(parameter, this.ulocale, this.timeZone);
        Collection choices = parameterHelper.createSelectionCollection();
        int limit = parameter.getListlimit();
        try {
            while (iterator.next() && (limit <= 0 || choices.size() < limit)) {
                if (filter != null && !filter.accept(iterator)) continue;
                String label = parameterHelper.getLabel(iterator);
                Object value = parameterHelper.getValue(iterator);
                choices.add(new SelectionChoice(label, value));
            }
        }
        catch (BirtException ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
            this.executionContext.addException(parameter, ex);
        }
        return choices;
    }

    private DataRequestSession createDataSession(DataSetHandle dataSet) throws BirtException {
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        DataRequestSession dteSession = this.getDataSession();
        dteSession.getDataSessionContext().getDataEngineContext().setFlowMode(DataEngineContext.DataEngineFlowMode.PARAM_EVALUATION_FLOW);
        dataEngine.defineDataSet(dataSet);
        return dteSession;
    }

    private QueryDefinition createQueryDefinition(DataSetHandle dataSet) throws EngineException {
        QueryDefinition queryDefn = new QueryDefinition();
        queryDefn.setDataSetName(dataSet.getQualifiedName());
        return queryDefn;
    }

    private IResultIterator executeQuery(DataRequestSession dteSession, QueryDefinition queryDefn) throws BirtException {
        IPreparedQuery query = dteSession.prepare(queryDefn);
        IQueryResults result = (IQueryResults)dteSession.execute((IBasePreparedQuery)query, null, this.executionContext.getScriptContext());
        return result.getResultIterator();
    }

    @Override
    public void evaluateQuery(String parameterGroupName) {
    }

    @Override
    public Collection getSelectionListForCascadingGroup(String parameterGroupName, Object[] groupKeyValues) {
        this.loadDesign();
        CascadingParameterGroupHandle parameterGroup = this.getCascadingParameterGroup(parameterGroupName);
        if (parameterGroup == null) {
            this.executionContext.addException(new EngineException("Error.ParameterGroupIsNotFoundByGroupname", parameterGroupName));
            return Collections.EMPTY_LIST;
        }
        SlotHandle slotHandle = parameterGroup.getParameters();
        if (groupKeyValues.length >= slotHandle.getCount()) {
            this.executionContext.addException(new EngineException("Error.ParameterInvalidGroupLevel", parameterGroupName));
            return Collections.EMPTY_LIST;
        }
        ScalarParameterHandle requestedParam = (ScalarParameterHandle)slotHandle.get(groupKeyValues.length);
        if (requestedParam == null) {
            this.executionContext.addException(new EngineException("Error.ParameterInGroupIsnotScalar", parameterGroupName));
            return Collections.EMPTY_LIST;
        }
        Collection res = null;
        ValuePopper popper = new ValuePopper(groupKeyValues);
        while (popper.hasNext()) {
            Object[] paramValues = popper.next();
            int i = 0;
            while (i < paramValues.length) {
                String paramName = ((ScalarParameterHandle)slotHandle.get(i)).getName();
                this.setParameterValue(paramName, paramValues[i]);
                ++i;
            }
            Collection tmp = this.getSelectionList(requestedParam.getName());
            if (res == null) {
                res = tmp;
                continue;
            }
            res.addAll(tmp);
        }
        return res;
    }

    @Override
    public Collection getSelectionTreeForCascadingGroup(String parameterGroupName) {
        try {
            this.switchToOsgiClassLoader();
            this.loadDesign();
            Collection collection = this.doGetSelectionTreeForCascadingGroup(parameterGroupName);
            return collection;
        }
        finally {
            this.switchClassLoaderBack();
        }
    }

    private Collection doGetSelectionTreeForCascadingGroup(String parameterGroupName) {
        CascadingParameterGroupHandle parameterGroup = this.getCascadingParameterGroup(parameterGroupName);
        if (parameterGroup == null) {
            this.executionContext.addException(new EngineException("Error.ParameterGroupIsNotFoundByGroupname", parameterGroupName));
            return Collections.EMPTY_LIST;
        }
        SlotHandle parameters = parameterGroup.getParameters();
        int parameterCount = parameters.getCount();
        if ("single".equals(parameterGroup.getDataSetMode())) {
            IResultIterator resultIterator = this.getResultSetOfCascadingGroup(parameterGroup);
            if (resultIterator == null) {
                return Collections.EMPTY_LIST;
            }
            Collection selectionTree = this.populateToSelectionTree(resultIterator, parameterGroup);
            this.close(resultIterator);
            return selectionTree;
        }
        ParameterHelper[] parameterHelpers = this.getParameterHelpers(parameterGroup);
        ChoiceListCache cache = new ChoiceListCache(parameterHelpers);
        assert (parameterCount > 0);
        return this.getSelectionTree(parameters, parameterHelpers, cache, new Object[0]);
    }

    private Collection getSelectionTree(SlotHandle parameters, ParameterHelper[] parameterHelpers, ChoiceListCache cache, Object[] parameterValueAhead) {
        int parameterIndex = parameterValueAhead.length;
        int parameterCount = parameters.getCount();
        ScalarParameterHandle parameter = (ScalarParameterHandle)parameters.get(parameterIndex);
        Collection choices = this.getChoicesFromParameterQuery(parameter);
        Iterator iterator = choices.iterator();
        Collection result = null;
        while (iterator.hasNext()) {
            Object value;
            Object[] values = new Object[parameterIndex + 1];
            int i = 0;
            while (i < parameterValueAhead.length) {
                values[i] = parameterValueAhead[i];
                ++i;
            }
            IParameterSelectionChoice choice = (IParameterSelectionChoice)iterator.next();
            values[parameterIndex] = value = choice.getValue();
            Collection children = null;
            if (parameterIndex == parameterCount - 1) {
                children = Collections.EMPTY_LIST;
            } else if (cache.containsChildren(values, parameterIndex)) {
                children = cache.getChildren(values, parameterIndex);
            } else {
                this.executionContext.setParameter(parameter.getName(), value, choice.getLabel());
                children = this.getSelectionTree(parameters, parameterHelpers, cache, values);
            }
            result = cache.getParent(values, parameterIndex);
            CascadingParameterSelectionChoice groupChoice = parameterHelpers[parameterIndex].createCascadingParameterSelectionChoice(choice);
            result.add(groupChoice);
            groupChoice.setChildren(children);
        }
        return result;
    }

    private void close(IResultIterator resultIterator) {
        try {
            resultIterator.close();
        }
        catch (BirtException e) {
            log.log(Level.WARNING, "close results");
        }
    }

    private Collection populateToSelectionTree(IResultIterator iterator, CascadingParameterGroupHandle parameterGroup) {
        assert (iterator != null);
        ParameterHelper[] parameterHelpers = this.getParameterHelpers(parameterGroup);
        ChoiceListCache cache = new ChoiceListCache(parameterHelpers);
        int parameterCount = parameterHelpers.length;
        try {
            while (iterator.next()) {
                Object[] values = new Object[parameterCount];
                int i = 0;
                while (i < parameterCount) {
                    ParameterHelper parameterHelper = parameterHelpers[i];
                    CascadingParameterSelectionChoice choice = parameterHelper.createCascadingParameterSelectionChoice(iterator);
                    values[i] = choice.getValue();
                    cache.getParent(values, i).add(choice);
                    choice.setChildren(cache.getChildren(values, i));
                    ++i;
                }
            }
        }
        catch (BirtException ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
            this.executionContext.addException(parameterGroup, ex);
        }
        return cache.getRoot();
    }

    private ParameterHelper[] getParameterHelpers(CascadingParameterGroupHandle parameterGroup) {
        SlotHandle parameters = parameterGroup.getParameters();
        int parameterCount = parameters.getCount();
        ParameterHelper[] parameterHelpers = new ParameterHelper[parameterCount];
        int i = 0;
        while (i < parameterCount) {
            AbstractScalarParameterHandle parameter = (AbstractScalarParameterHandle)parameters.get(i);
            parameterHelpers[i] = new ParameterHelper(parameter, this.ulocale, this.timeZone);
            ++i;
        }
        return parameterHelpers;
    }

    private Collection getChoicesFromParameterGroup(AbstractScalarParameterHandle parameter, Object[] groupKeyValues) {
        assert (this.isCascadingParameter(parameter));
        CascadingParameterGroupHandle parameterGroup = this.getCascadingGroup(parameter);
        IResultIterator iterator = this.getResultSetOfCascadingGroup(parameterGroup);
        if (iterator == null) {
            return Collections.EMPTY_LIST;
        }
        return this.populateToList(iterator, parameter, new ParameterGroupFilter(groupKeyValues, parameterGroup));
    }

    private IResultIterator getResultSetOfCascadingGroup(CascadingParameterGroupHandle parameterGroup) {
        if (parameterGroup == null) {
            return null;
        }
        DataSetHandle dataSet = parameterGroup.getDataSet();
        if (dataSet != null) {
            try {
                DataRequestSession dteSession = this.createDataSession(dataSet);
                dteSession.getDataSessionContext().setAppContext(this.getAppContext());
                QueryDefinition queryDefn = this.createQueryDefinition(dataSet);
                Iterator<DesignElementHandle> iter = parameterGroup.getParameters().iterator();
                while (iter.hasNext()) {
                    DesignElementHandle parameter = iter.next();
                    if (!(parameter instanceof ScalarParameterHandle)) continue;
                    ParameterHelper.addParameterBinding(queryDefn, (ScalarParameterHandle)parameter, dteSession.getModelAdaptor());
                    ParameterHelper.addParameterSortBy(queryDefn, (ScalarParameterHandle)parameter, dteSession.getModelAdaptor());
                }
                return this.executeQuery(dteSession, queryDefn);
            }
            catch (BirtException ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
                this.executionContext.addException(dataSet, ex);
            }
        }
        return null;
    }

    private CascadingParameterGroupHandle getCascadingParameterGroup(String name) {
        ModuleHandle design = this.executionContext.getDesign();
        return design.findCascadingParameterGroup(name);
    }

    private boolean isCascadingParameter(ParameterHandle parameter) {
        return parameter.getContainer() instanceof CascadingParameterGroupHandle;
    }

    private Object[] getParameterValuesAhead(ParameterHandle parameter) {
        assert (this.isCascadingParameter(parameter));
        CascadingParameterGroupHandle parameterGroup = this.getCascadingGroup(parameter);
        SlotHandle parameters = parameterGroup.getParameters();
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        while (i < parameters.getCount()) {
            ScalarParameterHandle tempParameter = (ScalarParameterHandle)parameters.get(i);
            if (tempParameter == parameter) break;
            values.add(this.getParameterValue(tempParameter.getName()));
            ++i;
        }
        return values.toArray();
    }

    private CascadingParameterGroupHandle getCascadingGroup(ParameterHandle parameter) {
        DesignElementHandle handle = parameter.getContainer();
        assert (handle instanceof CascadingParameterGroupHandle);
        CascadingParameterGroupHandle parameterGroup = (CascadingParameterGroupHandle)handle;
        return parameterGroup;
    }

    private Collection getChoicesFromParameterQuery(AbstractScalarParameterHandle parameter) {
        IResultIterator iter = this.getResultSetForParameter(parameter);
        if (iter == null) {
            return Collections.EMPTY_LIST;
        }
        return this.populateToList(iter, parameter, null);
    }

    private IResultIterator getResultSetForParameter(AbstractScalarParameterHandle parameter) {
        DataSetHandle dataSet = parameter.getDataSet();
        IResultIterator iterator = null;
        if (dataSet != null) {
            try {
                DataRequestSession dteSession = this.createDataSession(dataSet);
                dteSession.getDataSessionContext().setAppContext(this.getAppContext());
                QueryDefinition queryDefn = this.createQueryDefinition(dataSet);
                ParameterHelper.addParameterBinding(queryDefn, parameter, dteSession.getModelAdaptor());
                ParameterHelper.addParameterSortBy(queryDefn, parameter, dteSession.getModelAdaptor());
                iterator = this.executeQuery(dteSession, queryDefn);
            }
            catch (BirtException ex) {
                log.log(Level.WARNING, ex.getMessage(), ex);
                this.executionContext.addException(dataSet, ex);
            }
        }
        return iterator;
    }

    private IParameterDefnBase getParamDefnBaseByName(ParameterDefnBase param, String name) {
        ParameterDefnBase ret = null;
        if (name.equals(param.getName())) {
            ret = param;
        }
        if (param instanceof ParameterGroupDefn) {
            for (ParameterDefnBase pBase : ((ParameterGroupDefn)param).getContents()) {
                if (!name.equals(pBase.getName())) continue;
                ret = pBase;
                break;
            }
        }
        if (ret != null) {
            try {
                return (IParameterDefnBase)ret.clone();
            }
            catch (CloneNotSupportedException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return ret;
    }

    public ArrayList getParameters(ModuleHandle handle, boolean includeParameterGroups) {
        assert (handle != null);
        ParameterIRVisitor visitor = new ParameterIRVisitor(handle);
        ArrayList<IParameterDefnBase> parameters = new ArrayList<IParameterDefnBase>();
        SlotHandle paramSlot = handle.getParameters();
        int i = 0;
        while (i < paramSlot.getCount()) {
            visitor.apply(paramSlot.get(i));
            assert (visitor.currentElement != null);
            IParameterDefnBase param = (IParameterDefnBase)visitor.currentElement;
            assert (param.getName() != null);
            parameters.add(param);
            ++i;
        }
        if (includeParameterGroups) {
            return parameters;
        }
        return this.flattenParameter(parameters);
    }

    protected ArrayList flattenParameter(ArrayList params) {
        assert (params != null);
        ArrayList<IParameterDefnBase> allParameters = new ArrayList<IParameterDefnBase>();
        int n = 0;
        while (n < params.size()) {
            IParameterDefnBase param = (IParameterDefnBase)params.get(n);
            if (param.getParameterType() == 4 || param.getParameterType() == 5) {
                allParameters.addAll(this.flattenParameter(((IParameterGroupDefn)param).getContents()));
            } else {
                allParameters.add(param);
            }
            ++n;
        }
        return allParameters;
    }

    static class CascadingParameterSelectionChoice
    extends SelectionChoice
    implements ICascadingParameterSelectionChoice {
        Collection children;

        public CascadingParameterSelectionChoice(String label, Object value) {
            super(label, value);
        }

        public void setChildren(Collection children) {
            this.children = children;
        }

        @Override
        public Collection getChildSelectionList() {
            return this.children;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CascadingParameterSelectionChoice)) {
                return false;
            }
            CascadingParameterSelectionChoice choice = (CascadingParameterSelectionChoice)obj;
            if (this.value == null) {
                return choice.value == null;
            }
            return this.value.equals(choice.value);
        }
    }

    static class ChoiceListCache {
        private ParameterHelper[] parameterHelpers;
        private Map[] cachedLists;
        private Collection root;
        private int parameterCount;

        public ChoiceListCache(ParameterHelper[] parameterHelpers) {
            this.parameterHelpers = parameterHelpers;
            this.parameterCount = parameterHelpers.length;
            this.cachedLists = new Map[this.parameterCount - 1];
            int i = 0;
            while (i < this.cachedLists.length) {
                this.cachedLists[i] = new HashMap();
                ++i;
            }
            this.root = parameterHelpers[0].createSelectionCollection();
        }

        public Collection getParent(Object[] values, int parameterIndex) {
            if (parameterIndex == 0) {
                return this.root;
            }
            int parentIndex = parameterIndex - 1;
            Map cache = this.cachedLists[parentIndex];
            ValueGroup valueGroup = new ValueGroup(values, parentIndex);
            Collection parent = (Collection)cache.get(valueGroup);
            if (parent == null) {
                parent = this.parameterHelpers[parameterIndex].createSelectionCollection();
                cache.put(valueGroup, parent);
            }
            return parent;
        }

        public boolean containsChildren(Object[] values, int parameterIndex) {
            if (parameterIndex == this.parameterCount - 1) {
                return false;
            }
            ValueGroup valueGroup = new ValueGroup(values, parameterIndex);
            Map cache = this.cachedLists[parameterIndex];
            return cache.containsKey(valueGroup);
        }

        public Collection getChildren(Object[] values, int parameterIndex) {
            if (parameterIndex == this.parameterCount - 1) {
                return Collections.EMPTY_LIST;
            }
            Map cache = this.cachedLists[parameterIndex];
            ValueGroup valueGroup = new ValueGroup(values, parameterIndex);
            Collection parent = (Collection)cache.get(valueGroup);
            if (parent == null) {
                parent = this.parameterHelpers[parameterIndex + 1].createSelectionCollection();
                cache.put(valueGroup, parent);
            }
            return parent;
        }

        public Collection getRoot() {
            return this.root;
        }
    }

    static class ParameterBinding {
        String labelColumnName;
        String valueColumnName;
        String valueType;

        public ParameterBinding(String labelColumnName, String valueColumnName, String valueType) {
            this.labelColumnName = labelColumnName;
            this.valueColumnName = valueColumnName;
            this.valueType = valueType;
        }
    }

    private class ParameterGroupFilter
    implements SelectionFilter {
        Object[] keyValues;
        String[] valueColumnNames;
        String[] valueTypes;

        public ParameterGroupFilter(Object[] keyValues, CascadingParameterGroupHandle parameterGroup) {
            this.keyValues = keyValues;
            this.valueColumnNames = new String[keyValues.length];
            this.valueTypes = new String[keyValues.length];
            SlotHandle parameterSlots = parameterGroup.getParameters();
            int i = 0;
            while (i < keyValues.length) {
                ScalarParameterHandle tempParameter = (ScalarParameterHandle)parameterSlots.get(i);
                this.valueColumnNames[i] = ParameterHelper.getValueColumnName(tempParameter);
                this.valueTypes[i] = tempParameter.getDataType();
                ++i;
            }
        }

        @Override
        public boolean accept(IResultIterator iterator) throws BirtException {
            int i = 0;
            while (i < this.valueColumnNames.length) {
                Object value = iterator.getValue(this.valueColumnNames[i]);
                if ((value = GetParameterDefinitionTask.this.convertToType(value, this.valueTypes[i])) == null && this.keyValues[i] != null || value != null && !value.equals(this.keyValues[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class ParameterIRVisitor
    extends DesignVisitor {
        protected ModuleHandle handle;
        protected Object currentElement;

        ParameterIRVisitor(ModuleHandle handle) {
            this.handle = handle;
        }

        @Override
        public void visitParameterGroup(ParameterGroupHandle handle) {
            ParameterGroupDefn paramGroup = new ParameterGroupDefn();
            paramGroup.setLocale(GetParameterDefinitionTask.this.ulocale.toLocale());
            paramGroup.setHandle(handle);
            paramGroup.setParameterType(4);
            paramGroup.setName(handle.getName());
            paramGroup.setDisplayName(handle.getDisplayName());
            paramGroup.setDisplayNameKey(handle.getDisplayNameKey());
            paramGroup.setHelpText(handle.getHelpText());
            paramGroup.setHelpTextKey(handle.getHelpTextKey());
            paramGroup.setPromptText(handle.getPromptText());
            paramGroup.setPromptTextKey(handle.getPromptTextKey());
            SlotHandle parameters = handle.getParameters();
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                paramGroup.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            int size = parameters.getCount();
            int n = 0;
            while (n < size) {
                this.apply(parameters.get(n));
                if (this.currentElement != null) {
                    paramGroup.addParameter((IParameterDefnBase)this.currentElement);
                }
                ++n;
            }
            this.currentElement = paramGroup;
        }

        @Override
        public void visitCascadingParameterGroup(CascadingParameterGroupHandle handle) {
            CascadingParameterGroupDefn paramGroup = new CascadingParameterGroupDefn();
            paramGroup.setLocale(GetParameterDefinitionTask.this.ulocale.toLocale());
            paramGroup.setHandle(handle);
            paramGroup.setParameterType(5);
            paramGroup.setName(handle.getName());
            paramGroup.setDisplayName(handle.getDisplayName());
            paramGroup.setDisplayNameKey(handle.getDisplayNameKey());
            paramGroup.setHelpText(handle.getHelpText());
            paramGroup.setHelpTextKey(handle.getHelpTextKey());
            paramGroup.setPromptText(handle.getPromptText());
            paramGroup.setPromptTextKey(handle.getPromptTextKey());
            DataSetHandle dset = handle.getDataSet();
            if (dset != null) {
                paramGroup.setDataSet(dset.getName());
            }
            SlotHandle parameters = handle.getParameters();
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                paramGroup.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            int size = parameters.getCount();
            int n = 0;
            while (n < size) {
                this.apply(parameters.get(n));
                if (this.currentElement != null) {
                    paramGroup.addParameter((IParameterDefnBase)this.currentElement);
                }
                ++n;
            }
            this.currentElement = paramGroup;
        }

        @Override
        public void visitScalarParameter(ScalarParameterHandle handle) {
            assert (handle.getName() != null);
            ScalarParameterDefn scalarParameter = new ScalarParameterDefn();
            scalarParameter.setHandle(handle);
            scalarParameter.setLocale(GetParameterDefinitionTask.this.ulocale.toLocale());
            scalarParameter.setParameterType(0);
            scalarParameter.setName(handle.getName());
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                Expression expression = ExpressionUtil.createUserProperty(handle, p);
                Object value = ExpressionUtil.evaluate(GetParameterDefinitionTask.this.executionContext, expression);
                scalarParameter.addUserProperty(p.getName(), value);
                ++i;
            }
            String align = handle.getAlignment();
            if ("center".equals(align)) {
                scalarParameter.setAlignment(2);
            } else if ("left".equals(align)) {
                scalarParameter.setAlignment(1);
            } else if ("right".equals(align)) {
                scalarParameter.setAlignment(3);
            } else {
                scalarParameter.setAlignment(0);
            }
            scalarParameter.setAllowBlank(handle.allowBlank());
            scalarParameter.setAllowNull(handle.allowNull());
            scalarParameter.setIsRequired(handle.isRequired());
            scalarParameter.setScalarParameterType(handle.getParamType());
            String controlType = handle.getControlType();
            if ("check-box".equals(controlType)) {
                scalarParameter.setControlType(3);
            } else if ("list-box".equals(controlType)) {
                scalarParameter.setControlType(1);
            } else if ("radio-button".equals(controlType)) {
                scalarParameter.setControlType(2);
            } else if ("auto-suggest".equals(controlType)) {
                scalarParameter.setControlType(4);
            } else {
                scalarParameter.setControlType(0);
            }
            scalarParameter.setDefaultValue(handle.getDefaultValue());
            scalarParameter.setDisplayName(handle.getDisplayName());
            scalarParameter.setDisplayNameKey(handle.getDisplayNameKey());
            scalarParameter.setFormat(handle.getPattern());
            scalarParameter.setHelpText(handle.getHelpText());
            scalarParameter.setHelpTextKey(handle.getHelpTextKey());
            scalarParameter.setPromptText(handle.getPromptText());
            scalarParameter.setPromptTextKey(handle.getPromptTextID());
            scalarParameter.setIsHidden(handle.isHidden());
            scalarParameter.setName(handle.getName());
            String valueType = handle.getDataType();
            if ("boolean".equals(valueType)) {
                scalarParameter.setDataType(5);
            } else if ("dateTime".equals(valueType)) {
                scalarParameter.setDataType(4);
            } else if ("date".equals(valueType)) {
                scalarParameter.setDataType(7);
            } else if ("time".equals(valueType)) {
                scalarParameter.setDataType(8);
            } else if ("decimal".equals(valueType)) {
                scalarParameter.setDataType(3);
            } else if ("float".equals(valueType)) {
                scalarParameter.setDataType(2);
            } else if ("string".equals(valueType)) {
                scalarParameter.setDataType(1);
            } else if ("integer".equals(valueType)) {
                scalarParameter.setDataType(6);
            } else {
                scalarParameter.setDataType(0);
            }
            ArrayList<ParameterSelectionChoice> values = new ArrayList<ParameterSelectionChoice>();
            Iterator<?> selectionIter = handle.choiceIterator();
            while (selectionIter.hasNext()) {
                SelectionChoiceHandle selection = (SelectionChoiceHandle)selectionIter.next();
                ParameterSelectionChoice selectionChoice = new ParameterSelectionChoice(selection);
                selectionChoice.setLabel(selection.getLabelKey(), selection.getLabel());
                selectionChoice.setValue(selection.getValue(), scalarParameter.getDataType());
                values.add(selectionChoice);
            }
            scalarParameter.setSelectionList(values);
            scalarParameter.setAllowNewValues(!handle.isMustMatch());
            scalarParameter.setFixedOrder(handle.isFixedOrder());
            String paramType = handle.getValueType();
            if ("static".equals(paramType)) {
                scalarParameter.setSelectionListType(2);
            } else if ("dynamic".equals(paramType)) {
                scalarParameter.setSelectionListType(1);
            } else {
                scalarParameter.setSelectionListType(0);
            }
            scalarParameter.setValueConcealed(handle.isConcealValue());
            this.currentElement = scalarParameter;
            scalarParameter.setAutoSuggestThreshold(handle.getAutoSuggestThreshold());
        }

        @Override
        public void visitDynamicFilterParameter(DynamicFilterParameterHandle handle) {
            assert (handle.getName() != null);
            DynamicFilterParameterDefn parameter = new DynamicFilterParameterDefn();
            parameter.setHandle(handle);
            parameter.setLocale(GetParameterDefinitionTask.this.ulocale.toLocale());
            parameter.setParameterType(1);
            parameter.setName(handle.getName());
            parameter.setIsRequired(handle.isRequired());
            parameter.setDisplayName(handle.getDisplayName());
            parameter.setDisplayNameKey(handle.getDisplayNameKey());
            parameter.setHelpText(handle.getHelpText());
            parameter.setHelpTextKey(handle.getHelpTextKey());
            parameter.setPromptText(handle.getPromptText());
            parameter.setPromptTextKey(handle.getPromptTextID());
            parameter.setIsHidden(handle.isHidden());
            parameter.setName(handle.getName());
            List properties = handle.getUserProperties();
            int i = 0;
            while (i < properties.size()) {
                UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
                parameter.addUserProperty(p.getName(), handle.getProperty(p.getName()));
                ++i;
            }
            String valueType = handle.getDataType();
            if ("boolean".equals(valueType)) {
                parameter.setDataType(5);
            } else if ("dateTime".equals(valueType)) {
                parameter.setDataType(4);
            } else if ("date".equals(valueType)) {
                parameter.setDataType(7);
            } else if ("time".equals(valueType)) {
                parameter.setDataType(8);
            } else if ("decimal".equals(valueType)) {
                parameter.setDataType(3);
            } else if ("float".equals(valueType)) {
                parameter.setDataType(2);
            } else if ("string".equals(valueType)) {
                parameter.setDataType(1);
            } else if ("integer".equals(valueType)) {
                parameter.setDataType(6);
            } else {
                parameter.setDataType(0);
            }
            String paramType = handle.getValueType();
            if ("static".equals(paramType)) {
                parameter.setSelectionListType(2);
                ArrayList<ParameterSelectionChoice> values = new ArrayList<ParameterSelectionChoice>();
                Iterator<?> selectionIter = handle.choiceIterator();
                while (selectionIter.hasNext()) {
                    SelectionChoiceHandle selection = (SelectionChoiceHandle)selectionIter.next();
                    ParameterSelectionChoice selectionChoice = new ParameterSelectionChoice(selection);
                    selectionChoice.setLabel(selection.getLabelKey(), selection.getLabel());
                    selectionChoice.setValue(selection.getValue(), parameter.getDataType());
                    values.add(selectionChoice);
                }
                parameter.setSelectionList(values);
            } else if ("dynamic".equals(paramType)) {
                parameter.setSelectionListType(1);
            } else {
                parameter.setSelectionListType(0);
            }
            parameter.setColumn(handle.getColumn());
            if ("advanced".equals(handle.getDisplayType())) {
                parameter.setDisplayType(2);
            } else {
                parameter.setDisplayType(1);
            }
            List<String> operators = handle.getFilterOperatorList();
            if (operators != null) {
                ArrayList<String> filters = new ArrayList<String>();
                ArrayList<String> locFilters = new ArrayList<String>();
                for (String operator : operators) {
                    filters.add(operator);
                    IFilterExprDefinition expr = OdaFilterExprHelper.getFilterExpressionDefn(operator, null, null);
                    if (expr != null) {
                        locFilters.add(expr.getBirtFilterExprDisplayName(GetParameterDefinitionTask.this.ulocale));
                        continue;
                    }
                    locFilters.add(null);
                }
                parameter.setFilterOperatorList(filters);
                parameter.setFilterOperatorDisplayList(locFilters);
            } else {
                parameter.setFilterOperatorList(null);
                parameter.setFilterOperatorDisplayList(null);
            }
            this.currentElement = parameter;
        }
    }

    static class SelectionChoice
    implements IParameterSelectionChoice {
        String label;
        Object value;

        SelectionChoice(String label, Object value) {
            this.label = label;
            this.value = value;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SelectionChoice)) {
                return false;
            }
            SelectionChoice choice = (SelectionChoice)obj;
            if (this.value == null) {
                return choice.value == null;
            }
            return this.value.equals(choice.value);
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }

    private static interface SelectionFilter {
        public boolean accept(IResultIterator var1) throws BirtException;
    }

    static class ValueGroup {
        private Object[] values;
        private int parameterIndex;

        public ValueGroup(Object[] values, int parameterIndex) {
            this.values = values;
            this.parameterIndex = parameterIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            int i = 0;
            while (i <= this.parameterIndex) {
                hashCode += 13 * this.values[i].hashCode();
                ++i;
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ValueGroup)) {
                return false;
            }
            ValueGroup valueGroup = (ValueGroup)obj;
            if (this.parameterIndex != valueGroup.parameterIndex) {
                return false;
            }
            int i = 0;
            while (i <= this.parameterIndex) {
                if (!this.equal(this.values[i], valueGroup.values[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean equal(Object obj1, Object obj2) {
            if (obj1 == null) {
                return obj2 == null;
            }
            return obj1.equals(obj2);
        }
    }

    static class ValuePopper {
        Object[] values;
        boolean[] types;
        int[] lengths;
        int[] indexes;
        int size;
        int cur;
        Object[] tempValues;

        public ValuePopper(Object[] values) {
            this.values = new Object[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
            this.lengths = new int[values.length];
            this.indexes = new int[values.length];
            this.types = new boolean[values.length];
            this.size = 1;
            int index = 0;
            while (index < values.length) {
                if (values[index] instanceof Object[]) {
                    this.lengths[index] = ((Object[])values[index]).length;
                    this.types[index] = true;
                    this.size *= this.lengths[index];
                }
                ++index;
            }
            this.tempValues = new Object[values.length];
        }

        public Object[] next() {
            int last = this.values.length - 1;
            while (last >= 0) {
                this.tempValues[last] = !this.types[last] ? this.values[last] : ((Object[])this.values[last])[this.indexes[last]];
                --last;
            }
            return this.tempValues;
        }

        public boolean hasNext() {
            boolean has;
            boolean bl = has = this.cur < this.size;
            if (this.cur > 0 && has) {
                int last = this.indexes.length - 1;
                while (last >= 0) {
                    if (this.types[last] && this.lengths[last] != 1) {
                        if (this.indexes[last] + 1 < this.lengths[last]) {
                            int n = last;
                            this.indexes[n] = this.indexes[n] + 1;
                            break;
                        }
                        this.indexes[last] = 0;
                    }
                    --last;
                }
            }
            ++this.cur;
            return has;
        }
    }
}

