/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.docx.writer;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.docx.writer.BasicComponent;
import org.eclipse.birt.report.engine.emitter.docx.writer.Document;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.ImageManager;

public class Header
extends BasicComponent {
    private static Logger logger = Logger.getLogger(Header.class.getName());
    Document document;
    int headerHeight;
    int headerWidth;
    boolean wrapHeader;

    Header(IPart part, Document document, int headerHeight, int headerWidth) throws IOException {
        this(part, document, headerHeight, headerWidth, true);
    }

    Header(IPart part, Document document, int headerHeight, int headerWidth, boolean wrapHeader) throws IOException {
        super(part);
        this.document = document;
        this.headerHeight = headerHeight;
        this.headerWidth = headerWidth;
        this.wrapHeader = wrapHeader;
    }

    @Override
    void start() {
        this.writer.startWriter();
        this.writer.openTag("w:hdr");
        this.writeXmlns();
        if (this.wrapHeader) {
            this.startHeaderFooterContainer(this.headerHeight, this.headerWidth, true);
        }
    }

    @Override
    void end() {
        if (this.wrapHeader) {
            this.endHeaderFooterContainer();
        }
        this.writer.closeTag("w:hdr");
        this.writer.endWriter();
        this.writer.close();
    }

    protected int getImageID() {
        return this.document.getImageID();
    }

    @Override
    protected int getMhtTextId() {
        return this.document.getMhtTextId();
    }

    public void drawDocumentBackgroundImageWithSize(String backgroundImageUrl, String backgroundHeight, String backgroundWidth, double topMargin, double leftMargin, double pageHeight, double pageWidth) {
        int imageId = this.getImageID();
        IPart imagePart = null;
        if (backgroundImageUrl != null) {
            try {
                byte[] backgroundImageData = EmitterUtil.getImageData((String)backgroundImageUrl);
                ImageManager.ImagePart imgPart = this.imageManager.getImagePart(this.part, backgroundImageUrl, backgroundImageData);
                imagePart = imgPart.getPart();
                Image imageInfo = EmitterUtil.parseImage(null, (int)3, (String)backgroundImageUrl, null, null);
                int imageWidth = imageInfo.getWidth();
                int imageHeight = imageInfo.getHeight();
                String[] realSize = WordUtil.parseBackgroundSize((String)backgroundHeight, (String)backgroundWidth, (int)imageWidth, (int)imageHeight, (double)pageWidth, (double)pageHeight);
                this.drawBackgroundImageShape(realSize, topMargin, leftMargin, imageId, imagePart);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void drawBackgroundImageShape(String[] size, double topMargin, double leftMargin, int imageId, IPart imagePart) {
        this.writer.openTag("w:sdt");
        this.writer.openTag("w:sdtPr");
        this.writer.openTag("w:id");
        this.writer.attribute("w:val", "90701258");
        this.writer.closeTag("w:id");
        this.writer.openTag("w:docPartObj");
        this.writer.openTag("w:docPartGallery");
        this.writer.attribute("w:val", "Cover Pages");
        this.writer.closeTag("w:docPartGallery");
        this.writer.openTag("w:docPartUnique");
        this.writer.closeTag("w:docPartUnique");
        this.writer.closeTag("w:docPartObj");
        this.writer.closeTag("w:sdtPr");
        this.writer.openTag("w:sdtContent");
        this.writer.openTag("w:p");
        this.writer.attribute("w:rsidR", "00182958");
        this.writer.attribute("w:rsidRDefault", "00182958");
        this.writer.attribute("w:rsidP", "00182958");
        this.writer.openTag("w:r");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:noProof");
        this.writer.closeTag("w:noProof");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:pict");
        this.writer.openTag("v:rect");
        this.writer.attribute("id", "_x0000_s1041");
        String attrValue = "position:absolute;left:0;text-align:left;margin-left:0pt;margin-top:0pt;width:" + size[1] + ";height:" + size[0] + ";z-index:-1;mso-width-percent:1000;mso-position-horizontal-relative:page;mso-position-vertical-relative:page;mso-width-percent:1000";
        this.writer.attribute("style", attrValue);
        this.writer.attribute("o:allowincell", "f");
        this.writer.attribute("stroked", "f");
        this.writer.openTag("v:fill");
        this.writer.attribute("r:id", imagePart.getRelationshipId());
        this.writer.attribute("o:title", "exposure");
        this.writer.attribute("size", "0,0");
        this.writer.attribute("aspect", "atLeast");
        this.writer.attribute("origin", "-32767f,-32767f");
        this.writer.attribute("position", "-32767f,-32767f");
        this.writer.attribute("recolor", "t");
        this.writer.attribute("rotate", "t");
        this.writer.attribute("type", "frame");
        this.writer.closeTag("v:fill");
        this.writer.openTag("w10:wrap");
        this.writer.attribute("anchorx", "page");
        this.writer.attribute("anchory", "page");
        this.writer.closeTag("w10:wrap");
        this.writer.closeTag("v:rect");
        this.writer.closeTag("w:pict");
        this.writer.closeTag("w:r");
        this.writer.closeTag("w:p");
        this.writer.closeTag("w:sdtContent");
        this.writer.closeTag("w:sdt");
    }
}

