/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;

public class RowExecutor
extends ContainerExecutor {
    private int rowId;
    private int nextItem = 0;

    protected RowExecutor(ExecutorManager manager) {
        super(manager, 13);
    }

    void setRowId(int rowId) {
        this.rowId = rowId;
    }

    int getRowId() {
        return this.rowId;
    }

    @Override
    protected IContent doCreateContent() {
        return this.report.createRowContent();
    }

    @Override
    protected void doExecute() throws Exception {
        IRowContent rowContent = (IRowContent)this.content;
        rowContent.setRowID(this.rowId);
        this.executeQuery();
    }

    @Override
    public void close() {
        this.closeQuery();
        this.rowId = 0;
        this.nextItem = 0;
        super.close();
    }

    @Override
    protected ReportItemExecutor doCreateExecutor(long offset) {
        RowDesign rowDesign = (RowDesign)this.design;
        if (this.nextItem < rowDesign.getCellCount()) {
            CellDesign cellDesign = rowDesign.getCell(this.nextItem);
            ++this.nextItem;
            return this.manager.createExecutor(this, cellDesign, offset);
        }
        return null;
    }

    @Override
    protected void doSkipToExecutor(InstanceID id, long offset) {
        RowDesign rowDesign = (RowDesign)this.design;
        int cellCount = rowDesign.getCellCount();
        long cellDesignId = id.getComponentID();
        int i = 0;
        while (i < cellCount) {
            CellDesign childDesign = rowDesign.getCell(i);
            if (cellDesignId == childDesign.getID()) {
                this.nextItem = i;
                return;
            }
            ++i;
        }
        this.nextItem = rowDesign.getCellCount();
    }
}

