/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.writer;

import java.io.IOException;
import java.util.Base64;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.odf.IOdfWriter;
import org.eclipse.birt.report.engine.odf.SpanInfo;
import org.eclipse.birt.report.engine.odf.style.HyperlinkInfo;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;

public class AbstractOdfWriter
implements IOdfWriter {
    public XMLWriter writer;
    protected int bookmarkId = 0;
    protected int imageId = 75;

    @Override
    public void startTable(String name, StyleEntry style) {
        this.writer.openTag("table:table");
        if (name != null) {
            this.writer.attribute("table:name", name);
        }
        if (style != null) {
            this.writer.attribute("table:style-name", style.getName());
        }
    }

    @Override
    public void endTable() {
        this.writer.closeTag("table:table");
    }

    @Override
    public void startTableHeader() {
        this.writer.openTag("table:table-header-rows");
    }

    @Override
    public void endTableHeader() {
        this.writer.closeTag("table:table-header-rows");
    }

    @Override
    public void startTableRow(StyleEntry rowStyle) {
        this.writer.openTag("table:table-row");
        if (rowStyle != null) {
            this.writer.attribute("table:style-name", rowStyle.getName());
        }
    }

    @Override
    public void endTableRow() {
        this.writer.closeTag("table:table-row");
    }

    @Override
    public void startTableRowGroup() {
        this.writer.openTag("table:table-row-group");
    }

    @Override
    public void endTableRowGroup() {
        this.writer.closeTag("table:table-row-group");
    }

    @Override
    public void startTableCell(StyleEntry style, SpanInfo spanInfo) {
        this.writer.openTag("table:table-cell");
        if (style != null) {
            this.writer.attribute("table:style-name", style.getName());
        }
        if (spanInfo != null) {
            this.writeGridSpan(spanInfo);
        }
    }

    @Override
    public void endTableCell() {
        this.writer.closeTag("table:table-cell");
    }

    @Override
    public void writeAutoText(int type) {
        if (type == 1) {
            this.writer.openTag("text:page-number");
            this.writer.closeTag("text:page-number");
        } else if (type == 0) {
            this.writer.openTag("text:page-count");
            this.writer.closeTag("text:page-count");
        }
    }

    @Override
    public void writeColumn(StyleEntry[] colStyles) {
        int i = 0;
        while (i < colStyles.length) {
            int count;
            StyleEntry colStyle = colStyles[i];
            this.writer.openTag("table:table-column");
            if (colStyle != null) {
                this.writer.attribute("table:style-name", colStyle.getName());
                count = 1;
                while (i < colStyles.length - 1 && colStyles[i + 1] != null && colStyle.getName().equals(colStyles[i + 1].getName())) {
                    ++count;
                    ++i;
                }
                if (count > 1) {
                    this.writer.attribute("table:number-columns-repeated", count);
                }
            } else {
                count = 1;
                while (i < colStyles.length - 1 && colStyles[i + 1] == null) {
                    ++count;
                    ++i;
                }
                if (count > 1) {
                    this.writer.attribute("table:number-columns-repeated", count);
                }
            }
            this.writer.closeTag("table:table-column");
            ++i;
        }
    }

    @Override
    public void writeSpanCell(SpanInfo info) {
        this.writer.openTag("table:covered-table-cell");
        StyleEntry style = info.getStyle();
        if (style != null) {
            this.writer.attribute("table:style-name", style.getName());
        }
        this.writeGridSpan(info);
        this.insertHiddenParagraph();
        this.writer.closeTag("table:covered-table-cell");
    }

    @Override
    public void writeEmptyCell() {
        this.writer.openTag("table:table-cell");
        this.insertHiddenParagraph();
        this.writer.closeTag("table:table-cell");
    }

    public void insertHiddenParagraph() {
        this.writer.openTag("text:p");
        this.writer.attribute("text:style-name", "Hidden");
        this.writer.closeTag("text:p");
    }

    public void writeGridSpan(SpanInfo spanInfo) {
        int columnSpan = spanInfo.getColumnSpan();
        int rowSpan = spanInfo.getRowSpan();
        if (columnSpan > 1) {
            this.writer.attribute("table:number-columns-spanned", columnSpan);
        }
        if (rowSpan > 1) {
            this.writer.attribute("table:number-rows-spanned", rowSpan);
        }
    }

    protected void openHyperlink(HyperlinkInfo info) {
        this.openHyperlink(info, "text");
    }

    protected void openHyperlink(HyperlinkInfo info, String baseType) {
        if (info == null) {
            return;
        }
        this.writer.openTag(baseType + ":a");
        this.writer.attribute("xlink:type", "simple");
        if (info.getType() == 0) {
            this.writer.attribute("xlink:href", "#" + info.getUrl());
        } else if (1 == info.getType() || 2 == info.getType()) {
            this.writer.attribute("xlink:href", info.getUrl());
        }
        if (info.getTooltip() != null) {
            this.writer.attribute("xlink:title", info.getTooltip());
        }
    }

    protected void closeHyperlink(HyperlinkInfo info) {
        this.closeHyperlink(info, "text");
    }

    protected void closeHyperlink(HyperlinkInfo info, String baseType) {
        if (info == null) {
            return;
        }
        this.writer.closeTag(baseType + ":a");
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void writeParagraph(String txt, StyleEntry style) {
        this.writer.openTag("text:p");
        if (style != null) {
            this.writer.attribute("text:style-name", style.getName());
        }
        this.writeString(txt);
        this.writer.closeTag("text:p");
    }

    @Override
    public void writeString(String txt) {
        if (txt == null) {
            return;
        }
        boolean notFirst = false;
        String[] stringArray = txt.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            String row = "<![CDATA[" + st + "]]>";
            if (notFirst) {
                row = "<text:line-break />" + row;
            } else {
                notFirst = true;
            }
            this.writer.cdata(row);
            ++n2;
        }
    }

    public void writeBookmark(String bm) {
        if (bm == null) {
            return;
        }
        this.writer.openTag("text:bookmark");
        this.writer.attribute("text:name", bm);
        this.writer.closeTag("text:bookmark");
        ++this.bookmarkId;
    }

    protected void drawImage(String imageUrl, byte[] imageData, Double positionX, Double positionY, double height, double width, StyleEntry style, String altText, String layer, int imageId) {
        this.writer.openTag("draw:frame");
        if (style != null) {
            this.writer.attribute("draw:style-name", style.getName());
        }
        if (layer != null) {
            this.writer.attribute("draw:layer", layer);
        }
        this.writer.attribute("draw:name", "Image" + imageId);
        this.writer.attribute("text:anchor-type", "paragraph");
        this.writer.attribute("svg:width", width + "in");
        this.writer.attribute("svg:height", height + "in");
        if (positionX != null) {
            this.writer.attribute("svg:x", positionX + "in");
        }
        if (positionY != null) {
            this.writer.attribute("svg:y", positionY + "in");
        }
        this.writer.attribute("draw:z-index", "0");
        this.writer.openTag("draw:image");
        if (imageData != null) {
            this.drawImageData(imageData);
        } else {
            this.drawImageData(imageUrl);
        }
        this.writer.closeTag("draw:image");
        this.writer.openTag("svg:title");
        this.writer.text(altText);
        this.writer.closeTag("svg:title");
        this.writer.closeTag("draw:frame");
    }

    protected void drawImageData(String imageUrl) {
        if (imageUrl != null && imageUrl.length() > 0) {
            this.writer.attribute("xlink:href", imageUrl);
        }
    }

    protected void drawImageData(byte[] data) {
        String pic2Text = null;
        if (data != null && data.length != 0) {
            pic2Text = new String(Base64.getEncoder().encode(data));
        }
        if (pic2Text != null) {
            this.writer.openTag("office:binary-data");
            this.writer.text(pic2Text);
            this.writer.closeTag("office:binary-data");
        }
    }

    protected void writeSpan(String txt, StyleEntry style, HyperlinkInfo info, int fieldType, boolean isField) {
        this.writer.openTag("text:span");
        if (style != null && style.getType() == 1) {
            this.writer.attribute("text:style-name", style.getName());
        } else if (info != null && info.getStyle() != null) {
            this.writer.attribute("text:style-name", info.getStyle().getName());
        }
        if (isField) {
            this.writeAutoText(fieldType);
        } else {
            this.writeString(txt);
        }
        this.writer.closeTag("text:span");
    }

    protected int getImageID() {
        return this.imageId++;
    }
}

