/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.util.Map;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class EmitterServices {
    public static boolean booleanOption(ITaskOption options, IContent birtContent, String name, boolean defaultValue) {
        Expression expression;
        Map userProperties;
        boolean result = defaultValue;
        Object value = null;
        IContent currentElement = birtContent;
        while (currentElement != null && value == null) {
            Expression expression2;
            Map userProperties2;
            Object designObject;
            if (currentElement instanceof IContent && (designObject = currentElement.getGenerateBy()) instanceof ReportElementDesign && (userProperties2 = ((ReportElementDesign)designObject).getUserProperties()) != null && (expression2 = (Expression)userProperties2.get(name)) instanceof Expression.Constant) {
                Expression.Constant constant = (Expression.Constant)expression2;
                value = constant.getValue();
            }
            if (value != null) continue;
            currentElement = currentElement.getParent();
        }
        if (value == null && birtContent != null && (userProperties = birtContent.getReportContent().getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (birtContent != null && birtContent.getReportContent() != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(birtContent.getReportContent(), name);
        }
        if (value != null) {
            result = EmitterServices.booleanOption(value, defaultValue);
        }
        return result;
    }

    public static boolean booleanOption(ITaskOption options, IReportContent reportContent, String name, boolean defaultValue) {
        Expression expression;
        Map userProperties;
        boolean result = defaultValue;
        Object value = null;
        if (reportContent != null && (userProperties = reportContent.getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (reportContent != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(reportContent, name);
        }
        if (value != null) {
            result = EmitterServices.booleanOption(value, defaultValue);
        }
        return result;
    }

    public static String stringOption(ITaskOption options, IContent birtContent, String name, String defaultValue) {
        Expression expression;
        Map userProperties;
        String result = defaultValue;
        Object value = null;
        IContent currentElement = birtContent;
        while (currentElement != null && value == null) {
            Expression expression2;
            Map userProperties2;
            Object designObject;
            if (currentElement instanceof IContent && (designObject = currentElement.getGenerateBy()) instanceof ReportElementDesign && (userProperties2 = ((ReportElementDesign)designObject).getUserProperties()) != null && (expression2 = (Expression)userProperties2.get(name)) instanceof Expression.Constant) {
                Expression.Constant constant = (Expression.Constant)expression2;
                value = constant.getValue();
            }
            if (value != null) continue;
            currentElement = currentElement.getParent();
        }
        if (value == null && birtContent != null && (userProperties = birtContent.getReportContent().getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (birtContent != null && birtContent.getReportContent() != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(birtContent.getReportContent(), name);
        }
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    public static String stringOption(ITaskOption options, IReportContent reportContent, String name, String defaultValue) {
        Expression expression;
        Map userProperties;
        String result = defaultValue;
        Object value = null;
        if (reportContent != null && (userProperties = reportContent.getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (reportContent != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(reportContent, name);
        }
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    public static int integerOption(ITaskOption options, IContent birtContent, String name, int defaultValue) {
        Expression expression;
        Map userProperties;
        int result = defaultValue;
        Object value = null;
        IContent currentElement = birtContent;
        while (currentElement != null && value == null) {
            Expression expression2;
            Map userProperties2;
            Object designObject;
            if (currentElement instanceof IContent && (designObject = currentElement.getGenerateBy()) instanceof ReportElementDesign && (userProperties2 = ((ReportElementDesign)designObject).getUserProperties()) != null && (expression2 = (Expression)userProperties2.get(name)) instanceof Expression.Constant) {
                Expression.Constant constant = (Expression.Constant)expression2;
                value = constant.getValue();
            }
            if (value != null) continue;
            currentElement = currentElement.getParent();
        }
        if (value == null && birtContent != null && (userProperties = birtContent.getReportContent().getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (birtContent != null && birtContent.getReportContent() != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(birtContent.getReportContent(), name);
        }
        if (value instanceof Number) {
            result = ((Number)value).intValue();
        } else if (value != null) {
            try {
                result = Integer.parseInt(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean booleanOption(Object value, boolean defaultValue) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue() != 0.0;
            }
            if (value != null) {
                return Boolean.parseBoolean(value.toString());
            }
        }
        return defaultValue;
    }

    public static boolean booleanOption(String propertyName, boolean defaultValue) {
        return EmitterServices.booleanOption(null, propertyName, defaultValue);
    }

    public static boolean booleanOption(IContent birtContent, String propertyName, boolean defaultValue) {
        Object value = EmitterServices.getUserProperty(birtContent, propertyName);
        return EmitterServices.booleanOption(value, defaultValue);
    }

    public static String stringOption(IContent birtContent, String propertyName, boolean defaultValue) {
        String stringValue = null;
        Object value = EmitterServices.getUserProperty(birtContent, propertyName);
        if (value != null) {
            stringValue = value.toString();
        }
        return stringValue;
    }

    protected static Object getUserProperty(IContent birtContent, String propName) {
        Expression expression;
        Map designUserprops;
        Expression expression2;
        Map designUserprops2;
        ReportItemDesign designElem;
        Object value = null;
        Map userprops = birtContent.getUserProperties();
        if (userprops != null) {
            value = userprops.get(propName);
        }
        if (value == null && (designElem = (ReportItemDesign)birtContent.getGenerateBy()) != null && (designUserprops2 = designElem.getUserProperties()) != null && (expression2 = (Expression)designUserprops2.get(propName)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression2;
            value = constant.getValue();
        }
        if (value == null && (designUserprops = birtContent.getReportContent().getDesign().getUserProperties()) != null && (expression = (Expression)designUserprops.get(propName)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        return value;
    }

    private static Object getReportDesignConfiguration(IReportContent reportContent, String name) {
        Boolean value = null;
        if (name.equalsIgnoreCase("WordEmitter.WrappedTableForMarginPadding")) {
            value = reportContent.getDesign().getReportDesign().getWordWrapTableForMarginPadding();
        } else if (name.equalsIgnoreCase("WordEmitter.CombineMarginPadding")) {
            value = reportContent.getDesign().getReportDesign().getWordCombineMarginPadding();
        } else if (name.equalsIgnoreCase("WordEmitter.WrappedTableHeaderFooter")) {
            value = reportContent.getDesign().getReportDesign().getWordWrapTableForHeaderFooter();
        } else if (name.equalsIgnoreCase("WordEmitter.AddEmptyParagraphForListCell")) {
            value = reportContent.getDesign().getReportDesign().getWordListCellAddEmptyPara();
        }
        return value;
    }
}

