/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb;

import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbItem;
import org.eclipse.birt.report.designer.internal.ui.editors.breadcrumb.BreadcrumbViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class BreadcrumbItemDetails {
    private final Label fElementImage;
    private final Label fElementText;
    private final Composite fDetailComposite;
    private final BreadcrumbItem fParent;
    private final Composite fTextComposite;
    private final Composite fImageComposite;
    private boolean fTextVisible;
    private boolean fSelected;
    private boolean fHasFocus;

    public BreadcrumbItemDetails(BreadcrumbItem parent, Composite parentContainer) {
        this.fParent = parent;
        this.fTextVisible = true;
        this.fDetailComposite = new Composite(parentContainer, 0);
        this.fDetailComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.fDetailComposite.setLayout((Layout)layout);
        this.addElementListener((Control)this.fDetailComposite);
        this.fImageComposite = new Composite(this.fDetailComposite, 0);
        this.fImageComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        layout = new GridLayout(1, false);
        layout.marginHeight = 1;
        layout.marginWidth = 2;
        this.fImageComposite.setLayout((Layout)layout);
        this.installFocusComposite(this.fImageComposite);
        this.addElementListener((Control)this.fImageComposite);
        this.fElementImage = new Label(this.fImageComposite, 0);
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        this.fElementImage.setLayoutData((Object)layoutData);
        this.addElementListener((Control)this.fElementImage);
        this.fTextComposite = new Composite(this.fDetailComposite, 0);
        this.fTextComposite.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        layout = new GridLayout(1, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.fTextComposite.setLayout((Layout)layout);
        this.addElementListener((Control)this.fTextComposite);
        this.fTextComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (BreadcrumbItemDetails.this.fHasFocus && BreadcrumbItemDetails.this.isTextVisible()) {
                    e.gc.drawFocus(e.x, e.y, e.width, e.height);
                }
            }
        });
        this.installFocusComposite(this.fTextComposite);
        this.addElementListener((Control)this.fTextComposite);
        this.fElementText = new Label(this.fTextComposite, 0);
        layoutData = new GridData(1, 0x1000000, false, false);
        this.fElementText.setLayoutData((Object)layoutData);
        this.addElementListener((Control)this.fElementText);
        this.fTextComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BreadcrumbItemDetails.this.fElementText.getText();
            }
        });
        this.fImageComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BreadcrumbItemDetails.this.fElementText.getText();
            }
        });
        this.fDetailComposite.setTabList(new Control[]{this.fTextComposite});
    }

    public void setToolTip(String text) {
        if (this.isTextVisible()) {
            this.fElementText.getParent().setToolTipText(text);
            this.fElementText.setToolTipText(text);
            this.fElementImage.setToolTipText(text);
        } else {
            this.fElementText.getParent().setToolTipText(null);
            this.fElementText.setToolTipText(null);
            this.fElementImage.setToolTipText(text);
        }
    }

    public void setImage(Image image) {
        if (image != this.fElementImage.getImage()) {
            this.fElementImage.setImage(image);
        }
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.fElementText.getText())) {
            this.fElementText.setText(text);
        }
    }

    public int getWidth() {
        int result = 2;
        if (this.fElementImage.getImage() != null) {
            result += this.fElementImage.computeSize((int)-1, (int)-1).x;
        }
        if (this.fTextVisible && this.fElementText.getText().length() > 0) {
            result += this.fElementText.computeSize((int)-1, (int)-1).x;
        }
        return result;
    }

    public void setTextVisible(boolean enabled) {
        if (this.fTextVisible == enabled) {
            return;
        }
        this.fTextVisible = enabled;
        GridData data = (GridData)this.fTextComposite.getLayoutData();
        data.exclude = !enabled;
        this.fTextComposite.setVisible(enabled);
        if (this.fTextVisible) {
            this.fDetailComposite.setTabList(new Control[]{this.fTextComposite});
        } else {
            this.fDetailComposite.setTabList(new Control[]{this.fImageComposite});
        }
        this.updateSelection();
    }

    public boolean isTextVisible() {
        return this.fTextVisible;
    }

    public void setVisible(boolean visible) {
        this.fDetailComposite.setVisible(visible);
        GridData data = (GridData)this.fDetailComposite.getLayoutData();
        data.exclude = !visible;
    }

    public void setSelected(boolean selected) {
        if (selected == this.fSelected) {
            return;
        }
        this.fSelected = selected;
        this.updateSelection();
    }

    private void updateSelection() {
        Color foreground;
        Color background;
        if (this.fSelected && this.fHasFocus) {
            background = Display.getDefault().getSystemColor(26);
            foreground = Display.getDefault().getSystemColor(27);
        } else {
            foreground = null;
            background = null;
        }
        if (this.isTextVisible()) {
            this.fTextComposite.setBackground(background);
            this.fElementText.setBackground(background);
            this.fElementText.setForeground(foreground);
            this.fImageComposite.setBackground(null);
            this.fElementImage.setBackground(null);
        } else {
            this.fImageComposite.setBackground(background);
            this.fElementImage.setBackground(background);
            this.fTextComposite.setBackground(null);
            this.fElementText.setBackground(null);
            this.fElementText.setForeground(null);
        }
        this.fTextComposite.redraw();
        this.fImageComposite.redraw();
    }

    private void installFocusComposite(Composite composite) {
        composite.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    int index = BreadcrumbItemDetails.this.fParent.getViewer().getIndexOfItem(BreadcrumbItemDetails.this.fParent);
                    index = e.detail == 16 ? ++index : --index;
                    if (index > 0 && index < BreadcrumbItemDetails.this.fParent.getViewer().getItemCount()) {
                        BreadcrumbItemDetails.this.fParent.getViewer().selectItem(BreadcrumbItemDetails.this.fParent.getViewer().getItem(index));
                    }
                    e.doit = true;
                }
            }
        });
        composite.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.fParent.getViewer();
                switch (e.keyCode) {
                    case 0x1000003: {
                        if (BreadcrumbItemDetails.this.fSelected) {
                            viewer.doTraverse(false);
                            e.doit = false;
                            break;
                        }
                        viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        break;
                    }
                    case 0x1000004: {
                        if (BreadcrumbItemDetails.this.fSelected) {
                            viewer.doTraverse(true);
                            e.doit = false;
                            break;
                        }
                        viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        break;
                    }
                    case 0x1000002: {
                        if (!BreadcrumbItemDetails.this.fSelected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        }
                        this.openDropDown();
                        e.doit = false;
                        break;
                    }
                    case 16777259: {
                        if (!BreadcrumbItemDetails.this.fSelected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        }
                        this.openDropDown();
                        e.doit = false;
                        break;
                    }
                    case 13: {
                        if (!BreadcrumbItemDetails.this.fSelected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        }
                        viewer.fireOpen();
                        break;
                    }
                    default: {
                        if (e.character != ' ') break;
                        if (!BreadcrumbItemDetails.this.fSelected) {
                            viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                        }
                        this.openDropDown();
                        e.doit = false;
                    }
                }
            }

            private void openDropDown() {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.fParent.getViewer();
                int index = viewer.getIndexOfItem(BreadcrumbItemDetails.this.fParent);
                BreadcrumbItem parent = BreadcrumbItemDetails.this.fParent.getViewer().getItem(index - 1);
                Shell shell = parent.getDropDownShell();
                if (shell == null) {
                    parent.openDropDownMenu();
                    shell = parent.getDropDownShell();
                }
                shell.setFocus();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void addElementListener(Control control) {
        control.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                BreadcrumbItemDetails.this.fHasFocus = false;
                BreadcrumbItemDetails.this.updateSelection();
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.fParent.getViewer();
                viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                viewer.fireDoubleClick();
            }

            public void mouseDown(MouseEvent e) {
                BreadcrumbItemDetails.this.fHasFocus = true;
                BreadcrumbItemDetails.this.updateSelection();
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.fParent.getViewer();
                viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                viewer.fireOpen();
            }

            public void mouseUp(MouseEvent e) {
                Display.getDefault().timerExec(100, new Runnable(){

                    @Override
                    public void run() {
                        (this).BreadcrumbItemDetails.this.fHasFocus = false;
                        BreadcrumbItemDetails.this.updateSelection();
                    }
                });
            }
        });
        control.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                BreadcrumbViewer viewer = BreadcrumbItemDetails.this.fParent.getViewer();
                viewer.selectItem(BreadcrumbItemDetails.this.fParent);
                BreadcrumbItemDetails.this.fParent.getViewer().fireMenuDetect(e);
            }
        });
    }
}

