/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.LayoutModuleHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetHandleAdapter;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.elements.interfaces.IReportDesignModel;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.StyleUtil;

class ReportDesignHandleImpl
extends LayoutModuleHandle
implements IReportDesignModel {
    public ReportDesignHandleImpl(ReportDesign design) {
        super(design);
    }

    public String getAfterFactory() {
        return this.getStringProperty("afterFactory");
    }

    public String getAfterRender() {
        return this.getStringProperty("afterRender");
    }

    public String getBase() {
        return this.module.getStringProperty(this.module, "base");
    }

    public String getBeforeFactory() {
        return this.getStringProperty("beforeFactory");
    }

    public String getBeforeRender() {
        return this.getStringProperty("beforeRender");
    }

    public SlotHandle getBody() {
        return this.getSlot(6);
    }

    public int getRefreshRate() {
        return this.getIntProperty("refreshRate");
    }

    public SlotHandle getScratchPad() {
        return this.getSlot(7);
    }

    public Iterator includeLibraryScriptsIterator() {
        List<Library> libList = this.module.getAllLibraries();
        ArrayList includeLibScriptList = new ArrayList();
        if (libList != null) {
            for (Library lib : libList) {
                PropertyHandle propHandle = lib.getHandle(lib).getPropertyHandle("includeScripts");
                Iterator scriptIter = propHandle.iterator();
                while (scriptIter.hasNext()) {
                    includeLibScriptList.add(scriptIter.next());
                }
            }
        }
        return includeLibScriptList.iterator();
    }

    public void setAfterFactory(String value) {
        block2: {
            try {
                this.setStringProperty("afterFactory", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setAfterRender(String value) {
        block2: {
            try {
                this.setStringProperty("afterRender", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBase(String base) {
        block2: {
            try {
                this.setProperty("base", base);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBeforeFactory(String value) {
        block2: {
            try {
                this.setStringProperty("beforeFactory", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBeforeRender(String value) {
        block2: {
            try {
                this.setStringProperty("beforeRender", value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setRefreshRate(int rate) {
        block2: {
            try {
                this.setIntProperty("refreshRate", rate);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public List<CssStyleSheetHandle> getAllCssStyleSheets() {
        ReportDesign design = (ReportDesign)this.getElement();
        ArrayList<CssStyleSheetHandle> allStyles = new ArrayList<CssStyleSheetHandle>();
        List<CssStyleSheet> csses = design.getCsses();
        for (CssStyleSheet sheet : csses) {
            allStyles.add(sheet.handle(this.getModule()));
        }
        return allStyles;
    }

    @Override
    public void importCssStyles(CssStyleSheetHandle stylesheet, List selectedStyles) {
        if (stylesheet == null || selectedStyles == null || selectedStyles.isEmpty()) {
            return;
        }
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ImportCSSStyles"));
        for (Object selectedStyle : selectedStyles) {
            SharedStyleHandle newStyle;
            SharedStyleHandle style;
            if (!(selectedStyle instanceof SharedStyleHandle) || stylesheet.findStyle((style = (SharedStyleHandle)selectedStyle).getName()) == null || (newStyle = StyleUtil.transferCssStyleToSharedStyle(this.module, style)) == null) continue;
            this.module.makeUniqueName(newStyle.getElement());
            try {
                this.addElement(newStyle, 0);
            }
            catch (ContentException | NameException e) {
                assert (false);
            }
        }
        stack.commit();
    }

    public void setDisplayNameKey(String displayNameKey) throws SemanticException {
        this.setStringProperty("displayNameID", displayNameKey);
    }

    public String getDisplayNameKey() {
        return this.getStringProperty("displayNameID");
    }

    public void setDisplayName(String displayName) throws SemanticException {
        this.setStringProperty("displayName", displayName);
    }

    public String getDisplayName() {
        return this.getStringProperty("displayName");
    }

    public void setIconFile(String iconFile) throws SemanticException {
        this.setStringProperty("iconFile", iconFile);
    }

    public String getIconFile() {
        return this.getStringProperty("iconFile");
    }

    public void setCheatSheet(String cheatSheet) throws SemanticException {
        this.setStringProperty("cheatSheet", cheatSheet);
    }

    public String getCheatSheet() {
        return this.getStringProperty("cheatSheet");
    }

    public void setThumbnail(byte[] data) throws SemanticException {
        String toSet;
        block3: {
            toSet = null;
            try {
                if (data != null) {
                    toSet = new String(data, "8859_1");
                }
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        this.setStringProperty("thumbnail", toSet);
    }

    public byte[] getThumbnail() {
        return ((ReportDesign)this.module).getThumbnail();
    }

    public void deleteThumbnail() throws SemanticException {
        this.clearProperty("thumbnail");
    }

    public List<String> getAllBookmarks() {
        List<Object> bookmarks = ((ReportDesign)this.module).collectPropValues(6, "bookmark");
        ArrayList<String> resultList = new ArrayList<String>();
        for (Expression expression : bookmarks) {
            resultList.add(expression.getStringExpression());
        }
        return resultList;
    }

    public List<String> getAllTocs() {
        List<Object> tocs = ((ReportDesign)this.module).collectPropValues(6, "toc");
        ArrayList<String> resultList = new ArrayList<String>();
        for (TOC tOC : tocs) {
            resultList.add(tOC.getStringProperty(this.module, "expressionValue"));
        }
        return resultList;
    }

    public List<DesignElementHandle> getReportItemsBasedonTempalates() {
        ArrayList<DesignElementHandle> rtnList = new ArrayList<DesignElementHandle>();
        ArrayList<DesignElement> tempList = new ArrayList<DesignElement>();
        List<DesignElement> contents = new ContainerContext(this.getElement(), 6).getContents(this.module);
        contents.addAll(new ContainerContext(this.getElement(), 4).getContents(this.module));
        this.findTemplateItemIn(contents.iterator(), tempList);
        Iterator<DesignElement> iter = tempList.iterator();
        while (iter.hasNext()) {
            rtnList.add(iter.next().getHandle(this.module));
        }
        return Collections.unmodifiableList(rtnList);
    }

    private void findTemplateItemIn(Iterator<?> contents, List<DesignElement> addTo) {
        while (contents.hasNext()) {
            DesignElement e = (DesignElement)contents.next();
            if (e.isTemplateParameterValue(this.module)) {
                addTo.add(e);
                continue;
            }
            LevelContentIterator children = new LevelContentIterator(this.module, e, 1);
            this.findTemplateItemIn(children, addTo);
        }
    }

    @Override
    public SlotHandle getCubes() {
        return this.getSlot(9);
    }

    public String getLayoutPreference() {
        return this.getStringProperty("layoutPreference");
    }

    public void setLayoutPreference(String layout) throws SemanticException {
        this.setStringProperty("layoutPreference", layout);
    }

    public Iterator includeCssesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("cssStyleSheets");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    @Deprecated
    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByFileName(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findIncludedCssStyleSheetHandleByFileName(fileName);
    }

    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findIncludedCssStyleSheetHandleByProperties(fileName, externalCssURI, useExternalCss);
    }

    @Deprecated
    public CssStyleSheetHandle findCssStyleSheetHandleByFileName(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findCssStyleSheetHandleByFileName(fileName);
    }

    public CssStyleSheetHandle findCssStyleSheetHandleByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findCssStyleSheetHandleByProperties(fileName, externalCssURI, useExternalCss);
    }

    public void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(sheetHandle);
    }

    @Deprecated
    public void addCss(String fileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(fileName);
    }

    public void addCssByProperties(String fileName, String externalCssURI, boolean useExternalCss) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCssbyProperties(fileName, externalCssURI, useExternalCss);
    }

    public void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        if (cssStruct == null) {
            return;
        }
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(cssStruct);
    }

    @Deprecated
    public void renameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.renameCss(handle, newFileName);
    }

    public void renameCssByProperties(IncludedCssStyleSheetHandle handle, String fileName, String externalCssURI, boolean useExternalCss) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.renameCssByProperties(handle, fileName, externalCssURI, useExternalCss);
    }

    @Deprecated
    public boolean canRenameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canRenameCss(handle, newFileName);
    }

    public boolean canRenameCssByProperties(IncludedCssStyleSheetHandle handle, String fileName, String externalCssURI, boolean useExternalCss) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canRenameCssByProperties(handle, fileName, externalCssURI, useExternalCss);
    }

    public void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.dropCss(sheetHandle);
    }

    public boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canDropCssStyleSheet(sheetHandle);
    }

    public boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(sheetHandle);
    }

    @Deprecated
    public boolean canAddCssStyleSheet(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(fileName);
    }

    public boolean canAddCssStyleSheetByProperties(String fileName, String externalCssURI, boolean useExternalCss) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheetByProperties(fileName, externalCssURI, useExternalCss);
    }

    public void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.reloadCss(sheetHandle);
    }

    public String getBidiOrientation() {
        return this.getStringProperty("bidiLayoutOrientation");
    }

    public void setBidiOrientation(String bidiOrientation) throws SemanticException {
        this.setStringProperty("bidiLayoutOrientation", bidiOrientation);
    }

    @Override
    public boolean isDirectionRTL() {
        return "rtl".equals(this.getBidiOrientation());
    }

    public boolean isEnableACL() {
        return this.getBooleanProperty("enableACL");
    }

    public void setEnableACL(boolean enableACL) throws SemanticException {
        this.setBooleanProperty("enableACL", enableACL);
    }

    public String getACLExpression() {
        return this.getStringProperty("ACLExpression");
    }

    public void setACLExpression(String expr) throws SemanticException {
        this.setStringProperty("ACLExpression", expr);
    }

    public boolean cascadeACL() {
        return this.getBooleanProperty("cascadeACL");
    }

    public void setCascadeACL(boolean cascadeACL) throws SemanticException {
        this.setBooleanProperty("cascadeACL", cascadeACL);
    }

    public int getImageDPI() {
        return this.getIntProperty("imageDPI");
    }

    public void setImageDPI(int imageDPI) throws SemanticException {
        this.setIntProperty("imageDPI", imageDPI);
    }

    public String getOnPageStart() {
        return this.getStringProperty("onPageStart");
    }

    public void setOnPageStart(String onPageStart) throws SemanticException {
        this.setStringProperty("onPageStart", onPageStart);
    }

    public String getOnPageEnd() {
        return this.getStringProperty("onPageEnd");
    }

    public void setOnPageEnd(String onPageEnd) throws SemanticException {
        this.setStringProperty("onPageEnd", onPageEnd);
    }

    public List<VariableElementHandle> getPageVariables() {
        return this.getListProperty("pageVariables");
    }

    public VariableElementHandle getPageVariable(String pageVariableName) {
        if (pageVariableName == null) {
            return null;
        }
        VariableElement element = ((ReportDesign)this.module).findVariableElement(pageVariableName);
        if (element == null) {
            return null;
        }
        return element.handle(this.module);
    }

    public void setPageVariable(String pageVariableName, Expression value) throws SemanticException {
        if (pageVariableName == null) {
            return;
        }
        VariableElementHandle handle = this.getPageVariable(pageVariableName);
        if (handle == null) {
            ElementFactory factory = this.getElementFactory();
            handle = factory.newVariableElement();
            handle.setVariableName(pageVariableName);
            handle.setExpressionProperty("value", value);
            this.add("pageVariables", handle);
            return;
        }
        handle.setExpressionProperty("value", value);
    }

    public void addVariable(VariableElementHandle variable) throws SemanticException {
        this.add("dataObjects", variable);
    }

    public void dropVariable(VariableElementHandle variable) throws SemanticException {
        variable.drop();
    }

    public List<VariableElementHandle> getAllVariables() {
        PropertyHandle propHandle = this.getPropertyHandle("dataObjects");
        if (propHandle == null) {
            return Collections.emptyList();
        }
        return propHandle.getListValue();
    }

    public ULocale getLocale() {
        return (ULocale)this.getProperty("locale");
    }

    public void setLocale(ULocale locale) throws SemanticException {
        this.setProperty("locale", locale);
    }

    public List<IncludedCssStyleSheetHandle> getAllExternalIncludedCsses() {
        List libs;
        ArrayList<IncludedCssStyleSheetHandle> ret = new ArrayList<IncludedCssStyleSheetHandle>();
        List values = this.getNativeStructureList("cssStyleSheets");
        if (values != null && !values.isEmpty()) {
            for (IncludedCssStyleSheetHandle sheetHandle : values) {
                if (sheetHandle.getExternalCssURI() == null && !sheetHandle.isUseExternalCss()) continue;
                ret.add(sheetHandle);
            }
        }
        ArrayList<ThemeHandle> themeList = new ArrayList<ThemeHandle>();
        ThemeHandle themeHandle = this.getTheme();
        if (themeHandle != null) {
            themeList.add(themeHandle);
        }
        if ((libs = this.getAllLibraries()) != null) {
            for (LibraryHandle libHandle : libs) {
                themeHandle = libHandle.getTheme();
                if (themeHandle == null || themeList.contains(themeHandle)) continue;
                themeList.add(themeHandle);
            }
        }
        int i = 0;
        while (i < themeList.size()) {
            themeHandle = (ThemeHandle)themeList.get(i);
            Iterator iter = themeHandle.getPropertyHandle("cssStyleSheets").iterator();
            while (iter.hasNext()) {
                IncludedCssStyleSheetHandle sheetHandle = (IncludedCssStyleSheetHandle)iter.next();
                if (sheetHandle.getExternalCssURI() == null && !sheetHandle.isUseExternalCss()) continue;
                ret.add(sheetHandle);
            }
            ++i;
        }
        return ret;
    }

    public synchronized void cacheValues() {
        this.module.cacheValues();
    }

    public DesignElementHandle getFlattenElement(DesignElementHandle elementHandle, String originalName) {
        IDesignElement flatternElement = null;
        if (elementHandle != null) {
            flatternElement = ((ReportDesign)this.module).getFlattenElement(elementHandle.getElement(), originalName);
        }
        if (flatternElement != null) {
            return flatternElement.getHandle(this.module);
        }
        return null;
    }

    public String getOnPrepare() {
        return this.getStringProperty("onPrepare");
    }

    public void setOnPrepare(String script) throws SemanticException {
        this.setProperty("onPrepare", script);
    }

    public String getClientInitialize() {
        return this.getStringProperty("clientInitialize");
    }

    public void setClientInitialize(String script) throws SemanticException {
        this.setProperty("clientInitialize", script);
    }

    public String getLanguage() {
        return this.getStringProperty("language");
    }

    public void setLanguage(String language) throws SemanticException {
        this.setProperty("language", language);
    }

    public boolean getExcelForceAutoColWidths() {
        return this.getBooleanProperty("excelForceAutoColWidths");
    }

    public void setExcelForceAutoColWidths(boolean forceAutoColWidths) throws SemanticException {
        this.setBooleanProperty("excelForceAutoColWidths", forceAutoColWidths);
    }

    public boolean getExcelSingleSheet() {
        return this.getBooleanProperty("excelSingleSheet");
    }

    public void setExcelSingleSheet(boolean singleSheet) throws SemanticException {
        this.setBooleanProperty("excelSingleSheet", singleSheet);
    }

    public boolean getExcelDisableGrouping() {
        return this.getBooleanProperty("excelDisableGrouping");
    }

    public void setExcelDisableGrouping(boolean disableGrouping) throws SemanticException {
        this.setBooleanProperty("excelDisableGrouping", disableGrouping);
    }

    public boolean getExcelDisplayGridlines() {
        return this.getBooleanProperty("excelDisplayGridlines");
    }

    public void setExcelDisplayGridlines(boolean displayGridlines) throws SemanticException {
        this.setBooleanProperty("excelDisplayGridlines", displayGridlines);
    }

    public boolean getExcelAutoFilter() {
        return this.getBooleanProperty("excelAutoFilter");
    }

    public void setExcelAutoFilter(boolean enableAutoFilter) throws SemanticException {
        this.setBooleanProperty("excelAutoFilter", enableAutoFilter);
    }

    public boolean getExcelForceRecalculation() {
        return this.getBooleanProperty("excelForceRecalculation");
    }

    public void setExcelForceRecalculation(boolean forceRecalculation) throws SemanticException {
        this.setBooleanProperty("excelForceRecalculation", forceRecalculation);
    }

    public boolean getExcelImageScaling() {
        return this.getBooleanProperty("excelImageScalingToCellDimension");
    }

    public void setExcelImageScaling(boolean enableImageScaling) throws SemanticException {
        this.setBooleanProperty("excelImageScalingToCellDimension", enableImageScaling);
    }

    public boolean getExcelSingleSheetPageBreak() {
        return this.getBooleanProperty("excelSingleSheetWithPageBreaks");
    }

    public void setExcelSingleSheetPageBreak(boolean singleSheetPageBreak) throws SemanticException {
        this.setBooleanProperty("excelSingleSheetWithPageBreaks", singleSheetPageBreak);
    }

    public boolean getExcelStreamingXlsx() {
        return this.getBooleanProperty("excelStreamingXlsx");
    }

    public void setExcelStreamingXlsx(boolean streamingXlsx) throws SemanticException {
        this.setBooleanProperty("excelStreamingXlsx", streamingXlsx);
    }

    public boolean getExcelStructuredHeader() {
        return this.getBooleanProperty("excelStructuredHeader");
    }

    public void setExcelStructuredHeader(boolean structuredHeader) throws SemanticException {
        this.setBooleanProperty("excelStructuredHeader", structuredHeader);
    }

    public int getExcelPrintPagesWide() {
        return this.getIntProperty("excelPrintPagesWide");
    }

    public void setExcelPrintPagesWide(int printPagesWide) throws SemanticException {
        this.setIntProperty("excelPrintPagesWide", printPagesWide);
    }

    public int getExcelPrintPagesHigh() {
        return this.getIntProperty("excelPrintPagesHigh");
    }

    public void setExcelPrintPagesHigh(int printPagesHigh) throws SemanticException {
        this.setIntProperty("excelPrintPagesHigh", printPagesHigh);
    }

    public int getExcelPrintScale() {
        return this.getIntProperty("excelPrintScale");
    }

    public void setExcelPrintScale(int printScale) throws SemanticException {
        this.setIntProperty("excelPrintScale", printScale);
    }

    public String getExcelTemplateFile() {
        return this.getStringProperty("excelTemplateFile");
    }

    public void setExcelTemplateFile(String templateFile) throws SemanticException {
        this.setStringProperty("excelTemplateFile", templateFile);
    }

    public String getPdfVersion() {
        return this.getStringProperty("pdfVersion");
    }

    public void setPdfVersion(String pdfVersion) throws SemanticException {
        this.setStringProperty("pdfVersion", pdfVersion);
    }

    public String getPdfConformance() {
        return this.getStringProperty("pdfConformance");
    }

    public void setPdfConformance(String pdfConformance) throws SemanticException {
        this.setStringProperty("pdfConformance", pdfConformance);
    }

    public String getPdfUAConformance() {
        return this.getStringProperty("pdfUAConformance");
    }

    public void setPdfUAConformance(String pdfUAConformance) throws SemanticException {
        this.setStringProperty("pdfUAConformance", pdfUAConformance);
    }

    public String getPdfIccColorType() {
        return this.getStringProperty("pdfIccColorType");
    }

    public void setPdfIccColorType(String iccColorType) throws SemanticException {
        this.setStringProperty("pdfIccColorType", iccColorType);
    }

    public String getPdfIccColorProfileExternal() {
        return this.getStringProperty("pdfIccProfileExternal");
    }

    public void setPdfIccColorProfileExternal(String iccProfileExternal) throws SemanticException {
        this.setStringProperty("pdfIccProfileExternal", iccProfileExternal);
    }

    public String getPdfDocumentsPrepend() {
        return this.getStringProperty("pdfDocuemntPrepend");
    }

    public void setPdfDocumentsPrepend(String prependDocuments) throws SemanticException {
        this.setStringProperty("pdfDocuemntPrepend", prependDocuments);
    }

    public String getPdfDocumentsAppend() {
        return this.getStringProperty("pdfDocuemntAppend");
    }

    public void setPdfDocumentsAppend(String appendDocuments) throws SemanticException {
        this.setStringProperty("pdfDocuemntAppend", appendDocuments);
    }

    public String getPdfAFontFallback() {
        return this.getStringProperty("pdfaFontFallback");
    }

    public void setPdfAFontFallback(String pdfaFontFallback) throws SemanticException {
        this.setStringProperty("pdfaFontFallback", pdfaFontFallback);
    }

    public String getPdfFontCidEmbed() {
        return this.getStringProperty("pdfaFontCidEmbed");
    }

    public void setPdfFontCidEmbed(String embedCID) throws SemanticException {
        this.setStringProperty("pdfaFontCidEmbed", embedCID);
    }

    public String getPdfAEmbedTitle() {
        return this.getStringProperty("pdfaDocumentTitleEmbed");
    }

    public void setPdfAEmbedTitle(boolean embedTitle) throws SemanticException {
        this.setBooleanProperty("pdfaDocumentTitleEmbed", embedTitle);
    }

    public boolean getWordCombineMarginPadding() {
        return this.getBooleanProperty("wordCombineMarginPadding");
    }

    public void setWordCombineMarginPadding(boolean combineMarginPadding) throws SemanticException {
        this.setBooleanProperty("wordCombineMarginPadding", combineMarginPadding);
    }

    public boolean getWordListCellAddEmptyPara() {
        return this.getBooleanProperty("wordAddEmptyParagraphForListCell");
    }

    public void setWordListCellAddEmptyPara(boolean addEmptyPara) throws SemanticException {
        this.setBooleanProperty("wordAddEmptyParagraphForListCell", addEmptyPara);
    }

    public boolean getWordWrapTableForMarginPadding() {
        return this.getBooleanProperty("wordWrappedTableForMarginPadding");
    }

    public void setWordWrapTableForMarginPadding(boolean wrapTable) throws SemanticException {
        this.setBooleanProperty("wordWrappedTableForMarginPadding", wrapTable);
    }

    public boolean getWordWrapTableForHeaderFooter() {
        return this.getBooleanProperty("wordWrappedTableHeaderFooter");
    }

    public void setWordWrapTableForHeaderFooter(boolean wrapTable) throws SemanticException {
        this.setBooleanProperty("wordWrappedTableHeaderFooter", wrapTable);
    }
}

