/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.util.ReportDesignSerializer;
import org.eclipse.birt.report.model.writer.DocumentWriter;

public class DocumentUtil {
    public static ReportDesignHandle serialize(ReportDesignHandle designHandle, OutputStream out) throws IOException {
        assert (out != null);
        if (designHandle == null) {
            return null;
        }
        ReportDesign source = (ReportDesign)designHandle.getModule();
        List list = (List)source.getLocalProperty(source.getRoot(), "libraries");
        if (list == null || list.size() == 0) {
            Module copy = (Module)designHandle.copy();
            ReportDesign clonedDesign = (ReportDesign)copy;
            new DocumentWriter(clonedDesign).write(out);
            return clonedDesign.handle();
        }
        ReportDesign target = DocumentUtil.localizeDesign(source);
        assert (target != null);
        new DocumentWriter(target).write(out);
        return target.handle();
    }

    static ReportDesign localizeDesign(ReportDesign source) {
        assert (source != null);
        ReportDesignSerializer visitor = new ReportDesignSerializer();
        source.apply(visitor);
        return visitor.getTarget();
    }
}

