/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.ClientIterator;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.ContentElementHandle;
import org.eclipse.birt.report.model.api.DerivedElementIterator;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FactoryElementHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PrivateStyleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.PropertyIterator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.UserPropertyDefnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.api.command.TemplateException;
import org.eclipse.birt.report.model.api.command.UserPropertyException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.XPathUtil;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.EncryptionCommand;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.NameCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.TemplateCommand;
import org.eclipse.birt.report.model.command.UserPropertyCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.MultiViews;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public abstract class DesignElementHandle
implements IDesignElementModel {
    protected final Module module;
    private SlotHandle[] slotHandles = null;
    private Map<String, PropertyHandle> propHandles = new HashMap<String, PropertyHandle>();

    public DesignElementHandle(Module module) {
        this.module = module;
    }

    protected final void initializeSlotHandles() {
        int slotCount = this.getDefn().getSlotCount();
        if (slotCount == 0) {
            return;
        }
        Iterator<ISlotDefn> iter1 = ((ElementDefn)this.getDefn()).slotsIterator();
        if (this.slotHandles == null) {
            this.slotHandles = new SlotHandle[slotCount];
            int i = 0;
            while (i < slotCount) {
                this.slotHandles[i] = new SlotHandle(this, iter1.next().getSlotID());
                ++i;
            }
        }
    }

    protected void cachePropertyHandles() {
        List<IElementPropertyDefn> contents = this.getElement().getPropertyDefns();
        int i = 0;
        while (i < contents.size()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)contents.get(i);
            if (propDefn.isElementType()) {
                PropertyHandle pHandle = new PropertyHandle(this, propDefn);
                this.propHandles.put(propDefn.getName(), pHandle);
            }
            ++i;
        }
    }

    @Deprecated
    public ReportDesign getDesign() {
        if (this.module instanceof ReportDesign) {
            return (ReportDesign)this.module;
        }
        return null;
    }

    public Module getModule() {
        return this.module;
    }

    @Deprecated
    public ReportDesignHandle getDesignHandle() {
        if (this.getDesign() != null) {
            return (ReportDesignHandle)this.getDesign().getHandle(this.module);
        }
        return null;
    }

    public ModuleHandle getModuleHandle() {
        return (ModuleHandle)this.getModule().getHandle(this.getModule());
    }

    public abstract DesignElement getElement();

    public IElementDefn getDefn() {
        return this.getElement().getDefn();
    }

    public Object getProperty(String propName) {
        DesignElement element = this.getElement();
        Object value = element.getProperty(this.module, propName);
        PropertyDefn defn = (PropertyDefn)((Object)this.getPropertyDefn(propName));
        return ModelUtil.wrapPropertyValue(this.module, defn, value);
    }

    public String getStringProperty(String propName) {
        return this.getElement().getStringProperty(this.module, propName);
    }

    public String getDisplayProperty(String propName) {
        return this.getElement().getDisplayProperty(this.module, propName);
    }

    public boolean getBooleanProperty(String propName) {
        return this.getElement().getBooleanProperty(this.module, propName);
    }

    public int getIntProperty(String propName) {
        return this.getElement().getIntProperty(this.module, propName);
    }

    public double getFloatProperty(String propName) {
        return this.getElement().getFloatProperty(this.module, propName);
    }

    public BigDecimal getNumberProperty(String propName) {
        return this.getElement().getNumberProperty(this.module, propName);
    }

    public DimensionHandle getDimensionProperty(String propName) {
        ElementPropertyDefn propDefn = this.getElement().getPropertyDefn(propName);
        if (propDefn == null || propDefn.getTypeCode() != 3) {
            return null;
        }
        return new DimensionHandle(this, propDefn);
    }

    public ColorHandle getColorProperty(String propName) {
        ElementPropertyDefn propDefn = this.getElement().getPropertyDefn(propName);
        if (propDefn == null || propDefn.getTypeCode() != 4) {
            return null;
        }
        return new ColorHandle(this, propDefn);
    }

    protected FontHandle getFontProperty() {
        ElementPropertyDefn propDefn = this.getElement().getPropertyDefn("fontFamily");
        if (propDefn == null) {
            return null;
        }
        return new FontHandle(this);
    }

    public DesignElementHandle getElementProperty(String propName) {
        DesignElement target = this.getElement().getReferenceProperty(this.module, propName);
        if (target == null) {
            return null;
        }
        return target.getHandle(target.getRoot());
    }

    @Deprecated
    public List getListProperty(Module module, String propName) {
        return this.getElement().getListProperty(module, propName);
    }

    public List getListProperty(String propName) {
        PropertyHandle propHandle = this.getPropertyHandle(propName);
        return propHandle == null ? null : propHandle.getListValue();
    }

    public void setProperty(String propName, Object value) throws SemanticException {
        DesignElement element = this.getElement();
        PropertyCommand cmd = new PropertyCommand(this.module, element);
        cmd.setProperty(propName, value);
    }

    public void setIntProperty(String propName, int value) throws SemanticException {
        this.setProperty(propName, value);
    }

    public void setStringProperty(String propName, String value) throws SemanticException {
        this.setProperty(propName, value);
    }

    public void setFloatProperty(String propName, double value) throws SemanticException {
        this.setProperty(propName, new Double(value));
    }

    public void setNumberProperty(String propName, BigDecimal value) throws SemanticException {
        this.setProperty(propName, value);
    }

    public void setBooleanProperty(String propName, boolean value) throws SemanticException {
        this.setProperty(propName, value);
    }

    public void clearProperty(String propName) throws SemanticException {
        this.setProperty(propName, null);
    }

    public void clearAllProperties() throws SemanticException {
        List<IElementPropertyDefn> props = this.getDefn().getProperties();
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ClearProperties"));
        try {
            int i = 0;
            while (i < props.size()) {
                block7: {
                    PropertyHandle propHandle;
                    PropertyDefn propDefn = (PropertyDefn)((Object)props.get(i));
                    String propName = propDefn.getName();
                    if ("name".equals(propName)) {
                        NameCommand nameCmd = new NameCommand(this.module, this.getElement());
                        try {
                            nameCmd.checkName(null);
                        }
                        catch (NameException e) {
                            break block7;
                        }
                    }
                    if ((propHandle = this.getPropertyHandle(propName)).isLocal()) {
                        propHandle.clearValue();
                    }
                }
                ++i;
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public boolean hasLocalProperties() {
        return this.getElement().hasLocalPropertyValues();
    }

    public void addUserPropertyDefn(UserPropertyDefn prop) throws UserPropertyException {
        DesignElement element = this.getElement();
        UserPropertyCommand cmd = new UserPropertyCommand(this.module, element);
        cmd.addUserProperty(prop);
    }

    public void addElement(DesignElementHandle child, int slotId, int pos) throws ContentException, NameException {
        SlotHandle slotHandle = this.getSlot(slotId);
        if (slotHandle != null) {
            slotHandle.add(child, pos);
        }
    }

    public void addElement(DesignElementHandle child, int slotId) throws ContentException, NameException {
        SlotHandle slotHandle = this.getSlot(slotId);
        if (slotHandle != null) {
            slotHandle.add(child);
        }
    }

    public List getMethods() {
        List<IElementPropertyDefn> methods = this.getElement().getDefn().getMethods();
        if (this.getElement().isInSlot(4)) {
            for (IElementPropertyDefn method : methods) {
                if (!"onPageBreak".equals(method.getName())) continue;
                methods.remove(method);
                break;
            }
        }
        return methods;
    }

    public void setProperties(Map properties) throws SemanticException {
        if (properties == null) {
            return;
        }
        for (Map.Entry entry : properties.entrySet()) {
            this.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public void clearContents(int slotId) throws SemanticException {
        SlotHandle slotHandle = this.getSlot(slotId);
        if (slotHandle == null) {
            return;
        }
        int i = slotHandle.getCount() - 1;
        while (i >= 0) {
            slotHandle.dropAndClear(i);
            --i;
        }
    }

    public void dropUserPropertyDefn(String propName) throws UserPropertyException {
        DesignElement element = this.getElement();
        UserPropertyCommand cmd = new UserPropertyCommand(this.module, element);
        cmd.dropUserProperty(propName);
    }

    public DesignElementHandle getExtends() {
        DesignElement parent = this.getElement().getExtendsElement();
        if (parent == null) {
            return null;
        }
        return parent.getHandle(parent.getRoot());
    }

    public void setExtends(DesignElementHandle parent) throws ExtendsException {
        ExtendsCommand cmd = new ExtendsCommand(this.module, this.getElement());
        cmd.setExtendsElement(parent);
    }

    public void setExtendsName(String name) throws ExtendsException {
        DesignElement element = this.getElement();
        ExtendsCommand cmd = new ExtendsCommand(this.module, element);
        cmd.setExtendsName(name);
    }

    public void localize() throws SemanticException {
        DesignElement element = this.getElement();
        ExtendsCommand cmd = new ExtendsCommand(this.module, element);
        cmd.localizeElement();
    }

    @Deprecated
    public void setExtendsElement(DesignElement parent) throws ExtendsException {
        ExtendsCommand cmd = new ExtendsCommand(this.module, this.getElement());
        cmd.setExtendsElement(parent);
    }

    public SharedStyleHandle getStyle() {
        StyleElement style = this.getElement().getStyle(this.module);
        if (style == null) {
            return null;
        }
        return (SharedStyleHandle)style.getHandle(this.module);
    }

    public void setStyleName(String name) throws StyleException {
        DesignElement element = this.getElement();
        StyleCommand cmd = new StyleCommand(this.module, element);
        cmd.setStyle(name);
    }

    @Deprecated
    public void setStyleElement(StyleElement obj) throws StyleException {
        DesignElement element = this.getElement();
        StyleCommand cmd = new StyleCommand(this.module, element);
        cmd.setStyleElement(obj);
    }

    public void setStyle(SharedStyleHandle style) throws StyleException {
        if (style == null) {
            this.setStyleElement(null);
        } else {
            this.setStyleElement((StyleElement)style.getElement());
        }
    }

    public StyleHandle getPrivateStyle() {
        if (this.getDefn().hasStyle()) {
            return new PrivateStyleHandle(this.module, this.getElement());
        }
        return null;
    }

    public String getName() {
        return this.getElement().getName();
    }

    public String getFullName() {
        return this.getElement().getFullName();
    }

    public String getQualifiedName() {
        String name = this.getElement().getFullName();
        if (name == null) {
            return null;
        }
        Module rootElement = this.getModule();
        assert (rootElement != null);
        String namespace = rootElement.getNamespace();
        return StringUtil.buildQualifiedReference(namespace, name);
    }

    public void setName(String name) throws NameException {
        NameCommand cmd = new NameCommand(this.module, this.getElement());
        cmd.setName(name);
    }

    public long getID() {
        return this.getElement().getID();
    }

    public ElementFactory getElementFactory() {
        return new ElementFactory(this.module);
    }

    public PropertyHandle getPropertyHandle(String propName) {
        if (propName == null) {
            return null;
        }
        DesignElement element = this.getElement();
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (propDefn == null) {
            return null;
        }
        if (propDefn.isElementType() && !(this instanceof ContentElementHandle)) {
            PropertyHandle propHandle = this.propHandles.get(propName);
            if (propHandle != null) {
                return propHandle;
            }
            this.cachePropertyHandles();
            return this.propHandles.get(propName);
        }
        return new PropertyHandle(this, propDefn);
    }

    public UserPropertyDefnHandle getUserPropertyDefnHandle(String propName) {
        DesignElement element = this.getElement();
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (propDefn == null) {
            return null;
        }
        if (propDefn.isUserProperty()) {
            return new UserPropertyDefnHandle(this, (UserPropertyDefn)propDefn);
        }
        return null;
    }

    public List getUserProperties() {
        return this.getElement().getUserProperties();
    }

    public FactoryPropertyHandle getFactoryPropertyHandle(String propName) {
        DesignElement element = this.getElement();
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (propDefn == null) {
            return null;
        }
        FactoryPropertyHandle handle = new FactoryPropertyHandle(this, propDefn);
        if (handle.isSet()) {
            return handle;
        }
        return null;
    }

    public DesignElementHandle getContainer() {
        DesignElement element = this.getElement().getContainer();
        if (element == null) {
            return null;
        }
        return element.getHandle(this.module);
    }

    public void moveTo(DesignElementHandle newContainer, int toSlot) throws ContentException {
        DesignElement element = this.getElement();
        DesignElement oldContainer = element.getContainer();
        if (oldContainer == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        ContentCommand cmd = new ContentCommand(this.module, element.getContainerInfo());
        cmd.move(element, new ContainerContext(newContainer.getElement(), toSlot));
    }

    public void dropAndClear() throws SemanticException {
        DesignElement element = this.getElement();
        DesignElement container = element.getContainer();
        if (container == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        ContentCommand cmd = new ContentCommand(this.module, element.getContainerInfo());
        cmd.remove(element);
    }

    public void drop() throws SemanticException {
        DesignElement element = this.getElement();
        DesignElement container = element.getContainer();
        if (container == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        ContentCommand cmd = new ContentCommand(this.module, element.getContainerInfo(), false, true);
        cmd.remove(element);
    }

    public int findContentSlot(DesignElementHandle content) {
        if (content.getContainer().getElement() == this.getElement()) {
            return content.getElement().getContainerInfo().getSlotID();
        }
        return -1;
    }

    public SlotHandle getContainerSlotHandle() {
        DesignElementHandle containerHandle = this.getContainer();
        if (containerHandle == null) {
            return null;
        }
        int slotID = containerHandle.findContentSlot(this);
        if (slotID == -1) {
            return null;
        }
        return containerHandle.getSlot(slotID);
    }

    public PropertyHandle getContainerPropertyHandle() {
        DesignElementHandle containerHandle = this.getContainer();
        if (containerHandle == null) {
            return null;
        }
        return containerHandle.getPropertyHandle(this.getElement().getContainerInfo().getPropertyName());
    }

    public SlotHandle getSlot(int slotID) {
        if (slotID < 0 || this.slotHandles == null) {
            return null;
        }
        int index = this.getElement().getSlotIndex(slotID);
        if (index == -1) {
            return null;
        }
        return this.slotHandles[index];
    }

    public Iterator<SlotHandle> slotsIterator() {
        if (this.slotHandles == null) {
            return Collections.emptyList().iterator();
        }
        return Arrays.asList(this.slotHandles).iterator();
    }

    public Iterator getPropertyIterator() {
        return new PropertyIterator(this);
    }

    public void addListener(Listener obj) {
        this.getElement().addListener(obj);
    }

    public void removeListener(Listener obj) {
        this.getElement().removeListener(obj);
    }

    public Iterator derivedIterator() {
        return new DerivedElementIterator(this.module, this);
    }

    public Iterator clientsIterator() {
        return new ClientIterator(this);
    }

    public IChoice[] getChoices(String propName) {
        PropertyHandle propertyHandle = this.getPropertyHandle(propName);
        if (propertyHandle == null) {
            return null;
        }
        return propertyHandle.getChoices();
    }

    public String getDisplayLabel() {
        return this.getDisplayLabel(1);
    }

    public String getDisplayLabel(int level) {
        assert (level == 0 || level == 1 || level == 2);
        return this.getElement().getDisplayLabel(this.module, level);
    }

    public static void doSort(List list) {
        Collections.sort(list, new Comparator<DesignElementHandle>(){

            @Override
            public int compare(DesignElementHandle arg0, DesignElementHandle arg1) {
                DesignElementHandle h1 = arg0;
                DesignElementHandle h2 = arg1;
                String s1 = h1.getDisplayLabel();
                String s2 = h2.getDisplayLabel();
                return s1.compareTo(s2);
            }
        });
    }

    public boolean isValid() {
        return this.getElement().isValid();
    }

    public boolean showError() {
        return this.hasSemanticError() || !this.isValid();
    }

    public void setValid(boolean isValid) {
        this.getElement().setValid(isValid);
    }

    public boolean hasSemanticError() {
        return !this.getSemanticErrors().isEmpty();
    }

    public IDesignElement copy() {
        try {
            return (DesignElement)this.getElement().clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public void copyPropertyTo(String propName, DesignElementHandle targetHandle) throws SemanticException {
        assert (targetHandle.getModule() == this.getModule());
        if (targetHandle.getModule() != this.getModule()) {
            throw new IllegalArgumentException("The target element should be in the same report !");
        }
        ElementPropertyDefn propDefn = (ElementPropertyDefn)this.getDefn().getProperty(propName);
        if (propDefn == null) {
            throw new PropertyNameException(this.getElement(), propName);
        }
        propDefn = (ElementPropertyDefn)targetHandle.getDefn().getProperty(propName);
        if (propDefn == null) {
            throw new PropertyNameException(targetHandle.getElement(), propName);
        }
        Object value = this.getElement().getLocalProperty(this.module, propDefn.getName());
        if (value == null) {
            targetHandle.setProperty(propName, null);
            return;
        }
        if ("name".equals(propName) || "extends".equals(propName)) {
            throw new SemanticError(this.getElement(), new String[]{propName}, "Error.SemanticError.PROPERTY_COPY_FORBIDDEN");
        }
        switch (propDefn.getTypeCode()) {
            case 15: {
                ElementRefValue refValue = (ElementRefValue)value;
                if (refValue.isResolved()) {
                    targetHandle.setProperty(propDefn.getName(), refValue.getElement());
                    break;
                }
                String name = refValue.getName();
                name = ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, this.getModule());
                targetHandle.setProperty(propDefn.getName(), name);
                break;
            }
            case 19: {
                StructRefValue structRefValue = (StructRefValue)value;
                if (structRefValue.isResolved()) {
                    targetHandle.setProperty(propDefn.getName(), structRefValue.getStructure());
                    break;
                }
                targetHandle.setProperty(propDefn.getName(), structRefValue.getName());
                break;
            }
            case 16: {
                if (propDefn.isList()) {
                    PropertyHandle propHandle = targetHandle.getPropertyHandle(propName);
                    for (Structure struct : (List)value) {
                        propHandle.addItem(struct.copy());
                    }
                    break;
                }
                IStructure struct = (IStructure)value;
                targetHandle.setProperty(propName, struct.copy());
                break;
            }
            case 20: {
                assert (value instanceof List);
                List valueList = (List)value;
                PropertyHandle propHandle = targetHandle.getPropertyHandle(propName);
                int i = 0;
                while (i < valueList.size()) {
                    Object item = valueList.get(i);
                    if (propDefn.getSubTypeCode() != 15) {
                        propHandle.addItem(item);
                    } else {
                        assert (item instanceof ElementRefValue);
                        ElementRefValue refValue = (ElementRefValue)item;
                        if (refValue.isResolved()) {
                            propHandle.addItem(refValue.getElement());
                        } else {
                            propHandle.addItem(refValue.getQualifiedReference());
                        }
                    }
                    ++i;
                }
                break;
            }
            default: {
                targetHandle.setProperty(propName, value);
            }
        }
    }

    public List semanticCheck() {
        List<Exception> exceptionList = this.getElement().validate(this.module);
        List<ErrorDetail> errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return errorDetailList;
    }

    public boolean canDrop() {
        return this.getElement().canDrop(this.getModule());
    }

    public boolean canEdit() {
        return this.getElement().canEdit(this.module);
    }

    public boolean canTransformToTemplate() {
        boolean flag = this.getElement().canTransformToTemplate(this.getModule());
        if (!flag) {
            return false;
        }
        return !this.getModule().isReadOnly();
    }

    public boolean canContain(int slotId, String type) {
        if (StringUtil.isBlank(type)) {
            return false;
        }
        SlotHandle slot = this.getSlot(slotId);
        if (slot == null) {
            return false;
        }
        return new ContainerContext(this.getElement(), slotId).canContain(this.getModule(), type);
    }

    public boolean canContain(int slotId, DesignElementHandle content) {
        if (content == null) {
            return false;
        }
        SlotHandle slot = this.getSlot(slotId);
        if (slot == null) {
            return false;
        }
        return new ContainerContext(this.getElement(), slotId).canContain(this.getModule(), content.getElement());
    }

    public boolean canContain(String propName, String type) {
        if (StringUtil.isBlank(type) || StringUtil.isBlank(propName)) {
            return false;
        }
        IElementPropertyDefn defn = this.getPropertyDefn(propName);
        if (defn == null) {
            return false;
        }
        return new ContainerContext(this.getElement(), propName).canContain(this.getModule(), type);
    }

    public boolean canContain(String propName, DesignElementHandle content) {
        if (content == null || StringUtil.isBlank(propName)) {
            return false;
        }
        IElementPropertyDefn defn = this.getPropertyDefn(propName);
        if (defn == null) {
            return false;
        }
        return new ContainerContext(this.getElement(), propName).canContain(this.module, content.getElement());
    }

    public List getSemanticErrors() {
        List<Exception> exceptionList = this.getElement().getErrors();
        if (exceptionList == null) {
            return Collections.EMPTY_LIST;
        }
        List<ErrorDetail> errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return ErrorDetail.getSemanticErrors(errorDetailList, "Error.DesignFileException.SEMANTIC_ERROR");
    }

    public ModuleHandle getRoot() {
        Module module = this.getElement().getRoot();
        if (module != null) {
            return (ModuleHandle)module.getHandle(module);
        }
        return null;
    }

    public String getXPath() {
        return XPathUtil.getXPath(this);
    }

    public String getEventHandlerClass() {
        return this.getStringProperty("eventHandlerClass");
    }

    public void setEventHandlerClass(String expr) throws SemanticException {
        this.setProperty("eventHandlerClass", expr);
    }

    public boolean newHandlerOnEachEvent() {
        return this.getBooleanProperty("newHandlerOnEachEvent");
    }

    public void setNewHandlerOnEachEvent(boolean newHandler) throws SemanticException {
        this.setBooleanProperty("newHandlerOnEachEvent", newHandler);
    }

    public TemplateElementHandle createTemplateElement(String name) throws SemanticException {
        if (this.getRoot() == null) {
            throw new TemplateException(this.getElement(), "Error.TemplateException.CREATE_TEMPLATE_ELEMENT_FORBIDDEN");
        }
        TemplateCommand cmd = new TemplateCommand(this.getModule(), this.getElement().getContainerInfo());
        TemplateElement template = cmd.createTemplateElement(this.getElement(), name);
        if (template == null) {
            return null;
        }
        return (TemplateElementHandle)template.getHandle(this.module);
    }

    public TemplateElementHandle revertToTemplate(String name) throws SemanticException {
        if (this.getRoot() == null) {
            throw new TemplateException(this.getElement(), "Error.TemplateException.CREATE_TEMPLATE_ELEMENT_FORBIDDEN");
        }
        TemplateCommand cmd = new TemplateCommand(this.getModule(), this.getElement().getContainerInfo());
        TemplateElement template = cmd.revertToTemplate(this.getElement(), name);
        if (template == null) {
            return null;
        }
        return (TemplateElementHandle)template.getHandle(this.module);
    }

    public void revertToReportItem() throws SemanticException {
        this.clearProperty("refTemplateParameter");
    }

    public boolean isTemplateParameterValue() {
        return this.getElement().isTemplateParameterValue(this.getModule());
    }

    public IElementPropertyDefn getPropertyDefn(String propName) {
        return this.getElement().getPropertyDefn(propName);
    }

    protected Module getEffectiveModule() {
        return this.module;
    }

    @Deprecated
    public String getPropertyBinding(String propName) {
        PropertyBinding propBinding = this.findPropertyBinding(propName);
        if (propBinding != null) {
            return propBinding.getValue();
        }
        return null;
    }

    public List getPropertyBindings() {
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<PropertyBinding> resultList = new ArrayList<PropertyBinding>();
        DesignElement element = this.getElement();
        while (element != null && element.getRoot() != null) {
            List<PropertyBinding> propBindings = element.getRoot().getPropertyBindings(element);
            resultList.addAll(this.filterPropertyBindingName(propBindings, nameList));
            element = element.isVirtualElement() ? element.getVirtualParent() : element.getExtendsElement();
        }
        return resultList;
    }

    private List<PropertyBinding> filterPropertyBindingName(List<PropertyBinding> propertyBindings, List<String> nameList) {
        if (propertyBindings == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PropertyBinding> resultList = new ArrayList<PropertyBinding>();
        for (PropertyBinding propBinding : propertyBindings) {
            String name = propBinding.getName();
            if (nameList.contains(name)) continue;
            resultList.add(propBinding);
            nameList.add(name);
        }
        return resultList;
    }

    @Deprecated
    public void setPropertyBinding(String propName, String value) throws SemanticException {
        this.setPropertyBinding(propName, (Object)value);
    }

    public String getExternalizedValue(String textIDProp, String textProp) {
        return ModelUtil.getExternalizedValue(this.getElement(), textIDProp, textProp, this.getModule().getLocale());
    }

    public String getExternalizedValue(String textIDProp, String textProp, ULocale locale) {
        return ModelUtil.getExternalizedValue(this.getElement(), textIDProp, textProp, locale);
    }

    public String getExternalizedValue(String textIDProp, String textProp, Locale locale) {
        return ModelUtil.getExternalizedValue(this.getElement(), textIDProp, textProp, ULocale.forLocale((Locale)locale));
    }

    public int getIndex() {
        return this.getElement().getIndex(this.module);
    }

    public void add(String propName, DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), propName));
        cmd.add(content.getElement());
    }

    public void add(String propName, DesignElementHandle content, int newPos) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), propName));
        cmd.add(content.getElement(), newPos);
    }

    public List paste(String propName, DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return Collections.emptyList();
        }
        this.add(propName, content);
        return this.checkPostPasteErrors(content.getElement());
    }

    public List paste(String propName, IDesignElement content) throws SemanticException {
        if (content == null) {
            return Collections.emptyList();
        }
        this.add(propName, content.getHandle(this.getModule()));
        return this.checkPostPasteErrors((DesignElement)content);
    }

    public List paste(String propName, DesignElementHandle content, int newPos) throws SemanticException {
        if (content == null) {
            return Collections.emptyList();
        }
        this.add(propName, content, newPos);
        return this.checkPostPasteErrors(content.getElement());
    }

    public List paste(String propName, IDesignElement content, int newPos) throws SemanticException {
        if (content == null) {
            return Collections.emptyList();
        }
        this.add(propName, content.getHandle(this.getModule()), newPos);
        return this.checkPostPasteErrors((DesignElement)content);
    }

    List checkPostPasteErrors(DesignElement content) {
        Module currentModule = this.getModule();
        String nameSpace = null;
        if (currentModule instanceof Library) {
            nameSpace = ((Library)currentModule).getNamespace();
        }
        ModelUtil.revisePropertyNameSpace(this.getModule(), content, content.getDefn().getProperty("extends"), nameSpace);
        ModelUtil.reviseNameSpace(this.getModule(), content, nameSpace);
        List<Exception> exceptionList = content.validateWithContents(this.getModule());
        List<ErrorDetail> errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return errorDetailList;
    }

    public List getContents(String propName) {
        PropertyHandle propHandle = this.getPropertyHandle(propName);
        return propHandle == null ? Collections.EMPTY_LIST : propHandle.getContents();
    }

    public int getContentCount(String propName) {
        return this.getContents(propName).size();
    }

    public DesignElementHandle getContent(String propName, int index) {
        if (index < 0 || index >= this.getContentCount(propName)) {
            return null;
        }
        return (DesignElementHandle)this.getContents(propName).get(index);
    }

    public void shift(String propName, DesignElementHandle content, int toPosn) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), propName));
        cmd.movePosition(content.getElement(), toPosn);
    }

    public void moveTo(int posn) throws SemanticException {
        DesignElement element = this.getElement();
        DesignElement oldContainer = element.getContainer();
        if (oldContainer == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        ContentCommand cmd = new ContentCommand(this.module, element.getContainerInfo());
        cmd.movePosition(element, posn);
    }

    public void move(String fromPropName, DesignElementHandle content, DesignElementHandle newContainer, String toPropName) throws SemanticException {
        if (content == null || newContainer == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), fromPropName));
        cmd.move(content.getElement(), new ContainerContext(newContainer.getElement(), toPropName));
    }

    public void moveTo(DesignElementHandle newContainer, String toPropName) throws SemanticException {
        DesignElement element = this.getElement();
        DesignElement oldContainer = element.getContainer();
        if (oldContainer == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        if (newContainer == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), element.getContainerInfo());
        cmd.move(element, new ContainerContext(newContainer.getElement(), toPropName));
    }

    public void move(String fromPropName, DesignElementHandle content, DesignElementHandle newContainer, String toPropName, int newPos) throws SemanticException {
        if (content == null || newContainer == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), fromPropName));
        cmd.move(content.getElement(), new ContainerContext(newContainer.getElement(), toPropName), newPos);
    }

    public void moveTo(DesignElementHandle newContainer, String toPropName, int newPos) throws SemanticException {
        DesignElement element = this.getElement();
        DesignElement oldContainer = element.getContainer();
        if (oldContainer == null) {
            throw new ContentException(element, -1, "Error.ContentException.HAS_NO_CONTAINER");
        }
        if (newContainer == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), element.getContainerInfo());
        cmd.move(element, new ContainerContext(newContainer.getElement(), toPropName), newPos);
    }

    public void dropAndClear(String propName, DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), propName));
        cmd.remove(content.getElement());
    }

    public void drop(String propName, DesignElementHandle content) throws SemanticException {
        if (content == null) {
            return;
        }
        ContentCommand cmd = new ContentCommand(this.getModule(), new ContainerContext(this.getElement(), propName), false, true);
        cmd.remove(content.getElement());
    }

    public void dropAndClear(String propName, int posn) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle != null) {
            propHandle.dropAndClear(posn);
        }
    }

    public void drop(String propName, int posn) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle(propName);
        if (propHandle != null) {
            propHandle.drop(posn);
        }
    }

    public void setEncryption(String propName, String encryptionID) throws SemanticException {
        EncryptionCommand cmd = new EncryptionCommand(this.getModule(), this.getElement());
        cmd.setEncryption(propName, encryptionID);
    }

    public boolean isDirectionRTL() {
        String direction = this.getStringProperty("bidiTextDirection");
        if (direction != null) {
            return "rtl".equals(direction);
        }
        ModuleHandle root = this.getRoot();
        return root != null && root.isDirectionRTL();
    }

    public DesignElementHandle getHostViewHandle() {
        if (!(this.getElement().getContainer() instanceof MultiViews)) {
            return null;
        }
        return this.getElement().getContainer().getContainer().getHandle(this.module);
    }

    public boolean isInTemplateParameter() {
        DesignElement element = this.getElement();
        return element.isInTemplateParameterDefinitionSlot();
    }

    public FactoryElementHandle getFactoryElementHandle() {
        return new FactoryElementHandle(this);
    }

    public ExpressionHandle getExpressionProperty(String propName) {
        PropertyDefn defn = (PropertyDefn)((Object)this.getPropertyDefn(propName));
        if (defn == null) {
            return null;
        }
        if (defn.allowExpression() && !defn.isListType()) {
            return new ExpressionHandle(this, (ElementPropertyDefn)defn);
        }
        return null;
    }

    public void setExpressionProperty(String propName, Expression expression) throws SemanticException {
        this.setProperty(propName, expression);
    }

    public void setPropertyBinding(String propName, Expression value) throws SemanticException {
        this.setPropertyBinding(propName, (Object)value);
    }

    public Expression getPropertyBindingExpression(String propName) {
        PropertyBinding propBinding = this.findPropertyBinding(propName);
        if (propBinding != null) {
            return propBinding.getExpressionProperty("value");
        }
        return null;
    }

    private void setPropertyBinding(String propName, Object value) throws SemanticException {
        ElementPropertyDefn defn = (ElementPropertyDefn)this.getPropertyDefn(propName);
        if (defn == null) {
            throw new SemanticError(this.getElement(), new String[]{propName}, "Error.SemanticError.INVALID_PROPERTY_NAME");
        }
        if ("propertyBindings".equals(defn.getName())) {
            return;
        }
        Module root = this.getElement().getRoot();
        if (root == null) {
            throw new SemanticError(this.getElement(), "Error.SemanticError.PROPERTY_BINDING_FORBIDDEN");
        }
        assert (root.getElementByID(this.getID()) == this.getElement());
        ArrayList bindingList = (ArrayList)root.getLocalProperty(root, "propertyBindings");
        PropertyBinding binding = root.findPropertyBinding(this.getElement(), propName);
        if (binding == null && value == null) {
            return;
        }
        if (bindingList == null) {
            assert (value != null);
            bindingList = new ArrayList();
            root.setProperty("propertyBindings", bindingList);
        }
        defn = root.getPropertyDefn("propertyBindings");
        assert (defn != null);
        if (value == null && binding != null) {
            ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, root);
            cmd.removeItem(binding.getContext(), bindingList.indexOf(binding));
        } else if (binding == null) {
            binding = new PropertyBinding();
            binding.setName(propName);
            binding.setID(this.getID());
            binding.setProperty("value", value);
            ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, root);
            cmd.addItem(new StructureContext(root, defn, null), (Object)binding);
        } else {
            PropertyCommand cmd = new PropertyCommand(this.module, root);
            cmd.setMember(new StructureContext(binding, (PropertyDefn)binding.getDefn().getMember("value"), null), value);
        }
    }

    private PropertyBinding findPropertyBinding(String propName) {
        if (propName == null) {
            return null;
        }
        DesignElement element = this.getElement();
        while (element != null && element.getRoot() != null) {
            PropertyBinding propBinding = element.getRoot().findPropertyBinding(element, propName);
            if (propBinding != null) {
                return propBinding;
            }
            element = element.isVirtualElement() ? element.getVirtualParent() : element.getExtendsElement();
        }
        return null;
    }
}

