/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.ibm.icu.util.ULocale;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPage;
import org.eclipse.birt.report.engine.emitter.pdf.TOCHandler;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.internal.util.BundleVersionUtil;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;

public class PDFPageDevice
implements IPageDevice {
    protected Document doc;
    protected PdfWriter writer;
    protected IReportContext context;
    protected IReportContent report;
    protected static Logger logger = Logger.getLogger(PDFPageDevice.class.getName());
    protected PDFPage currentPage;
    protected HashMap<Float, PdfTemplate> templateMap;
    protected HashMap<String, PdfTemplate> imageCache;
    protected static String[] versionInfo = new String[]{BundleVersionUtil.getBundleVersion("org.eclipse.birt.report.engine")};
    protected static final int MAX_PAGE_WIDTH = 14400000;
    protected static final int MAX_PAGE_HEIGHT = 14400000;
    private static String APPEND_PROPERTY_NAME = "AppendList";
    private static String PREPEND_PROPERTY_NAME = "PrependList";

    public PDFPageDevice(OutputStream output, String title, String author, String subject, String description, IReportContext context, IReportContent report) {
        block19: {
            this.doc = null;
            this.writer = null;
            this.currentPage = null;
            this.templateMap = new HashMap();
            this.imageCache = new HashMap();
            this.context = context;
            this.report = report;
            this.doc = new Document();
            try {
                String list;
                Expression listObject;
                this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(output));
                this.writer.setFullCompression();
                this.writer.setRgbTransparencyBlending(true);
                EngineResourceHandle handle = new EngineResourceHandle(ULocale.forLocale((Locale)context.getLocale()));
                String creator = handle.getMessage("PDFCreator", versionInfo);
                this.doc.addCreator(creator);
                if (author != null) {
                    this.doc.addAuthor(author);
                }
                if (title != null) {
                    this.doc.addTitle(title);
                }
                if (subject != null) {
                    this.doc.addSubject(subject);
                    this.doc.addKeywords(subject);
                }
                if (description != null) {
                    this.doc.addHeader("Description", description);
                }
                ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
                Map<String, Expression> props = report.getDesign().getUserProperties();
                if (props == null || (listObject = props.get(PREPEND_PROPERTY_NAME)) == null) break block19;
                Expression exp = listObject;
                Object result = context.evaluate(exp);
                if (result instanceof String && (list = (String)result) != null && list.length() > 0) {
                    String[] stringArray = list.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        try {
                            String fileName = s.trim();
                            File f = new File(fileName);
                            if (f.exists()) {
                                FileInputStream fis = new FileInputStream(f);
                                pdfs.add(fis);
                            } else {
                                URL url = context.getResource(fileName);
                                BufferedInputStream is = new BufferedInputStream(url.openStream());
                                pdfs.add(is);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                        ++n2;
                    }
                }
                if (result instanceof ArrayList) {
                    ArrayList pdfList = (ArrayList)result;
                    for (String fileName : pdfList) {
                        try {
                            File f = new File(fileName);
                            if (f.exists()) {
                                FileInputStream fis = new FileInputStream(f);
                                pdfs.add(fis);
                                continue;
                            }
                            URL url = context.getResource(fileName);
                            BufferedInputStream is = new BufferedInputStream(url.openStream());
                            pdfs.add(is);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                if (pdfs.size() > 0) {
                    if (!this.doc.isOpen()) {
                        this.doc.open();
                    }
                    this.concatPDFs(pdfs, false);
                }
            }
            catch (DocumentException | BirtException be) {
                logger.log(Level.SEVERE, be.getMessage(), be);
            }
        }
    }

    public PDFPageDevice(OutputStream output) {
        this.doc = null;
        this.writer = null;
        this.currentPage = null;
        this.templateMap = new HashMap();
        this.imageCache = new HashMap();
        this.doc = new Document();
        try {
            this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(output));
        }
        catch (DocumentException de) {
            logger.log(Level.SEVERE, de.getMessage(), de);
        }
    }

    public void setPDFTemplate(Float scale, PdfTemplate totalPageTemplate) {
        this.templateMap.put(scale, totalPageTemplate);
    }

    public HashMap<Float, PdfTemplate> getTemplateMap() {
        return this.templateMap;
    }

    public PdfTemplate getPDFTemplate(Float scale) {
        return this.templateMap.get(scale);
    }

    public boolean hasTemplate(Float scale) {
        return this.templateMap.containsKey(scale);
    }

    public HashMap<String, PdfTemplate> getImageCache() {
        return this.imageCache;
    }

    @Override
    public void close() throws Exception {
        Expression listObject;
        if (!this.doc.isOpen()) {
            this.doc.open();
        }
        ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
        Map<String, Expression> props = this.report.getDesign().getUserProperties();
        if (props != null && (listObject = props.get(APPEND_PROPERTY_NAME)) != null) {
            String list;
            Expression exp = listObject;
            Object result = this.context.evaluate(exp);
            if (result instanceof String && (list = (String)result) != null && list.length() > 0) {
                String[] stringArray = list.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    try {
                        String fileName = s.trim();
                        File f = new File(fileName);
                        if (f.exists()) {
                            FileInputStream fis = new FileInputStream(f);
                            pdfs.add(fis);
                        } else {
                            URL url = this.context.getResource(fileName);
                            BufferedInputStream is = new BufferedInputStream(url.openStream());
                            pdfs.add(is);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                    ++n2;
                }
            }
            if (result instanceof ArrayList) {
                ArrayList pdfList = (ArrayList)result;
                for (String fileName : pdfList) {
                    try {
                        File f = new File(fileName);
                        if (f.exists()) {
                            FileInputStream fis = new FileInputStream(f);
                            pdfs.add(fis);
                            continue;
                        }
                        URL url = this.context.getResource(fileName);
                        BufferedInputStream is = new BufferedInputStream(url.openStream());
                        pdfs.add(is);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
            if (pdfs.size() > 0) {
                this.concatPDFs(pdfs, false);
            }
        }
        this.writer.setPageEmpty(false);
        if (this.doc.isOpen()) {
            this.doc.close();
        }
    }

    @Override
    public IPage newPage(int width, int height, Color backgroundColor) {
        int w = Math.min(width, 14400000);
        int h = Math.min(height, 14400000);
        this.currentPage = this.createPDFPage(w, h);
        this.currentPage.drawBackgroundColor(backgroundColor, 0, 0, w, h);
        return this.currentPage;
    }

    protected PDFPage createPDFPage(int pageWidth, int pageHeight) {
        return new PDFPage(pageWidth, pageHeight, this.doc, this.writer, this);
    }

    public void createTOC(Set<String> bookmarks) {
        if (!this.doc.isOpen()) {
            return;
        }
        if (bookmarks.isEmpty()) {
            this.writer.setViewerPreferences(64);
            return;
        }
        ULocale ulocale = null;
        Locale locale = this.context.getLocale();
        ulocale = locale == null ? ULocale.getDefault() : ULocale.forLocale((Locale)locale);
        ITOCTree tocTree = this.report.getTOCTree("pdf", ulocale);
        if (tocTree == null) {
            this.writer.setViewerPreferences(64);
        } else {
            TOCNode rootNode = tocTree.getRoot();
            if (rootNode == null || rootNode.getChildren().isEmpty()) {
                this.writer.setViewerPreferences(64);
            } else {
                this.writer.setViewerPreferences(128);
                TOCHandler tocHandler = new TOCHandler(rootNode, this.writer.getDirectContent().getRootOutline(), bookmarks);
                tocHandler.createTOC();
            }
        }
    }

    protected TOCHandler createTOCHandler(TOCNode root, PdfOutline outline, Set<String> bookmarks) {
        return new TOCHandler(root, outline, bookmarks);
    }

    public void concatPDFs(List<InputStream> streamOfPDFFiles, boolean paginate) {
        Document document = this.doc;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                int n = pdfReader.getNumberOfPages();
                totalPages += n;
            }
            PdfWriter writer = this.writer;
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            PdfContentByte cb = writer.getDirectContent();
            int currentPageNumber = 0;
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    ++currentPageNumber;
                    Rectangle sourcePageSize = pdfReader.getPageSize(++pageOfCurrentReaderPDF);
                    document.setPageSize(sourcePageSize);
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    if (!paginate) continue;
                    cb.beginText();
                    cb.setFontAndSize(bf, 9.0f);
                    cb.showTextAligned(1, currentPageNumber + " of " + totalPages, 520.0f, 5.0f, 0.0f);
                    cb.endText();
                }
                pageOfCurrentReaderPDF = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

