/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.script.ParameterAttribute;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.impl.ParameterSelectionChoice;

public class ReportRunner {
    protected static Logger logger = Logger.getLogger(ReportRunner.class.getName());
    protected String[] args;
    protected String source;
    protected String targetFile = null;
    protected String mode = "RunAndRender";
    protected String locale = "en";
    protected String format = "html";
    protected String htmlType = "HTML";
    protected String encoding = "utf-8";
    protected HashMap params = new HashMap();
    protected long pageNumber = -1L;
    private IReportEngine engine;
    CommandLine results;

    public ReportRunner(String[] args) {
        this.args = (String[])args.clone();
    }

    public static void main(String[] args) {
        int result = new ReportRunner(args).execute();
        System.exit(result);
    }

    public int execute() {
        if (this.parseHelpOptions() > 0) {
            return 0;
        }
        try {
            this.parseNormalOptions();
            if (this.engine == null) {
                EngineConfig config = this.createEngineConfig();
                Platform.startup(config);
                IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject("org.eclipse.birt.report.engine.ReportEngineFactory");
                this.engine = factory.createReportEngine(config);
                this.engine.changeLogLevel(Level.WARNING);
            }
            if ("Run".equalsIgnoreCase(this.mode)) {
                int n = this.runReport();
                return n;
            }
            if ("Render".equalsIgnoreCase(this.mode)) {
                int n = this.renderReport();
                return n;
            }
            int n = this.runAndRenderReport();
            return n;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "exception in parsing the paramters", ex);
            return -1;
        }
        finally {
            Platform.shutdown();
        }
    }

    protected int runAndRenderReport() {
        try {
            IReportRunnable runnable = this.engine.openReportDesign(this.source);
            HashMap inputValues = this.evaluateParameterValues(runnable);
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            for (Map.Entry entry : inputValues.entrySet()) {
                String paraName = (String)entry.getKey();
                ParameterAttribute pa = (ParameterAttribute)entry.getValue();
                Object valueObject = pa.getValue();
                if (valueObject instanceof Object[]) {
                    Object[] valueArray = (Object[])valueObject;
                    String[] displayTextArray = (String[])pa.getDisplayText();
                    task.setParameter(paraName, valueArray, displayTextArray);
                    continue;
                }
                task.setParameter(paraName, pa.getValue(), (String)pa.getDisplayText());
            }
            RenderOption options = new RenderOption();
            options.setOutputFormat(this.format);
            options.setOutputFileName(this.targetFile);
            if (this.format.equalsIgnoreCase("html")) {
                HTMLRenderOption htmlOptions = new HTMLRenderOption(options);
                if ("ReportletNoCSS".equals(this.htmlType)) {
                    htmlOptions.setEmbeddable(true);
                }
                htmlOptions.setUrlEncoding(this.encoding);
                htmlOptions.setHtmlPagination(true);
                htmlOptions.setImageDirectory("image");
            }
            task.setRenderOption(options);
            task.setLocale(this.getLocale(this.locale));
            task.run();
            return 0;
        }
        catch (EngineException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return -1;
        }
    }

    protected int runReport() {
        try {
            IReportRunnable runnable = this.engine.openReportDesign(this.source);
            IRunTask task = this.engine.createRunTask(runnable);
            HashMap inputValues = this.evaluateParameterValues(runnable);
            for (Map.Entry entry : inputValues.entrySet()) {
                String paraName = (String)entry.getKey();
                ParameterAttribute pa = (ParameterAttribute)entry.getValue();
                Object valueObject = pa.getValue();
                if (valueObject instanceof Object[]) {
                    Object[] valueArray = (Object[])valueObject;
                    String[] displayTextArray = (String[])pa.getDisplayText();
                    task.setParameter(paraName, valueArray, displayTextArray);
                    continue;
                }
                task.setParameter(paraName, pa.getValue(), (String)pa.getDisplayText());
            }
            task.setAppContext(new HashMap());
            task.run(this.targetFile);
            task.close();
            return 0;
        }
        catch (EngineException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return -1;
        }
    }

    protected int renderReport() {
        try {
            IReportDocument document = this.engine.openReportDocument(this.source);
            IRenderTask task = this.engine.createRenderTask(document);
            RenderOption options = new RenderOption();
            options.setOutputFormat(this.format);
            if (this.format.equalsIgnoreCase("html")) {
                HTMLRenderOption htmlOptions = new HTMLRenderOption(options);
                if ("ReportletNoCSS".equals(this.htmlType)) {
                    htmlOptions.setEmbeddable(true);
                }
                htmlOptions.setImageDirectory("image");
                htmlOptions.setUrlEncoding(this.encoding);
            }
            task.setRenderOption(options);
            task.setLocale(this.getLocale(this.locale));
            if (this.pageNumber <= 0L) {
                int extPos = this.targetFile.lastIndexOf(46);
                assert (extPos != -1);
                String pathName = this.targetFile.substring(0, extPos);
                String extName = this.targetFile.substring(extPos);
                long pageCount = document.getPageCount();
                if (pageCount == 1L) {
                    options.setOutputFileName(this.targetFile);
                    task.setPageNumber(1L);
                    task.render();
                } else {
                    long i = 1L;
                    while (i <= pageCount) {
                        String fileName = String.valueOf(pathName) + '_' + i + extName;
                        options.setOutputFileName(fileName);
                        task.setPageNumber(i);
                        task.render();
                        ++i;
                    }
                }
            } else {
                options.setOutputFileName(this.targetFile);
                task.setPageNumber(this.pageNumber);
                task.render();
            }
            task.close();
            return 0;
        }
        catch (BirtException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return -1;
        }
    }

    protected void printGeneralUsage() {
        System.out.println("Help for ReportRunner");
        System.out.println("");
        System.out.println("--mode/-m [run|render|runrender] [options] [rptdesign|rptdocument]\n\tThe default mode is runrender.");
        System.out.println("To see options for run mode, use:");
        System.out.println("\t--help/-h run");
        System.out.println("To see options for render mode, use:");
        System.out.println("\t--help/-h render");
        System.out.println("To see options for runrender mode, use:");
        System.out.println("\t--help/-h runrender");
        System.out.println("Print current message, use --help/-h");
    }

    protected void printRunUsage() {
        System.out.println("ReportRunner's run mode:");
        System.out.println("--mode/-m run [options] <rptdesign file>");
        System.out.println("where options could be:");
        System.out.println("\t--output/-o <target file>");
        System.out.println("\t--parameter/-p <\"parameterName=parameterValue\">");
        System.out.println("\t--config/-c <\"configName=configValue\">");
        System.out.println("\t--file/-F <file>\n");
        System.out.println("1. parameters/configs in command line will overide those in file");
        System.out.println("2. parameter/config name can not include characters such as ' ', '=', ':' ");
        System.out.println("use \"--help/-h configNames\" for a list of configurables");
        System.out.println("use \"--help/-h file\" for options in <file>");
    }

    protected void printRenderUsage() {
        System.out.println("ReportRunner's RENDER mode:");
        System.out.println("--mode/-m render [options] <rptdocument file>");
        System.out.println("where options could be:");
        System.out.println("\t--format/-f [HTML|PDF]");
        System.out.println("\t--output/-o <target file>");
        System.out.println("\t--page/-n <pageNumber>");
        System.out.println("\t--locale/-l <locale>     default is english");
        System.out.println("\t--config/-c <\"configName=configValue\">");
        System.out.println("\t--renderOption/-r <\"optionName=optionValue\">");
        System.out.println("\t--file/-F <file>\n");
        System.out.println("1. configs/renderOptions in command line will overide those in file");
        System.out.println("2. config/renderOption name can not include characters such as ' ', '=', ':' ");
        System.out.println("use \"--help/-h configNames\" for a list of configurables");
        System.out.println("use \"--help/-h renderOptions\" for a list of render options");
        System.out.println("use \"--help/-h file\" for options in <file>");
    }

    protected void printRunRenderUsage() {
        System.out.println("ReportRunner's RUNRENDER mode:");
        System.out.println("--mode/-m runrender [options] <rptdesign file>");
        System.out.println("where options could be:");
        System.out.println("\t--format/-f [HTML|PDF]");
        System.out.println("\t--output/-o <target file>");
        System.out.println("\t--htmlType/-t < HTML | ReportletNoCSS >");
        System.out.println("\t--encoding/-e <target encoding>");
        System.out.println("\t--locale/-l <locale>    default is english");
        System.out.println("\t--parameter/-p <\"parameterName=parameterValue\">");
        System.out.println("\t--config/-c <\"configName=configValue\">");
        System.out.println("\t--renderOption/-r <\"optionName=optionValue\">");
        System.out.println("\t--file/-F <file>\n");
        System.out.println("1. parameters/configs/renderOptions in command line will overide those in file");
        System.out.println("2. parameter/config/renderOption name can not include characters such as ' ', '=', ':' ");
        System.out.println("use \"--help/-h configNames\" for a list of configurables");
        System.out.println("use \"--help/-h renderOptions\" for a list of render options");
        System.out.println("use \"--help/-h file\" for options in <file>");
    }

    protected void printConfigUsage() {
        System.out.println("Configurables include:");
        System.out.println("\tresourceDir    the directory where resources reside");
        System.out.println("\ttempDir        the directory to place temporary file");
        System.out.println("\tlogDir         the directory where logs are generated");
        System.out.println("\tlogLevel       log level, see java.util.Level");
        System.out.println("\tlogFile        the log file");
        System.out.println("\tscriptPath     the class path where to find scripts");
    }

    protected void printRenderOptionUsage() {
        System.out.println("RenderOptions include:");
        System.out.println("\tformat      the output format, html or pdf");
        System.out.println("\thtmlType    html type");
        System.out.println("\toutput      the output file");
        System.out.println("\tlocale      the locale used to render the report");
        System.out.println("\tencoding    encoding");
        System.out.println("\tpage        the page number to be rendered");
    }

    protected void printFileUsage() {
        System.out.println("When specified with --file/-F <file>, the <file> can be used to hold some default options.\nThe command line options overwrite those in <file>.\nThe options include what config/renderOption/parameter can have.\nUse \"-h configNames\", \"-h renderOptions\" for detailed options");
    }

    private Locale getLocale(String locale) {
        int index = locale.indexOf(95);
        if (index != -1) {
            String language = locale.substring(0, index);
            String country = locale.substring(index + 1);
            return new Locale(language, country);
        }
        return new Locale(locale);
    }

    protected void parseRunOptions() throws Exception {
        assert (this.mode.equalsIgnoreCase("Run"));
        if (this.params.get("output") != null) {
            this.targetFile = (String)this.params.get("output");
        }
        if (this.results.hasOption('o')) {
            this.targetFile = this.results.getOptionValue('o');
        }
    }

    protected void parseRenderOptions() throws Exception {
        assert (this.mode.equalsIgnoreCase("Render"));
        if (this.params.get("format") != null) {
            this.format = (String)this.params.get("format");
        }
        if (this.results.hasOption('f')) {
            this.format = this.results.getOptionValue('f');
        }
        if (this.params.get("htmlType") != null) {
            this.htmlType = (String)this.params.get("htmlType");
        }
        if (this.results.hasOption('t')) {
            this.htmlType = this.results.getOptionValue('t');
        }
        if (this.params.get("output") != null) {
            this.targetFile = (String)this.params.get("output");
        }
        if (this.results.hasOption('o')) {
            this.targetFile = this.results.getOptionValue('o');
        }
        if (this.params.get("locale") != null) {
            this.locale = (String)this.params.get("locale");
        }
        if (this.results.hasOption('l')) {
            this.locale = this.results.getOptionValue('l');
        }
        if (this.params.get("encoding") != null) {
            this.encoding = (String)this.params.get("encoding");
        }
        if (this.results.hasOption('e')) {
            this.encoding = this.results.getOptionValue('e');
        }
        String paramPageNumber = (String)this.params.get("page");
        if (this.results.hasOption('p')) {
            paramPageNumber = this.results.getOptionValue('p');
        }
        if (this.results.hasOption('n')) {
            paramPageNumber = this.results.getOptionValue('n');
        }
        if (paramPageNumber != null) {
            try {
                this.pageNumber = Long.parseLong(paramPageNumber);
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.SEVERE, "Can not parse parameter(page number) \"" + paramPageNumber + "\"");
            }
        }
    }

    protected void parseRunAndRenderOptions() throws Exception {
        assert (this.mode.equalsIgnoreCase("RunAndRender"));
        if (this.params.get("format") != null) {
            this.format = (String)this.params.get("format");
        }
        if (this.results.hasOption('f')) {
            this.format = this.results.getOptionValue('f');
        }
        if (this.params.get("htmlType") != null) {
            this.htmlType = (String)this.params.get("htmlType");
        }
        if (this.results.hasOption('t')) {
            this.htmlType = this.results.getOptionValue('t');
        }
        if (this.params.get("output") != null) {
            this.targetFile = (String)this.params.get("output");
        }
        if (this.results.hasOption('o')) {
            this.targetFile = this.results.getOptionValue('o');
        }
        if (this.params.get("locale") != null) {
            this.locale = (String)this.params.get("locale");
        }
        if (this.results.hasOption('l')) {
            this.locale = this.results.getOptionValue('l');
        }
        if (this.params.get("encoding") != null) {
            this.encoding = (String)this.params.get("encoding");
        }
        if (this.results.hasOption('e')) {
            this.encoding = this.results.getOptionValue('e');
        }
    }

    protected int parseHelpOptions() {
        if (this.args.length == 0) {
            this.printGeneralUsage();
            return 1;
        }
        try {
            Options option = new Options();
            option.addOption("h", "help", true, "");
            CommandLine results = new BasicParser().parse(option, this.args, true);
            if (results.hasOption('h')) {
                String name = results.getOptionValue('h');
                if (name == null || name.length() == 0) {
                    this.printGeneralUsage();
                } else if (name.equalsIgnoreCase("run")) {
                    this.printRunUsage();
                } else if (name.equalsIgnoreCase("render")) {
                    this.printRenderUsage();
                } else if (name.equalsIgnoreCase("runrender")) {
                    this.printRunRenderUsage();
                } else if (name.equalsIgnoreCase("configNames")) {
                    this.printConfigUsage();
                } else if (name.equalsIgnoreCase("renderOptions")) {
                    this.printRenderOptionUsage();
                } else if (name.equalsIgnoreCase("file")) {
                    this.printFileUsage();
                } else {
                    this.printGeneralUsage();
                }
                return 1;
            }
        }
        catch (ParseException ex) {
            this.printGeneralUsage();
            return 1;
        }
        return 0;
    }

    protected void parseNormalOptions() {
        this.source = this.args[this.args.length - 1];
        this.args[this.args.length - 1] = "";
        try {
            Options option = new Options();
            option.addOption("m", "mode", true, "RunAndRender");
            option.addOption("o", "output", true, "");
            option.addOption("f", "format", true, "html");
            option.addOption("t", "htmlType", true, "");
            option.addOption("l", "locale", true, "");
            option.addOption("e", "encoding", true, "");
            option.addOption("p", "parameter", true, "");
            option.addOption("n", "page", true, "");
            option.addOption("p", "page", true, "");
            option.addOption("F", "file", true, "");
            option.addOption("c", "config", true, "");
            option.addOption("r", "renderOption", true, "");
            this.results = new BasicParser().parse(option, this.args, true);
            if (this.results.hasOption('F')) {
                String fileName = this.results.getOptionValue('F');
                this.readConfigurationFile(fileName, this.params);
            }
            this.parseConfigurationOptions();
            if (this.results.hasOption('m')) {
                this.mode = this.results.getOptionValue('m');
            }
            if ("Run".equalsIgnoreCase(this.mode)) {
                this.parseRunOptions();
            } else if ("Render".equalsIgnoreCase(this.mode)) {
                this.parseRenderOptions();
            } else {
                this.parseRunAndRenderOptions();
            }
            this.checkTargetFileName();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.printGeneralUsage();
        }
    }

    protected void readParamString(String param, HashMap params) {
        if (param == null || param.length() < 2) {
            return;
        }
        int index = param.indexOf("=");
        if (index < 1) {
            return;
        }
        String name = param.substring(0, index).trim();
        String value = param.substring(index + 1).trim();
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 2) {
            value = value.substring(1, value.length() - 1);
        }
        params.put(name, value);
    }

    protected void parseConfigurationOptions() {
        char[] options = new char[]{'c', 'r', 'p'};
        int optIndex = 0;
        while (optIndex < options.length) {
            String[] stringParams;
            char currentOption = options[optIndex];
            if (this.results.hasOption(currentOption) && (stringParams = this.results.getOptionValues(currentOption)) != null) {
                int i = 0;
                while (i < stringParams.length) {
                    this.readParamString(stringParams[i], this.params);
                    ++i;
                }
            }
            ++optIndex;
        }
    }

    protected void readConfigurationFile(String fileName, HashMap params) {
        Properties ps;
        block17: {
            File file = new File(fileName);
            ps = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                ps.load(in);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "file: " + file.getAbsolutePath() + " not exists!");
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.SEVERE, "Can not close file: " + file.getAbsolutePath());
                    }
                }
                break block17;
            }
            catch (IOException e) {
                try {
                    logger.log(Level.SEVERE, "Can not open file: " + file.getAbsolutePath());
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e3) {
                            logger.log(Level.SEVERE, "Can not close file: " + file.getAbsolutePath());
                        }
                    }
                }
            }
            if (in == null) break block17;
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Can not close file: " + file.getAbsolutePath());
            }
        }
        params.putAll(ps);
    }

    private HashMap evaluateParameterValues(IReportRunnable runnable) {
        HashMap<String, ParameterAttribute> inputValues = new HashMap<String, ParameterAttribute>();
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(runnable);
        Collection paramDefns = task.getParameterDefns(false);
        for (IParameterDefnBase pBase : paramDefns) {
            if (!(pBase instanceof IScalarParameterDefn)) continue;
            IScalarParameterDefn paramDefn = (IScalarParameterDefn)pBase;
            String paramName = paramDefn.getName();
            String inputValue = (String)this.params.get(paramName);
            int paramDataType = paramDefn.getDataType();
            String paramType = paramDefn.getScalarParameterType();
            boolean isAllowMutipleValues = false;
            try {
                Object[] paramValue = null;
                if ("multi-value".equals(paramType)) {
                    paramValue = this.stringToObjectArray(paramDataType, inputValue);
                    isAllowMutipleValues = true;
                } else {
                    paramValue = this.stringToObject(paramDataType, inputValue);
                }
                if (paramValue == null) continue;
                ArrayList selectList = paramDefn.getSelectionList();
                ParameterAttribute pa = null;
                if (isAllowMutipleValues) {
                    Object[] values = paramValue;
                    ArrayList<String> displayTextList = new ArrayList<String>();
                    if (selectList != null && selectList.size() > 0) {
                        Object[] objectArray = values;
                        int n = values.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            for (ParameterSelectionChoice select : selectList) {
                                if (!o.equals(select.getValue())) continue;
                                displayTextList.add(select.getLabel());
                            }
                            ++n2;
                        }
                    }
                    String[] displayTexts = new String[displayTextList.size()];
                    pa = new ParameterAttribute(values, displayTextList.toArray(displayTexts));
                } else {
                    String displayText = null;
                    if (selectList != null && selectList.size() > 0) {
                        for (ParameterSelectionChoice select : selectList) {
                            if (!paramValue.equals(select.getValue())) continue;
                            displayText = select.getLabel();
                            break;
                        }
                    }
                    pa = new ParameterAttribute((Object)paramValue, displayText);
                }
                inputValues.put(paramName, pa);
            }
            catch (BirtException ex) {
                logger.log(Level.SEVERE, "the value of parameter " + paramName + " is invalid", ex);
            }
        }
        return inputValues;
    }

    private Object[] stringToObjectArray(int paramDataType, String inputValue) throws BirtException {
        String[] inputValues;
        if (inputValue == null) {
            return null;
        }
        LinkedList<Object> result = new LinkedList<Object>();
        String[] stringArray = inputValues = inputValue.split(",");
        int n = inputValues.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            result.add(this.stringToObject(paramDataType, value));
            ++n2;
        }
        return result.toArray();
    }

    protected Object stringToObject(int type, String value) throws BirtException {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 5: {
                return DataTypeUtil.toBoolean(value);
            }
            case 7: {
                return DataTypeUtil.toSqlDate(value);
            }
            case 8: {
                return DataTypeUtil.toSqlTime((Object)value);
            }
            case 4: {
                return DataTypeUtil.toDate((Object)value);
            }
            case 3: {
                return DataTypeUtil.toBigDecimal(value);
            }
            case 2: {
                return DataTypeUtil.toDouble(value);
            }
            case 1: {
                return DataTypeUtil.toString(value);
            }
            case 6: {
                return DataTypeUtil.toInteger(value);
            }
        }
        return null;
    }

    protected void checkTargetFileName() {
        File designFile;
        String designFileName;
        int n;
        String fileExt = "." + this.format;
        if ("Run".equalsIgnoreCase(this.mode)) {
            fileExt = ".rptdocument";
        }
        if ((n = (designFileName = (designFile = new File(new File(this.source).getAbsolutePath())).getName()).lastIndexOf(46)) != -1) {
            designFileName = designFileName.substring(0, n);
        }
        if (this.targetFile == null) {
            this.targetFile = String.valueOf(designFile.getParent()) + File.separatorChar + designFileName + fileExt;
        } else if (!this.targetFile.toLowerCase().endsWith(fileExt.toLowerCase())) {
            this.targetFile = String.valueOf(this.targetFile) + File.separatorChar + designFileName + fileExt;
            File file = new File(this.targetFile);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
        }
    }

    protected EngineConfig createEngineConfig() {
        String tempDir;
        EngineConfig config = new EngineConfig();
        String resourcePath = (String)this.params.get("resourceDir");
        if (resourcePath != null) {
            config.setResourcePath(resourcePath.trim());
        }
        if ((tempDir = (String)this.params.get("tempDir")) != null) {
            config.setTempDir(tempDir.trim());
        }
        String logDir = (String)this.params.get("logDir");
        String logLevel = (String)this.params.get("logLevel");
        Level level = null;
        if (logLevel != null) {
            if ("all".equalsIgnoreCase(logLevel = logLevel.trim())) {
                level = Level.ALL;
            } else if ("config".equalsIgnoreCase(logLevel)) {
                level = Level.CONFIG;
            } else if ("fine".equalsIgnoreCase(logLevel)) {
                level = Level.FINE;
            } else if ("finer".equalsIgnoreCase(logLevel)) {
                level = Level.FINER;
            } else if ("finest".equalsIgnoreCase(logLevel)) {
                level = Level.FINEST;
            } else if ("info".equalsIgnoreCase(logLevel)) {
                level = Level.INFO;
            } else if ("off".equalsIgnoreCase(logLevel)) {
                level = Level.OFF;
            } else if ("severe".equalsIgnoreCase(logLevel)) {
                level = Level.SEVERE;
            } else if ("warning".equalsIgnoreCase(logLevel)) {
                level = Level.WARNING;
            }
        }
        String logD = logDir == null ? config.getLogDirectory() : logDir;
        Level logL = level == null ? config.getLogLevel() : level;
        config.setLogConfig(logD, logL);
        String logFile = (String)this.params.get("logFile");
        if (logFile != null) {
            config.setLogFile(logFile.trim());
        }
        String scripts = (String)this.params.get("scriptPath");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user.projectclasspath", scripts);
        config.setAppContext(map);
        return config;
    }
}

