/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import com.ibm.icu.util.ULocale;
import java.awt.Shape;
import java.awt.geom.FlatteningPathIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.device.image.MultiActionValuesScriptGenerator;
import org.eclipse.birt.chart.device.swing.ShapedAction;
import org.eclipse.birt.chart.device.util.CSSHelper;
import org.eclipse.birt.chart.device.util.HTMLAttribute;
import org.eclipse.birt.chart.device.util.HTMLEncoderAdapter;
import org.eclipse.birt.chart.device.util.HTMLTag;
import org.eclipse.birt.chart.device.util.ICharacterEncoderAdapter;
import org.eclipse.birt.chart.device.util.ScriptUtil;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.emf.common.util.EList;

public class ImageMapEmitter
implements IImageMapEmitter {
    private List<ShapedAction> saList = null;
    private boolean _bAltEnabled = false;
    private ULocale locale = null;
    private static final String NO_OP_JAVASCRIPT = "javascript:void(0);";
    private static final String POLY_SHAPE = "poly";
    private Map<String, Boolean> callbackMethodsRegistry = new HashMap<String, Boolean>(5);
    private volatile boolean hasMultipleMenu = false;
    private volatile boolean hasAddedMenuLib = false;
    private ICharacterEncoderAdapter encoderAdapter = HTMLEncoderAdapter.getInstance();
    private int dpi = 72;

    public ImageMapEmitter(List<ShapedAction> saList, boolean bAltEnabled, ULocale locale) {
        this.saList = saList;
        this._bAltEnabled = bAltEnabled;
        this.locale = locale;
    }

    public ImageMapEmitter(List<ShapedAction> saList, boolean bAltEnabled, ULocale locale, int dpi) {
        this.saList = saList;
        this._bAltEnabled = bAltEnabled;
        this.locale = locale;
        this.dpi = dpi;
    }

    @Override
    public String getImageMap() {
        Collections.sort(this.saList, new Comparator<ShapedAction>(){

            @Override
            public int compare(ShapedAction o1, ShapedAction o2) {
                if (o1.getZOrder() == 0 || o2.getZOrder() == 0) {
                    return 0;
                }
                return o2.getZOrder() - o1.getZOrder();
            }
        });
        if (this.saList == null || this.saList.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        ListIterator<ShapedAction> iter = this.saList.listIterator(this.saList.size());
        while (iter.hasPrevious()) {
            ShapedAction sa = iter.previous();
            this.userCallback(sa, sb);
            String coords = this.shape2polyCoords(sa.getShape());
            if (coords == null) continue;
            HTMLTag tag = new HTMLTag("area");
            tag.addAttribute(HTMLAttribute.SHAPE, POLY_SHAPE);
            tag.addAttribute(HTMLAttribute.COORDS, coords);
            tag.addAttribute(HTMLAttribute.ALT, this._bAltEnabled ? sa.getSource().getSource().toString() : "");
            this.setCursorAttribute(tag, sa);
            boolean changed = false;
            changed |= this.processOnFocus(sa, tag);
            changed |= this.processOnBlur(sa, tag);
            changed |= this.processOnClick(sa, tag);
            changed |= this.processOnDoubleClick(sa, tag);
            if (!(changed |= this.processOnMouseOver(sa, tag))) continue;
            sb.append(tag);
        }
        return sb.toString();
    }

    private void setCursorAttribute(HTMLTag tag, ShapedAction sa) {
        if (sa.getCursor() == null || sa.getCursor().getType() == CursorType.AUTO) {
            return;
        }
        String value = CSSHelper.getCSSCursorValue(sa.getCursor());
        if (value != null) {
            tag.addAttribute(HTMLAttribute.STYLE, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processCommonEvent(ShapedAction sa, HTMLTag tag, TriggerCondition condition, HTMLAttribute htmlAttr) {
        Action ac = sa.getActionForCondition(condition);
        if (!this.checkSupportedAction(ac)) return false;
        if (ac instanceof MultipleActions) {
            List<Action> validActions = MultiActionValuesScriptGenerator.getValidActions((MultipleActions)ac);
            int size = validActions.size();
            if (size == 0) {
                return false;
            }
            if (size == 1) {
                Action subAction = validActions.get(0);
                if (subAction.getValue() instanceof URLValue) {
                    this.setURLValueAttributes(tag, condition, htmlAttr, (URLValue)subAction.getValue(), null);
                    return true;
                }
                if (!(subAction.getValue() instanceof ScriptValue)) return false;
                this.setAttributesWithScript(sa, tag, condition, htmlAttr);
                return true;
            }
            this.setAttributesWithScript(sa, tag, condition, htmlAttr);
            return true;
        }
        switch (ac.getType().getValue()) {
            case 0: {
                if (ac.getValue() instanceof MultiURLValues) {
                    List<URLValue> validURLValues = MultiActionValuesScriptGenerator.getValidURLValues((MultiURLValues)ac.getValue());
                    int size = validURLValues.size();
                    if (size == 0) {
                        this.setTooltipAttribute(tag, ((MultiURLValues)ac.getValue()).getTooltip());
                        return false;
                    }
                    if (size == 1) {
                        URLValue uv = validURLValues.get(0);
                        this.setURLValueAttributes(tag, condition, htmlAttr, uv, ((MultiURLValues)ac.getValue()).getTooltip());
                        return true;
                    }
                    this.setTooltipAttribute(tag, ((MultiURLValues)ac.getValue()).getTooltip());
                    this.setAttributesWithScript(sa, tag, condition, htmlAttr);
                    return true;
                }
                URLValue uv = (URLValue)ac.getValue();
                this.setURLValueAttributes(tag, condition, htmlAttr, uv, null);
                return true;
            }
            case 1: {
                return false;
            }
            case 3: {
                this.setAttributesWithScript(sa, tag, condition, htmlAttr);
                return true;
            }
        }
        return false;
    }

    private void setTooltipAttribute(HTMLTag tag, String tooltip) {
        if (tooltip != null && tooltip.trim().length() > 0) {
            tag.addAttribute(HTMLAttribute.TITLE, this.eval2HTML(tooltip));
        }
    }

    private void setAttributesWithScript(ShapedAction sa, HTMLTag tag, TriggerCondition condition, HTMLAttribute htmlAttr) {
        tag.addAttribute(HTMLAttribute.HREF, NO_OP_JAVASCRIPT);
        StringBuffer callbackFunction = new StringBuffer(this.getJSMethodName(condition, sa));
        this.addCallBackScript(sa, callbackFunction);
        tag.addAttribute(htmlAttr, this.eval2JS(callbackFunction.toString(), true));
    }

    private String removeSurroundingQuotes(String sBaseUrl) {
        if (sBaseUrl == null) {
            return null;
        }
        if (sBaseUrl.length() > 0) {
            int iEnd = sBaseUrl.length() - 1;
            if (sBaseUrl.charAt(0) == '\"' && sBaseUrl.charAt(iEnd) == '\"') {
                return sBaseUrl.substring(1, iEnd);
            }
        }
        return sBaseUrl;
    }

    private void setURLValueAttributes(HTMLTag tag, TriggerCondition condition, HTMLAttribute htmlAttr, URLValue uv, String tooltip) {
        if (uv != null && uv.getTooltip() != null) {
            this.setTooltipAttribute(tag, uv.getTooltip());
        } else {
            this.setTooltipAttribute(tag, tooltip);
        }
        if (condition == TriggerCondition.ONCLICK_LITERAL) {
            tag.addAttribute(HTMLAttribute.HREF, this.eval2HTML(this.removeSurroundingQuotes(uv.getBaseUrl())));
            if (uv.getTarget() != null) {
                tag.addAttribute(HTMLAttribute.TARGET, uv.getTarget());
            }
        } else {
            tag.addAttribute(HTMLAttribute.HREF, NO_OP_JAVASCRIPT);
            String value = this.getJsURLRedirect(uv);
            if (htmlAttr.equals(HTMLAttribute.ONFOCUS)) {
                value = "this.blur();" + value;
            }
            tag.addAttribute(htmlAttr, value);
        }
    }

    protected boolean processOnFocus(ShapedAction sa, HTMLTag tag) {
        return this.processCommonEvent(sa, tag, TriggerCondition.ONFOCUS_LITERAL, HTMLAttribute.ONFOCUS);
    }

    protected boolean processOnBlur(ShapedAction sa, HTMLTag tag) {
        return this.processCommonEvent(sa, tag, TriggerCondition.ONBLUR_LITERAL, HTMLAttribute.ONBLUR);
    }

    protected boolean processOnClick(ShapedAction sa, HTMLTag tag) {
        return this.processCommonEvent(sa, tag, TriggerCondition.ONCLICK_LITERAL, HTMLAttribute.ONCLICK);
    }

    protected boolean processOnDoubleClick(ShapedAction sa, HTMLTag tag) {
        return this.processCommonEvent(sa, tag, TriggerCondition.ONDBLCLICK_LITERAL, HTMLAttribute.ONDBLCLICK);
    }

    protected boolean processOnMouseOver(ShapedAction sa, HTMLTag tag) {
        Action ac = sa.getActionForCondition(TriggerCondition.ONMOUSEOVER_LITERAL);
        if (this.checkSupportedAction(ac)) {
            switch (ac.getType().getValue()) {
                case 0: {
                    return false;
                }
                case 1: {
                    TooltipValue tv = (TooltipValue)ac.getValue();
                    if (tv.getText() != null && tv.getText().length() > 0) {
                        tag.addAttribute(HTMLAttribute.TITLE, this.eval2HTML(tv.getText()));
                        return true;
                    }
                    return false;
                }
                case 3: {
                    StringBuffer callbackFunction = new StringBuffer(this.getJSMethodName(TriggerCondition.ONMOUSEOVER_LITERAL, sa));
                    this.addCallBackScript(sa, callbackFunction);
                    tag.addAttribute(HTMLAttribute.ONMOUSEOVER, this.eval2JS(callbackFunction.toString(), true));
                    return true;
                }
            }
        }
        return false;
    }

    protected String getJsURLRedirect(URLValue uv) {
        String sBaseUrl = uv.getBaseUrl() == null ? "" : uv.getBaseUrl();
        if ((sBaseUrl = this.removeSurroundingQuotes(sBaseUrl)).startsWith("javascript:")) {
            return sBaseUrl;
        }
        if (sBaseUrl.startsWith("#")) {
            return "window.location='" + this.eval2HTML(sBaseUrl) + "'";
        }
        return "window.open('" + this.eval2HTML(sBaseUrl) + "','" + (uv.getTarget() == null ? "self" : uv.getTarget()) + "')";
    }

    private String shape2polyCoords(Shape shape) {
        if (shape == null) {
            return null;
        }
        ArrayList<Double> al = new ArrayList<Double>();
        FlatteningPathIterator pitr = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        double[] data = new double[6];
        while (!pitr.isDone()) {
            int type = pitr.currentSegment(data);
            switch (type) {
                case 0: {
                    al.add(new Double(data[0]));
                    al.add(new Double(data[1]));
                    break;
                }
                case 1: {
                    al.add(new Double(data[0]));
                    al.add(new Double(data[1]));
                    break;
                }
                case 2: {
                    al.add(new Double(data[0]));
                    al.add(new Double(data[1]));
                    al.add(new Double(data[2]));
                    al.add(new Double(data[3]));
                    break;
                }
                case 3: {
                    al.add(new Double(data[0]));
                    al.add(new Double(data[1]));
                    al.add(new Double(data[2]));
                    al.add(new Double(data[3]));
                    al.add(new Double(data[4]));
                    al.add(new Double(data[5]));
                    break;
                }
            }
            pitr.next();
        }
        if (al.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < al.size()) {
            Double db = (Double)al.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append((int)this.translateCoor(db));
            ++i;
        }
        return sb.toString();
    }

    private double translateCoor(double d) {
        return d / (double)this.dpi * 96.0;
    }

    private boolean checkSupportedAction(Action action) {
        return action != null && (action.getType() == ActionType.URL_REDIRECT_LITERAL || action.getType() == ActionType.SHOW_TOOLTIP_LITERAL || action.getType() == ActionType.INVOKE_SCRIPT_LITERAL);
    }

    protected String eval2HTML(String expr) {
        return this.encoderAdapter.escape(expr);
    }

    protected String eval2JS(String expr, boolean bCallback) {
        if (expr == null) {
            return "";
        }
        if (bCallback) {
            return expr;
        }
        return JavascriptEvalUtil.transformToJsConstants(expr);
    }

    private void userCallback(ShapedAction sa, StringBuffer sb) {
        this.addCallbackMethod(sa, sb, TriggerCondition.ONCLICK_LITERAL);
        this.addCallbackMethod(sa, sb, TriggerCondition.ONDBLCLICK_LITERAL);
        this.addCallbackMethod(sa, sb, TriggerCondition.ONMOUSEOVER_LITERAL);
        this.addCallbackMethod(sa, sb, TriggerCondition.ONFOCUS_LITERAL);
        this.addCallbackMethod(sa, sb, TriggerCondition.ONBLUR_LITERAL);
        if (this.hasMultipleMenu && !this.hasAddedMenuLib) {
            sb.insert(0, "<Script>" + MultiActionValuesScriptGenerator.getBirtChartMenuLib() + "</Script>");
            this.hasAddedMenuLib = true;
        }
    }

    private void addCallbackMethod(ShapedAction sa, StringBuffer sb, TriggerCondition condition) {
        String functionName = this.getJSMethodName(condition, sa);
        String key = String.valueOf(condition.getLiteral()) + functionName;
        if (!this.callbackMethodsRegistry.containsKey(key)) {
            this.addScriptCallBack(sa, sb, sa.getActionForCondition(condition), functionName);
            this.callbackMethodsRegistry.put(key, Boolean.TRUE);
        }
    }

    private void addScriptCallBack(ShapedAction sa, StringBuffer sb, Action ac, String functionName) {
        if (ac != null) {
            if (ac instanceof MultipleActions) {
                if (((MultipleActions)ac).getActions().size() > 0) {
                    sb.append(this.wrapJSMethod(functionName, this.generateJSContent(ac)));
                }
            } else if (ac.getType().getValue() == 3) {
                sb.append(this.wrapJSMethod(functionName, this.generateJSContent(ac)));
            } else if (ac.getType().getValue() == 0 && ac.getValue() instanceof MultiURLValues && ((MultiURLValues)ac.getValue()).getURLValues().size() > 1) {
                sb.append(this.wrapJSMethod(functionName, this.generateJSContent(ac)));
            }
        }
    }

    private String generateUniqueJSKey(Action ac) {
        if (ac == null) {
            return "";
        }
        if (ac instanceof MultipleActions) {
            EList<Action> subActions = ((MultipleActions)ac).getActions();
            if (subActions.size() <= 1) {
                return this.generateJSContent((Action)subActions.get(0));
            }
            return String.valueOf(MultiActionValuesScriptGenerator.getJSKey((MultipleActions)ac, this.locale)) + this.hashCode();
        }
        if (ac.getValue() instanceof MultiURLValues) {
            MultiURLValues values = (MultiURLValues)ac.getValue();
            if (values.getURLValues().size() <= 1) {
                return this.generateJSContent(ac);
            }
            return String.valueOf(MultiActionValuesScriptGenerator.getJSKey(values)) + this.hashCode();
        }
        return this.generateJSContent(ac);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String generateJSContent(Action ac) {
        if (ac != null) {
            block13: {
                if (ac instanceof MultipleActions) {
                    boolean needMenu = ac.getValue() != null && ac.getValue().getLabel() != null && ac.getValue().getLabel().isVisible();
                    List<Action> validActions = MultiActionValuesScriptGenerator.getValidActions((MultipleActions)ac);
                    if (validActions.size() == 0) {
                        return "";
                    }
                    if (validActions.size() == 1 && !needMenu) {
                        ActionValue av = validActions.get(0).getValue();
                        if (av instanceof URLValue) {
                            return this.getJsURLRedirect((URLValue)av);
                        }
                        if (av instanceof ScriptValue) {
                            return ((ScriptValue)av).getScript();
                        }
                        break block13;
                    } else {
                        this.hasMultipleMenu = true;
                        return MultiActionValuesScriptGenerator.getJSContent((MultipleActions)ac, this.locale);
                    }
                }
                if (ac.getType().getValue() == 3) {
                    ScriptValue sv = (ScriptValue)ac.getValue();
                    return sv.getScript();
                }
            }
            if (ac.getType().getValue() == 0) {
                ActionValue value = ac.getValue();
                if (value instanceof URLValue) {
                    URLValue uv = (URLValue)ac.getValue();
                    return this.getJsURLRedirect(uv);
                }
                if (value instanceof MultiURLValues) {
                    List<URLValue> validURLValues = MultiActionValuesScriptGenerator.getValidURLValues((MultiURLValues)value);
                    if (validURLValues.size() == 0) {
                        return "";
                    }
                    if (validURLValues.size() == 1) {
                        return this.getJsURLRedirect(validURLValues.get(0));
                    }
                    this.hasMultipleMenu = true;
                    return MultiActionValuesScriptGenerator.getJSContent(value);
                }
            }
        }
        return "";
    }

    private String wrapJSMethod(String functionName, String functionContent) {
        return "<Script>function " + functionName + "(evt," + "categoryData" + ", " + "valueData" + ", " + "valueSeriesName" + ", " + "legendItemData" + ", " + "legendItemText" + ", " + "legendItemValue" + ", " + "axisLabel" + "){" + this.eval2JS(functionContent, true) + "};</Script>";
    }

    private String getJSMethodName(TriggerCondition tc, ShapedAction sa) {
        int hashCode = this.generateUniqueJSKey(sa.getActionForCondition(tc)).hashCode();
        if (hashCode != Integer.MIN_VALUE) {
            return "userCallBack" + Math.abs(hashCode);
        }
        return "userCallBack2147483647";
    }

    private void addCallBackScript(ShapedAction sa, StringBuffer callbackFunction) {
        StructureSource source = sa.getSource();
        DataPointHints dph = StructureType.SERIES_DATA_POINT.equals(source.getType()) ? (DataPointHints)source.getSource() : null;
        LegendItemHints lerh = StructureType.LEGEND_ENTRY.equals(source.getType()) ? (LegendItemHints)source.getSource() : null;
        String axisLabel = StructureType.AXIS_LABEL.equals(source.getType()) ? (String)source.getSource() : null;
        callbackFunction.append("(event");
        ScriptUtil.script(callbackFunction, dph, lerh, axisLabel);
        callbackFunction.append(");");
    }
}

