/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.UserPropertyEvent;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class UserPropertyRecord
extends SimpleRecord {
    private DesignElement element = null;
    private UserPropertyDefn property = null;
    private boolean addOp = true;

    public UserPropertyRecord(DesignElement obj, UserPropertyDefn prop, boolean add2) {
        this.element = obj;
        this.property = prop;
        this.addOp = add2;
        this.label = this.addOp ? CommandLabelFactory.getCommandLabel("Message.AddProperty", new String[]{prop.getDisplayName()}) : CommandLabelFactory.getCommandLabel("Message.DropProperty", new String[]{prop.getDisplayName()});
    }

    @Override
    public NotificationEvent getEvent() {
        assert (this.state == 1 || this.state == 2 || this.state == 3);
        int event = 1;
        if (this.addOp && this.state != 2 || !this.addOp && this.state == 2) {
            event = 0;
        }
        return new UserPropertyEvent(this.element, this.property, event);
    }

    @Override
    protected void perform(boolean undo) {
        if (this.addOp && !undo || !this.addOp && undo) {
            this.element.addUserPropertyDefn(this.property);
        } else {
            this.element.dropUserPropertyDefn(this.property);
        }
    }

    public boolean isAdd() {
        return this.addOp;
    }

    @Override
    public DesignElement getTarget() {
        return this.element;
    }
}

