/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.report.data.adapter.api.AdapterException;

class ResultMetaData
implements IResultMetaData {
    private List columnDefinitions;

    ResultMetaData(List columnDefinitions) throws BirtException {
        assert (columnDefinitions != null);
        this.columnDefinitions = columnDefinitions;
    }

    @Override
    public int getColumnCount() {
        return this.columnDefinitions.size();
    }

    @Override
    public String getColumnName(int index) throws BirtException {
        return this.getIndexedColumnDefinition(index).getColumnName();
    }

    @Override
    public String getColumnAlias(int index) throws BirtException {
        return this.getIndexedColumnDefinition(index).getAlias();
    }

    @Override
    public int getColumnType(int index) throws BirtException {
        return this.getIndexedColumnDefinition(index).getDataType();
    }

    @Override
    public String getColumnTypeName(int index) throws BirtException {
        return DataType.getName(this.getIndexedColumnDefinition(index).getDataType());
    }

    @Override
    public String getColumnNativeTypeName(int index) throws BirtException {
        return null;
    }

    @Override
    public String getColumnLabel(int index) throws BirtException {
        return null;
    }

    @Override
    public boolean isComputedColumn(int index) throws BirtException {
        return false;
    }

    protected IColumnDefinition getIndexedColumnDefinition(int index) throws AdapterException {
        if (index < 1 || index > this.columnDefinitions.size()) {
            throw new AdapterException("datasethandle.invalidColumnIndex");
        }
        return (IColumnDefinition)this.columnDefinitions.get(index - 1);
    }
}

