/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.withoutaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.extension.render.PieRenderer;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;

public final class Pie
extends BaseRenderer {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine.extension/render");
    private PieRenderer pr = null;

    @Override
    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, (Throwable)vex);
        }
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        SeriesDefinition sd = this.getSeriesDefinition();
        Bounds boCB = this.getCellBounds();
        try {
            this.pr = new PieRenderer(cwoa, this, srh.getDataPoints(), srh.asPrimitiveDoubleValues(), sd.getSeriesPalette());
            this.pr.computeInsets(boCB);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, (Throwable)ex);
        }
    }

    @Override
    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        PieSeries ps;
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        if (cwoa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL && cwoa.getDimension() != ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.pie.dimension", new Object[]{cwoa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (this.isFirstPie()) {
            Insets ins = null;
            boolean first = true;
            int i = 1;
            while (i < this.iSeriesCount) {
                if (this.getRenderer(i) instanceof Pie) {
                    if (first) {
                        ins = ((Pie)this.getRenderer(i)).getActualRenderer().getFittingInsets();
                        first = false;
                    } else {
                        ins = goFactory.max(ins, ((Pie)this.getRenderer(i)).getActualRenderer().getFittingInsets());
                    }
                }
                ++i;
            }
            try {
                i = 1;
                while (i < this.iSeriesCount) {
                    if (this.getRenderer(i) instanceof Pie) {
                        ((Pie)this.getRenderer(i)).getActualRenderer().setFittingInsets(ins);
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)uiex);
            }
        }
        if (!(ps = (PieSeries)this.getSeries()).isVisible()) {
            return;
        }
        logger.log(1, String.valueOf(Messages.getString("info.render.series", this.getRunTimeContext().getULocale())) + this.getClass().getName() + (this.iSeriesIndex + 1) + this.iSeriesCount);
        Bounds boCB = this.getCellBounds();
        this.pr.render(this.getDevice(), boCB);
    }

    protected boolean isFirstPie() {
        int i = 1;
        while (i < this.iSeriesCount) {
            if (this.getRenderer(i) instanceof Pie) {
                return this.getRenderer(i) == this;
            }
            ++i;
        }
        return false;
    }

    private PieRenderer getActualRenderer() {
        return this.pr;
    }

    @Override
    public Collection<Integer> getFilteredMinSliceEntry(DataSetIterator dsi) {
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        if (!cwoa.isSetMinSlice()) {
            return Collections.emptySet();
        }
        boolean bPercentageMinSlice = cwoa.isSetMinSlicePercent() && cwoa.isMinSlicePercent();
        double dMinSlice = cwoa.getMinSlice();
        dsi.reset();
        if (bPercentageMinSlice) {
            double total = 0.0;
            while (dsi.hasNext()) {
                Object obj = dsi.next();
                if (!(obj instanceof Number)) continue;
                total += Math.abs(((Number)obj).doubleValue());
            }
            dMinSlice = total * dMinSlice / 100.0;
            dsi.reset();
        }
        double dMinSliceAbs = Math.abs(dMinSlice);
        HashSet<Integer> setIds = new HashSet<Integer>();
        int idx = 0;
        while (dsi.hasNext()) {
            Object obj = dsi.next();
            if (obj instanceof Number && Math.abs(((Number)obj).doubleValue()) < dMinSliceAbs) {
                setIds.add(idx);
            }
            ++idx;
        }
        return setIds;
    }

    @Override
    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        PieSeries bs = (PieSeries)this.getSeries();
        ColorDefinition cd = bs.getSliceOutline();
        LineAttributes lia = goFactory.createLineAttributes(cd == null ? null : goFactory.copyOf(cd), LineStyle.SOLID_LITERAL, 1);
        Location[] loaFrontFace = new Location[]{goFactory.createLocation(bo.getLeft(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + 0.8 * bo.getWidth(), bo.getTop())};
        this.renderPlane(ipr, StructureSource.createLegend(lg), loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 3.0 * this.getDeviceScale(), false);
    }
}

