/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;

public class RowSaveUtil {
    public static Integer EXCEPTION_INDICATOR = new Integer(2147483547);
    private int lastRowIndex;
    private long currentOffset;
    private int rowCount;
    private DataOutputStream rowExprsDos;
    private DataOutputStream rowLenDos;
    private boolean inited;
    private Set exprNameSet;
    private Map directColumnReferenceBinding;
    private int version;
    private Map bindingNameType;

    RowSaveUtil(int rowCount, OutputStream rowExprsOs, OutputStream rowLenOs, Set exprNameSet, Map directColumnReferenceExpr, Map bindingNameType, int version) {
        this.rowCount = rowCount;
        this.rowExprsDos = new DataOutputStream(rowExprsOs);
        this.rowLenDos = new DataOutputStream(rowLenOs);
        this.lastRowIndex = -1;
        this.exprNameSet = exprNameSet;
        this.directColumnReferenceBinding = directColumnReferenceExpr;
        this.bindingNameType = bindingNameType;
        this.version = version;
    }

    void saveExprValue(int currIndex, Map valueMap) throws DataException {
        try {
            this.initSave(false);
            this.saveNullRowsBetween(this.lastRowIndex, currIndex);
            int rowBytes = this.saveExprValue(valueMap);
            IOUtil.writeLong((DataOutputStream)this.rowLenDos, (long)this.currentOffset);
            this.currentOffset += (long)rowBytes;
            this.lastRowIndex = currIndex;
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    private int initSave(Map valueMap) throws DataException {
        ByteArrayOutputStream tempBaos = new ByteArrayOutputStream();
        BufferedOutputStream tempBos = new BufferedOutputStream(tempBaos);
        DataOutputStream tempDos = new DataOutputStream(tempBos);
        try {
            IOUtil.writeInt((OutputStream)tempDos, (int)this.exprNameSet.size());
            for (Object key : this.exprNameSet) {
                IOUtil.writeObject((DataOutputStream)tempDos, key);
                IOUtil.writeInt((OutputStream)tempDos, (int)((Integer)this.bindingNameType.get(key)));
            }
            IOUtil.writeInt((OutputStream)tempDos, (int)this.directColumnReferenceBinding.size());
            for (Object key : this.directColumnReferenceBinding.keySet()) {
                Object value = this.directColumnReferenceBinding.get(key);
                IOUtil.writeObject((DataOutputStream)tempDos, key);
                IOUtil.writeObject((DataOutputStream)tempDos, value);
                IOUtil.writeInt((OutputStream)tempDos, (int)((Integer)this.bindingNameType.get(key)));
            }
            tempDos.flush();
            tempBos.flush();
            tempBaos.flush();
            byte[] bytes = tempBaos.toByteArray();
            int rowBytes = bytes.length;
            IOUtil.writeRawBytes((DataOutputStream)this.rowExprsDos, (byte[])bytes);
            tempBaos = null;
            tempBos = null;
            tempDos = null;
            return rowBytes;
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    private int saveExprValue(Map valueMap) throws DataException {
        ByteArrayOutputStream tempBaos = new ByteArrayOutputStream();
        BufferedOutputStream tempBos = new BufferedOutputStream(tempBaos);
        DataOutputStream tempDos = new DataOutputStream(tempBos);
        try {
            IOUtil.writeInt((OutputStream)tempDos, (int)this.exprNameSet.size());
            for (Object key : this.exprNameSet) {
                Object value = valueMap.get(key);
                if (value instanceof BirtException) {
                    value = EXCEPTION_INDICATOR;
                }
                IOUtil.writeObject((DataOutputStream)tempDos, value);
            }
            tempDos.flush();
            tempBos.flush();
            tempBaos.flush();
            byte[] bytes = tempBaos.toByteArray();
            int rowBytes = bytes.length;
            IOUtil.writeRawBytes((DataOutputStream)this.rowExprsDos, (byte[])bytes);
            tempBaos = null;
            tempBos = null;
            tempDos = null;
            return rowBytes;
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    Set getExprNameSet() {
        return this.exprNameSet;
    }

    void saveFinish(int currIndex) throws DataException {
        this.initSave(true);
        try {
            this.saveNullRowsBetween(this.lastRowIndex, currIndex);
            this.rowExprsDos.close();
            this.rowLenDos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    private void initSave(boolean finish) throws DataException {
        if (this.inited) {
            return;
        }
        this.inited = true;
        try {
            IOUtil.writeInt((OutputStream)this.rowExprsDos, (int)this.rowCount);
            HashMap map = new HashMap();
            for (Object value : this.exprNameSet) {
                map.put(value, value);
            }
            int rowBytes = this.version >= 50 ? this.initSave(map) : this.saveExprValue(map);
            IOUtil.writeInt((OutputStream)this.rowExprsDos, (int)rowBytes);
            this.rowExprsDos.flush();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    private void saveNullRowsBetween(int lastRowIndex, int currIndex) throws IOException {
        int gapRows = currIndex - lastRowIndex - 1;
        int i = 0;
        while (i < gapRows) {
            IOUtil.writeInt((OutputStream)this.rowExprsDos, (int)0);
            IOUtil.writeLong((DataOutputStream)this.rowLenDos, (long)this.currentOffset);
            this.currentOffset += 4L;
            ++i;
        }
    }
}

