/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class ImageContent
extends AbstractContent
implements IImageContent {
    protected String helpTextKey;
    protected String extension;
    protected String uri;
    protected int sourceType = -1;
    protected transient byte[] data;
    protected Object imageMap;
    protected String MIMEType;
    private int resolution;
    protected static final short FIELD_ALTTEXT = 500;
    protected static final short FIELD_ALTTEXTKEY = 501;
    protected static final short FIELD_EXTENSEION = 502;
    protected static final short FIELD_URI = 503;
    protected static final short FIELD_SOURCETYPE = 504;
    protected static final short FIELD_IMAGEMAP = 505;
    protected static final short FIELD_MIMETYPE = 506;
    protected static final short FIELD_DATA = 507;

    ImageContent(IImageContent image) {
        super(image);
        this.helpTextKey = image.getHelpKey();
        this.extension = image.getExtension();
        this.uri = image.getURI();
        this.sourceType = image.getImageSource();
        this.data = image.getData();
        this.imageMap = image.getImageMap();
        this.MIMEType = image.getMIMEType();
    }

    @Override
    public int getContentType() {
        return 5;
    }

    ImageContent(ReportContent report) {
        super(report);
    }

    ImageContent(IContent content) {
        super(content);
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitImage(this, value);
    }

    @Override
    public String getAltText() {
        if (this.altText == null && this.generateBy instanceof ImageItemDesign) {
            Expression expr = ((ImageItemDesign)this.generateBy).getAltText();
            if (expr != null && expr.getType() == 0) {
                return expr.getScriptText();
            }
            return null;
        }
        return this.altText;
    }

    @Override
    public String getAltTextKey() {
        if (this.altTextKey == null && this.generateBy instanceof ImageItemDesign) {
            return ((ImageItemDesign)this.generateBy).getAltTextKey();
        }
        return this.altTextKey;
    }

    @Override
    public void setAltTextKey(String key) {
        this.altTextKey = key;
    }

    @Override
    public String getHelpText() {
        if (this.helpText == null && this.generateBy instanceof ImageItemDesign) {
            return ((ImageItemDesign)this.generateBy).getHelpText();
        }
        return this.helpText;
    }

    @Override
    public String getHelpKey() {
        if (this.helpTextKey == null && this.generateBy instanceof ImageItemDesign) {
            return ((ImageItemDesign)this.generateBy).getHelpTextKey();
        }
        return this.helpTextKey;
    }

    @Override
    public void setHelpKey(String key) {
        this.helpTextKey = key;
    }

    @Override
    public byte[] getData() {
        if (this.sourceType == 1) {
            String imageName;
            ReportDesignHandle design;
            EmbeddedImage embeddedImage;
            Report reportDesign = this.report.getDesign();
            if (reportDesign != null && (embeddedImage = (design = reportDesign.getReportDesign()).findImage(imageName = this.getImageName())) != null) {
                return embeddedImage.getData(design.getModule());
            }
            return null;
        }
        return this.data;
    }

    @Override
    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getURI() {
        switch (this.sourceType) {
            case 1: {
                return this.getImageName();
            }
            case 0: 
            case 3: {
                return this.getImageURI();
            }
        }
        return this.uri;
    }

    @Override
    public int getImageSource() {
        return this.sourceType;
    }

    @Override
    public void setAltText(String altText) {
        this.altText = altText;
    }

    private void setImageName(String name) {
        Expression nameExpr;
        assert (this.sourceType == 1);
        this.uri = name;
        if (this.uri != null && this.generateBy instanceof ImageItemDesign && (nameExpr = ((ImageItemDesign)this.generateBy).getImageName()) != null && nameExpr.getType() == 0 && this.uri.equals(nameExpr.getScriptText())) {
            this.uri = null;
        }
        this.data = null;
    }

    private String getImageName() {
        Expression nameExpr;
        assert (this.sourceType == 1);
        if (this.uri != null) {
            return this.uri;
        }
        if (this.generateBy instanceof ImageItemDesign && (nameExpr = ((ImageItemDesign)this.generateBy).getImageName()) != null) {
            return nameExpr.getScriptText();
        }
        return null;
    }

    private void setImageURI(String uri) {
        Expression uriExpr;
        assert (this.sourceType == 0 || this.sourceType == 3);
        if (uri != null && this.generateBy instanceof ImageItemDesign && (uriExpr = ((ImageItemDesign)this.generateBy).getImageUri()) != null && uriExpr.getType() == 0 && uri.equals(uriExpr.getScriptText())) {
            uri = null;
        }
        this.uri = uri;
        this.data = null;
    }

    private String getImageURI() {
        Expression uriExpr;
        assert (this.sourceType == 0 || this.sourceType == 3);
        if (this.uri != null) {
            return this.uri;
        }
        if (this.generateBy instanceof ImageItemDesign && (uriExpr = ((ImageItemDesign)this.generateBy).getImageUri()) != null) {
            return uriExpr.getScriptText();
        }
        return null;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public void setImageSource(int sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public void setURI(String uri) {
        switch (this.sourceType) {
            case 1: {
                this.setImageName(uri);
                break;
            }
            case 0: 
            case 3: {
                this.setImageURI(uri);
                break;
            }
            default: {
                this.uri = uri;
            }
        }
    }

    @Override
    public void setImageMap(Object imageMap) {
        this.imageMap = imageMap;
    }

    @Override
    public Object getImageMap() {
        return this.imageMap;
    }

    @Override
    public void setMIMEType(String MIMEType) {
        this.MIMEType = MIMEType;
    }

    @Override
    public String getMIMEType() {
        return this.MIMEType;
    }

    @Override
    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.extension != null) {
            IOUtil.writeShort((OutputStream)out, (short)502);
            IOUtil.writeString((DataOutputStream)out, (String)this.extension);
        }
        if (this.imageMap != null) {
            IOUtil.writeShort((OutputStream)out, (short)505);
            IOUtil.writeObject((DataOutputStream)out, (Object)this.imageMap);
        }
        if (this.sourceType != -1) {
            IOUtil.writeShort((OutputStream)out, (short)504);
            IOUtil.writeInt((OutputStream)out, (int)this.sourceType);
        }
        switch (this.sourceType) {
            case 0: 
            case 1: 
            case 3: {
                if (this.uri == null) break;
                IOUtil.writeShort((OutputStream)out, (short)503);
                IOUtil.writeString((DataOutputStream)out, (String)this.uri);
                break;
            }
            case 2: {
                if (this.data == null) break;
                IOUtil.writeShort((OutputStream)out, (short)507);
                IOUtil.writeBytes((DataOutputStream)out, (byte[])this.data);
            }
        }
        if (this.MIMEType != null) {
            IOUtil.writeShort((OutputStream)out, (short)506);
            IOUtil.writeString((DataOutputStream)out, (String)this.MIMEType);
        }
    }

    @Override
    public boolean needSave() {
        return true;
    }

    @Override
    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 502: {
                this.extension = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 503: {
                this.uri = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 504: {
                this.sourceType = IOUtil.readInt((InputStream)in);
                break;
            }
            case 505: {
                this.imageMap = IOUtil.readObject((DataInputStream)in, (ClassLoader)loader);
                break;
            }
            case 506: {
                this.MIMEType = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 507: {
                this.data = IOUtil.readBytes((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    @Override
    protected IContent cloneContent() {
        return new ImageContent(this);
    }

    @Override
    public int getResolution() {
        return this.resolution;
    }

    @Override
    public void setResolution(int resolution) {
        this.resolution = resolution;
    }
}

