/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.layout;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.presentation.aggregation.layout.DocumentFragment;
import org.eclipse.birt.report.presentation.aggregation.layout.FramesetFragment;
import org.eclipse.birt.report.presentation.aggregation.layout.ReportDialogFragment;
import org.eclipse.birt.report.service.actionhandler.BirtRenderImageActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunAndRenderActionHandler;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class RunFragment
extends FramesetFragment {
    @Override
    protected void build() {
        this.addChild(new ReportDialogFragment());
        this.addChild(new DocumentFragment());
    }

    @Override
    protected boolean __checkHTMLFormat(HttpServletRequest request) {
        BaseAttributeBean bean = (BaseAttributeBean)request.getAttribute("attributeBean");
        assert (bean != null);
        if (!ParameterAccessor.isReportParameterExist(request, "__report") && !ParameterAccessor.isReportParameterExist(request, "__document")) {
            return false;
        }
        return super.__checkHTMLFormat(request);
    }

    @Override
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block6: {
            BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
            Object out = response.getOutputStream();
            GetUpdatedObjectsResponse upResponse = new GetUpdatedObjectsResponse();
            BirtContext context = new BirtContext(request, response);
            Operation op = null;
            try {
                if (ParameterAccessor.isGetImageOperator(request)) {
                    BirtRenderImageActionHandler renderImageHandler = new BirtRenderImageActionHandler(context, op, upResponse);
                    renderImageHandler.execute();
                } else {
                    boolean isPrint = false;
                    if ("print".equalsIgnoreCase(attrBean.getAction())) {
                        isPrint = true;
                        out = new ByteArrayOutputStream();
                    }
                    BirtRunAndRenderActionHandler runAndRenderHandler = new BirtRunAndRenderActionHandler(context, op, upResponse, (OutputStream)out);
                    runAndRenderHandler.execute();
                    if (isPrint) {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
                        BirtUtility.doPrintAction(inputStream, request, response);
                    }
                }
            }
            catch (RemoteException e) {
                if (ParameterAccessor.isGetImageOperator(request)) break block6;
                response.setContentType("text/html; charset=utf-8");
                BirtUtility.appendErrorMessage((OutputStream)response.getOutputStream(), e);
            }
        }
    }
}

