/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.AbstractSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;

public class FloatSerializer
extends AbstractSerializer<Float> {
    private static final FloatSerializer instance = new FloatSerializer();

    public static FloatSerializer get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(Float obj) {
        return IntegerSerializer.get().toByteBuffer(Float.floatToRawIntBits(obj.floatValue()));
    }

    @Override
    public Float fromByteBuffer(ByteBuffer bytes) {
        return Float.valueOf(Float.intBitsToFloat(IntegerSerializer.get().fromByteBuffer(bytes)));
    }
}

