/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.dao;

import java.util.HashMap;
import java.util.Map;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.Rows;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import me.prettyprint.hector.api.query.MultigetSliceQuery;
import me.prettyprint.hector.api.query.QueryResult;

public class SimpleCassandraDao {
    protected String columnFamilyName;
    protected Keyspace keyspace;
    private final StringSerializer serializer = StringSerializer.get();

    public void insert(String key, String columnName, String value) {
        HFactory.createMutator(this.keyspace, this.serializer).insert(key, this.columnFamilyName, HFactory.createColumn(columnName, value, this.serializer, this.serializer));
    }

    public String get(String key, String columnName) throws HectorException {
        ColumnQuery<String, String, String> q = HFactory.createColumnQuery(this.keyspace, this.serializer, this.serializer, this.serializer);
        QueryResult r = q.setKey(key).setName(columnName).setColumnFamily(this.columnFamilyName).execute();
        HColumn c = (HColumn)r.get();
        return c != null ? (String)c.getValue() : null;
    }

    public Map<String, String> getMulti(String columnName, String ... keys) {
        MultigetSliceQuery<String, String, String> q = HFactory.createMultigetSliceQuery(this.keyspace, this.serializer, this.serializer, this.serializer);
        q.setColumnFamily(this.columnFamilyName);
        q.setKeys((String[])keys);
        q.setColumnNames((String[])new String[]{columnName});
        QueryResult r = q.execute();
        Rows rows = (Rows)r.get();
        HashMap<String, String> ret = new HashMap<String, String>(keys.length);
        for (String k : keys) {
            HColumn c = rows.getByKey(k).getColumnSlice().getColumnByName(columnName);
            if (c == null || c.getValue() == null) continue;
            ret.put(k, (String)c.getValue());
        }
        return ret;
    }

    public void insertMulti(String columnName, Map<String, String> keyValues) {
        Mutator<String> m = HFactory.createMutator(this.keyspace, this.serializer);
        for (Map.Entry<String, String> keyValue : keyValues.entrySet()) {
            m.addInsertion(keyValue.getKey(), this.columnFamilyName, HFactory.createColumn(columnName, keyValue.getValue(), this.keyspace.createClock(), this.serializer, this.serializer));
        }
        m.execute();
    }

    public void delete(String columnName, String ... keys) {
        Mutator<String> m = HFactory.createMutator(this.keyspace, this.serializer);
        for (String key : keys) {
            m.addDeletion(key, this.columnFamilyName, columnName, this.serializer);
        }
        m.execute();
    }

    public void setColumnFamilyName(String columnFamilyName) {
        this.columnFamilyName = columnFamilyName;
    }

    public void setKeyspace(Keyspace keyspace) {
        this.keyspace = keyspace;
    }
}

