/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.service.BatchMutation;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.hector.api.HConsistencyLevel;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SuperColumn;

public interface KeyspaceService {
    public static final String CF_TYPE = "Type";
    public static final String CF_TYPE_STANDARD = "Standard";
    public static final String CF_TYPE_SUPER = "Super";

    public Column getColumn(ByteBuffer var1, ColumnPath var2) throws HectorException;

    public Column getColumn(String var1, ColumnPath var2) throws HectorException;

    public CounterColumn getCounter(ByteBuffer var1, ColumnPath var2) throws HectorException;

    public CounterColumn getCounter(String var1, ColumnPath var2) throws HectorException;

    public SuperColumn getSuperColumn(ByteBuffer var1, ColumnPath var2) throws HectorException;

    public SuperColumn getSuperColumn(String var1, ColumnPath var2) throws HectorException;

    public SuperColumn getSuperColumn(ByteBuffer var1, ColumnPath var2, boolean var3, int var4) throws HectorException;

    public List<Column> getSlice(ByteBuffer var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public List<Column> getSlice(String var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public List<CounterColumn> getCounterSlice(ByteBuffer var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public List<CounterColumn> getCounterSlice(String var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public List<SuperColumn> getSuperSlice(ByteBuffer var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public List<SuperColumn> getSuperSlice(String var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public List<CounterSuperColumn> getCounterSuperSlice(ByteBuffer var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public List<CounterSuperColumn> getCounterSuperSlice(String var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public Map<ByteBuffer, SuperColumn> multigetSuperColumn(List<ByteBuffer> var1, ColumnPath var2) throws HectorException;

    public Map<ByteBuffer, SuperColumn> multigetSuperColumn(List<ByteBuffer> var1, ColumnPath var2, boolean var3, int var4) throws HectorException;

    public Map<ByteBuffer, List<Column>> multigetSlice(List<ByteBuffer> var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public Map<ByteBuffer, List<CounterColumn>> multigetCounterSlice(List<ByteBuffer> var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public Map<ByteBuffer, List<SuperColumn>> multigetSuperSlice(List<ByteBuffer> var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public Map<ByteBuffer, List<CounterSuperColumn>> multigetCounterSuperSlice(List<ByteBuffer> var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public void insert(ByteBuffer var1, ColumnParent var2, Column var3) throws HectorException;

    public void insert(String var1, ColumnPath var2, ByteBuffer var3) throws HectorException;

    public void insert(String var1, ColumnPath var2, ByteBuffer var3, long var4) throws HectorException;

    public void addCounter(ByteBuffer var1, ColumnParent var2, CounterColumn var3) throws HectorException;

    public void addCounter(String var1, ColumnParent var2, CounterColumn var3) throws HectorException;

    public void batchMutate(Map<ByteBuffer, Map<String, List<Mutation>>> var1) throws HectorException;

    public void batchMutate(BatchMutation var1) throws HectorException;

    public void remove(ByteBuffer var1, ColumnPath var2);

    public void remove(ByteBuffer var1, ColumnPath var2, long var3) throws HectorException;

    public void remove(String var1, ColumnPath var2) throws HectorException;

    public void remove(String var1, ColumnPath var2, long var3) throws HectorException;

    public void removeCounter(ByteBuffer var1, ColumnPath var2) throws HectorException;

    public void removeCounter(String var1, ColumnPath var2) throws HectorException;

    public int getCount(ByteBuffer var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public Map<ByteBuffer, List<Column>> getRangeSlices(ColumnParent var1, SlicePredicate var2, KeyRange var3) throws HectorException;

    public Map<ByteBuffer, List<CounterColumn>> getRangeCounterSlices(ColumnParent var1, SlicePredicate var2, KeyRange var3) throws HectorException;

    public Map<ByteBuffer, List<SuperColumn>> getSuperRangeSlices(ColumnParent var1, SlicePredicate var2, KeyRange var3) throws HectorException;

    public Map<ByteBuffer, List<CounterSuperColumn>> getSuperRangeCounterSlices(ColumnParent var1, SlicePredicate var2, KeyRange var3);

    public Map<ByteBuffer, List<Column>> getIndexedSlices(ColumnParent var1, IndexClause var2, SlicePredicate var3) throws HectorException;

    public Map<ByteBuffer, Integer> multigetCount(List<ByteBuffer> var1, ColumnParent var2, SlicePredicate var3) throws HectorException;

    public HConsistencyLevel getConsistencyLevel(OperationType var1);

    public String getName();

    public CassandraHost getCassandraHost();
}

