/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.Iterator;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;

public class KeyIterator<K>
implements Iterable<K> {
    private static StringSerializer stringSerializer = new StringSerializer();
    private static int MAX_ROW_COUNT_DEFAULT = 500;
    private int maxColumnCount = 2;
    private Iterator<Row<K, String, String>> rowsIterator = null;
    private RangeSlicesQuery<K, String, String> query = null;
    private K nextValue = null;
    private K lastReadValue = null;
    private K endKey;
    private boolean firstRun = true;
    private Iterator<K> keyIterator = new Iterator<K>(){

        @Override
        public boolean hasNext() {
            return KeyIterator.this.nextValue != null;
        }

        @Override
        public K next() {
            Object next = KeyIterator.this.nextValue;
            KeyIterator.this.findNext(false);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private void findNext(boolean fromRunQuery) {
        this.nextValue = null;
        if (this.rowsIterator == null) {
            return;
        }
        while (this.rowsIterator.hasNext() && this.nextValue == null) {
            Row<K, String, String> row = this.rowsIterator.next();
            this.lastReadValue = row.getKey();
            if (row.getColumnSlice().getColumns().isEmpty()) continue;
            this.nextValue = this.lastReadValue;
        }
        if (!this.rowsIterator.hasNext() && this.nextValue == null) {
            this.runQuery(this.lastReadValue, this.endKey);
        }
    }

    public KeyIterator(Keyspace keyspace, String columnFamily, Serializer<K> serializer) {
        this(keyspace, columnFamily, serializer, null, null, MAX_ROW_COUNT_DEFAULT);
    }

    public KeyIterator(Keyspace keyspace, String columnFamily, Serializer<K> serializer, int maxRowCount) {
        this(keyspace, columnFamily, serializer, null, null, maxRowCount);
    }

    public KeyIterator(Keyspace keyspace, String columnFamily, Serializer<K> serializer, K start, K end) {
        this(keyspace, columnFamily, serializer, start, end, MAX_ROW_COUNT_DEFAULT);
    }

    public KeyIterator(Keyspace keyspace, String columnFamily, Serializer<K> serializer, K start, K end, int maxRowCount) {
        this.query = HFactory.createRangeSlicesQuery(keyspace, serializer, stringSerializer, stringSerializer).setColumnFamily(columnFamily).setRange(null, null, false, this.maxColumnCount).setRowCount(maxRowCount);
        this.endKey = end;
        this.runQuery(start, end);
    }

    private void runQuery(K start, K end) {
        this.query.setKeys(start, end);
        this.rowsIterator = null;
        QueryResult result = this.query.execute();
        OrderedRows rows = result != null ? (OrderedRows)result.get() : null;
        Iterator<Object> iterator = this.rowsIterator = rows != null ? rows.iterator() : null;
        if (!this.firstRun && this.rowsIterator != null) {
            this.rowsIterator.next();
        }
        this.firstRun = false;
        if (!this.rowsIterator.hasNext()) {
            this.nextValue = null;
        } else {
            this.findNext(true);
        }
    }

    @Override
    public Iterator<K> iterator() {
        return this.keyIterator;
    }
}

