/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import java.util.LinkedHashMap;
import java.util.Map;
import me.prettyprint.cassandra.model.AbstractSliceQuery;
import me.prettyprint.cassandra.model.HKeyRange;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.OrderedSuperRowsImpl;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.OrderedSuperRows;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSuperSlicesQuery;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftRangeSuperSlicesQuery<K, SN, N, V>
extends AbstractSliceQuery<K, SN, V, OrderedSuperRows<K, SN, N, V>>
implements RangeSuperSlicesQuery<K, SN, N, V> {
    private final Serializer<N> nameSerializer;
    private final HKeyRange<K> keyRange;

    public ThriftRangeSuperSlicesQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(keyspace, keySerializer, sNameSerializer, valueSerializer);
        Assert.notNull(nameSerializer, "nameSerializer cannot be null");
        this.nameSerializer = nameSerializer;
        this.keyRange = new HKeyRange<K>(keySerializer);
    }

    @Override
    public RangeSuperSlicesQuery<K, SN, N, V> setKeys(K start, K end) {
        this.keyRange.setKeys(start, end);
        return this;
    }

    @Override
    public RangeSuperSlicesQuery<K, SN, N, V> setRowCount(int rowCount) {
        this.keyRange.setRowCount(rowCount);
        return this;
    }

    @Override
    public QueryResult<OrderedSuperRows<K, SN, N, V>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        return new QueryResultImpl<OrderedSuperRows<K, SN, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<OrderedSuperRows<K, SN, N, V>>(){

            @Override
            public OrderedSuperRows<K, SN, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                ColumnParent columnParent = new ColumnParent(ThriftRangeSuperSlicesQuery.this.columnFamilyName);
                Map thriftRet = ThriftRangeSuperSlicesQuery.this.keySerializer.fromBytesMap(ks.getSuperRangeSlices(columnParent, ThriftRangeSuperSlicesQuery.this.getPredicate(), ThriftRangeSuperSlicesQuery.this.keyRange.toThrift()));
                return new OrderedSuperRowsImpl((LinkedHashMap)thriftRet, ThriftRangeSuperSlicesQuery.this.keySerializer, ThriftRangeSuperSlicesQuery.this.columnNameSerializer, ThriftRangeSuperSlicesQuery.this.nameSerializer, ThriftRangeSuperSlicesQuery.this.valueSerializer);
            }
        }), this);
    }

    public String toString() {
        return "RangeSuperSlicesQuery(" + this.keyRange + super.toStringInternal() + ")";
    }

    @Override
    public RangeSuperSlicesQuery<K, SN, N, V> setColumnNames(SN ... columnNames) {
        return (RangeSuperSlicesQuery)super.setColumnNames(columnNames);
    }

    @Override
    public RangeSuperSlicesQuery<K, SN, N, V> setRange(SN start, SN finish, boolean reversed, int count) {
        return (RangeSuperSlicesQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public RangeSuperSlicesQuery<K, SN, N, V> setColumnFamily(String cf) {
        return (RangeSuperSlicesQuery)super.setColumnFamily(cf);
    }
}

