/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import me.prettyprint.cassandra.model.AbstractSliceQuery;
import me.prettyprint.cassandra.model.CounterRowsImpl;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.CounterRows;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.MultigetSliceCounterQuery;
import me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.thrift.ColumnParent;

public final class ThriftMultigetSliceCounterQuery<K, N>
extends AbstractSliceQuery<K, N, Long, CounterRows<K, N>>
implements MultigetSliceCounterQuery<K, N> {
    private Iterable<K> keys;

    public ThriftMultigetSliceCounterQuery(Keyspace k, Serializer<K> keySerializer, Serializer<N> nameSerializer) {
        super(k, keySerializer, nameSerializer, LongSerializer.get());
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setKeys(K ... keys) {
        this.keys = Arrays.asList(keys);
        return this;
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setKeys(Iterable<K> keys) {
        this.keys = keys;
        return this;
    }

    @Override
    public QueryResult<CounterRows<K, N>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName can't be null");
        Assert.notNull(this.keys, "keys can't be null");
        return new QueryResultImpl<CounterRows<K, N>>(this.keyspace.doExecute(new KeyspaceOperationCallback<CounterRows<K, N>>(){

            @Override
            public CounterRows<K, N> doInKeyspace(KeyspaceService ks) throws HectorException {
                ArrayList<ByteBuffer> keysList = new ArrayList<ByteBuffer>();
                for (Object k : ThriftMultigetSliceCounterQuery.this.keys) {
                    keysList.add(ThriftMultigetSliceCounterQuery.this.keySerializer.toByteBuffer(k));
                }
                ColumnParent columnParent = new ColumnParent(ThriftMultigetSliceCounterQuery.this.columnFamilyName);
                Map thriftRet = ThriftMultigetSliceCounterQuery.this.keySerializer.fromBytesMap(ks.multigetCounterSlice(keysList, columnParent, ThriftMultigetSliceCounterQuery.this.getPredicate()));
                return new CounterRowsImpl(thriftRet, ThriftMultigetSliceCounterQuery.this.columnNameSerializer);
            }
        }), this);
    }

    public String toString() {
        return "MultigetSliceQuery(" + this.keys + "," + super.toStringInternal() + ")";
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setColumnNames(N ... columnNames) {
        return (MultigetSliceCounterQuery)super.setColumnNames(columnNames);
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setRange(N start, N finish, boolean reversed, int count) {
        return (MultigetSliceCounterQuery)super.setRange(start, finish, reversed, count);
    }

    @Override
    public MultigetSliceCounterQuery<K, N> setColumnFamily(String cf) {
        return (MultigetSliceCounterQuery)super.setColumnFamily(cf);
    }
}

