/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import me.prettyprint.cassandra.connection.ConnectionManagerListener;
import me.prettyprint.cassandra.service.CassandraHost;

public class ConnectionManagerListenersHandler
implements Serializable {
    private Map<String, ConnectionManagerListener> listeners = new HashMap<String, ConnectionManagerListener>();

    public void put(String listenerName, ConnectionManagerListener listener) {
        this.listeners.put(listenerName, listener);
    }

    public void remove(String listenerName) {
        this.listeners.remove(listenerName);
    }

    public void clear() {
        this.listeners.clear();
    }

    public void fireOnHostDown(CassandraHost cassandraHost) {
        for (ConnectionManagerListener listener : this.listeners.values()) {
            listener.onHostDown(cassandraHost);
        }
    }

    public void fireOnHostRestored(CassandraHost cassandraHost) {
        for (ConnectionManagerListener listener : this.listeners.values()) {
            listener.onHostRestored(cassandraHost);
        }
    }

    public void fireOnAllHostsDown() {
        for (ConnectionManagerListener listener : this.listeners.values()) {
            listener.onAllHostsDown();
        }
    }

    public void fireOnSuspendHost(CassandraHost cassandraHost, boolean removed) {
        for (ConnectionManagerListener listener : this.listeners.values()) {
            listener.onSuspendHost(cassandraHost, removed);
        }
    }

    public void fireOnUnSuspendHost(CassandraHost cassandraHost, boolean readded) {
        for (ConnectionManagerListener listener : this.listeners.values()) {
            listener.onUnSuspendHost(cassandraHost, readded);
        }
    }

    public void fireOnAddHost(CassandraHost cassandraHost, boolean added, String errorMessage, Exception e) {
        for (ConnectionManagerListener listener : this.listeners.values()) {
            listener.onAddHost(cassandraHost, added, errorMessage, e);
        }
    }

    public void fireOnRemoveHost(CassandraHost cassandraHost, boolean removed, String message) {
        for (ConnectionManagerListener listener : this.listeners.values()) {
            listener.onRemoveHost(cassandraHost, removed, message);
        }
    }
}

